/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.newGUI;

import fr.orsay.lri.varna.applications.newGUI.VARNAGUIModel;
import fr.orsay.lri.varna.applications.newGUI.VARNAGUITreeModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

class VARNAGUIRenderer
extends DefaultTreeCellRenderer {
    JTree _j;
    VARNAGUITreeModel _m;
    private static VARNAGUIRenderer _default = new VARNAGUIRenderer(null, null);

    public VARNAGUIRenderer(JTree j, VARNAGUITreeModel m) {
        this._j = j;
        this._m = m;
    }

    public JComponent baseElements(JTree tree, VARNAGUITreeModel m, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel initValue = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout());
        initValue.setBorder(null);
        if (hasFocus) {
            result.setBorder(BorderFactory.createLineBorder(Color.blue));
            result.setBackground(UIManager.getColor("Tree.selectionBackground"));
            initValue.setOpaque(true);
        } else {
            result.setBackground(Color.white);
            result.setBorder(BorderFactory.createLineBorder(initValue.getBackground()));
        }
        DefaultMutableTreeNode t = (DefaultMutableTreeNode)value;
        Object o = t.getUserObject();
        if (!(o instanceof VARNAGUIModel)) {
            if (expanded) {
                initValue.setIcon(_default.getOpenIcon());
            } else {
                initValue.setIcon(_default.getClosedIcon());
            }
            result.add((Component)initValue, "West");
            JButton del = new JButton("X");
            del.addActionListener(new FolderCloses((String)o, tree, m));
            result.add((Component)del, "East");
        } else {
            VARNAGUIModel mod = (VARNAGUIModel)o;
            initValue.setIcon(_default.getLeafIcon());
            result.add((Component)initValue, "West");
            if (mod.hasChanged()) {
                JButton refresh = new JButton("Refresh");
                result.add((Component)refresh, "East");
            }
        }
        return result;
    }

    public Component getDefaultTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return this.baseElements(tree, this._m, value, sel, expanded, leaf, row, hasFocus);
    }

    public Dimension getPreferredSize(int row) {
        Dimension size = super.getPreferredSize();
        size.width = this._j.getWidth();
        System.out.println(size);
        return size;
    }

    public class FolderCloses
    implements ActionListener {
        String _path;
        JComponent _p;
        VARNAGUITreeModel _m;

        public FolderCloses(String path, JComponent p, VARNAGUITreeModel m) {
            this._path = path;
            this._p = p;
            this._m = m;
        }

        public void actionPerformed(ActionEvent e) {
            if (JOptionPane.showConfirmDialog(this._p, "This folder will cease to be watched. Confirm?", "Closing folder", 0) == 0) {
                this._m.removeFolder(this._path);
                System.out.println(VARNAGUIRenderer.this._j);
                VARNAGUIRenderer.this._j.updateUI();
            }
        }
    }
}

