/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.newGUI;

import fr.orsay.lri.varna.exceptions.ExceptionExportFailed;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionPermissionDenied;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VARNAGUIModel
implements Comparable<VARNAGUIModel> {
    private Date _lastModified;
    private boolean _outOfSync = false;
    private RNA _r = null;
    private String _caption = "";
    private String _path = "";
    private String _folder = "";
    public static DataFlavor Flavor = new DataFlavor(VARNAGUIModel.class, "VARNA Object");

    public static Date lastModif(String path) {
        return new Date(new File(path).lastModified());
    }

    public VARNAGUIModel(String folder, String path) {
        this(folder, path, VARNAGUIModel.lastModif(path));
    }

    public VARNAGUIModel(String folder, String path, Date lastModified) {
        this._lastModified = lastModified;
        this._outOfSync = false;
        this._folder = folder;
        this._path = path;
        String[] s = path.split(Pattern.quote(File.separator));
        if (s.length > 0) {
            this._caption = s[s.length - 1];
        }
    }

    public boolean hasChanged() {
        return this._outOfSync;
    }

    public boolean checkForModifications() {
        if (!VARNAGUIModel.lastModif(this._path).equals(this._lastModified) && !this._outOfSync) {
            this._outOfSync = true;
            return true;
        }
        return false;
    }

    public RNA getRNA() {
        if (this._r == null) {
            try {
                this.createRNA();
            }
            catch (ExceptionUnmatchedClosingParentheses e) {
                e.printStackTrace();
            }
            catch (ExceptionFileFormatOrSyntax e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (ExceptionExportFailed e) {
                e.printStackTrace();
            }
            catch (ExceptionPermissionDenied e) {
                e.printStackTrace();
            }
            catch (ExceptionLoadingFailed e) {
                e.printStackTrace();
            }
        }
        return this._r;
    }

    private RNA createRNA() throws ExceptionUnmatchedClosingParentheses, ExceptionFileFormatOrSyntax, FileNotFoundException, ExceptionExportFailed, ExceptionPermissionDenied, ExceptionLoadingFailed {
        ArrayList<RNA> r = RNAFactory.loadSecStr(this._path);
        if (r.size() <= 0) {
            throw new ExceptionFileFormatOrSyntax("No valid RNA defined in this file.");
        }
        this._r = (RNA)r.iterator().next();
        this._r.drawRNARadiate();
        return this._r;
    }

    public String toString() {
        return String.valueOf(this._caption) + (this._outOfSync ? "*" : "");
    }

    public String getID() {
        return this.getRNA().getID();
    }

    public String getCaption() {
        return this._caption;
    }

    public String getFolder() {
        return this._folder;
    }

    @Override
    public int compareTo(VARNAGUIModel o) {
        return this._caption.compareTo(o._caption);
    }
}

