/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.newGUI;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.applications.BasicINI;
import fr.orsay.lri.varna.applications.newGUI.VARNAGUICellEditor;
import fr.orsay.lri.varna.applications.newGUI.VARNAGUIModel;
import fr.orsay.lri.varna.applications.newGUI.VARNAGUIRenderer;
import fr.orsay.lri.varna.applications.newGUI.VARNAGUITree;
import fr.orsay.lri.varna.applications.newGUI.VARNAGUITreeModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class VARNAGUI
extends JFrame
implements TreeModelListener,
MouseListener,
DropTargetListener,
WindowListener,
ComponentListener,
ActionListener {
    private static final long serialVersionUID = -790155708306987257L;
    private String _INIFilename = "FragSeqUI.ini";
    private Color _backgroundColor = Color.white;
    private boolean redrawOnSlide = false;
    private int dividerWidth = 5;
    private JPanel _varnaUpperPanels = new JPanel();
    private JPanel _varnaLowerPanels = new JPanel();
    private JPanel _listPanel = new JPanel();
    private JPanel _infoPanel = new JPanel();
    private VARNAGUITree _sideList = null;
    private VARNAGUITreeModel _treeModel;
    private JToolBar _toolbar = new JToolBar();
    private JFileChooser _choice = new JFileChooser();
    private JScrollPane _listScroller;
    private JList _selectedElems;
    private JSplitPane _splitLeft;
    private JSplitPane _splitRight;
    private JSplitPane _splitVARNA;
    int index = 0;
    private ArrayList<VARNAHolder> _varnaPanels = new ArrayList();

    public VARNAGUI() {
        super("VARNA Explorer");
        this.RNAPanelDemoInit();
    }

    private void RNAPanelDemoInit() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.addWindowListener(this);
        this._selectedElems = new JList();
        this._treeModel = new VARNAGUITreeModel();
        this._treeModel.addTreeModelListener(this);
        this._sideList = new VARNAGUITree(this._treeModel);
        this._sideList.addMouseListener(this);
        this._sideList.setLargeModel(true);
        this._sideList.setEditable(true);
        VARNAGUIRenderer renderer = new VARNAGUIRenderer(this._sideList, this._treeModel);
        this._sideList.setCellRenderer(renderer);
        this._sideList.setCellEditor(new VARNAGUICellEditor((JTree)this._sideList, (DefaultTreeCellRenderer)renderer, this._treeModel));
        TreeSelectionModel m = this._sideList.getSelectionModel();
        m.setSelectionMode(4);
        this._sideList.setSelectionModel(m);
        this._sideList.setShowsRootHandles(true);
        this._sideList.setDragEnabled(true);
        this._sideList.setRootVisible(false);
        this._sideList.setTransferHandler(new TransferHandler(null){

            public int getSourceActions(JComponent c) {
                return 3;
            }

            protected Transferable createTransferable(JComponent c) {
                JTree tree = (JTree)c;
                TreePath tp = tree.getSelectionPath();
                if (tp != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
                    if (node.getUserObject() instanceof VARNAGUIModel) {
                        return new Transferable(){

                            public DataFlavor[] getTransferDataFlavors() {
                                DataFlavor[] dt = new DataFlavor[]{VARNAGUIModel.Flavor};
                                return dt;
                            }

                            public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
                                if (!this.isDataFlavorSupported(df)) {
                                    throw new UnsupportedFlavorException(df);
                                }
                                DefaultMutableTreeNode node = (DefaultMutableTreeNode)VARNAGUI.this._sideList.getSelectionPath().getLastPathComponent();
                                return node.getUserObject();
                            }

                            public boolean isDataFlavorSupported(DataFlavor df) {
                                return VARNAGUIModel.Flavor.equals(df);
                            }
                        };
                    }
                    return null;
                }
                return null;
            }
        });
        JButton refreshAllFoldersButton = new JButton("Refresh All");
        refreshAllFoldersButton.setActionCommand("" + (Object)((Object)Commands.REFRESH_ALL));
        refreshAllFoldersButton.addActionListener(this);
        JButton watchFolderButton = new JButton("Add folder");
        watchFolderButton.setActionCommand("" + (Object)((Object)Commands.NEW_FOLDER));
        watchFolderButton.addActionListener(this);
        JButton addUpperButton = new JButton("+Up");
        addUpperButton.setActionCommand("" + (Object)((Object)Commands.ADD_PANEL_UP));
        addUpperButton.addActionListener(this);
        JButton removeUpperButton = new JButton("-Up");
        removeUpperButton.setActionCommand("" + (Object)((Object)Commands.REMOVE_PANEL_UP));
        removeUpperButton.addActionListener(this);
        JButton addLowerButton = new JButton("+Down");
        addLowerButton.setActionCommand("" + (Object)((Object)Commands.ADD_PANEL_DOWN));
        addLowerButton.addActionListener(this);
        JButton removeLowerButton = new JButton("-Down");
        removeLowerButton.setActionCommand("" + (Object)((Object)Commands.REMOVE_PANEL_DOWN));
        removeLowerButton.addActionListener(this);
        this._toolbar.setFloatable(false);
        this._toolbar.add(refreshAllFoldersButton);
        this._toolbar.addSeparator();
        this._toolbar.add(addUpperButton);
        this._toolbar.add(removeUpperButton);
        this._toolbar.add(addLowerButton);
        this._toolbar.add(removeLowerButton);
        this._listScroller = new JScrollPane(this._sideList, 22, 32);
        this._listScroller.setPreferredSize(new Dimension(300, 200));
        this._listScroller.addComponentListener(this);
        this._listPanel.setLayout(new BorderLayout());
        this._listPanel.add((Component)this._listScroller, "Center");
        this._listPanel.add((Component)this._selectedElems, "South");
        this._listPanel.setBorder(BorderFactory.createTitledBorder("Structures"));
        this._listPanel.setPreferredSize(new Dimension(300, 0));
        this._varnaUpperPanels.setLayout(new GridLayout());
        this._varnaUpperPanels.setPreferredSize(new Dimension(800, 600));
        this._varnaLowerPanels.setLayout(new GridLayout());
        this._varnaLowerPanels.setPreferredSize(new Dimension(800, 0));
        JRadioButton sortFileName = new JRadioButton("Filename");
        sortFileName.setActionCommand("sortfilename");
        sortFileName.setSelected(true);
        sortFileName.setOpaque(false);
        sortFileName.setActionCommand("" + (Object)((Object)Commands.SORT_FILENAME));
        sortFileName.addActionListener(this);
        JRadioButton sortID = new JRadioButton("ID");
        sortID.setActionCommand("sortid");
        sortID.setOpaque(false);
        sortID.setActionCommand("" + (Object)((Object)Commands.SORT_ID));
        sortID.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(sortFileName);
        group.add(sortID);
        JToolBar listTools = new JToolBar();
        listTools.setFloatable(false);
        listTools.add(watchFolderButton);
        listTools.addSeparator();
        listTools.add(new JLabel("Sort by"));
        listTools.add(sortFileName);
        listTools.add(sortID);
        JPanel sidePanel = new JPanel();
        sidePanel.setLayout(new BorderLayout());
        sidePanel.add((Component)listTools, "North");
        sidePanel.add((Component)this._listPanel, "Center");
        JPanel mainVARNAPanel = new JPanel();
        mainVARNAPanel.setLayout(new BorderLayout());
        this._splitVARNA = new JSplitPane(0, this.redrawOnSlide, this._varnaUpperPanels, this._varnaLowerPanels);
        this._splitVARNA.setDividerSize(this.dividerWidth);
        this._splitVARNA.setResizeWeight(1.0);
        this._splitLeft = new JSplitPane(1, this.redrawOnSlide, sidePanel, this._splitVARNA);
        this._splitLeft.setResizeWeight(0.1);
        this._splitLeft.setDividerSize(this.dividerWidth);
        this._splitRight = new JSplitPane(1, this.redrawOnSlide, this._splitLeft, this._infoPanel);
        this._splitRight.setResizeWeight(0.85);
        this._splitRight.setDividerSize(this.dividerWidth);
        this._infoPanel.setLayout(new GridLayout(0, 1));
        this.restoreConfig();
        this.setBackground(this._backgroundColor);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._splitRight, "Center");
        this.getContentPane().add((Component)this._toolbar, "North");
        this.addUpperPanel();
        this.setVisible(true);
    }

    public VARNAGUI getSelf() {
        return this;
    }

    public VARNAHolder createIntegratedPanel(int height) {
        VARNAHolder vh = new VARNAHolder(this);
        this._varnaPanels.add(vh);
        return vh;
    }

    public void removeUpperPanel() {
        if (this._varnaUpperPanels.getComponentCount() > 1) {
            VARNAHolder vh = (VARNAHolder)this._varnaUpperPanels.getComponent(this._varnaUpperPanels.getComponentCount() - 1);
            this._infoPanel.remove(vh.getInfoPane());
            this._varnaUpperPanels.remove(vh);
            this._splitLeft.validate();
            this._splitRight.validate();
        }
    }

    public void addUpperPanel() {
        VARNAHolder vh = this.createIntegratedPanel(100);
        this._varnaUpperPanels.add(vh);
        this._infoPanel.add(vh.getInfoPane());
        this._splitRight.validate();
        this._splitLeft.validate();
    }

    public void removeLowerPanel() {
        if (this._varnaLowerPanels.getComponentCount() > 0) {
            this._varnaLowerPanels.remove(this._varnaLowerPanels.getComponentCount() - 1);
            if (this._varnaLowerPanels.getComponentCount() == 0) {
                this._splitVARNA.setDividerLocation(1.0);
                this._splitVARNA.validate();
                this._splitVARNA.repaint();
            }
            this._splitLeft.validate();
        }
    }

    public void addLowerPanel() {
        if (this._varnaLowerPanels.getComponentCount() == 0) {
            this._splitVARNA.setDividerLocation(0.7);
            this._splitVARNA.validate();
        }
        this._varnaLowerPanels.add(this.createIntegratedPanel(400));
        this._splitLeft.validate();
    }

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (Exception info) {
            // empty catch block
        }
        VARNAGUI d = new VARNAGUI();
        d.setDefaultCloseOperation(3);
        d.pack();
        d.setVisible(true);
    }

    public void treeNodesChanged(TreeModelEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
        try {
            int index = e.getChildIndices()[0];
            node = (DefaultMutableTreeNode)node.getChildAt(index);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void addFolder(String path) {
        this.addFolder(path, true);
    }

    public void addFolder(String path, boolean shouldBeVisible) {
        DefaultMutableTreeNode childNode = this._treeModel.addFolder(path);
        if (childNode != null && shouldBeVisible) {
            System.out.println("  Expanding: " + childNode.getUserObject());
            TreePath tp = new TreePath(childNode.getPath());
            this._sideList.scrollPathToVisible(tp);
            this._sideList.expandRow(this._sideList.getRowForPath(tp));
            this._sideList.updateUI();
            this._sideList.validate();
        }
    }

    public void treeNodesInserted(TreeModelEvent e) {
        System.out.println(e);
    }

    public void treeNodesRemoved(TreeModelEvent e) {
    }

    public void treeStructureChanged(TreeModelEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        DefaultMutableTreeNode node;
        TreePath t;
        if (e.getSource() == this._sideList && e.getClickCount() == 2 && (t = this._sideList.getSelectionPath()) != null && (node = (DefaultMutableTreeNode)t.getLastPathComponent()).getUserObject() instanceof VARNAGUIModel) {
            VARNAGUIModel model = (VARNAGUIModel)node.getUserObject();
            int res = this.index % (this._varnaUpperPanels.getComponentCount() + this._varnaLowerPanels.getComponentCount());
            VARNAHolder c = null;
            c = res < this._varnaUpperPanels.getComponentCount() ? (VARNAHolder)this._varnaUpperPanels.getComponent(res) : (VARNAHolder)this._varnaLowerPanels.getComponent(res -= this._varnaUpperPanels.getComponentCount());
            if (c instanceof VARNAHolder) {
                VARNAHolder h = c;
                h.setModel(model);
            }
            ++this.index;
        }
    }

    private VARNAHolder getHolder(Component vp) {
        int i;
        if (vp instanceof VARNAHolder && (i = this._varnaPanels.indexOf(vp)) != -1) {
            return this._varnaPanels.get(i);
        }
        if (vp instanceof VARNAPanel) {
            for (VARNAHolder vh : this._varnaPanels) {
                if (vh.getVARNAPanel() != vp) continue;
                return vh;
            }
        }
        return null;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void dragEnter(DropTargetDragEvent arg0) {
    }

    public void dragExit(DropTargetEvent arg0) {
    }

    public void dragOver(DropTargetDragEvent arg0) {
    }

    public void drop(DropTargetDropEvent arg0) {
        try {
            VARNAHolder h;
            DropTarget o = (DropTarget)arg0.getSource();
            if (o.getComponent() instanceof VARNAPanel && (h = this.getHolder(o.getComponent())) != null) {
                h.setModel((VARNAGUIModel)arg0.getTransferable().getTransferData(VARNAGUIModel.Flavor));
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dropActionChanged(DropTargetDragEvent arg0) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.saveConfig();
        System.exit(0);
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    private void restoreConfig() {
        BasicINI config = BasicINI.loadINI(this._INIFilename);
        ArrayList<String> vals = config.getItemList("folders");
        System.out.print("[C]" + vals);
        for (String path : vals) {
            System.out.println("Loading folder " + path);
            this.addFolder(path);
        }
        this._sideList.validate();
        this._listScroller.validate();
    }

    private void saveConfig() {
        BasicINI data = new BasicINI();
        int i = 0;
        for (String folderPath : this._treeModel.getFolders()) {
            data.addItem("folders", "val" + i, folderPath);
            ++i;
        }
        BasicINI.saveINI(data, this._INIFilename);
    }

    public void componentResized(ComponentEvent e) {
        this._sideList.validate();
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        block13: {
            String cmd = e.getActionCommand();
            System.out.println(cmd);
            if (cmd.equals("" + (Object)((Object)Commands.NEW_FOLDER))) {
                this._choice.setDialogTitle("Watch new folder...");
                this._choice.setFileSelectionMode(1);
                this._choice.setAcceptAllFileFilterUsed(false);
                try {
                    if (this._choice.showOpenDialog(this.getSelf()) == 0) {
                        this.addFolder(this._choice.getSelectedFile().getCanonicalPath());
                        break block13;
                    }
                    System.out.println("No Selection ");
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            } else if (cmd.equals("" + (Object)((Object)Commands.ADD_PANEL_DOWN))) {
                this.addLowerPanel();
            } else if (cmd.equals("" + (Object)((Object)Commands.ADD_PANEL_UP))) {
                this.addUpperPanel();
            } else if (cmd.equals("" + (Object)((Object)Commands.REMOVE_PANEL_DOWN))) {
                this.removeLowerPanel();
            } else if (cmd.equals("" + (Object)((Object)Commands.REMOVE_PANEL_UP))) {
                this.removeUpperPanel();
            } else {
                JOptionPane.showMessageDialog(this, "Command '" + cmd + "' not implemented yet.");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Commands {
        NEW_FOLDER,
        ADD_PANEL_UP,
        ADD_PANEL_DOWN,
        REMOVE_PANEL_UP,
        REMOVE_PANEL_DOWN,
        SORT_ID,
        SORT_FILENAME,
        REFRESH_ALL;

    }

    class VARNAHolder
    extends JPanel {
        VARNAPanel vp = new VARNAPanel();
        VARNAGUIModel _m;
        JPanel _infoPanel;
        JTextPane _infoTxt;

        public VARNAHolder(DropTargetListener f) {
            this.vp.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                }
            });
            this.vp.setPreferredSize(new Dimension(800, 400));
            this.vp.setBackground(VARNAGUI.this._backgroundColor);
            this._infoTxt = new JTextPane();
            this._infoTxt.setPreferredSize(new Dimension(200, 0));
            this._infoTxt.setContentType("text/html");
            JScrollPane scroll = new JScrollPane(this._infoTxt, 22, 32);
            this._infoPanel = new JPanel();
            this._infoPanel.setLayout(new BorderLayout());
            this._infoPanel.setPreferredSize(new Dimension(200, 0));
            this._infoPanel.setBorder(BorderFactory.createTitledBorder("Info"));
            this._infoPanel.add((Component)scroll, "Center");
            this._infoPanel.validate();
            this.setLayout(new BorderLayout());
            this.setPreferredSize(new Dimension(300, 600));
            this.setBorder(BorderFactory.createTitledBorder("None"));
            this.add((Component)this.vp, "Center");
            DropTarget dt = new DropTarget(this.vp, f);
        }

        VARNAPanel getVARNAPanel() {
            return this.vp;
        }

        void setModel(VARNAGUIModel m) {
            this._m = m;
            this.vp.showRNAInterpolated(m.getRNA());
            this.setBorder(BorderFactory.createTitledBorder(m.toString()));
            this._infoTxt.setText(m.getRNA().getHTMLDescription());
            this._infoPanel.setBorder(BorderFactory.createTitledBorder("Info (" + this._m + ")"));
            this.vp.requestFocus();
        }

        VARNAGUIModel getModel() {
            this.setBorder(BorderFactory.createTitledBorder(this._m.toString()));
            return this._m;
        }

        public void setInfoTxt(String s) {
            this._infoTxt.setText(this.vp.getRNA().getHTMLDescription());
            this._infoTxt.validate();
        }

        public JPanel getInfoPane() {
            return this._infoPanel;
        }
    }
}

