/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.fragseq;

import fr.orsay.lri.varna.applications.fragseq.FragSeqFileModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqNode;
import fr.orsay.lri.varna.applications.fragseq.FragSeqTree;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragSeqTreeModel
extends DefaultTreeModel
implements TreeWillExpandListener {
    private FragSeqNode _rootIDs = new FragSeqNode("IDs");
    private FragSeqNode _rootFolders = new FragSeqNode("Folders");
    private TreeSet<String> _folders = new TreeSet();
    private Hashtable<String, FragSeqNode> _folderPathToFolderNode = new Hashtable();
    private Hashtable<String, FragSeqNode> _idsToNode = new Hashtable();
    private Hashtable<String, ArrayList<FragSeqNode>> _pathToIDFileNodes = new Hashtable();
    private SORT_MODE _mode = SORT_MODE.PATH;
    FilenameFilter _f = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".dbn") || name.toLowerCase().endsWith(".ct") || name.toLowerCase().endsWith(".bpseq") || name.toLowerCase().endsWith(".rnaml");
        }
    };
    private Hashtable<FragSeqNode, Boolean> _isExpanded = new Hashtable();

    public FragSeqTreeModel() {
        this(new FragSeqNode("Folders"));
    }

    public FragSeqTreeModel(TreeNode t) {
        super(t);
        this.setRoot(this._rootFolders);
    }

    public FragSeqNode getPathViewRoot() {
        return this._rootFolders;
    }

    public FragSeqNode getIDViewRoot() {
        return this._rootIDs;
    }

    public void switchToIDView() {
        if (this._mode != SORT_MODE.ID) {
            this.setRoot(this._rootIDs);
        }
        this._mode = SORT_MODE.ID;
    }

    private void removeAllNodes(ArrayList<FragSeqNode> toBeRemoved) {
        for (FragSeqNode leafNode : toBeRemoved) {
            FragSeqNode parent = (FragSeqNode)leafNode.getParent();
            parent.remove(leafNode);
            if (parent.getChildCount() == 0) {
                parent.removeFromParent();
                this._folderPathToFolderNode.remove(parent);
                if (!(parent.getUserObject() instanceof String)) continue;
                String string = parent.getUserObject().toString();
                continue;
            }
            this.reload(parent);
        }
    }

    public FragSeqNode getNodeForId(String id) {
        FragSeqNode idNode;
        if (!this._idsToNode.containsKey(id)) {
            idNode = new FragSeqNode(id);
            this._idsToNode.put(id, idNode);
            this._rootIDs.add(idNode);
        }
        idNode = this._idsToNode.get(id);
        return idNode;
    }

    public void removeFolder(String path) {
        ArrayList<FragSeqNode> toBeRemoved = new ArrayList<FragSeqNode>();
        Enumeration<TreeNode> en = this._folderPathToFolderNode.get(path).children();
        while (en.hasMoreElements()) {
            FragSeqNode n = (FragSeqNode)en.nextElement();
            toBeRemoved.add(n);
        }
        this.removeAllNodes(toBeRemoved);
        this._folders.remove(path);
    }

    public FragSeqNode insertGroupNode(String crit, TreeSet<String> t) {
        FragSeqNode groupNode = new FragSeqNode(crit);
        FragSeqNode parent = this.getRoot();
        int pos = t.headSet(crit).size();
        parent.insert(groupNode, pos);
        this.reload(groupNode);
        return groupNode;
    }

    public void insertFileNode(FragSeqNode parent, FragSeqFileModel m) {
        FragSeqNode leafNode = new FragSeqNode(m);
        parent.add(leafNode);
    }

    public FragSeqNode addFolder(String path) {
        FragSeqNode groupNode = null;
        try {
            File dir;
            if (!this._folders.contains(path) && (dir = new File(path)).isDirectory()) {
                path = dir.getCanonicalPath();
                this._folders.add(path);
                groupNode = this.insertGroupNode(path, this._folders);
                this._folderPathToFolderNode.put(path, groupNode);
                File[] fileArray = dir.listFiles(this._f);
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    this.addFile(path, f.getCanonicalPath());
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return groupNode;
    }

    private void addFile(String folder, String path) {
        System.out.println("  => " + path);
        FragSeqFileModel m = new FragSeqFileModel(folder, path);
        this.addFolder(folder);
        this.insertFileNode(this._folderPathToFolderNode.get(folder), m);
    }

    @Override
    public FragSeqNode getRoot() {
        return (FragSeqNode)super.getRoot();
    }

    public ArrayList<String> getFolders() {
        ArrayList<String> result = new ArrayList<String>(this._folders);
        return result;
    }

    public FilenameFilter getFileNameFilter() {
        return this._f;
    }

    public void setFileNameFilter(FilenameFilter f) {
        this._f = f;
    }

    public boolean isExpanded(FragSeqNode n) {
        if (this._isExpanded.containsKey(n)) {
            return this._isExpanded.get(n);
        }
        return false;
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        if (event.getSource() instanceof FragSeqTree) {
            FragSeqTree tree = (FragSeqTree)event.getSource();
            TreePath t = event.getPath();
            FragSeqNode n = (FragSeqNode)t.getLastPathComponent();
            this._isExpanded.put(n, true);
            Object o = n.getUserObject();
            if (o instanceof FragSeqFileModel) {
                FragSeqFileModel f = (FragSeqFileModel)o;
                if (!f._cached) {
                    String path = f.getPath();
                    if (!this._pathToIDFileNodes.containsKey(path)) {
                        this._pathToIDFileNodes.put(path, new ArrayList());
                    }
                    ArrayList<FragSeqNode> nodesForID = this._pathToIDFileNodes.get(path);
                    for (FragSeqModel m : f.getModels()) {
                        n.add(new FragSeqNode(m));
                        FragSeqNode nid = this.getNodeForId(m.getID());
                        nid.add(new FragSeqNode(m));
                        nodesForID.add(nid);
                    }
                }
            }
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        TreePath t = event.getPath();
        FragSeqNode n = (FragSeqNode)t.getLastPathComponent();
        this._isExpanded.put(n, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SORT_MODE {
        PATH,
        ID;

    }
}

