/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.fragseq;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.applications.BasicINI;
import fr.orsay.lri.varna.applications.fragseq.FragSeqAnnotationDataModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqCellEditor;
import fr.orsay.lri.varna.applications.fragseq.FragSeqCellRenderer;
import fr.orsay.lri.varna.applications.fragseq.FragSeqFileModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqNode;
import fr.orsay.lri.varna.applications.fragseq.FragSeqRNASecStrModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqTree;
import fr.orsay.lri.varna.applications.fragseq.FragSeqTreeModel;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.models.FullBackup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class FragSeqGUI
extends JFrame
implements TreeModelListener,
MouseListener,
DropTargetListener,
WindowListener,
ComponentListener,
ActionListener,
TreeSelectionListener {
    private static final long serialVersionUID = -790155708306987257L;
    private String _INIFilename = "FragSeqUI.ini";
    private boolean redrawOnSlide = false;
    private int dividerWidth = 5;
    private JPanel _varnaUpperPanels = new JPanel();
    private JPanel _varnaLowerPanels = new JPanel();
    private JPanel _listPanel = new JPanel();
    private JPanel _infoPanel = new JPanel();
    private FragSeqTree _sideList = null;
    private FragSeqTreeModel _treeModel;
    private JToolBar _toolbar = new JToolBar();
    private JFileChooser _choice = new JFileChooser();
    private JScrollPane _listScroller;
    private JList _selectedElems;
    private JSplitPane _splitLeft;
    private JSplitPane _splitRight;
    private JSplitPane _splitVARNA;
    private JComboBox _lnf;
    int index = 0;
    private ArrayList<VARNAHolder> _varnaPanels = new ArrayList();

    public FragSeqGUI() {
        super("VARNA Explorer");
        this.RNAPanelDemoInit();
    }

    private void RNAPanelDemoInit() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.addWindowListener(this);
        this._selectedElems = new JList();
        this._lnf = new JComboBox<UIManager.LookAndFeelInfo>(UIManager.getInstalledLookAndFeels());
        this._treeModel = new FragSeqTreeModel();
        this._treeModel.addTreeModelListener(this);
        this._sideList = new FragSeqTree(this._treeModel);
        this._sideList.addMouseListener(this);
        this._sideList.setLargeModel(true);
        this._sideList.setEditable(true);
        this._sideList.addTreeWillExpandListener(this._treeModel);
        FragSeqCellRenderer renderer = new FragSeqCellRenderer(this._sideList, this._treeModel);
        this._sideList.setCellRenderer(renderer);
        this._sideList.setCellEditor(new FragSeqCellEditor((JTree)this._sideList, (DefaultTreeCellRenderer)renderer, this._treeModel));
        TreeSelectionModel m = this._sideList.getSelectionModel();
        m.setSelectionMode(1);
        this._sideList.setSelectionModel(m);
        m.addTreeSelectionListener(this);
        this._sideList.setShowsRootHandles(true);
        this._sideList.setDragEnabled(true);
        this._sideList.setRootVisible(false);
        this._sideList.setTransferHandler(new TransferHandler(null){

            public int getSourceActions(JComponent c) {
                return 3;
            }

            protected Transferable createTransferable(JComponent c) {
                JTree tree = (JTree)c;
                TreePath tp = tree.getSelectionPath();
                if (tp != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
                    if (node.getUserObject() instanceof FragSeqRNASecStrModel) {
                        return new Transferable(){

                            public DataFlavor[] getTransferDataFlavors() {
                                DataFlavor[] dt = new DataFlavor[]{FragSeqRNASecStrModel.Flavor};
                                return dt;
                            }

                            public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
                                if (!this.isDataFlavorSupported(df)) {
                                    throw new UnsupportedFlavorException(df);
                                }
                                DefaultMutableTreeNode node = (DefaultMutableTreeNode)FragSeqGUI.this._sideList.getSelectionPath().getLastPathComponent();
                                return node.getUserObject();
                            }

                            public boolean isDataFlavorSupported(DataFlavor df) {
                                return FragSeqRNASecStrModel.Flavor.equals(df);
                            }
                        };
                    }
                    if (node.getUserObject() instanceof FragSeqAnnotationDataModel) {
                        return new Transferable(){

                            public DataFlavor[] getTransferDataFlavors() {
                                DataFlavor[] dt = new DataFlavor[]{FragSeqAnnotationDataModel.Flavor};
                                return dt;
                            }

                            public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
                                if (!this.isDataFlavorSupported(df)) {
                                    throw new UnsupportedFlavorException(df);
                                }
                                DefaultMutableTreeNode node = (DefaultMutableTreeNode)FragSeqGUI.this._sideList.getSelectionPath().getLastPathComponent();
                                return node.getUserObject();
                            }

                            public boolean isDataFlavorSupported(DataFlavor df) {
                                return FragSeqAnnotationDataModel.Flavor.equals(df);
                            }
                        };
                    }
                    return null;
                }
                return null;
            }
        });
        JButton refreshAllFoldersButton = new JButton("Refresh All");
        refreshAllFoldersButton.setActionCommand("" + (Object)((Object)Commands.REFRESH_ALL));
        refreshAllFoldersButton.addActionListener(this);
        JButton watchFolderButton = new JButton("Add folder");
        watchFolderButton.setActionCommand("" + (Object)((Object)Commands.NEW_FOLDER));
        watchFolderButton.addActionListener(this);
        JButton addUpperButton = new JButton("+Up");
        addUpperButton.setActionCommand("" + (Object)((Object)Commands.ADD_PANEL_UP));
        addUpperButton.addActionListener(this);
        JButton removeUpperButton = new JButton("-Up");
        removeUpperButton.setActionCommand("" + (Object)((Object)Commands.REMOVE_PANEL_UP));
        removeUpperButton.addActionListener(this);
        JButton addLowerButton = new JButton("+Down");
        addLowerButton.setActionCommand("" + (Object)((Object)Commands.ADD_PANEL_DOWN));
        addLowerButton.addActionListener(this);
        JButton removeLowerButton = new JButton("-Down");
        removeLowerButton.setActionCommand("" + (Object)((Object)Commands.REMOVE_PANEL_DOWN));
        removeLowerButton.addActionListener(this);
        JButton changeLNFButton = new JButton("Change");
        changeLNFButton.setActionCommand("" + (Object)((Object)Commands.CHANGE_LNF));
        changeLNFButton.addActionListener(this);
        JButton XMLButton = new JButton("Test XML");
        XMLButton.setActionCommand("" + (Object)((Object)Commands.TEST_XML));
        XMLButton.addActionListener(this);
        this._toolbar.setFloatable(false);
        this._toolbar.add(refreshAllFoldersButton);
        this._toolbar.addSeparator();
        this._toolbar.add(addUpperButton);
        this._toolbar.add(removeUpperButton);
        this._toolbar.add(addLowerButton);
        this._toolbar.add(removeLowerButton);
        this._toolbar.addSeparator();
        this._toolbar.add(XMLButton);
        this._toolbar.addSeparator();
        this._toolbar.add(this._lnf);
        this._toolbar.add(changeLNFButton);
        this._listScroller = new JScrollPane(this._sideList, 22, 32);
        this._listScroller.setPreferredSize(new Dimension(300, 200));
        this._listScroller.addComponentListener(this);
        this._listPanel.setLayout(new BorderLayout());
        this._listPanel.add((Component)this._listScroller, "Center");
        this._listPanel.add((Component)this._selectedElems, "South");
        this._listPanel.setBorder(BorderFactory.createTitledBorder("Structures"));
        this._listPanel.setPreferredSize(new Dimension(300, 0));
        this._varnaUpperPanels.setLayout(new GridLayout());
        this._varnaUpperPanels.setPreferredSize(new Dimension(800, 600));
        this._varnaLowerPanels.setLayout(new GridLayout());
        this._varnaLowerPanels.setPreferredSize(new Dimension(800, 0));
        JRadioButton sortFileName = new JRadioButton("Directory");
        sortFileName.setActionCommand("sortfilename");
        sortFileName.setSelected(true);
        sortFileName.setOpaque(false);
        sortFileName.setActionCommand("" + (Object)((Object)Commands.SORT_FILENAME));
        sortFileName.addActionListener(this);
        JRadioButton sortID = new JRadioButton("ID");
        sortID.setActionCommand("sortid");
        sortID.setOpaque(false);
        sortID.setActionCommand("" + (Object)((Object)Commands.SORT_ID));
        sortID.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(sortFileName);
        group.add(sortID);
        JToolBar listTools = new JToolBar();
        listTools.setFloatable(false);
        listTools.add(watchFolderButton);
        listTools.addSeparator();
        listTools.add(new JLabel("Sort by"));
        listTools.add(sortFileName);
        listTools.add(sortID);
        JPanel sidePanel = new JPanel();
        sidePanel.setLayout(new BorderLayout());
        sidePanel.add((Component)listTools, "North");
        sidePanel.add((Component)this._listPanel, "Center");
        JPanel mainVARNAPanel = new JPanel();
        mainVARNAPanel.setLayout(new BorderLayout());
        this._splitVARNA = new JSplitPane(0, this.redrawOnSlide, this._varnaUpperPanels, this._varnaLowerPanels);
        this._splitVARNA.setDividerSize(this.dividerWidth);
        this._splitVARNA.setResizeWeight(1.0);
        this._splitLeft = new JSplitPane(1, this.redrawOnSlide, sidePanel, this._splitVARNA);
        this._splitLeft.setResizeWeight(0.1);
        this._splitLeft.setDividerSize(this.dividerWidth);
        this._splitRight = new JSplitPane(1, this.redrawOnSlide, this._splitLeft, this._infoPanel);
        this._splitRight.setResizeWeight(0.85);
        this._splitRight.setDividerSize(this.dividerWidth);
        this._infoPanel.setLayout(new GridLayout(0, 1));
        this.restoreConfig();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._splitRight, "Center");
        this.getContentPane().add((Component)this._toolbar, "North");
        this.addUpperPanel();
        this.addUpperPanel();
        this.setVisible(true);
    }

    public FragSeqGUI getSelf() {
        return this;
    }

    public VARNAHolder createIntegratedPanel(int height) {
        VARNAHolder vh = new VARNAHolder(this);
        this._varnaPanels.add(vh);
        return vh;
    }

    public void removeUpperPanel() {
        if (this._varnaUpperPanels.getComponentCount() > 1) {
            VARNAHolder vh = (VARNAHolder)this._varnaUpperPanels.getComponent(this._varnaUpperPanels.getComponentCount() - 1);
            this._infoPanel.remove(vh.getInfoPane());
            this._varnaUpperPanels.remove(vh);
            this._splitLeft.validate();
            this._splitRight.validate();
        }
    }

    public void addUpperPanel() {
        VARNAHolder vh = this.createIntegratedPanel(100);
        this._varnaUpperPanels.add(vh);
        this._infoPanel.add(vh.getInfoPane());
        this._splitRight.validate();
        this._splitLeft.validate();
    }

    public void removeLowerPanel() {
        if (this._varnaLowerPanels.getComponentCount() > 0) {
            this._varnaLowerPanels.remove(this._varnaLowerPanels.getComponentCount() - 1);
            if (this._varnaLowerPanels.getComponentCount() == 0) {
                this._splitVARNA.setDividerLocation(1.0);
                this._splitVARNA.validate();
                this._splitVARNA.repaint();
            }
            this._splitLeft.validate();
        }
    }

    public void addLowerPanel() {
        if (this._varnaLowerPanels.getComponentCount() == 0) {
            this._splitVARNA.setDividerLocation(0.7);
            this._splitVARNA.validate();
        }
        this._varnaLowerPanels.add(this.createIntegratedPanel(400));
        this._splitLeft.validate();
    }

    public void treeNodesChanged(TreeModelEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
        try {
            int index = e.getChildIndices()[0];
            node = (DefaultMutableTreeNode)node.getChildAt(index);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void addFolder(String path) {
        this.addFolder(path, true);
    }

    public void addFolder(String path, boolean shouldBeVisible) {
        FragSeqNode childNode = this._treeModel.addFolder(path);
        if (childNode != null && shouldBeVisible) {
            System.out.println("  Expanding: " + childNode.getUserObject());
            TreePath tp = new TreePath(childNode.getPath());
            this._sideList.scrollPathToVisible(tp);
            this._sideList.expandRow(this._sideList.getRowForPath(tp));
            this._sideList.updateUI();
            this._sideList.validate();
        }
    }

    public void treeNodesInserted(TreeModelEvent e) {
        System.out.println(e);
    }

    public void treeNodesRemoved(TreeModelEvent e) {
    }

    public void treeStructureChanged(TreeModelEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        TreePath t;
        if (e.getSource() == this._sideList && e.getClickCount() != 1 && e.getClickCount() == 2 && (t = this._sideList.getSelectionPath()) != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)t.getLastPathComponent();
            if (node.getUserObject() instanceof FragSeqFileModel) {
                if (!this._sideList.isExpanded(t)) {
                    try {
                        this._sideList.fireTreeWillExpand(t);
                        this._sideList.expandPath(t);
                    }
                    catch (ExpandVetoException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    try {
                        this._sideList.fireTreeWillCollapse(t);
                        this._sideList.collapsePath(t);
                    }
                    catch (ExpandVetoException e1) {
                        e1.printStackTrace();
                    }
                }
            } else if (node.getUserObject() instanceof FragSeqModel) {
                FragSeqModel model = (FragSeqModel)node.getUserObject();
                int res = model instanceof FragSeqRNASecStrModel ? this.index % (this._varnaUpperPanels.getComponentCount() + this._varnaLowerPanels.getComponentCount()) : (this.index + this._varnaUpperPanels.getComponentCount() + this._varnaLowerPanels.getComponentCount() - 1) % (this._varnaUpperPanels.getComponentCount() + this._varnaLowerPanels.getComponentCount());
                VARNAHolder c = null;
                c = res < this._varnaUpperPanels.getComponentCount() ? (VARNAHolder)this._varnaUpperPanels.getComponent(res) : (VARNAHolder)this._varnaLowerPanels.getComponent(res -= this._varnaUpperPanels.getComponentCount());
                if (c instanceof VARNAHolder) {
                    VARNAHolder h = c;
                    if (model instanceof FragSeqRNASecStrModel) {
                        h.setSecStrModel((FragSeqRNASecStrModel)model);
                        ++this.index;
                    } else if (model instanceof FragSeqAnnotationDataModel) {
                        h.setDataModel((FragSeqAnnotationDataModel)model);
                    }
                }
            }
        }
    }

    private VARNAHolder getHolder(Component vp) {
        int i;
        if (vp instanceof VARNAHolder && (i = this._varnaPanels.indexOf(vp)) != -1) {
            return this._varnaPanels.get(i);
        }
        if (vp instanceof VARNAPanel) {
            for (VARNAHolder vh : this._varnaPanels) {
                if (vh.getVARNAPanel() != vp) continue;
                return vh;
            }
        }
        return null;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void dragEnter(DropTargetDragEvent arg0) {
    }

    public void dragExit(DropTargetEvent arg0) {
    }

    public void dragOver(DropTargetDragEvent arg0) {
    }

    public void drop(DropTargetDropEvent arg0) {
        try {
            VARNAHolder h;
            DropTarget o = (DropTarget)arg0.getSource();
            if (o.getComponent() instanceof VARNAPanel && (h = this.getHolder(o.getComponent())) != null) {
                System.out.println("[X]");
                Transferable t = arg0.getTransferable();
                if (t.isDataFlavorSupported(FragSeqRNASecStrModel.Flavor)) {
                    Object data = t.getTransferData(FragSeqRNASecStrModel.Flavor);
                    if (data instanceof FragSeqRNASecStrModel) {
                        h.setSecStrModel((FragSeqRNASecStrModel)data);
                    }
                } else if (t.isDataFlavorSupported(FragSeqAnnotationDataModel.Flavor)) {
                    System.out.println("[Y]");
                    Object data = t.getTransferData(FragSeqAnnotationDataModel.Flavor);
                    if (data instanceof FragSeqAnnotationDataModel) {
                        FragSeqAnnotationDataModel d = (FragSeqAnnotationDataModel)data;
                        h.setDataModel(d);
                    }
                }
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dropActionChanged(DropTargetDragEvent arg0) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.saveConfig();
        System.exit(0);
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    private void restoreConfig() {
        BasicINI config = BasicINI.loadINI(this._INIFilename);
        ArrayList<String> vals = config.getItemList("folders");
        System.out.print("[C]" + vals);
        for (String path : vals) {
            System.out.println("Loading folder " + path);
            this.addFolder(path);
        }
        this._sideList.validate();
        this._listScroller.validate();
    }

    private void saveConfig() {
        BasicINI data = new BasicINI();
        int i = 0;
        for (String folderPath : this._treeModel.getFolders()) {
            data.addItem("folders", "val" + i, folderPath);
            ++i;
        }
        BasicINI.saveINI(data, this._INIFilename);
    }

    public void componentResized(ComponentEvent e) {
        this._sideList.validate();
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        block28: {
            String cmd = e.getActionCommand();
            System.out.println(cmd);
            if (cmd.equals("" + (Object)((Object)Commands.NEW_FOLDER))) {
                this._choice.setDialogTitle("Watch new folder...");
                this._choice.setFileSelectionMode(1);
                this._choice.setAcceptAllFileFilterUsed(false);
                try {
                    if (this._choice.showOpenDialog(this.getSelf()) == 0) {
                        this.addFolder(this._choice.getSelectedFile().getCanonicalPath());
                        break block28;
                    }
                    System.out.println("No Selection ");
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            } else if (cmd.equals("" + (Object)((Object)Commands.ADD_PANEL_DOWN))) {
                this.addLowerPanel();
            } else if (cmd.equals("" + (Object)((Object)Commands.ADD_PANEL_UP))) {
                this.addUpperPanel();
            } else if (cmd.equals("" + (Object)((Object)Commands.REMOVE_PANEL_DOWN))) {
                this.removeLowerPanel();
            } else if (cmd.equals("" + (Object)((Object)Commands.REMOVE_PANEL_UP))) {
                this.removeUpperPanel();
            } else if (cmd.equals("" + (Object)((Object)Commands.SORT_FILENAME))) {
                this._sideList.switchToPath();
            } else if (cmd.equals("" + (Object)((Object)Commands.SORT_ID))) {
                this._sideList.switchToID();
            } else if (cmd.equals("" + (Object)((Object)Commands.TEST_XML))) {
                String path = "temp.xml";
                VARNAHolder vh = (VARNAHolder)this._varnaUpperPanels.getComponent(0);
                vh.vp.toXML(path);
                try {
                    VARNAPanel cfr_ignored_0 = vh.vp;
                    FullBackup b = VARNAPanel.importSession(path);
                    VARNAHolder vh2 = (VARNAHolder)this._varnaUpperPanels.getComponent(1);
                    vh2.vp.setConfig(b.config);
                    vh2.vp.showRNAInterpolated(b.rna);
                    vh2.vp.repaint();
                }
                catch (ExceptionLoadingFailed e1) {
                    e1.printStackTrace();
                }
            } else if (cmd.equals("" + (Object)((Object)Commands.CHANGE_LNF))) {
                try {
                    Object o = this._lnf.getModel().getSelectedItem();
                    System.out.println(o);
                    UIManager.setLookAndFeel(((UIManager.LookAndFeelInfo)this._lnf.getModel().getSelectedItem()).getClassName());
                    SwingUtilities.updateComponentTreeUI(this);
                    this.pack();
                }
                catch (UnsupportedLookAndFeelException e1) {
                    e1.printStackTrace();
                }
                catch (ClassNotFoundException e2) {
                    e2.printStackTrace();
                }
                catch (InstantiationException e3) {
                    e3.printStackTrace();
                }
                catch (IllegalAccessException e4) {
                    e4.printStackTrace();
                }
            } else {
                JOptionPane.showMessageDialog(this, "Command '" + cmd + "' not implemented yet.");
            }
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        int[] t = this._sideList.getSelectionRows();
        if (t == null) {
            System.out.print("null");
        } else {
            System.out.print("[");
            int i = 0;
            while (i < t.length) {
                System.out.print(String.valueOf(t[i]) + ",");
                ++i;
            }
            System.out.println("]");
        }
    }

    public static void main(String[] args) {
        FragSeqGUI d = new FragSeqGUI();
        d.setDefaultCloseOperation(3);
        d.pack();
        d.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Commands {
        NEW_FOLDER,
        ADD_PANEL_UP,
        ADD_PANEL_DOWN,
        REMOVE_PANEL_UP,
        REMOVE_PANEL_DOWN,
        SORT_ID,
        SORT_FILENAME,
        REFRESH_ALL,
        CHANGE_LNF,
        TEST_XML;

    }

    class VARNAHolder
    extends JPanel {
        VARNAPanel vp = new VARNAPanel();
        FragSeqRNASecStrModel _m;
        FragSeqAnnotationDataModel _data;
        JPanel _infoPanel;
        JTextPane _infoTxt;

        public VARNAHolder(DropTargetListener f) {
            this.vp.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                }
            });
            this.vp.setPreferredSize(new Dimension(800, 400));
            this._infoTxt = new JTextPane();
            this._infoTxt.setPreferredSize(new Dimension(200, 0));
            this._infoTxt.setContentType("text/html");
            JScrollPane scroll = new JScrollPane(this._infoTxt, 22, 32);
            this._infoPanel = new JPanel();
            this._infoPanel.setLayout(new BorderLayout());
            this._infoPanel.setPreferredSize(new Dimension(200, 0));
            this._infoPanel.setBorder(BorderFactory.createTitledBorder("Info"));
            this._infoPanel.add((Component)scroll, "Center");
            this._infoPanel.validate();
            this.setLayout(new BorderLayout());
            this.setPreferredSize(new Dimension(300, 600));
            this.setBorder(BorderFactory.createTitledBorder("None"));
            this.add((Component)this.vp, "Center");
            DropTarget dt = new DropTarget(this.vp, f);
        }

        VARNAPanel getVARNAPanel() {
            return this.vp;
        }

        void setSecStrModel(FragSeqRNASecStrModel m) {
            this._m = m;
            this.vp.showRNAInterpolated(m.getRNA());
            this.setBorder(BorderFactory.createTitledBorder(m.toString()));
            this._infoTxt.setText(m.getRNA().getHTMLDescription());
            this._infoPanel.setBorder(BorderFactory.createTitledBorder("Info (" + this._m + ")"));
            this.vp.requestFocus();
        }

        void setDataModel(FragSeqAnnotationDataModel data) {
            this._data = data;
            data.applyTo(this.vp.getRNA());
            this.vp.repaint();
            this.vp.requestFocus();
        }

        FragSeqModel getModel() {
            this.setBorder(BorderFactory.createTitledBorder(this._m.toString()));
            return this._m;
        }

        public void setInfoTxt(String s) {
            this._infoTxt.setText(this.vp.getRNA().getHTMLDescription());
            this._infoTxt.validate();
        }

        public JPanel getInfoPane() {
            return this._infoPanel;
        }
    }
}

