/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.fragseq;

import fr.orsay.lri.varna.applications.fragseq.FragSeqAnnotationDataModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqRNASecStrModel;
import fr.orsay.lri.varna.exceptions.ExceptionExportFailed;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionPermissionDenied;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.models.rna.RNA;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragSeqFileModel
implements Comparable<FragSeqFileModel> {
    private ArrayList<FragSeqModel> _models = new ArrayList();
    protected Date _lastModified;
    protected boolean _outOfSync = false;
    protected String _caption = "";
    protected String _path = "";
    protected String _folder = "";
    protected boolean _cached = false;
    private static Random _rnd = new Random();

    public static Date lastModif(String path) {
        return new Date(new File(path).lastModified());
    }

    public FragSeqFileModel(String folder, String path) {
        this(folder, path, FragSeqFileModel.lastModif(path));
    }

    public FragSeqFileModel(String folder, String path, Date lastModified) {
        this._lastModified = lastModified;
        this._outOfSync = false;
        this._folder = folder;
        this._path = path;
        String[] s = path.split(Pattern.quote(File.separator));
        if (s.length > 0) {
            this._caption = s[s.length - 1];
        }
    }

    public void load() {
        ArrayList<RNA> rnas = null;
        try {
            rnas = this.createRNAs();
            for (RNA r : rnas) {
                this.addModel(new FragSeqRNASecStrModel(r));
                int nb = _rnd.nextInt(5);
                int i = 0;
                while (i < nb) {
                    FragSeqAnnotationDataModel data = new FragSeqAnnotationDataModel(r.getID(), i + "-" + r.getID());
                    FragSeqAnnotationDataModel.addRandomAnnotations(r, data);
                    this.addModel(data);
                    ++i;
                }
            }
        }
        catch (ExceptionUnmatchedClosingParentheses e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ExceptionFileFormatOrSyntax e) {
            e.printStackTrace();
        }
        catch (ExceptionExportFailed e) {
            e.printStackTrace();
        }
        catch (ExceptionPermissionDenied e) {
            e.printStackTrace();
        }
        catch (ExceptionLoadingFailed e) {
            e.printStackTrace();
        }
        this._cached = true;
    }

    public boolean hasChanged() {
        return this._outOfSync;
    }

    public boolean checkForModifications() {
        if (!FragSeqFileModel.lastModif(this._path).equals(this._lastModified) && !this._outOfSync) {
            this._outOfSync = true;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this._caption) + (this._outOfSync ? "*" : "");
    }

    public String getCaption() {
        return this._caption;
    }

    public String getFolder() {
        return this._folder;
    }

    public String getPath() {
        return this._path;
    }

    @Override
    public int compareTo(FragSeqFileModel o) {
        return this._caption.compareTo(o._caption);
    }

    public ArrayList<FragSeqModel> getModels() {
        if (!this._cached) {
            this.load();
        }
        return this._models;
    }

    public void addModel(FragSeqModel f) {
        this._models.add(f);
    }

    private ArrayList<RNA> createRNAs() throws ExceptionUnmatchedClosingParentheses, ExceptionFileFormatOrSyntax, FileNotFoundException, ExceptionExportFailed, ExceptionPermissionDenied, ExceptionLoadingFailed {
        ArrayList<RNA> r = RNAFactory.loadSecStr(this._path);
        for (RNA r2 : r) {
            r2.drawRNARadiate();
        }
        return new ArrayList<RNA>(r);
    }
}

