/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.fragseq;

import fr.orsay.lri.varna.applications.fragseq.FragSeqFileModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqRNASecStrModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqTreeModel;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

class FragSeqCellRenderer
extends DefaultTreeCellRenderer {
    JTree _j;
    FragSeqTreeModel _m;
    private static FragSeqCellRenderer _default = new FragSeqCellRenderer(null, null);

    public FragSeqCellRenderer(JTree j, FragSeqTreeModel m) {
        this._j = j;
        this._m = m;
    }

    public JComponent baseElements(JTree tree, FragSeqTreeModel m, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel initValue = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout());
        initValue.setBorder(null);
        result.setBorder(null);
        result.setBackground(initValue.getBackground());
        DefaultMutableTreeNode t = (DefaultMutableTreeNode)value;
        Object o = t.getUserObject();
        if (o instanceof String) {
            if (expanded) {
                initValue.setIcon(_default.getOpenIcon());
            } else {
                initValue.setIcon(_default.getClosedIcon());
            }
            result.add((Component)initValue, "West");
            JButton del = new JButton();
            del.setIcon(new SimpleIcon(Color.red, 26, false));
            Dimension d = this.getPreferredSize();
            d.width = 24;
            del.setPreferredSize(d);
            del.addActionListener(new FolderCloses((String)o, tree, m));
            result.add((Component)del, "East");
        } else if (o instanceof FragSeqRNASecStrModel) {
            initValue.setIcon(new SimpleIcon(Color.blue.darker()));
            result.add((Component)initValue, "West");
        } else if (o instanceof FragSeqFileModel) {
            initValue.setIcon(_default.getLeafIcon());
            FragSeqFileModel mod = (FragSeqFileModel)o;
            result.add((Component)initValue, "West");
            if (mod.hasChanged()) {
                JButton refresh = new JButton("Refresh");
                result.add((Component)refresh, "East");
            }
        } else if (o instanceof FragSeqModel) {
            FragSeqModel mod = (FragSeqModel)o;
            initValue.setIcon(new SimpleIcon());
            result.add((Component)initValue, "West");
        }
        return result;
    }

    public Component getDefaultTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return this.baseElements(tree, this._m, value, sel, expanded, leaf, row, hasFocus);
    }

    public Dimension getPreferredSize(int row) {
        Dimension size = super.getPreferredSize();
        size.width = this._j.getWidth();
        System.out.println(size);
        return size;
    }

    public class FolderCloses
    implements ActionListener {
        String _path;
        JComponent _p;
        FragSeqTreeModel _m;

        public FolderCloses(String path, JComponent p, FragSeqTreeModel m) {
            this._path = path;
            this._p = p;
            this._m = m;
        }

        public void actionPerformed(ActionEvent e) {
            if (JOptionPane.showConfirmDialog(this._p, "This folder will cease to be watched. Confirm?", "Closing folder", 0) == 0) {
                this._m.removeFolder(this._path);
                System.out.println(FragSeqCellRenderer.this._j);
                FragSeqCellRenderer.this._j.updateUI();
            }
        }
    }

    public class SimpleIcon
    implements Icon {
        private int _w = 16;
        private int _h = 16;
        private BasicStroke stroke = new BasicStroke(3.0f);
        private Color _r;
        private boolean _drawBackground = true;

        public SimpleIcon() {
            this(Color.magenta.darker());
        }

        public SimpleIcon(Color r) {
            this(r, 16, true);
        }

        public SimpleIcon(Color r, int dim, boolean drawBackground) {
            this(r, dim, dim, drawBackground);
        }

        public SimpleIcon(Color r, int width, int height, boolean drawBackground) {
            this._r = r;
            this._w = width;
            this._h = height;
            this._drawBackground = drawBackground;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g.create();
            if (this._drawBackground) {
                g2d.setColor(Color.WHITE);
                g2d.fillRect(x + 1, y + 1, this._w - 2, this._h - 2);
                g2d.setColor(Color.BLACK);
                g2d.drawRect(x + 1, y + 1, this._w - 2, this._h - 2);
            }
            g2d.setColor(this._r);
            g2d.setStroke(this.stroke);
            g2d.drawLine(x + 10, y + 10, x + this._w - 10, y + this._h - 10);
            g2d.drawLine(x + 10, y + this._h - 10, x + this._w - 10, y + 10);
            g2d.dispose();
        }

        public int getIconWidth() {
            return this._w;
        }

        public int getIconHeight() {
            return this._h;
        }
    }
}

