/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.fragseq;

import fr.orsay.lri.varna.applications.fragseq.FragSeqModel;
import fr.orsay.lri.varna.models.annotations.ChemProbAnnotation;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.Color;
import java.awt.datatransfer.DataFlavor;
import java.util.Hashtable;
import java.util.Random;

public class FragSeqAnnotationDataModel
extends FragSeqModel {
    private String _id;
    private String _name;
    private Hashtable<Integer, ChemProbModel> _values = new Hashtable();
    static Random _rnd = new Random();
    public static DataFlavor Flavor = new DataFlavor(FragSeqAnnotationDataModel.class, "RNA Chem Prob Data");

    public FragSeqAnnotationDataModel(String id, String name) {
        this._id = id;
        this._name = name;
    }

    public FragSeqAnnotationDataModel() {
        this(Long.toHexString(Double.doubleToLongBits(Math.random())), Long.toHexString(Double.doubleToLongBits(Math.random())));
    }

    public void addValue(ChemProbModel cpm) {
        this._values.put(cpm._baseNumber1, cpm);
    }

    public static void addRandomAnnotations(RNA r, FragSeqAnnotationDataModel data) {
        int nb = r.getSize() / 5 + _rnd.nextInt(r.getSize() / 3);
        Color[] colors = new Color[]{Color.orange, Color.black, Color.blue.darker(), Color.green.darker(), Color.gray};
        ChemProbAnnotation.ChemProbAnnotationType[] types = ChemProbAnnotation.ChemProbAnnotationType.values();
        int i = 0;
        while (i < nb) {
            int index = _rnd.nextInt(r.getSize() - 1);
            int number1 = r.getBaseNumber(index);
            int number2 = r.getBaseNumber(index + 1);
            FragSeqAnnotationDataModel fragSeqAnnotationDataModel = data;
            fragSeqAnnotationDataModel.getClass();
            ChemProbModel cpm = fragSeqAnnotationDataModel.new ChemProbModel(number1, number2, colors[_rnd.nextInt(colors.length)], 2.0 * _rnd.nextDouble(), types[_rnd.nextInt(types.length)], true);
            data.addValue(cpm);
            ++i;
        }
    }

    public String toString() {
        return this._name;
    }

    public String getID() {
        return this._id;
    }

    public void applyTo(RNA r) {
        r.clearChemProbAnnotations();
        for (ChemProbModel c : this._values.values()) {
            c.applyTo(r);
        }
    }

    public class ChemProbModel {
        private Color _color;
        private double _intensity;
        private ChemProbAnnotation.ChemProbAnnotationType _type;
        private boolean _out;
        private int _baseNumber1;
        private int _baseNumber2;

        public ChemProbModel(int baseNumber1, int baseNumber2, Color color, double intensity, ChemProbAnnotation.ChemProbAnnotationType type, boolean out) {
            this._color = color;
            this._intensity = intensity;
            this._type = type;
            this._out = out;
            this._baseNumber1 = baseNumber1;
            this._baseNumber2 = baseNumber2;
        }

        public void applyTo(RNA r) {
            System.out.println(this);
            int i = r.getIndexFromBaseNumber(this._baseNumber1);
            int j = r.getIndexFromBaseNumber(this._baseNumber2);
            if (i != -1 && j != -1) {
                ModeleBase mb1 = r.getBaseAt(i);
                ModeleBase mb2 = r.getBaseAt(j);
                r.addChemProbAnnotation(new ChemProbAnnotation(mb1, mb2, this._type, this._intensity, this._color, this._out));
            }
        }

        public String toString() {
            return this._baseNumber1 + ": col=" + this._color + " int=" + this._intensity + " type=" + (Object)((Object)this._type) + " out=" + this._out;
        }
    }
}

