/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.exceptions.ExceptionExportFailed;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionJPEGEncoding;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionModeleStyleBaseSyntaxError;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.exceptions.ExceptionParameterError;
import fr.orsay.lri.varna.exceptions.ExceptionPermissionDenied;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.exceptions.ExceptionWritingForbidden;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.interfaces.InterfaceParameterLoader;
import fr.orsay.lri.varna.models.VARNAConfigLoader;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VARNAcmd
implements InterfaceParameterLoader {
    private Hashtable<String, String> _optsValues = new Hashtable();
    private Hashtable<String, String> _basicOptsInv = new Hashtable();
    private String _inFile = "";
    private String _outFile = "";
    int _baseWidth = 400;
    double _scale = 1.0;
    float _quality = 0.9f;
    private String[] _basicOptions = new String[]{VARNAConfigLoader.algoOpt, VARNAConfigLoader.bpStyleOpt, VARNAConfigLoader.bondColorOpt, VARNAConfigLoader.backboneColorOpt, VARNAConfigLoader.periodNumOpt, VARNAConfigLoader.baseInnerColorOpt, VARNAConfigLoader.baseOutlineColorOpt};
    Vector<String[]> matrix = new Vector();
    private static int MAX_WIDTH = 100;

    public VARNAcmd(Vector<String> args) throws ExitCode {
        int j = 0;
        while (j < this._basicOptions.length) {
            this._basicOptsInv.put(this._basicOptions[j], this._basicOptions[j]);
            ++j;
        }
        int i = 0;
        while (i < args.size()) {
            String opt = args.elementAt(i);
            if (opt.charAt(0) != '-') {
                this.errorExit("Missing or unknown option \"" + opt + "\"");
            }
            if (opt.equals("-h")) {
                this.displayLightHelpExit();
            }
            if (opt.equals("-x")) {
                this.displayDetailledHelpExit();
            } else {
                if (i + 1 >= args.size()) {
                    this.errorExit("Missing argument for option \"" + opt + "\"");
                }
                String val = args.get(i + 1);
                if (opt.equals("-i")) {
                    this._inFile = val;
                } else if (opt.equals("-o")) {
                    this._outFile = val;
                } else if (opt.equals("-quality")) {
                    this._quality = Float.parseFloat(val);
                } else if (opt.equals("-resolution")) {
                    this._scale = Float.parseFloat(val);
                } else {
                    this.addOption(opt, val);
                }
            }
            i += 2;
        }
        if (this._outFile.equals("")) {
            this.errorExit("Missing output file");
        }
    }

    public void addOption(String key, String value) {
        if (key.equals("-i")) {
            this._inFile = value;
        } else if (key.equals("-o")) {
            this._outFile = value;
        } else {
            this._optsValues.put(key.substring(1), value);
        }
    }

    private String getDescription() {
        return "VARNA v3.8 Assisted drawing of RNA secondary structure (Command Line version)";
    }

    private String indent(int k) {
        String result = "";
        int i = 0;
        while (i < k) {
            result = String.valueOf(result) + "  ";
            ++i;
        }
        return result;
    }

    private String complete(String s, int k) {
        String result = s;
        while (result.length() < k) {
            result = String.valueOf(result) + " ";
        }
        return result;
    }

    private void addLine(String opt, String val) {
        String[] line = new String[]{opt, val};
        this.matrix.add(line);
    }

    private void printMatrix(int ind) {
        String[] elem;
        String[][] values = new String[this.matrix.size()][];
        this.matrix.toArray((T[])values);
        Arrays.sort(values, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] tab1 = (String[])o1;
                String[] tab2 = (String[])o2;
                return tab1[0].compareTo(tab2[0]);
            }
        });
        int maxSize = 0;
        int i = 0;
        while (i < values.length) {
            elem = values[i];
            maxSize = Math.max(maxSize, elem[0].length());
            ++i;
        }
        maxSize += ind + 2;
        i = 0;
        while (i < values.length) {
            elem = values[i];
            String opt = elem[0];
            String msg = elem[1];
            opt = String.valueOf(this.complete("", ind)) + "-" + this.complete(opt, maxSize - ind);
            System.out.println(String.valueOf(opt) + msg.substring(0, Math.min(MAX_WIDTH - opt.length(), msg.length())));
            if (opt.length() + msg.length() >= MAX_WIDTH) {
                int off = MAX_WIDTH - opt.length();
                while (off < msg.length()) {
                    String nmsg = msg.substring(off, Math.min(off + MAX_WIDTH - opt.length(), msg.length()));
                    System.out.println(String.valueOf(this.complete("", opt.length())) + nmsg);
                    off += MAX_WIDTH - opt.length();
                }
            }
            ++i;
        }
        this.matrix = new Vector();
    }

    private void printUsage() {
        System.out.println("Usage: java -cp . [-i InFile|-sequenceDBN XXX -structureDBN YYY] -o OutFile [Options]");
        System.out.println("Where:");
        System.out.println(String.valueOf(this.indent(1)) + "OutFile\tSupported formats: {JPEG,PNG,EPS,XFIG,SVG}");
        System.out.println(String.valueOf(this.indent(1)) + "InFile\tSecondary structure file: Supported formats: {BPSEQ,CT,RNAML,DBN}");
    }

    private void printHelpOptions() {
        System.out.println("\nMain options:");
        this.addLine("h", "Displays a short description of main options and exits");
        this.addLine("x", "Displays a detailled description of all options");
        this.printMatrix(2);
    }

    private void printMainOptions(String[][] info) {
        System.out.println("\nMain options:");
        this.addLine("h", "Displays a short description of main options and exits");
        this.addLine("x", "Displays a detailled description of all options");
        int i = 0;
        while (i < info.length) {
            String key = info[i][0];
            if (this._basicOptsInv.containsKey(key)) {
                this.addLine(key, info[i][2]);
            }
            ++i;
        }
        this.printMatrix(2);
    }

    private void printAdvancedOptions(String[][] info) {
        System.out.println("\nAdvanced options:");
        int i = 0;
        while (i < info.length) {
            String key = info[i][0];
            if (!this._basicOptsInv.containsKey(key)) {
                this.addLine(key, info[i][2]);
            }
            ++i;
        }
        this.addLine("quality", "Sets quality (non-vector file formats only)");
        this.addLine("resolution", "Sets resolution (non-vector file formats only)");
        this.printMatrix(2);
    }

    private void displayLightHelpExit() throws ExitCode {
        String[][] info = VARNAConfigLoader.getParameterInfo();
        System.out.println(this.getDescription());
        this.printUsage();
        this.printMainOptions(info);
        throw new ExitCode(1, "");
    }

    private void displayDetailledHelpExit() throws ExitCode {
        String[][] info = VARNAConfigLoader.getParameterInfo();
        System.out.println(this.getDescription());
        this.printUsage();
        this.printMainOptions(info);
        this.printAdvancedOptions(info);
        throw new ExitCode(1, "");
    }

    private void errorExit(String msg) throws ExitCode {
        System.out.println(this.getDescription());
        System.out.println("Error: " + msg + "\n");
        this.printUsage();
        this.printHelpOptions();
        throw new ExitCode(1, "");
    }

    @Override
    public String getParameterValue(String key, String def) {
        if (this._optsValues.containsKey(key)) {
            return this._optsValues.get(key);
        }
        return def;
    }

    public String formatOutputPath(String base, int index, int total) {
        String result = base;
        if (total > 1) {
            String ext;
            String pref;
            int indexDot = base.lastIndexOf(46);
            if (indexDot != -1) {
                pref = base.substring(0, indexDot);
                ext = base.substring(indexDot);
            } else {
                pref = base;
                ext = "";
            }
            result = String.valueOf(pref) + "-" + index + ext;
        }
        System.err.println("Output file: " + result);
        return result;
    }

    public void run() throws IOException, ExitCode {
        VARNAConfigLoader VARNAcfg = new VARNAConfigLoader(this);
        try {
            ArrayList<RNA> rnas;
            if (!this._inFile.equals("")) {
                rnas = RNAFactory.loadSecStr(this._inFile);
                if (rnas.isEmpty()) {
                    throw new ExceptionFileFormatOrSyntax("No RNA could be parsed from file '" + this._inFile + "'.");
                }
            } else {
                RNA r = new RNA();
                r.setRNA(this.getParameterValue("sequenceDBN", ""), this.getParameterValue("structureDBN", ""));
                rnas = new ArrayList();
                rnas.add(r);
            }
            int index = 1;
            for (RNA r : rnas) {
                VARNAcfg.setRNA(r);
                ArrayList<VARNAPanel> vpl = VARNAcfg.createVARNAPanels();
                if (vpl.size() > 0) {
                    VARNAPanel _vp = vpl.get(0);
                    RNA _rna = _vp.getRNA();
                    Rectangle2D.Double bbox = _vp.getRNA().getBBox();
                    if (this._outFile.toLowerCase().endsWith(".jpeg") || this._outFile.toLowerCase().endsWith(".jpg") || this._outFile.toLowerCase().endsWith(".png")) {
                        _vp.setTitleFontSize((int)(this._scale * (double)_vp.getTitleFont().getSize()));
                        _vp.setSize((int)((double)this._baseWidth * this._scale), (int)(this._scale * (double)this._baseWidth * bbox.height / bbox.width));
                    }
                    if (this._outFile.toLowerCase().endsWith(".eps")) {
                        _rna.saveRNAEPS(this.formatOutputPath(this._outFile, index, rnas.size()), _vp.getConfig());
                    } else if (this._outFile.toLowerCase().endsWith(".xfig") || this._outFile.toLowerCase().endsWith(".fig")) {
                        _rna.saveRNAXFIG(this.formatOutputPath(this._outFile, index, rnas.size()), _vp.getConfig());
                    } else if (this._outFile.toLowerCase().endsWith(".svg")) {
                        _rna.saveRNASVG(this.formatOutputPath(this._outFile, index, rnas.size()), _vp.getConfig());
                    } else if (this._outFile.toLowerCase().endsWith(".jpeg") || this._outFile.toLowerCase().endsWith(".jpg")) {
                        this.saveToJPEG(this.formatOutputPath(this._outFile, index, rnas.size()), _vp);
                    } else if (this._outFile.toLowerCase().endsWith(".png")) {
                        this.saveToPNG(this.formatOutputPath(this._outFile, index, rnas.size()), _vp);
                    } else if (this._outFile.toLowerCase().endsWith(".varna")) {
                        _vp.saveSession(this.formatOutputPath(this._outFile, index, rnas.size()));
                    } else {
                        this.errorExit("Unknown extension for output file \"" + this._outFile + "\"");
                    }
                }
                ++index;
            }
        }
        catch (ExceptionWritingForbidden e) {
            e.printStackTrace();
            throw new ExitCode(1, "");
        }
        catch (ExceptionJPEGEncoding e) {
            e.printStackTrace();
            throw new ExitCode(1, "");
        }
        catch (ExceptionParameterError e) {
            e.printStackTrace();
            throw new ExitCode(1, "");
        }
        catch (ExceptionModeleStyleBaseSyntaxError e) {
            e.printStackTrace();
            throw new ExitCode(1, "");
        }
        catch (ExceptionNonEqualLength e) {
            e.printStackTrace();
            throw new ExitCode(1, "");
        }
        catch (ExceptionUnmatchedClosingParentheses e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (ExceptionExportFailed e) {
            e.printStackTrace();
            throw new ExitCode(1, "");
        }
        catch (ExceptionPermissionDenied e) {
            e.printStackTrace();
            throw new ExitCode(1, "");
        }
        catch (ExceptionLoadingFailed e) {
            e.printStackTrace();
            throw new ExitCode(1, "");
        }
        catch (ExceptionFileFormatOrSyntax e) {
            e.setPath(this._inFile);
            e.printStackTrace();
            throw new ExitCode(1, "");
        }
        catch (FileNotFoundException e) {
            throw new ExitCode(1, "Error: Missing input file \"" + this._inFile + "\".");
        }
        throw new ExitCode(0, "");
    }

    public void saveToJPEG(String filename, VARNAPanel vp) throws ExceptionJPEGEncoding, ExceptionExportFailed {
        BufferedImage myImage = new BufferedImage(Math.round(vp.getWidth()), Math.round(vp.getHeight()), 1);
        Graphics2D g2 = myImage.createGraphics();
        vp.paintComponent(g2);
        try {
            FileImageOutputStream out = new FileImageOutputStream(new File(filename));
            ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
            ImageWriteParam params = writer.getDefaultWriteParam();
            params.setCompressionMode(2);
            params.setCompressionQuality(this._quality);
            writer.setOutput(out);
            IIOImage myIIOImage = new IIOImage(myImage, null, null);
            writer.write(null, myIIOImage, params);
            out.close();
        }
        catch (IOException e) {
            throw new ExceptionExportFailed(e.getMessage(), filename);
        }
    }

    public void saveToPNG(String filename, VARNAPanel vp) throws ExceptionExportFailed {
        BufferedImage myImage = new BufferedImage(Math.round(vp.getWidth()), Math.round(vp.getHeight()), 1);
        Graphics2D g2 = myImage.createGraphics();
        vp.paintComponent(g2);
        g2.dispose();
        try {
            ImageIO.write((RenderedImage)myImage, "PNG", new File(filename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] argv) {
        Vector<String> opts = new Vector<String>();
        int i = 0;
        while (i < argv.length) {
            opts.add(argv[i]);
            ++i;
        }
        try {
            VARNAcmd app = new VARNAcmd(opts);
            app.run();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExitCode e) {
            System.err.println(e.getExitMessage());
            System.exit(e.getExitCode());
        }
    }

    public class ExitCode
    extends Exception {
        private static final long serialVersionUID = -3011196062868355584L;
        private int _c;
        private String _msg;

        public ExitCode(int c, String msg) {
            this._c = c;
            this._msg = msg;
        }

        public int getExitCode() {
            return this._c;
        }

        public String getExitMessage() {
            return this._msg;
        }
    }
}

