/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionModeleStyleBaseSyntaxError;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.exceptions.ExceptionParameterError;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.interfaces.InterfaceVARNAListener;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.rna.ModelBaseStyle;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NussinovDemo
extends JFrame
implements InterfaceVARNAListener {
    private static final long serialVersionUID = -790155708306987257L;
    private static final String SEQUENCE_A = "AGGCACGUCU";
    private static final String SEQUENCE_B = "GAGUAGCCUC";
    private static final String SEQUENCE_C = "GCAUAGCUGC";
    private static final String SEQUENCE_BIG = "AAAACAAAAACACCAUGGUGUUUUCACCCAAUUGGGUGAAAACAGAGAUCUCGAGAUCUCUGUUUUUGUUUU";
    private static final String DEFAULT_STRUCTURE = "..........";
    private VARNAPanel _vpMaster;
    private JPanel _tools = new JPanel();
    private JPanel _input = new JPanel();
    private JPanel _seqPanel = new JPanel();
    private JPanel _structPanel = new JPanel();
    private JLabel _info = new JLabel();
    private JLabel _struct = new JLabel("..........");
    private JComboBox _seq1 = new JComboBox();
    private JLabel _structLabel = new JLabel("Predicted Secondary Structure");
    private JLabel _seqLabel = new JLabel("RNA sequence");
    private JButton _goButton = new JButton("Fold");
    private JButton _switchButton = new JButton("Reset");
    private static String errorOpt = "error";
    private boolean _error;
    private Color _backgroundColor = Color.white;
    private int _algoCode;

    public static ModelBaseStyle createStyle(String txt) {
        ModelBaseStyle result = new ModelBaseStyle();
        try {
            result.assignParameters(txt);
        }
        catch (ExceptionModeleStyleBaseSyntaxError e) {
            e.printStackTrace();
        }
        catch (ExceptionParameterError e) {
            e.printStackTrace();
        }
        return result;
    }

    public void applyTo(VARNAPanel vp, ModelBaseStyle mb, int[] indices) {
        int i = 0;
        while (i < indices.length) {
            ModeleBase m = vp.getRNA().getBaseAt(indices[i]);
            m.setStyleBase(mb);
            if (m.getElementStructure() != -1) {
                vp.getRNA().getBaseAt(m.getElementStructure()).setStyleBase(mb);
            }
            ++i;
        }
        vp.repaint();
    }

    public NussinovDemo() {
        try {
            this._vpMaster = new VARNAPanel(this.getSeq(), "");
        }
        catch (ExceptionNonEqualLength e) {
            this._vpMaster.errorDialog(e);
        }
        this._vpMaster.setPreferredSize(new Dimension(600, 600));
        this.RNAPanelDemoInit();
    }

    private void RNAPanelDemoInit() {
        int marginTools = 250;
        Font textFieldsFont = Font.decode("MonoSpaced-BOLD-16");
        Font labelsFont = this._seqLabel.getFont().deriveFont(16.0f);
        this._seq1.setFont(textFieldsFont);
        String[] seqs = new String[]{SEQUENCE_A, SEQUENCE_B, SEQUENCE_C, SEQUENCE_BIG};
        this._seq1.setModel(new DefaultComboBoxModel<String>(seqs));
        this._seq1.setEditable(true);
        this.setBackground(this._backgroundColor);
        this._vpMaster.setBackground(this._backgroundColor);
        this._vpMaster.addVARNAListener(this);
        this._seqLabel.setHorizontalTextPosition(2);
        this._seqLabel.setPreferredSize(new Dimension(marginTools, 15));
        this._seqLabel.setFont(labelsFont);
        this._structLabel.setFont(labelsFont);
        this._goButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NussinovDemo.this.showSolution();
                NussinovDemo.this.onStructureRedrawn();
            }
        });
        this._switchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    RNA r = new RNA();
                    r.setRNA("", "");
                    NussinovDemo.this._struct.setText("");
                    NussinovDemo.this._vpMaster.setTitle("");
                    NussinovDemo.this._vpMaster.showRNA(r);
                    NussinovDemo.this.onStructureRedrawn();
                }
                catch (ExceptionFileFormatOrSyntax e2) {
                    e2.printStackTrace();
                }
                catch (ExceptionUnmatchedClosingParentheses e2) {
                    e2.printStackTrace();
                }
                NussinovDemo.this._vpMaster.repaint();
            }
        });
        this._seqPanel.setLayout(new BorderLayout());
        this._seqPanel.add((Component)this._seqLabel, "West");
        this._seqPanel.add((Component)this._seq1, "Center");
        this._structLabel.setPreferredSize(new Dimension(marginTools, 15));
        this._structLabel.setHorizontalTextPosition(2);
        this._struct.setFont(textFieldsFont);
        this._structPanel.setLayout(new BorderLayout());
        this._structPanel.add((Component)this._structLabel, "West");
        this._structPanel.add((Component)this._struct, "Center");
        this._input.setLayout(new GridLayout(2, 0));
        this._input.add(this._seqPanel);
        this._input.add(this._structPanel);
        JPanel goPanel = new JPanel();
        goPanel.setLayout(new BorderLayout());
        this._tools.setLayout(new BorderLayout());
        this._tools.add((Component)this._input, "Center");
        this._tools.add((Component)this._info, "South");
        this._tools.add((Component)goPanel, "East");
        goPanel.add((Component)this._goButton, "Center");
        goPanel.add((Component)this._switchButton, "South");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel VARNAs = new JPanel();
        VARNAs.setLayout(new GridLayout(1, 1));
        VARNAs.add(this._vpMaster);
        this.getContentPane().add((Component)VARNAs, "Center");
        this.getContentPane().add((Component)this._tools, "South");
        this.setVisible(true);
        this._vpMaster.getVARNAUI().UIRadiate();
        this._vpMaster.setTitleFontSize(26.0f);
        this._vpMaster.setTitleFontStyle(0);
        this.setTitle("RNA Folding Demo - Simple Matching Algorithm");
        this.onStructureRedrawn();
    }

    private void showSolution() {
        RNA rflat = this.getRNA();
        rflat.drawRNALine();
        this._vpMaster.setTitle("#Secondary Structures: " + this.count(this.getSeq()));
        this._struct.setText(this.getStruct());
        this._vpMaster.drawRNA(rflat);
        this._vpMaster.showRNAInterpolated(rflat);
        RNA rfolded = this.getRNA();
        rfolded.drawRNARadiate(this._vpMaster.getConfig());
        this._vpMaster.showRNAInterpolated(rfolded);
        RNA rLinear = this.getRNA();
        rLinear.drawRNALine();
        this._vpMaster.showRNAInterpolated(rLinear);
    }

    public RNA getRNA() {
        RNA r = new RNA();
        try {
            r.setRNA(this.getSeq(), this.getStruct());
        }
        catch (ExceptionUnmatchedClosingParentheses e) {
            e.printStackTrace();
        }
        catch (ExceptionFileFormatOrSyntax e) {
            e.printStackTrace();
        }
        return r;
    }

    public String getSeq() {
        return "" + this._seq1.getSelectedItem();
    }

    private boolean canBasePair(char a, char b) {
        if (a == 'G' && b == 'C') {
            return true;
        }
        if (a == 'C' && b == 'G') {
            return true;
        }
        if (a == 'U' && b == 'A') {
            return true;
        }
        return a == 'A' && b == 'U';
    }

    public int[][] fillMatrix(String seq) {
        int n = seq.length();
        int[][] tab = new int[n][n];
        int m = 1;
        while (m <= n) {
            int i = 0;
            while (i < n - m + 1) {
                int j = i + m - 1;
                tab[i][j] = 0;
                if (i < j) {
                    tab[i][j] = Math.max(tab[i][j], tab[i + 1][j]);
                    int k = i + 1;
                    while (k <= j) {
                        if (this.canBasePair(seq.charAt(i), seq.charAt(k))) {
                            int fact1 = 0;
                            if (k > i + 1) {
                                fact1 = tab[i + 1][k - 1];
                            }
                            int fact2 = 0;
                            if (k < j - 1) {
                                fact2 = tab[k + 1][j];
                            }
                            tab[i][j] = Math.max(tab[i][j], 1 + fact1 + fact2);
                        }
                        ++k;
                    }
                }
                ++i;
            }
            ++m;
        }
        return tab;
    }

    private String backtrack(int[][] tab, String seq) {
        return this.backtrack(tab, seq, 0, seq.length() - 1);
    }

    private String backtrack(int[][] tab, String seq, int i, int j) {
        if (i < j) {
            if (tab[i][j] == tab[i + 1][j]) {
                return "." + this.backtrack(tab, seq, i + 1, j);
            }
            int k = i + 1;
            while (k <= j) {
                if (this.canBasePair(seq.charAt(i), seq.charAt(k))) {
                    int fact1 = 0;
                    if (k > i + 1) {
                        fact1 = tab[i + 1][k - 1];
                    }
                    int fact2 = 0;
                    if (k < j - 1) {
                        fact2 = tab[k + 1][j];
                    }
                    if (tab[i][j] == 1 + fact1 + fact2) {
                        return "(" + this.backtrack(tab, seq, i + 1, k - 1) + ")" + this.backtrack(tab, seq, k + 1, j);
                    }
                }
                ++k;
            }
        } else if (i == j) {
            return ".";
        }
        return "";
    }

    public long count(String seq) {
        int n = seq.length();
        long[][] tab = new long[n][n];
        int m = 1;
        while (m <= n) {
            int i = 0;
            while (i < n - m + 1) {
                int j = i + m - 1;
                tab[i][j] = 0L;
                if (i < j) {
                    long[] lArray = tab[i];
                    int n2 = j;
                    lArray[n2] = lArray[n2] + tab[i + 1][j];
                    int k = i + 1;
                    while (k <= j) {
                        if (this.canBasePair(seq.charAt(i), seq.charAt(k))) {
                            long fact1 = 1L;
                            if (k > i + 1) {
                                fact1 = tab[i + 1][k - 1];
                            }
                            long fact2 = 1L;
                            if (k < j - 1) {
                                fact2 = tab[k + 1][j];
                            }
                            long[] lArray2 = tab[i];
                            int n3 = j;
                            lArray2[n3] = lArray2[n3] + fact1 * fact2;
                        }
                        ++k;
                    }
                } else {
                    tab[i][j] = 1L;
                }
                ++i;
            }
            ++m;
        }
        return tab[0][n - 1];
    }

    public String getStruct() {
        String seq = this.getSeq();
        seq = seq.toUpperCase();
        int n = seq.length();
        int[][] mfe = this.fillMatrix(seq);
        String back = this.backtrack(mfe, seq);
        return back;
    }

    private String cleanStruct(String struct) {
        struct = struct.replaceAll("[:-]", "");
        return struct;
    }

    public void init() {
        this._vpMaster.setBackground(this._backgroundColor);
        this._error = true;
    }

    private Color getSafeColor(String col, Color def) {
        Color result;
        try {
            result = Color.decode(col);
        }
        catch (Exception e) {
            try {
                result = Color.getColor(col, def);
            }
            catch (Exception e2) {
                return def;
            }
        }
        return result;
    }

    public VARNAPanel get_varnaPanel() {
        return this._vpMaster;
    }

    public void set_varnaPanel(VARNAPanel surface) {
        this._vpMaster = surface;
    }

    public JLabel get_info() {
        return this._info;
    }

    public void set_info(JLabel _info) {
        this._info = _info;
    }

    public static void main(String[] args) {
        NussinovDemo d = new NussinovDemo();
        d.setDefaultCloseOperation(3);
        d.pack();
        d.setVisible(true);
    }

    public void onStructureRedrawn() {
        this._vpMaster.repaint();
    }

    public void onWarningEmitted(String s) {
    }

    public void onLoad(String path) {
    }

    public void onLoaded() {
    }

    public void onUINewStructure(VARNAConfig v, RNA r) {
    }
}

