/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicINI {
    private Hashtable<String, Hashtable<String, String>> _data = new Hashtable();

    public void addItem(String category, String key, String val) {
        if (!this._data.containsKey(category)) {
            this._data.put(category, new Hashtable());
        }
        System.out.println("[E]" + key + "->" + val);
        this._data.get(category).put(key, val);
    }

    public String getItem(String category, String key) {
        String result = "";
        if (this._data.containsKey(category) && this._data.get(category).containsKey(key)) {
            result = this._data.get(category).get(key);
        }
        return result;
    }

    public ArrayList<String> getItemList(String category) {
        ArrayList<String> result = new ArrayList<String>();
        if (this._data.containsKey(category)) {
            for (String key : this._data.get(category).keySet()) {
                result.add(this._data.get(category).get(key));
            }
        }
        return result;
    }

    public static void saveINI(BasicINI data, String filename) {
        try {
            FileWriter out = new FileWriter(filename);
            Set<String> cats = data._data.keySet();
            Object[] sortedCats = new String[cats.size()];
            sortedCats = cats.toArray(sortedCats);
            Arrays.sort(sortedCats);
            int i = 0;
            while (i < sortedCats.length) {
                Object cat = sortedCats[i];
                out.write("[" + (String)cat + "]\n");
                Hashtable<String, String> vals = data._data.get(cat);
                Set<String> keys = vals.keySet();
                String[] sortedKeys = new String[keys.size()];
                sortedKeys = keys.toArray(sortedKeys);
                int j = 0;
                while (j < sortedKeys.length) {
                    String key = sortedKeys[j];
                    String val = vals.get(key);
                    out.write(String.valueOf(key) + "=" + val + "\n");
                    ++j;
                }
                ++i;
            }
            out.close();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    public static BasicINI loadINI(String filename) {
        BasicINI result = new BasicINI();
        boolean CATEGORY = false;
        boolean KEY = true;
        int VAL = 2;
        int state = 1;
        String category = "";
        String key = "";
        String val = "";
        try {
            System.out.println("Loading " + new File(filename).getAbsolutePath());
            FileReader r = new FileReader(filename);
            StreamTokenizer s = new StreamTokenizer(r);
            s.resetSyntax();
            s.eolIsSignificant(true);
            s.wordChars(0, 255);
            s.whitespaceChars(0, 15);
            s.ordinaryChar(91);
            s.ordinaryChar(93);
            s.ordinaryChar(61);
            int token = s.nextToken();
            System.out.println("[F]" + token);
            while (token != -1) {
                System.out.println("[G]");
                System.out.println(token);
                block1 : switch (token) {
                    case 91: {
                        state = 0;
                        break;
                    }
                    case 93: {
                        state = 1;
                        break;
                    }
                    case 61: {
                        state = 2;
                        break;
                    }
                    case 10: {
                        if (state == 2) {
                            state = 1;
                            result.addItem(category, key, val);
                            key = "";
                            val = "";
                        }
                    }
                    case -3: {
                        String word = s.sval;
                        switch (state) {
                            case 0: {
                                category = word;
                                break block1;
                            }
                            case 1: {
                                key = word;
                                break block1;
                            }
                            case 2: {
                                val = word;
                            }
                        }
                    }
                }
                token = s.nextToken();
            }
        }
        catch (Exception exc1) {
            exc1.printStackTrace();
        }
        return result;
    }
}

