/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna;

import fr.orsay.lri.varna.controlers.ControleurBlinkingThread;
import fr.orsay.lri.varna.controlers.ControleurClicMovement;
import fr.orsay.lri.varna.controlers.ControleurDraggedMolette;
import fr.orsay.lri.varna.controlers.ControleurInterpolator;
import fr.orsay.lri.varna.controlers.ControleurMolette;
import fr.orsay.lri.varna.controlers.ControleurVARNAPanelKeys;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionNAViewAlgorithm;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.interfaces.InterfaceVARNAListener;
import fr.orsay.lri.varna.interfaces.InterfaceVARNARNAListener;
import fr.orsay.lri.varna.interfaces.InterfaceVARNASelectionListener;
import fr.orsay.lri.varna.models.BaseList;
import fr.orsay.lri.varna.models.FullBackup;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.annotations.ChemProbAnnotation;
import fr.orsay.lri.varna.models.annotations.HighlightRegionAnnotation;
import fr.orsay.lri.varna.models.annotations.TextAnnotation;
import fr.orsay.lri.varna.models.export.SwingGraphics;
import fr.orsay.lri.varna.models.export.VueVARNAGraphics;
import fr.orsay.lri.varna.models.rna.Mapping;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.ModeleBaseNucleotide;
import fr.orsay.lri.varna.models.rna.ModeleBasesComparison;
import fr.orsay.lri.varna.models.rna.ModeleColorMap;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.utils.VARNASessionParser;
import fr.orsay.lri.varna.views.VueMenu;
import fr.orsay.lri.varna.views.VueUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.undo.UndoManager;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VARNAPanel
extends JPanel {
    private static final long serialVersionUID = 8194421570308956001L;
    private RNA _RNA = new RNA();
    private boolean _debug = false;
    private VARNAConfig _conf = new VARNAConfig();
    private ArrayList<InterfaceVARNAListener> _VARNAListeners = new ArrayList();
    private ArrayList<InterfaceVARNASelectionListener> _selectionListeners = new ArrayList();
    private ArrayList<InterfaceVARNARNAListener> _RNAListeners = new ArrayList();
    UndoManager _manager;
    private Point2D.Double[] _realCoords = new Point2D.Double[0];
    private Point2D.Double[] _realCenters = new Point2D.Double[0];
    private double _scaleFactor = 1.0;
    private Point2D.Double _offsetPanel = new Point2D.Double();
    private Point2D.Double _offsetRNA = new Point2D.Double();
    private double _offX;
    private double _offY;
    private ControleurBlinkingThread _blink;
    private BaseList _selectedBases = new BaseList("selection");
    private ArrayList<ModeleBase> _backupSelection = new ArrayList();
    private Integer _nearestBase = null;
    private Point2D.Double _lastSelectedCoord = new Point2D.Double(0.0, 0.0);
    private Point2D.Double _linkOrigin = null;
    private Point2D.Double _linkDestination = null;
    private Rectangle _selectionRectangle = null;
    private boolean _highlightAnnotation = false;
    private int _titleHeight;
    private Dimension _border = new Dimension(0, 0);
    private boolean _drawBBox = false;
    private boolean _drawBorder = false;
    private Point _translation;
    private boolean _horsCadre;
    private boolean _premierAffichage;
    private ControleurInterpolator _interpolator;
    private VueMenu _popup = new VueMenu(this);
    private VueUI _UI = new VueUI(this);
    private TextAnnotation _selectedAnnotation;
    public static String VARNA_SESSION_EXTENSION = "varna";
    public ModeleBase _hoveredBase = null;
    public static String XML_ELEMENT_NAME = "VARNASession";

    public VARNAPanel() {
        this.init();
        this.drawRNA();
    }

    public VARNAPanel(String seq, String str) throws ExceptionNonEqualLength {
        this(seq, str, 2);
    }

    public VARNAPanel(String seq, String str, int drawMode) throws ExceptionNonEqualLength {
        this(seq, str, drawMode, "");
    }

    public VARNAPanel(Reader r) throws ExceptionNonEqualLength, ExceptionFileFormatOrSyntax {
        this(r, 2);
    }

    public VARNAPanel(Reader r, int drawMode) throws ExceptionNonEqualLength, ExceptionFileFormatOrSyntax {
        this(r, drawMode, "");
    }

    public VARNAPanel(Reader r, int drawMode, String title) throws ExceptionNonEqualLength, ExceptionFileFormatOrSyntax {
        this.init();
        this.drawRNA(r, drawMode);
        this.setTitle(title);
    }

    public void setOriginLink(Point2D.Double p) {
        this._linkOrigin = p;
    }

    public void setDestinationLink(Point2D.Double p) {
        this._linkDestination = p;
    }

    public void removeLink() {
        this._linkOrigin = null;
        this._linkDestination = null;
    }

    public VARNAPanel(RNA r) {
        this.showRNA(r);
        this.init();
    }

    public VARNAPanel(String seq, String str, int drawMode, String title) throws ExceptionNonEqualLength {
        this.drawRNA(seq, str, drawMode);
        this.init();
        this.setTitle(title);
    }

    public VARNAPanel(String seq1, String struct1, String seq2, String struct2, int drawMode, String title) {
        this._conf._comparisonMode = true;
        this.drawRNA(seq1, struct1, seq2, struct2, drawMode);
        this.init();
        this.setTitle(title);
    }

    private void init() {
        this.setBackground(VARNAConfig.DEFAULT_BACKGROUND_COLOR);
        this._manager = new UndoManager();
        this._manager.setLimit(10000);
        this._UI.addUndoableEditListener(this._manager);
        this._blink = new ControleurBlinkingThread(this, 50L, 0.0, 1.0, 0.0, 0.2);
        this._blink.start();
        this._premierAffichage = true;
        this._translation = new Point(0, 0);
        this._horsCadre = false;
        this.setFont(this._conf._fontBasesGeneral);
        ControleurClicMovement controleurClicMovement = new ControleurClicMovement(this);
        this.addMouseListener(controleurClicMovement);
        this.addMouseMotionListener(controleurClicMovement);
        this.addMouseWheelListener(new ControleurMolette(this));
        ControleurDraggedMolette ctrlDraggedMolette = new ControleurDraggedMolette(this);
        this.addMouseMotionListener(ctrlDraggedMolette);
        this.addMouseListener(ctrlDraggedMolette);
        ControleurVARNAPanelKeys ctrlKey = new ControleurVARNAPanelKeys(this);
        this.addKeyListener(ctrlKey);
        this.addFocusListener(ctrlKey);
        this._interpolator = new ControleurInterpolator(this);
        this._interpolator.start();
    }

    public void undo() {
        this._manager.undo();
    }

    public void redo() {
        this._manager.redo();
    }

    public void setTitleFontStyle(int newStyle) {
        this._conf._titleFont = this._conf._titleFont.deriveFont(newStyle);
        this.updateTitleHeight();
    }

    public void setTitleFontSize(float newSize) {
        this._conf._titleFont = this._conf._titleFont.deriveFont(newSize);
        this.updateTitleHeight();
    }

    public void setTitleFontFamily(String newFamily) {
        this._conf._titleFont = new Font(newFamily, this._conf._titleFont.getStyle(), this._conf._titleFont.getSize());
        this.updateTitleHeight();
    }

    public void setTitleFontColor(Color newColor) {
        this._conf._titleColor = newColor;
        this.updateTitleHeight();
    }

    public void setBaseFontSize(Float size) {
        this._conf._fontBasesGeneral = this._conf._fontBasesGeneral.deriveFont(size.floatValue());
    }

    public void setNumbersFontSize(Float size) {
        this._conf._numbersFont = this._conf._numbersFont.deriveFont(size.floatValue());
    }

    public void setBaseFontStyle(int style) {
        this._conf._fontBasesGeneral = this._conf._fontBasesGeneral.deriveFont(style);
    }

    private void updateTitleHeight() {
        this._titleHeight = !this.getTitle().equals("") ? (int)((double)this._conf._titleFont.getSize() * 1.5) : 0;
        if (this._translation.x == 0) {
            this._translation.y = (int)((double)(-this.getTitleHeight()) / 2.0);
        }
    }

    public void setTitle(String title) {
        this._RNA.setName(title);
        this._conf._title = title;
        this.updateTitleHeight();
    }

    public void setNumPeriod(int n) {
        this._conf._numPeriod = n;
    }

    public int getNumPeriod() {
        return this._conf._numPeriod;
    }

    private void setAutoFit(boolean fit) {
        this._conf._autoFit = fit;
        this.repaint();
    }

    public void lockScrolling() {
        this.setAutoFit(false);
        this.setAutoCenter(false);
    }

    public void unlockScrolling() {
        this.setAutoFit(true);
        this.setAutoCenter(true);
    }

    private void drawStringOutline(VueVARNAGraphics g2D, String res, double x, double y, double margin) {
        Dimension d = g2D.getStringDimension(res);
        g2D.setColor(Color.GRAY);
        g2D.setDashedStroke();
        g2D.drawRect((x -= (double)d.width / 2.0) - margin, (y += (double)d.height / 2.0) - (double)d.height - margin, (double)d.width + 2.0 * margin, (double)d.height + 2.0 * margin);
    }

    private void drawSymbol(VueVARNAGraphics g2D, double posx, double posy, double normx, double normy, double radius, boolean isCIS, ModeleBP.Edge e) {
        switch (e) {
            case WC: {
                if (isCIS) {
                    g2D.fillCircle(posx - radius / 2.0, posy - radius / 2.0, radius);
                    break;
                }
                Color bck = g2D.getColor();
                g2D.setColor(Color.white);
                g2D.fillCircle(posx - radius / 2.0, posy - radius / 2.0, radius);
                g2D.setColor(bck);
                g2D.drawCircle(posx - radius / 2.0, posy - radius / 2.0, radius);
                break;
            }
            case HOOGSTEEN: {
                GeneralPath p2 = new GeneralPath();
                p2.moveTo((float)(posx - radius * normx / 2.0 - radius * normy / 2.0), (float)(posy - radius * normy / 2.0 + radius * normx / 2.0));
                p2.lineTo((float)(posx + radius * normx / 2.0 - radius * normy / 2.0), (float)(posy + radius * normy / 2.0 + radius * normx / 2.0));
                p2.lineTo((float)(posx + radius * normx / 2.0 + radius * normy / 2.0), (float)(posy + radius * normy / 2.0 - radius * normx / 2.0));
                p2.lineTo((float)(posx - radius * normx / 2.0 + radius * normy / 2.0), (float)(posy - radius * normy / 2.0 - radius * normx / 2.0));
                p2.closePath();
                if (isCIS) {
                    g2D.fill(p2);
                    break;
                }
                Color bck = g2D.getColor();
                g2D.setColor(Color.white);
                g2D.fill(p2);
                g2D.setColor(bck);
                g2D.draw(p2);
                break;
            }
            case SUGAR: {
                double ix = radius * normx / 2.0;
                double iy = radius * normy / 2.0;
                double jx = radius * normy / 2.0;
                double jy = -radius * normx / 2.0;
                GeneralPath p2 = new GeneralPath();
                p2.moveTo((float)(posx - ix + jx), (float)(posy - iy + jy));
                p2.lineTo((float)(posx + ix + jx), (float)(posy + iy + jy));
                p2.lineTo((float)(posx - jx), (float)(posy - jy));
                p2.closePath();
                if (isCIS) {
                    g2D.fill(p2);
                    break;
                }
                Color bck = g2D.getColor();
                g2D.setColor(Color.white);
                g2D.fill(p2);
                g2D.setColor(bck);
                g2D.draw(p2);
            }
        }
    }

    private void drawBasePair(VueVARNAGraphics g2D, Point2D.Double orig, Point2D.Double dest, ModeleBP style, double newRadius) {
        double dx = dest.x - orig.x;
        double dy = dest.y - orig.y;
        double dist = Math.sqrt((dest.x - orig.x) * (dest.x - orig.x) + (dest.y - orig.y) * (dest.y - orig.y));
        double nx = -(dy /= dist);
        double ny = dx /= dist;
        orig = new Point2D.Double(orig.x + newRadius * dx, orig.y + newRadius * dy);
        dest = new Point2D.Double(dest.x - newRadius * dx, dest.y - newRadius * dy);
        if (this._conf._mainBPStyle == VARNAConfig.BP_STYLE.LW) {
            double radiusCircle = (65.0 - (double)this._RNA.BASE_RADIUS) / 5.0 * this._scaleFactor;
            if (style.isCanonical()) {
                if (style.isCanonicalGC()) {
                    if (orig.x != dest.x || orig.y != dest.y) {
                        g2D.drawLine(orig.x + (nx *= this._scaleFactor * (double)this._RNA.BASE_RADIUS / 4.0), orig.y + (ny *= this._scaleFactor * (double)this._RNA.BASE_RADIUS / 4.0), dest.x + nx, dest.y + ny);
                        g2D.drawLine(orig.x - nx, orig.y - ny, dest.x - nx, dest.y - ny);
                    }
                } else if (style.isCanonicalAU()) {
                    g2D.drawLine(orig.x, orig.y, dest.x, dest.y);
                } else if (style.isWobbleUG()) {
                    double cx = (dest.x + orig.x) / 2.0;
                    double cy = (dest.y + orig.y) / 2.0;
                    g2D.drawLine(orig.x, orig.y, dest.x, dest.y);
                    this.drawSymbol(g2D, cx, cy, nx, ny, radiusCircle, false, ModeleBP.Edge.WC);
                } else {
                    double cx = (dest.x + orig.x) / 2.0;
                    double cy = (dest.y + orig.y) / 2.0;
                    g2D.drawLine(orig.x, orig.y, dest.x, dest.y);
                    this.drawSymbol(g2D, cx, cy, nx, ny, radiusCircle, style.isCIS(), style.getEdgePartner5());
                }
            } else {
                ModeleBP.Edge p1 = style.getEdgePartner5();
                ModeleBP.Edge p2 = style.getEdgePartner3();
                double cx = (dest.x + orig.x) / 2.0;
                double cy = (dest.y + orig.y) / 2.0;
                g2D.drawLine(orig.x, orig.y, dest.x, dest.y);
                if (p1 == p2) {
                    this.drawSymbol(g2D, cx, cy, nx, ny, radiusCircle, style.isCIS(), p1);
                } else {
                    double vdx = dest.x - orig.x;
                    double vdy = dest.y - orig.y;
                    this.drawSymbol(g2D, cx + (vdx /= 6.0), cy + (vdy /= 6.0), nx, ny, radiusCircle, style.isCIS(), p2);
                    this.drawSymbol(g2D, cx - vdx, cy - vdy, nx, ny, radiusCircle, style.isCIS(), p1);
                }
            }
        } else if (this._conf._mainBPStyle == VARNAConfig.BP_STYLE.SIMPLE) {
            g2D.drawLine(orig.x, orig.y, dest.x, dest.y);
        } else if (this._conf._mainBPStyle == VARNAConfig.BP_STYLE.RNAVIZ) {
            double xcenter = (orig.x + dest.x) / 2.0;
            double ycenter = (orig.y + dest.y) / 2.0;
            double radius = Math.max(4.0 * this._scaleFactor, 1.0);
            g2D.fillCircle(xcenter - radius, ycenter - radius, 2.0 * radius);
        }
    }

    private Color getHighlightedVersion(Color c1, Color c2) {
        int r1 = c1.getRed();
        int g1 = c1.getGreen();
        int b1 = c1.getBlue();
        int r2 = c2.getRed();
        int g2 = c2.getGreen();
        int b2 = c2.getBlue();
        double val = this._blink.getVal();
        int nr = Math.max(0, Math.min((int)((double)r1 * val + (double)r2 * (1.0 - val)), 255));
        int ng = Math.max(0, Math.min((int)((double)g1 * val + (double)g2 * (1.0 - val)), 255));
        int nb = Math.max(0, Math.min((int)((double)b1 * val + (double)b2 * (1.0 - val)), 255));
        return new Color(nr, ng, nb);
    }

    private Color highlightFilter(int index, Color initialColor, Color c1, Color c2) {
        if (this._selectedBases.contains(this._RNA.getBaseAt(index))) {
            return this.getHighlightedVersion(c1, c2);
        }
        return initialColor;
    }

    private Point2D.Double computeExcentricUnitVector(int i, Point2D.Double[] points, Point2D.Double[] centers) {
        double dist = points[i].distance(centers[i]);
        Point2D.Double byCenter = new Point2D.Double((points[i].x - centers[i].x) / dist, (points[i].y - centers[i].y) / dist);
        if (i > 0 && i < points.length - 1) {
            Point2D.Double p0 = points[i - 1];
            Point2D.Double p1 = points[i];
            Point2D.Double p2 = points[i + 1];
            double dist1 = p2.distance(p1);
            Point2D.Double v1 = new Point2D.Double((p2.x - p1.x) / dist1, (p2.y - p1.y) / dist1);
            Point2D.Double vn1 = new Point2D.Double(v1.y, -v1.x);
            double dist2 = p1.distance(p0);
            Point2D.Double v2 = new Point2D.Double((p1.x - p0.x) / dist2, (p1.y - p0.y) / dist2);
            Point2D.Double vn2 = new Point2D.Double(v2.y, -v2.x);
            Point2D.Double vn = new Point2D.Double((vn1.x + vn2.x) / 2.0, (vn1.y + vn2.y) / 2.0);
            double D = vn.distance(new Point2D.Double(0.0, 0.0));
            vn.x /= D;
            vn.y /= D;
            if (byCenter.x * vn.x + byCenter.y * vn.y < 0.0) {
                vn.x = -vn.x;
                vn.y = -vn.y;
            }
            return vn;
        }
        return byCenter;
    }

    private void drawBase(VueVARNAGraphics g2D, int i, Point2D.Double[] points, Point2D.Double[] centers, double newRadius) {
        Point2D.Double p = points[i];
        ModeleBase mb = this._RNA.get_listeBases().get(i);
        g2D.setFont(this._conf._fontBasesGeneral);
        Color baseInnerColor = this.highlightFilter(i, this._RNA.getBaseInnerColor(i, this._conf), Color.white, this._RNA.getBaseInnerColor(i, this._conf));
        Color baseOuterColor = this.highlightFilter(i, this._RNA.getBaseOuterColor(i, this._conf), this._RNA.getBaseOuterColor(i, this._conf), Color.white);
        Color baseNameColor = this.highlightFilter(i, this._RNA.getBaseNameColor(i, this._conf), this._RNA.getBaseNameColor(i, this._conf), Color.white);
        if (mb instanceof ModeleBaseNucleotide) {
            ModeleBaseNucleotide mbn = (ModeleBaseNucleotide)mb;
            String res = mbn.getBase();
            if (this._hoveredBase == mb) {
                g2D.setColor(this._conf._hoverColor);
                g2D.fillCircle(p.getX() - 1.5 * newRadius, p.getY() - 1.5 * newRadius, 3.0 * newRadius);
                g2D.setColor(this._conf._hoverColor.darker());
                g2D.drawCircle(p.getX() - 1.5 * newRadius, p.getY() - 1.5 * newRadius, 3.0 * newRadius);
                g2D.setPlainStroke();
            }
            if (this._conf._fillBase) {
                g2D.setColor(baseInnerColor);
                g2D.fillCircle(p.getX() - newRadius, p.getY() - newRadius, 2.0 * newRadius);
            }
            if (this._conf._drawOutlineBase) {
                g2D.setColor(baseOuterColor);
                g2D.setStrokeThickness(this._conf._baseThickness * this._scaleFactor);
                g2D.drawCircle(p.getX() - newRadius, p.getY() - newRadius, 2.0 * newRadius);
            }
            g2D.setColor(baseNameColor);
            g2D.drawStringCentered(String.valueOf(res), p.getX(), p.getY());
        } else if (mb instanceof ModeleBasesComparison) {
            ModeleBasesComparison mbc = (ModeleBasesComparison)mb;
            g2D.setPlainStroke();
            g2D.setStrokeThickness(this._conf._baseThickness * this._scaleFactor);
            g2D.setColor(baseInnerColor);
            g2D.fillRoundRect(p.getX() - newRadius, p.getY() - newRadius, 3.0 * newRadius, 2.0 * newRadius, 10.0 * this._scaleFactor, 10.0 * this._scaleFactor);
            g2D.setColor(baseOuterColor);
            g2D.drawRoundRect(p.getX() - newRadius, p.getY() - newRadius, 3.0 * newRadius, 2.0 * newRadius, 10.0 * this._scaleFactor, 10.0 * this._scaleFactor);
            g2D.drawLine(p.getX() + newRadius / 2.0, p.getY() + newRadius - 1.0, p.getX() + newRadius / 2.0, p.getY() - newRadius + 1.0);
            String label1 = String.valueOf(mbc.getBase1());
            String label2 = String.valueOf(mbc.getBase2());
            g2D.setColor(this.getRNA().get_listeBases().get(i).getStyleBase().get_base_name_color());
            g2D.drawStringCentered(label1, p.getX() - newRadius * 0.15, p.getY());
            g2D.drawStringCentered(label2, p.getX() + newRadius * 1.2, p.getY());
        }
        if (this._RNA.isNumberDrawn(mb, this.getNumPeriod())) {
            Point2D.Double vn = this.computeExcentricUnitVector(i, points, centers);
            g2D.setColor(mb.getStyleBase().get_base_number_color());
            g2D.setFont(this._conf._numbersFont);
            double factorMin = Math.min(0.5, this._conf._distNumbers);
            double factorMax = Math.min(this._conf._distNumbers - 1.5, this._conf._distNumbers);
            g2D.drawLine(p.x + vn.x * ((1.0 + factorMin) * newRadius), p.y + vn.y * ((1.0 + factorMin) * newRadius), p.x + vn.x * ((1.0 + factorMax) * newRadius), p.y + vn.y * ((1.0 + factorMax) * newRadius));
            g2D.drawStringCentered("" + mb.getBaseNumber(), p.x + vn.x * ((1.0 + this._conf._distNumbers) * newRadius), p.y + vn.y * ((1.0 + this._conf._distNumbers) * newRadius));
        }
    }

    void drawChemProbAnnotation(VueVARNAGraphics g2D, ChemProbAnnotation cpa, Point2D.Double anchor, double scaleFactor) {
        g2D.setColor(cpa.getColor());
        g2D.setStrokeThickness(RNA.CHEM_PROB_ARROW_THICKNESS * this._scaleFactor * cpa.getIntensity());
        g2D.setPlainStroke();
        Point2D.Double v = cpa.getDirVector();
        Point2D.Double vn = cpa.getNormalVector();
        Point2D.Double base = new Point2D.Double(anchor.x + this._RNA.CHEM_PROB_DIST * scaleFactor * v.x, anchor.y + this._RNA.CHEM_PROB_DIST * scaleFactor * v.y);
        Point2D.Double edge = new Point2D.Double(base.x + this._RNA.CHEM_PROB_BASE_LENGTH * cpa.getIntensity() * scaleFactor * v.x, base.y + this._RNA.CHEM_PROB_BASE_LENGTH * cpa.getIntensity() * scaleFactor * v.y);
        switch (cpa.getType()) {
            case ARROW: {
                Point2D.Double arrowTip1 = new Point2D.Double(base.x + cpa.getIntensity() * scaleFactor * (this._RNA.CHEM_PROB_ARROW_WIDTH * vn.x + this._RNA.CHEM_PROB_ARROW_HEIGHT * v.x), base.y + cpa.getIntensity() * scaleFactor * (this._RNA.CHEM_PROB_ARROW_WIDTH * vn.y + this._RNA.CHEM_PROB_ARROW_HEIGHT * v.y));
                Point2D.Double arrowTip2 = new Point2D.Double(base.x + cpa.getIntensity() * scaleFactor * (-this._RNA.CHEM_PROB_ARROW_WIDTH * vn.x + this._RNA.CHEM_PROB_ARROW_HEIGHT * v.x), base.y + cpa.getIntensity() * scaleFactor * (-this._RNA.CHEM_PROB_ARROW_WIDTH * vn.y + this._RNA.CHEM_PROB_ARROW_HEIGHT * v.y));
                g2D.drawLine(base.x, base.y, edge.x, edge.y);
                g2D.drawLine(base.x, base.y, arrowTip1.x, arrowTip1.y);
                g2D.drawLine(base.x, base.y, arrowTip2.x, arrowTip2.y);
                break;
            }
            case PIN: {
                Point2D.Double side1 = new Point2D.Double(edge.x - cpa.getIntensity() * scaleFactor * (this._RNA.CHEM_PROB_PIN_SEMIDIAG * v.x), edge.y - cpa.getIntensity() * scaleFactor * (this._RNA.CHEM_PROB_PIN_SEMIDIAG * v.y));
                Point2D.Double side2 = new Point2D.Double(edge.x - cpa.getIntensity() * scaleFactor * (this._RNA.CHEM_PROB_PIN_SEMIDIAG * vn.x), edge.y - cpa.getIntensity() * scaleFactor * (this._RNA.CHEM_PROB_PIN_SEMIDIAG * vn.y));
                Point2D.Double side3 = new Point2D.Double(edge.x + cpa.getIntensity() * scaleFactor * (this._RNA.CHEM_PROB_PIN_SEMIDIAG * v.x), edge.y + cpa.getIntensity() * scaleFactor * (this._RNA.CHEM_PROB_PIN_SEMIDIAG * v.y));
                Point2D.Double side4 = new Point2D.Double(edge.x + cpa.getIntensity() * scaleFactor * (this._RNA.CHEM_PROB_PIN_SEMIDIAG * vn.x), edge.y + cpa.getIntensity() * scaleFactor * (this._RNA.CHEM_PROB_PIN_SEMIDIAG * vn.y));
                GeneralPath p2 = new GeneralPath();
                p2.moveTo((float)side1.x, (float)side1.y);
                p2.lineTo((float)side2.x, (float)side2.y);
                p2.lineTo((float)side3.x, (float)side3.y);
                p2.lineTo((float)side4.x, (float)side4.y);
                p2.closePath();
                g2D.fill(p2);
                g2D.drawLine(base.x, base.y, edge.x, edge.y);
                break;
            }
            case TRIANGLE: {
                Point2D.Double arrowTip1 = new Point2D.Double(edge.x + cpa.getIntensity() * scaleFactor * (this._RNA.CHEM_PROB_TRIANGLE_WIDTH * vn.x), edge.y + cpa.getIntensity() * scaleFactor * (this._RNA.CHEM_PROB_TRIANGLE_WIDTH * vn.y));
                Point2D.Double arrowTip2 = new Point2D.Double(edge.x + cpa.getIntensity() * scaleFactor * (-this._RNA.CHEM_PROB_TRIANGLE_WIDTH * vn.x), edge.y + cpa.getIntensity() * scaleFactor * (-this._RNA.CHEM_PROB_TRIANGLE_WIDTH * vn.y));
                GeneralPath p2 = new GeneralPath();
                p2.moveTo((float)base.x, (float)base.y);
                p2.lineTo((float)arrowTip1.x, (float)arrowTip1.y);
                p2.lineTo((float)arrowTip2.x, (float)arrowTip2.y);
                p2.closePath();
                g2D.fill(p2);
                break;
            }
            case DOT: {
                Double radius = scaleFactor * this._RNA.CHEM_PROB_DOT_RADIUS * cpa.getIntensity();
                Point2D.Double center = new Point2D.Double(base.x + radius * v.x, base.y + radius * v.y);
                g2D.fillCircle(center.x - radius, center.y - radius, 2.0 * radius);
            }
        }
    }

    Point2D.Double buildCaptionPosition(ModeleBase mb, double scaleFactor, double heightEstimate) {
        double radius = 2.0;
        if (this._RNA.isNumberDrawn(mb, this.getNumPeriod())) {
            radius += this._conf._distNumbers;
        }
        Point2D.Double center = mb.getCenter();
        Point2D.Double p = mb.getCoords();
        double realDistance = (double)this._RNA.BASE_RADIUS * radius + heightEstimate;
        return new Point2D.Double(center.getX() + (p.getX() - center.getX()) * ((p.distance(center) + realDistance) / p.distance(center)), center.getY() + (p.getY() - center.getY()) * ((p.distance(center) + realDistance) / p.distance(center)));
    }

    private void renderAnnotations(VueVARNAGraphics g2D, double offX, double offY, double rnaBBoxX, double rnaBBoxY, double scaleFactor) {
        for (TextAnnotation textAnnotation : this._RNA.getAnnotations()) {
            g2D.setColor(textAnnotation.getColor());
            g2D.setFont(textAnnotation.getFont().deriveFont((float)(2.0 * (double)textAnnotation.getFont().getSize() * scaleFactor)));
            Point2D.Double position = textAnnotation.getCenterPosition();
            if (textAnnotation.getType() == TextAnnotation.AnchorType.BASE) {
                ModeleBase mb = (ModeleBase)textAnnotation.getAncrage();
                double fontHeight = Math.ceil(textAnnotation.getFont().getSize());
                position = this.buildCaptionPosition(mb, scaleFactor, fontHeight);
            }
            position = this.transformCoord(position, offX, offY, rnaBBoxX, rnaBBoxY, scaleFactor);
            g2D.drawStringCentered(textAnnotation.getTexte(), position.x, position.y);
            if (this._selectedAnnotation != textAnnotation || !this._highlightAnnotation) continue;
            this.drawStringOutline(g2D, textAnnotation.getTexte(), position.x, position.y, 5.0);
        }
        for (ChemProbAnnotation cpa : this._RNA.getChemProbAnnotations()) {
            Point2D.Double anchor = this.transformCoord(cpa.getAnchorPosition(), offX, offY, rnaBBoxX, rnaBBoxY, scaleFactor);
            this.drawChemProbAnnotation(g2D, cpa, anchor, scaleFactor);
        }
    }

    public Rectangle2D.Double getExtendedRNABBox() {
        Rectangle2D.Double rnabbox = this._RNA.getBBox();
        rnabbox.y -= this._conf._distNumbers * (double)this._RNA.BASE_RADIUS;
        rnabbox.height += 2.0 * this._conf._distNumbers * (double)this._RNA.BASE_RADIUS;
        rnabbox.x -= this._conf._distNumbers * (double)this._RNA.BASE_RADIUS;
        rnabbox.width += 2.0 * this._conf._distNumbers * (double)this._RNA.BASE_RADIUS;
        if (this._RNA.hasVirtualLoops()) {
            rnabbox.y -= 40.0;
            rnabbox.height += 80.0;
            rnabbox.x -= 40.0;
            rnabbox.width += 80.0;
        }
        return rnabbox;
    }

    public void drawBackbone(VueVARNAGraphics g2D, Point2D.Double[] newCoords, double newRadius) {
        if (this.getDrawBackbone()) {
            g2D.setStrokeThickness(1.5 * this._scaleFactor);
            g2D.setColor(this._conf._backboneColor);
            int i = 1;
            while (i < this._RNA.get_listeBases().size()) {
                boolean consecutive;
                Point2D.Double p1 = newCoords[i - 1];
                Point2D.Double p2 = newCoords[i];
                double dist = p1.distance(p2);
                boolean discontinuous = this._RNA.getBaseNumber(i) - this._RNA.getBaseNumber(i - 1) != 1;
                int a = this._RNA.getBaseAt(i - 1).getElementStructure();
                int b = this._RNA.getBaseAt(i).getElementStructure();
                boolean bl = consecutive = a == i && b == i - 1;
                if (dist > 0.0) {
                    Point2D.Double vbp = new Point2D.Double();
                    vbp.x = (p2.x - p1.x) / dist;
                    vbp.y = (p2.y - p1.y) / dist;
                    if (!discontinuous) {
                        g2D.setPlainStroke();
                    } else {
                        g2D.setDashedStroke();
                    }
                    if (consecutive && this._RNA.getDrawMode() != 4 && this._RNA.getDrawMode() != 1) {
                        int dir = 0;
                        if (i + 1 < newCoords.length) {
                            dir = this._RNA.testDirectionality(i - 1, i, i + 1) ? -1 : 1;
                        } else if (i - 2 >= 0) {
                            dir = this._RNA.testDirectionality(i - 2, i - 1, i) ? -1 : 1;
                        }
                        Point2D.Double vn = new Point2D.Double((double)dir * vbp.y, (double)(-dir) * vbp.x);
                        Point2D.Double centerSeg = new Point2D.Double((p1.x + p2.x) / 2.0, (p1.y + p2.y) / 2.0);
                        double distp1CenterSeq = p1.distance(centerSeg);
                        double centerDist = Math.sqrt(40.0 * this._scaleFactor * 40.0 * this._scaleFactor - distp1CenterSeq * distp1CenterSeq);
                        Point2D.Double centerLoop = new Point2D.Double(centerSeg.x + centerDist * vn.x, centerSeg.y + centerDist * vn.y);
                        double radius = centerLoop.distance(p1);
                        double a1 = 360.0 * Math.atan2(-(p1.y - centerLoop.y), p1.x - centerLoop.x) / (Math.PI * 2);
                        double a2 = 360.0 * Math.atan2(-(p2.y - centerLoop.y), p2.x - centerLoop.x) / (Math.PI * 2);
                        double angle = a2 - a1;
                        if ((double)(-dir) * angle < 0.0) {
                            angle += (double)(-dir) * 360.0;
                        }
                        g2D.drawArc(centerLoop.x + 0.8 * newRadius * vn.x, centerLoop.y + 0.8 * newRadius * vn.y, 2.0 * radius, 2.0 * radius, a1, angle);
                    } else {
                        g2D.drawLine(newCoords[i - 1].x + newRadius * vbp.x, newCoords[i - 1].y + newRadius * vbp.y, newCoords[i].x - newRadius * vbp.x, newCoords[i].y - newRadius * vbp.y);
                    }
                }
                ++i;
            }
        }
    }

    public Point2D.Double logicToPanel(Point2D.Double logicPoint) {
        return new Point2D.Double(this._offX + this._scaleFactor * (logicPoint.x - this._offsetRNA.x), this._offY + this._scaleFactor * (logicPoint.y - this._offsetRNA.y));
    }

    private void renderRNA(VueVARNAGraphics g2D, Rectangle2D.Double bbox) {
        if (this._RNA.get_listeBases().size() != 0) {
            Rectangle2D.Double rnabbox = this.getExtendedRNABBox();
            if (this._conf._autoFit) {
                this.setScaleFactor(Math.min(bbox.width / rnabbox.width, bbox.height / rnabbox.height));
            }
            float newFontSize = Math.max(1, (int)(1.7 * (double)this._RNA.BASE_RADIUS * this._scaleFactor));
            rnabbox.y -= (double)newFontSize;
            rnabbox.height += (double)newFontSize;
            if (this._conf._drawColorMap) {
                rnabbox.height += this.getColorMapHeight();
            }
            rnabbox.x -= (double)newFontSize;
            rnabbox.width += (double)newFontSize;
            if (this._conf._autoFit) {
                this.setScaleFactor(Math.min(bbox.width / rnabbox.width, bbox.height / rnabbox.height));
            }
            newFontSize = Math.max(1, (int)(1.7 * (double)this._RNA.BASE_RADIUS * this._scaleFactor));
            double newRadius = Math.max(1.0, this._scaleFactor * (double)this._RNA.BASE_RADIUS);
            this.setBaseFontSize(Float.valueOf(newFontSize));
            this.setNumbersFontSize(Float.valueOf(newFontSize));
            if (this._conf._autoCenter) {
                this._offX = bbox.x;
                this._offY = bbox.y;
                this._offX = bbox.x + (bbox.width - (double)Math.round(rnabbox.width * this._scaleFactor)) / 2.0;
                this._offY = bbox.y + (bbox.height - (double)Math.round(rnabbox.height * this._scaleFactor)) / 2.0;
                this._offsetPanel = new Point2D.Double(this._offX, this._offY);
                this._offsetRNA = new Point2D.Double(rnabbox.x, rnabbox.y);
            }
            Point2D.Double[] newCoords = new Point2D.Double[this._RNA.get_listeBases().size()];
            Point2D.Double[] newCenters = new Point2D.Double[this._RNA.get_listeBases().size()];
            int i = 0;
            while (i < this._RNA.get_listeBases().size()) {
                ModeleBase mb = this._RNA.getBaseAt(i);
                newCoords[i] = new Point2D.Double(this._offX + this._scaleFactor * (mb.getCoords().x - this._offsetRNA.x), this._offY + this._scaleFactor * (mb.getCoords().y - this._offsetRNA.y));
                Point2D.Double centerBck = this._RNA.getCenter(i);
                if ((this._RNA.get_drawMode() == 3 || this._RNA.get_drawMode() == 2) && mb.getElementStructure() != -1 && i < this._RNA.get_listeBases().size() - 1 && i > 1) {
                    int j2;
                    ModeleBase b1 = this._RNA.get_listeBases().get(i - 1);
                    ModeleBase b2 = this._RNA.get_listeBases().get(i + 1);
                    int j1 = b1.getElementStructure();
                    if (j1 == -1 ^ (j2 = b2.getElementStructure()) == -1) {
                        Point2D.Double a1 = b1.getCoords();
                        Point2D.Double a2 = b2.getCoords();
                        Point2D.Double c1 = b1.getCenter();
                        Point2D.Double c2 = b2.getCenter();
                        centerBck.x = mb.getCoords().x + (c1.x - a1.x) / c1.distance(a1) + (c2.x - a2.x) / c2.distance(a2);
                        centerBck.y = mb.getCoords().y + (c1.y - a1.y) / c1.distance(a1) + (c2.y - a2.y) / c2.distance(a2);
                    }
                }
                newCenters[i] = new Point2D.Double(this._offX + this._scaleFactor * (centerBck.x - this._offsetRNA.x), this._offY + this._scaleFactor * (centerBck.y - this._offsetRNA.y));
                ++i;
            }
            this._realCoords = newCoords;
            this._realCenters = newCenters;
            g2D.setStrokeThickness(1.5 * this._scaleFactor);
            g2D.setPlainStroke();
            g2D.setFont(this._conf._fontBasesGeneral);
            this.drawRegionHighlightsAnnotation(g2D, this._realCoords, this._realCenters, this._scaleFactor);
            this.drawBackbone(g2D, newCoords, newRadius);
            int i2 = 0;
            while (i2 < this._RNA.get_listeBases().size()) {
                ModeleBP msbp;
                int j = this._RNA.get_listeBases().get(i2).getElementStructure();
                if (j > i2 && ((msbp = this._RNA.get_listeBases().get(i2).getStyleBP()).isCanonical() || this._conf._drawnNonCanonicalBP)) {
                    if (this._RNA.get_drawMode() == 4) {
                        g2D.setStrokeThickness(this._RNA.getBasePairThickness(msbp, this._conf) * 2.0 * this._scaleFactor * this._conf._bpThickness);
                    } else {
                        g2D.setStrokeThickness(this._RNA.getBasePairThickness(msbp, this._conf) * 1.5 * this._scaleFactor);
                    }
                    g2D.setColor(this._RNA.getBasePairColor(msbp, this._conf));
                    if (this._RNA.get_drawMode() == 4) {
                        double coef = j - i2 == 1 ? this.getBPHeightIncrement() * 1.75 : this.getBPHeightIncrement();
                        double distance = newCoords[j].x - newCoords[i2].x;
                        g2D.drawArc((newCoords[j].x + newCoords[i2].x) / 2.0, newCoords[j].y - this._scaleFactor * (double)this._RNA.BASE_RADIUS / 2.0, distance, distance * coef, 0.0, 180.0);
                    } else {
                        this.drawBasePair(g2D, newCoords[i2], newCoords[j], msbp, newRadius);
                    }
                }
                ++i2;
            }
            if (this._conf._drawnNonPlanarBP) {
                ArrayList<ModeleBP> bpaux = this._RNA.getStructureAux();
                int k = 0;
                while (k < bpaux.size()) {
                    ModeleBP bp = bpaux.get(k);
                    if (bp.isCanonical() || this._conf._drawnNonCanonicalBP) {
                        int i3 = bp.getPartner5().getIndex();
                        int j = bp.getPartner3().getIndex();
                        if (this._RNA.get_drawMode() == 4) {
                            g2D.setStrokeThickness(this._RNA.getBasePairThickness(bp, this._conf) * 2.5 * this._scaleFactor * this._conf._bpThickness);
                            g2D.setPlainStroke();
                        } else {
                            g2D.setStrokeThickness(this._RNA.getBasePairThickness(bp, this._conf) * 1.5 * this._scaleFactor);
                            g2D.setPlainStroke();
                        }
                        g2D.setColor(this._RNA.getBasePairColor(bp, this._conf));
                        if (j > i3) {
                            if (this._RNA.get_drawMode() == 4) {
                                double coef = j - i3 == 1 ? this.getBPHeightIncrement() * 1.75 : this.getBPHeightIncrement();
                                double distance = newCoords[j].x - newCoords[i3].x;
                                g2D.drawArc((newCoords[j].x + newCoords[i3].x) / 2.0, newCoords[j].y - this._scaleFactor * (double)this._RNA.BASE_RADIUS / 2.0, distance, distance * coef, 0.0, 180.0);
                            } else {
                                this.drawBasePair(g2D, newCoords[i3], newCoords[j], bp, newRadius);
                            }
                        }
                    }
                    ++k;
                }
            }
            g2D.setPlainStroke();
            i = 0;
            while (i < Math.min(this._RNA.get_listeBases().size(), newCoords.length)) {
                this.drawBase(g2D, i, newCoords, newCenters, newRadius);
                ++i;
            }
            if (this._debug || this._drawBBox) {
                g2D.setColor(Color.RED);
                g2D.setDashedStroke();
                g2D.drawRect(this._offX, this._offY, this._scaleFactor * rnabbox.width - 1.0, this._scaleFactor * rnabbox.height - 1.0);
            }
            if (this._conf._drawColorMap) {
                this.drawColorMap(g2D, this._scaleFactor, rnabbox);
            }
            if (this._debug || this._drawBBox) {
                g2D.setColor(Color.GRAY);
                g2D.setDashedStroke();
                g2D.drawRect(0.0, 0.0, this.getWidth() - 1, this.getHeight() - this.getTitleHeight() - 1);
            }
            this.renderAnnotations(g2D, this._offX, this._offY, this._offsetRNA.x, this._offsetRNA.y, this._scaleFactor);
            if (this._RNA._debugShape != null) {
                Color c = new Color(255, 0, 0, 50);
                g2D.setColor(c);
                AffineTransform at = new AffineTransform();
                at.translate(this._offX - this._scaleFactor * rnabbox.x, this._offY - this._scaleFactor * rnabbox.y);
                at.scale(this._scaleFactor, this._scaleFactor);
                Shape s = at.createTransformedShape(this._RNA._debugShape);
                if (s instanceof GeneralPath) {
                    g2D.fill((GeneralPath)s);
                }
            }
        }
    }

    public ModeleBase getBaseAt(Point2D.Double po) {
        ModeleBase mb = null;
        Point2D.Double p = this.panelToLogicPoint(po);
        double dist = Double.MAX_VALUE;
        for (ModeleBase tmp : this._RNA.get_listeBases()) {
            double ndist = tmp.getCoords().distance(p);
            if (!(dist > ndist)) continue;
            mb = tmp;
            dist = ndist;
        }
        return mb;
    }

    public void setColorMapValues(Double[] values) {
        this._RNA.setColorMapValues(values, this._conf._cm, true);
        this._conf._drawColorMap = true;
        this.repaint();
    }

    public void setColorMapMaxValue(double d) {
        this._conf._cm.setMaxValue(d);
    }

    public void setColorMapMinValue(double d) {
        this._conf._cm.setMinValue(d);
    }

    public ModeleColorMap getColorMap() {
        return this._conf._cm;
    }

    public void setColorMap(ModeleColorMap cm) {
        this._RNA.adaptColorMapToValues(cm);
        this._conf._cm = cm;
        this.repaint();
    }

    public void setColorMapCaption(String caption) {
        this._conf._colorMapCaption = caption;
        this.repaint();
    }

    public String getColorMapCaption() {
        return this._conf._colorMapCaption;
    }

    public void drawColorMap(boolean draw) {
        this._conf._drawColorMap = draw;
    }

    private double getColorMapHeight() {
        double result = (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE + this._conf._colorMapHeight;
        if (!this._conf._colorMapCaption.equals("")) {
            result += (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE;
        }
        return result;
    }

    private void drawColorMap(VueVARNAGraphics g2D, double scaleFactor, Rectangle2D.Double rnabbox) {
        double v1 = this._conf._cm.getMinValue();
        double v2 = this._conf._cm.getMaxValue();
        g2D.setPlainStroke();
        double xSpaceAvail = 0.0;
        double ySpaceAvail = Math.min(((double)this.getHeight() - rnabbox.height * scaleFactor - (double)this.getTitleHeight()) / 2.0, scaleFactor * (this._conf._colorMapHeight + (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE));
        if ((int)ySpaceAvail == 0) {
            xSpaceAvail = Math.min(((double)this.getWidth() - rnabbox.width * scaleFactor) / 2.0, scaleFactor * this._conf._colorMapWidth + (double)VARNAConfig.DEFAULT_COLOR_MAP_STRIPE_WIDTH);
        }
        double xBase = xSpaceAvail + this._offX + scaleFactor * (rnabbox.width - this._conf._colorMapWidth - this._conf._colorMapXOffset);
        double hcaption = VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE;
        double yBase = ySpaceAvail + this._offY + scaleFactor * (rnabbox.height - this._conf._colorMapHeight - this._conf._colorMapYOffset - hcaption);
        int i = 0;
        while ((double)i < this._conf._colorMapWidth) {
            double ratio = (double)i / this._conf._colorMapWidth;
            double val = v1 + (v2 - v1) * ratio;
            g2D.setColor(this._conf._cm.getColorForValue(val));
            double x = xBase + scaleFactor * (double)i;
            double y = yBase;
            g2D.fillRect(x, y, VARNAConfig.DEFAULT_COLOR_MAP_STRIPE_WIDTH, scaleFactor * this._conf._colorMapHeight);
            ++i;
        }
        g2D.setColor(VARNAConfig.DEFAULT_COLOR_MAP_OUTLINE);
        g2D.drawRect(xBase, yBase, (double)(VARNAConfig.DEFAULT_COLOR_MAP_STRIPE_WIDTH - 1) + scaleFactor * this._conf._colorMapWidth, scaleFactor * this._conf._colorMapHeight);
        g2D.setFont(this.getFont().deriveFont((float)(scaleFactor * (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE)));
        g2D.setColor(VARNAConfig.DEFAULT_COLOR_MAP_FONT_COLOR);
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        g2D.drawStringCentered(nf.format(this._conf._cm.getMinValue()), xBase, yBase - scaleFactor * (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE / 1.7);
        g2D.drawStringCentered(nf.format(this._conf._cm.getMaxValue()), xBase + (double)VARNAConfig.DEFAULT_COLOR_MAP_STRIPE_WIDTH + scaleFactor * this._conf._colorMapWidth, yBase - scaleFactor * (double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE / 1.7);
        if (!this._conf._colorMapCaption.equals("")) {
            g2D.drawStringCentered(this._conf._colorMapCaption, xBase + scaleFactor * this._conf._colorMapWidth / 2.0, yBase + scaleFactor * ((double)VARNAConfig.DEFAULT_COLOR_MAP_FONT_SIZE / 1.7 + this._conf._colorMapHeight));
        }
    }

    public Point2D.Double panelToLogicPoint(Point2D.Double p) {
        return new Point2D.Double((p.x - this.getOffsetPanel().x) / this.getScaleFactor() + this.getRNAOffset().x, (p.y - this.getOffsetPanel().y) / this.getScaleFactor() + this.getRNAOffset().y);
    }

    public Point2D.Double transformCoord(Point2D.Double coordDebut, double offX, double offY, double rnaBBoxX, double rnaBBoxY, double scaleFactor) {
        return new Point2D.Double(offX + scaleFactor * (coordDebut.x - rnaBBoxX), offY + scaleFactor * (coordDebut.y - rnaBBoxY));
    }

    public void eraseSequence() {
        this._RNA.eraseSequence();
    }

    public Point2D.Double transformCoord(Point2D.Double coordDebut) {
        Rectangle2D.Double rnabbox = this.getExtendedRNABBox();
        return new Point2D.Double(this._offX + this._scaleFactor * (coordDebut.x - rnabbox.x), this._offY + this._scaleFactor * (coordDebut.y - rnabbox.y));
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paintComponent(g, false);
    }

    public void paintComponent(Graphics g, boolean transparentBackground) {
        if (this._premierAffichage) {
            this._translation.x = 0;
            this._translation.y = (int)((double)(-this.getTitleHeight()) / 2.0);
            this._popup.buildPopupMenu();
            this.add(this._popup);
            this._premierAffichage = false;
        }
        Graphics2D g2 = (Graphics2D)g;
        SwingGraphics g2D = new SwingGraphics(g2);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.removeAll();
        super.paintComponent(g2);
        this.renderComponent(g2D, transparentBackground);
        if (this.isFocusOwner()) {
            g2.setStroke(new BasicStroke(1.5f));
            g2.setColor(Color.decode("#C0C0C0"));
            g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    public synchronized void renderComponent(VueVARNAGraphics g2D, boolean transparentBackground) {
        this.updateTitleHeight();
        if (this._debug || this._drawBorder) {
            g2D.setColor(Color.BLACK);
            g2D.setPlainStroke();
            g2D.drawRect(this.getLeftOffset(), this.getTopOffset(), this.getInnerWidth(), this.getInnerHeight());
        }
        if (!transparentBackground) {
            super.setBackground(this._conf._backgroundColor);
        } else {
            super.setBackground(new Color(0, 0, 0, 120));
        }
        if (this.getMinimumSize().height < this.getSize().height && this.getMinimumSize().width < this.getSize().width) {
            if (!this.getTitle().equals("")) {
                g2D.setColor(this._conf._titleColor);
                g2D.setFont(this._conf._titleFont);
                g2D.drawStringCentered(this.getTitle(), this.getWidth() / 2, (double)this.getHeight() - (double)this.getTitleHeight() / 2.0);
            }
            this.renderRNA(g2D, this.getClip());
        }
        if (this._selectionRectangle != null) {
            g2D.setColor(Color.BLACK);
            g2D.setDashedStroke();
            g2D.drawRect(this._selectionRectangle.x, this._selectionRectangle.y, this._selectionRectangle.width, this._selectionRectangle.height);
        }
        if (this._linkOrigin != null && this._linkDestination != null) {
            g2D.setColor(this._conf._bondColor);
            g2D.setPlainStroke();
            g2D.setStrokeThickness(4.0 * this._scaleFactor);
            Point2D.Double linkOrigin = this._linkOrigin;
            Point2D.Double linkDestination = this._linkDestination;
            g2D.drawLine(linkOrigin.x, linkOrigin.y, linkDestination.x, linkDestination.y);
            for (int i : this.getSelection().getIndices()) {
                this.drawBase(g2D, i, this._realCoords, this._realCenters, this._scaleFactor * (double)this._RNA.BASE_RADIUS);
            }
        }
    }

    public void drawRegionHighlightsAnnotation(VueVARNAGraphics g2D, Point2D.Double[] realCoords, Point2D.Double[] realCenters, double scaleFactor) {
        g2D.setStrokeThickness(2.0 * this._scaleFactor);
        g2D.setPlainStroke();
        for (HighlightRegionAnnotation r : this._RNA.getHighlightRegion()) {
            GeneralPath s = r.getShape(realCoords, realCenters, scaleFactor);
            g2D.setColor(r.getFillColor());
            g2D.fill(s);
            g2D.setColor(r.getOutlineColor());
            g2D.draw(s);
        }
    }

    private Rectangle2D.Double getClip() {
        return new Rectangle2D.Double(this.getLeftOffset(), this.getTopOffset(), this.getInnerWidth(), this.getInnerHeight());
    }

    public Color getBackboneColor() {
        return this._conf._backboneColor;
    }

    public void setBackboneColor(Color backbone_color) {
        this._conf._backboneColor = backbone_color;
    }

    public Color getBondColor() {
        return this._conf._bondColor;
    }

    public String getTitle() {
        if (!this._RNA.getName().equals("")) {
            return this._RNA.getName();
        }
        return this._conf._title;
    }

    public void setDefaultBPColor(Color bond_color) {
        this._conf._bondColor = bond_color;
    }

    public void setBorderSize(Dimension b) {
        this._border = b;
    }

    public Dimension getBorderSize() {
        return this._border;
    }

    public synchronized void showRNA(RNA r) {
        this.fireUINewStructure(r);
        this._RNA = r;
    }

    public void drawRNA(String seq, String str) throws ExceptionNonEqualLength {
        this.drawRNA(seq, str, this._RNA.get_drawMode());
    }

    public void drawRNA(RNA r, int drawMode) {
        r.setDrawMode(drawMode);
        this.drawRNA(r);
    }

    public void drawRNA() {
        try {
            this._RNA.drawRNA(this._RNA.get_drawMode(), this._conf);
        }
        catch (ExceptionNAViewAlgorithm e) {
            this.errorDialog(e);
            e.printStackTrace();
        }
        this.repaint();
    }

    public void drawRNA(RNA r) {
        if (r != null) {
            this._RNA = r;
            this.drawRNA();
        }
    }

    public void drawRNA(String seq, String str, int drawMode) throws ExceptionNonEqualLength {
        this._RNA.setDrawMode(drawMode);
        try {
            this._RNA.setRNA(seq, str);
            this.drawRNA();
        }
        catch (ExceptionUnmatchedClosingParentheses e) {
            this.errorDialog(e);
        }
        catch (ExceptionFileFormatOrSyntax e1) {
            this.errorDialog(e1);
        }
    }

    public void drawRNA(Reader r, int drawMode) throws ExceptionNonEqualLength, ExceptionFileFormatOrSyntax {
        this._RNA.setDrawMode(drawMode);
        ArrayList<RNA> rnas = RNAFactory.loadSecStr(r);
        if (rnas.isEmpty()) {
            throw new ExceptionFileFormatOrSyntax("No RNA could be parsed from that source.");
        }
        this._RNA = (RNA)rnas.iterator().next();
        this.drawRNA();
    }

    public void drawRNAInterpolated(String seq, String str) throws ExceptionNonEqualLength {
        this.drawRNAInterpolated(seq, str, this._RNA.get_drawMode());
    }

    public void drawRNAInterpolated(String seq, String str, int drawMode) {
        this.drawRNAInterpolated(seq, str, drawMode, Mapping.DefaultOutermostMapping(this._RNA.get_listeBases().size(), str.length()));
    }

    public void drawRNAInterpolated(String seq, String str, Mapping m) {
        this.drawRNAInterpolated(seq, str, this._RNA.get_drawMode(), m);
    }

    public void drawRNAInterpolated(String seq, String str, int drawMode, Mapping m) {
        RNA target = new RNA();
        try {
            target.setRNA(seq, str);
            this.drawRNAInterpolated(target, drawMode, m);
        }
        catch (ExceptionUnmatchedClosingParentheses e) {
            this.errorDialog(e);
        }
        catch (ExceptionFileFormatOrSyntax e) {
            this.errorDialog(e);
        }
    }

    public void drawRNAInterpolated(RNA target) {
        this.drawRNAInterpolated(target, target.get_drawMode(), Mapping.DefaultOutermostMapping(this._RNA.get_listeBases().size(), target.getSize()));
    }

    public void drawRNAInterpolated(RNA target, Mapping m) {
        this.drawRNAInterpolated(target, target.get_drawMode(), m);
    }

    public void drawRNAInterpolated(RNA target, int drawMode, Mapping m) {
        try {
            target.drawRNA(drawMode, this._conf);
            this._conf._drawColorMap = false;
            this._interpolator.addTarget(target, m);
        }
        catch (ExceptionNAViewAlgorithm e) {
            this.errorDialog(e);
            e.printStackTrace();
        }
    }

    public int getDrawMode() {
        return this._RNA.getDrawMode();
    }

    public void showRNA(RNA t, VARNAConfig cfg) {
        this.showRNA(t);
        if (cfg != null) {
            this.setConfig(cfg);
        }
        this.repaint();
    }

    public boolean isInterpolationInProgress() {
        if (this._interpolator == null) {
            return false;
        }
        return this._interpolator.isInterpolationInProgress();
    }

    public void showRNAInterpolated(RNA target) {
        this.showRNAInterpolated(target, Mapping.DefaultOutermostMapping(this._RNA.get_listeBases().size(), target.getSize()));
    }

    public void showRNAInterpolated(RNA target, Mapping m) {
        this.showRNAInterpolated(target, null, m);
    }

    public void showRNAInterpolated(RNA target, VARNAConfig cfg, Mapping m) {
        this._interpolator.addTarget(target, cfg, m);
    }

    public void drawRNA(String firstSeq, String firstStruct, String secondSeq, String secondStruct, int drawMode) {
        this._RNA.setDrawMode(drawMode);
        if (firstSeq.length() == secondSeq.length() && firstStruct.length() == secondStruct.length()) {
            if (firstSeq.length() != firstStruct.length()) {
                if (this._conf._showWarnings) {
                    this.emitWarning("First sequence length " + firstSeq.length() + " differs from that of it's secondary structure " + firstStruct.length() + ". \nAdapting first sequence length ...");
                }
                if (firstSeq.length() < firstStruct.length()) {
                    while (firstSeq.length() < firstStruct.length()) {
                        firstSeq = String.valueOf(firstSeq) + " ";
                    }
                } else {
                    firstSeq = firstSeq.substring(0, firstStruct.length());
                }
            }
            if (secondSeq.length() != secondStruct.length()) {
                if (this._conf._showWarnings) {
                    this.emitWarning("Second sequence length " + secondSeq.length() + " differs from that of it's secondary structure " + secondStruct.length() + ". \nAdapting second sequence length ...");
                }
                if (secondSeq.length() < secondStruct.length()) {
                    while (secondSeq.length() < secondStruct.length()) {
                        secondSeq = String.valueOf(secondSeq) + " ";
                    }
                } else {
                    secondSeq = secondSeq.substring(0, secondStruct.length());
                }
            }
            int RNALength = firstSeq.length();
            String string_superStruct = new String("");
            String string_superSeq = new String("");
            ArrayList<Integer> array_rnaOwn = new ArrayList<Integer>();
            firstStruct = firstStruct.replace('-', '.');
            secondStruct = secondStruct.replace('-', '.');
            int i = 0;
            while (i < RNALength) {
                if (firstStruct.charAt(i) == secondStruct.charAt(i)) {
                    string_superStruct = String.valueOf(string_superStruct) + firstStruct.charAt(i);
                    array_rnaOwn.add(0);
                } else if (firstStruct.charAt(i) == '(' || secondStruct.charAt(i) == '(') {
                    string_superStruct = String.valueOf(string_superStruct) + '(';
                    array_rnaOwn.add(firstStruct.charAt(i) == '(' ? 1 : 2);
                } else if (firstStruct.charAt(i) == ')' || secondStruct.charAt(i) == ')') {
                    string_superStruct = String.valueOf(string_superStruct) + ')';
                    array_rnaOwn.add(firstStruct.charAt(i) == ')' ? 1 : 2);
                } else {
                    string_superStruct = String.valueOf(string_superStruct) + '.';
                    array_rnaOwn.add(-1);
                }
                ++i;
            }
            i = 0;
            while (i < RNALength) {
                string_superSeq = String.valueOf(string_superSeq) + firstSeq.charAt(i) + secondSeq.charAt(i);
                ++i;
            }
            if (!string_superSeq.equals("") && !string_superStruct.equals("")) {
                try {
                    this._RNA.setRNA(string_superSeq, string_superStruct, array_rnaOwn);
                }
                catch (ExceptionUnmatchedClosingParentheses e) {
                    this.errorDialog(e);
                }
                catch (ExceptionFileFormatOrSyntax e) {
                    this.errorDialog(e);
                }
            } else {
                this.emitWarning("ERROR : The super-structure is NULL.");
            }
            switch (this._RNA.get_drawMode()) {
                case 2: {
                    this._RNA.drawRNARadiate(this._conf);
                    break;
                }
                case 1: {
                    this._RNA.drawRNACircle();
                    break;
                }
                case 4: {
                    this._RNA.drawRNALine();
                    break;
                }
                case 3: {
                    try {
                        this._RNA.drawRNANAView();
                    }
                    catch (ExceptionNAViewAlgorithm e) {
                        this.errorDialog(e);
                    }
                    break;
                }
            }
        }
    }

    public Point2D.Double[] getRealCoords() {
        return this._realCoords;
    }

    public void setRealCoords(Point2D.Double[] coords) {
        this._realCoords = coords;
    }

    public VueMenu getPopup() {
        return this._popup;
    }

    public void setBondColor(Color bond_color) {
        this._conf._bondColor = bond_color;
    }

    public Color getTitleColor() {
        return this._conf._titleColor;
    }

    public void setTitleColor(Color title_color) {
        this._conf._titleColor = title_color;
    }

    private int getTitleHeight() {
        return this._titleHeight;
    }

    private void setTitleHeight(int title_height) {
        this._titleHeight = title_height;
    }

    public boolean isAutoCentered() {
        return this._conf._autoCenter;
    }

    public void setAutoCenter(boolean center) {
        this._conf._autoCenter = center;
    }

    public Font getTitleFont() {
        return this._conf._titleFont;
    }

    public void setTitleFont(Font font) {
        this._conf._titleFont = font;
        this.updateTitleHeight();
    }

    public double getBPHeightIncrement() {
        return this._RNA._bpHeightIncrement;
    }

    public void setBPHeightIncrement(double inc) {
        this._RNA._bpHeightIncrement = inc;
    }

    public double getScaleFactor() {
        return this._scaleFactor;
    }

    public void setScaleFactor(double factor) {
        this._scaleFactor = factor;
    }

    public Point2D.Double getOffsetPanel() {
        return this._offsetPanel;
    }

    public Point2D.Double getRNAOffset() {
        return this._offsetRNA;
    }

    public VueMenu getPopupMenu() {
        return this._popup;
    }

    public double getZoomIncrement() {
        return this._conf._zoomAmount;
    }

    public void setZoomIncrement(Object amount) {
        this.setZoomIncrement(Float.valueOf(amount.toString()));
    }

    public void setZoomIncrement(double amount) {
        this._conf._zoomAmount = amount;
    }

    public double getZoom() {
        return this._conf._zoom;
    }

    public void setZoom(Object _zoom) {
        this._conf._zoom = Float.valueOf(_zoom.toString()).floatValue();
    }

    public Point getTranslation() {
        return this._translation;
    }

    public void setTranslation(Point trans) {
        this._translation = trans;
    }

    public RNA getRNA() {
        return this._RNA;
    }

    public boolean isOutOfFrame() {
        return this._horsCadre;
    }

    public void errorDialog(Exception error) {
        this.errorDialog(error, this);
    }

    public void errorDialog(Exception error, Component c) {
        if (this.isErrorsOn()) {
            JOptionPane.showMessageDialog(c, error.getMessage(), "VARNA Error", 0);
        }
    }

    public static void errorDialogStatic(Exception error, Component c) {
        JOptionPane.showMessageDialog(c, error.getMessage(), "VARNA Critical Error", 0);
    }

    public void emitWarning(String warning) {
        if (this._conf._showWarnings) {
            JOptionPane.showMessageDialog(this, warning, "VARNA Warning", 2);
        }
    }

    public void setModifiable(boolean modifiable) {
        this._conf._modifiable = modifiable;
    }

    public boolean isModifiable() {
        return this._conf._modifiable;
    }

    public void reset() {
        this.setBorderSize(new Dimension(0, 0));
        this.setTranslation(new Point(0, (int)((double)(-this.getTitleHeight()) / 2.0)));
        this.setZoom(1.0);
        this.setZoomIncrement(1.2);
    }

    public Color getNonStandardBasesColor() {
        return this._conf._specialBasesColor;
    }

    public void setNonStandardBasesColor(Color basesColor) {
        this._conf._specialBasesColor = basesColor;
    }

    public void checkTranslation() {
        if (this.getZoom() <= 1.0) {
            if (this.getTranslation().x < -((int)((double)(this.getWidth() - this.getInnerWidth()) / 2.0))) {
                this.setTranslation(new Point(-((int)((double)(this.getWidth() - this.getInnerWidth()) / 2.0)), this.getTranslation().y));
            }
            if (this.getTranslation().x > (int)((double)(this.getWidth() - this.getInnerWidth()) / 2.0)) {
                this.setTranslation(new Point((int)((double)(this.getWidth() - this.getInnerWidth()) / 2.0), this.getTranslation().y));
            }
            if (this.getTranslation().y > (int)((double)(this.getHeight() - this.getTitleHeight() * 2 - this.getInnerHeight()) / 2.0)) {
                this.setTranslation(new Point(this.getTranslation().x, (int)((double)(this.getHeight() - this.getTitleHeight() * 2 - this.getInnerHeight()) / 2.0)));
            }
            if (this.getTranslation().y < -((int)((double)(this.getHeight() - this.getInnerHeight()) / 2.0))) {
                this.setTranslation(new Point(this.getTranslation().x, -((int)((double)(this.getHeight() - this.getInnerHeight()) / 2.0))));
            }
        } else {
            if (this.getTranslation().x < -((int)((double)this.getInnerWidth() / 2.0))) {
                this.setTranslation(new Point(-((int)((double)this.getInnerWidth() / 2.0)), this.getTranslation().y));
            }
            if (this.getTranslation().x > (int)((double)this.getInnerWidth() / 2.0)) {
                this.setTranslation(new Point((int)((double)this.getInnerWidth() / 2.0), this.getTranslation().y));
            }
            if (this.getTranslation().y < -((int)((double)this.getInnerHeight() / 2.0))) {
                this.setTranslation(new Point(this.getTranslation().x, -((int)((double)this.getInnerHeight() / 2.0))));
            }
            if (this.getTranslation().y > (int)((double)this.getInnerHeight() / 2.0)) {
                this.setTranslation(new Point(this.getTranslation().x, (int)((double)this.getInnerHeight() / 2.0)));
            }
        }
    }

    public int getLeftOffset() {
        return this._border.width + (this.getWidth() - 2 * this._border.width - this.getInnerWidth()) / 2 + this._translation.x;
    }

    public int getInnerWidth() {
        return (int)Math.round((double)(this.getWidth() - 2 * this._border.width) * this._conf._zoom);
    }

    public int getTopOffset() {
        return this._border.height + (this.getHeight() - 2 * this._border.height - this.getInnerHeight()) / 2 + this._translation.y;
    }

    public int getInnerHeight() {
        return (int)Math.round((double)this.getHeight() * this._conf._zoom - (double)(2 * this._border.height) - (double)this.getTitleHeight());
    }

    public boolean isComparisonMode() {
        return this._conf._comparisonMode;
    }

    public void globalRotation(Double angleDegres) {
        this._RNA.globalRotation(angleDegres);
        this.fireLayoutChanged();
        this.repaint();
    }

    public Integer getNearestBase() {
        return this._nearestBase;
    }

    public void setNearestBase(Integer base) {
        this._nearestBase = base;
    }

    public Color getGapsBasesColor() {
        return this._conf._dashBasesColor;
    }

    public void setGapsBasesColor(Color c) {
        this._conf._dashBasesColor = c;
    }

    private void imprimer() {
        HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
        try {
            PrinterJob job = PrinterJob.getPrinterJob();
            if (job.printDialog(attributes)) {
                job.print(attributes);
            }
        }
        catch (PrinterException exception) {
            this.errorDialog(exception);
        }
    }

    public boolean isErrorsOn() {
        return this._conf._errorsOn;
    }

    public void setErrorsOn(boolean on) {
        this._conf._errorsOn = on;
    }

    public VueUI getVARNAUI() {
        return this._UI;
    }

    public void setUseBaseColorsForBPs(boolean on) {
        this._conf._useBaseColorsForBPs = on;
    }

    public boolean getUseBaseColorsForBPs() {
        return this._conf._useBaseColorsForBPs;
    }

    public void setColorNonStandardBases(boolean on) {
        this._conf._colorSpecialBases = on;
    }

    public boolean getColorSpecialBases() {
        return this._conf._colorSpecialBases;
    }

    public void setColorGapsBases(boolean on) {
        this._conf._colorDashBases = on;
    }

    public boolean getColorGapsBases() {
        return this._conf._colorDashBases;
    }

    public void setShowWarnings(boolean on) {
        this._conf._showWarnings = on;
    }

    public boolean getShowWarnings() {
        return this._conf._showWarnings;
    }

    public void setShowNonCanonicalBP(boolean on) {
        this._conf._drawnNonCanonicalBP = on;
    }

    public boolean getShowNonCanonicalBP() {
        return this._conf._drawnNonCanonicalBP;
    }

    public void setShowNonPlanarBP(boolean on) {
        this._conf._drawnNonPlanarBP = on;
    }

    public boolean getShowNonPlanarBP() {
        return this._conf._drawnNonPlanarBP;
    }

    public void setBPStyle(VARNAConfig.BP_STYLE st) {
        this._conf._mainBPStyle = st;
    }

    public VARNAConfig.BP_STYLE getBPStyle() {
        return this._conf._mainBPStyle;
    }

    public VARNAConfig getConfig() {
        return this._conf;
    }

    @Override
    public void setBackground(Color c) {
        if (this._conf != null) {
            if (c != null) {
                this._conf._backgroundColor = c;
                this._conf._drawBackground = !c.equals(VARNAConfig.DEFAULT_BACKGROUND_COLOR);
            } else {
                this._conf._backgroundColor = VARNAConfig.DEFAULT_BACKGROUND_COLOR;
                this._conf._drawBackground = false;
            }
        }
    }

    public void highlightSelectedBase(ModeleBase m) {
        ArrayList<Integer> v = new ArrayList<Integer>();
        int sel = m.getIndex();
        if (sel != -1) {
            v.add(sel);
        }
        this.setSelection(v);
    }

    public void highlightSelectedStem(ModeleBase m) {
        ArrayList<Integer> v = new ArrayList<Integer>();
        int sel = m.getIndex();
        if (sel != -1) {
            ArrayList<Integer> r = this._RNA.findStem(sel);
            v.addAll(r);
        }
        this.setSelection(v);
    }

    public BaseList getSelection() {
        return this._selectedBases;
    }

    public ArrayList<Integer> getSelectionIndices() {
        return this._selectedBases.getIndices();
    }

    public void setSelection(ArrayList<Integer> indices) {
        this.setSelection((Collection<? extends ModeleBase>)this._RNA.getBasesAt(indices));
    }

    public void setSelection(Collection<? extends ModeleBase> mbs) {
        BaseList bck = new BaseList(this._selectedBases);
        this._selectedBases.clear();
        this._selectedBases.addBases(mbs);
        this._blink.setActive(true);
        this.fireSelectionChanged(bck, this._selectedBases);
    }

    public ArrayList<Integer> getBasesInRectangleDiff(Rectangle recIn, Rectangle recOut) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        while (i < this._realCoords.length) {
            if (recIn.contains(this._realCoords[i]) ^ recOut.contains(this._realCoords[i])) {
                result.add(i);
            }
            ++i;
        }
        return result;
    }

    public ArrayList<Integer> getBasesInRectangle(Rectangle rec) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        while (i < this._realCoords.length) {
            if (rec.contains(this._realCoords[i])) {
                result.add(i);
            }
            ++i;
        }
        return result;
    }

    public void setSelectionRectangle(Rectangle rec) {
        ArrayList<Object> result = new ArrayList();
        result = this._selectionRectangle != null ? this.getBasesInRectangleDiff(this._selectionRectangle, rec) : this.getBasesInRectangle(rec);
        this._selectionRectangle = new Rectangle(rec);
        this.toggleSelection(result);
        this.repaint();
    }

    public void removeSelectionRectangle() {
        this._selectionRectangle = null;
    }

    public void addToSelection(Collection<? extends Integer> indices) {
        Iterator<? extends Integer> iterator = indices.iterator();
        while (iterator.hasNext()) {
            int i = iterator.next();
            this.addToSelection(i);
        }
    }

    public void addToSelection(int i) {
        BaseList bck = new BaseList(this._selectedBases);
        ModeleBase mb = this._RNA.getBaseAt(i);
        this._selectedBases.addBase(mb);
        this._blink.setActive(true);
        this.fireSelectionChanged(bck, this._selectedBases);
    }

    public void removeFromSelection(int i) {
        BaseList bck = new BaseList(this._selectedBases);
        ModeleBase mb = this._RNA.getBaseAt(i);
        this._selectedBases.removeBase(mb);
        if (this._selectedBases.size() == 0) {
            this._blink.setActive(false);
        } else {
            this._blink.setActive(true);
        }
        this.fireSelectionChanged(bck, this._selectedBases);
    }

    public boolean isInSelection(int i) {
        return this._selectedBases.contains(this._RNA.getBaseAt(i));
    }

    public void toggleSelection(int i) {
        if (this.isInSelection(i)) {
            this.removeFromSelection(i);
        } else {
            this.addToSelection(i);
        }
    }

    public void toggleSelection(Collection<? extends Integer> indices) {
        Iterator<? extends Integer> iterator = indices.iterator();
        while (iterator.hasNext()) {
            int i = iterator.next();
            this.toggleSelection(i);
        }
    }

    public void clearSelection() {
        BaseList bck = new BaseList(this._selectedBases);
        this._selectedBases.clear();
        this._blink.setActive(false);
        this.repaint();
        this.fireSelectionChanged(bck, this._selectedBases);
    }

    public void saveSelection() {
        this._backupSelection.clear();
        this._backupSelection.addAll(this._selectedBases.getBases());
    }

    public void restoreSelection() {
        this.setSelection((Collection<? extends ModeleBase>)this._backupSelection);
    }

    public void resetAnnotationHighlight() {
        this._highlightAnnotation = false;
        this.repaint();
    }

    public void drawBBox(boolean on) {
        this._drawBBox = on;
    }

    public void drawBorder(boolean on) {
        this._drawBorder = on;
    }

    public void setBaseInnerColor(Color c) {
        this._RNA.setBaseInnerColor(c);
    }

    public void setBaseNumbersColor(Color c) {
        this._RNA.setBaseNumbersColor(c);
    }

    public void setBaseNameColor(Color c) {
        this._RNA.setBaseNameColor(c);
    }

    public void setBaseOutlineColor(Color c) {
        this._RNA.setBaseOutlineColor(c);
    }

    public ArrayList<TextAnnotation> getListeAnnotations() {
        return this._RNA.getAnnotations();
    }

    public void resetListeAnnotations() {
        this._RNA.clearAnnotations();
        this.repaint();
    }

    public void addAnnotation(TextAnnotation textAnnotation) {
        this._RNA.addAnnotation(textAnnotation);
        this.repaint();
    }

    public boolean removeAnnotation(TextAnnotation textAnnotation) {
        boolean done = this._RNA.removeAnnotation(textAnnotation);
        this.repaint();
        return done;
    }

    public TextAnnotation get_selectedAnnotation() {
        return this._selectedAnnotation;
    }

    public void set_selectedAnnotation(TextAnnotation annotation) {
        this._selectedAnnotation = annotation;
    }

    public void removeSelectedAnnotation() {
        this._highlightAnnotation = false;
        this._selectedAnnotation = null;
    }

    public void highlightSelectedAnnotation() {
        this._highlightAnnotation = true;
    }

    public boolean getFlatExteriorLoop() {
        return this._conf._flatExteriorLoop;
    }

    public void setFlatExteriorLoop(boolean on) {
        this._conf._flatExteriorLoop = on;
    }

    public void setLastSelectedPosition(Point2D.Double p) {
        this._lastSelectedCoord.x = p.x;
        this._lastSelectedCoord.y = p.y;
    }

    public Point2D.Double getLastSelectedPosition() {
        return this._lastSelectedCoord;
    }

    public void setSequence(String s) {
        this._RNA.setSequence(s);
        this.repaint();
    }

    public void setColorMapVisible(boolean b) {
        this._conf._drawColorMap = b;
        this.repaint();
    }

    public boolean getColorMapVisible() {
        return this._conf._drawColorMap;
    }

    public void removeColorMap() {
        this._conf._drawColorMap = false;
        this.repaint();
    }

    public void saveSession(String path) {
        this.toXML(path);
    }

    public FullBackup loadSession(String path) throws ExceptionLoadingFailed {
        FullBackup bck = VARNAPanel.importSession(path);
        Mapping map = Mapping.DefaultOutermostMapping(this.getRNA().getSize(), bck.rna.getSize());
        this.showRNAInterpolated(bck.rna, map);
        this._conf = bck.config;
        this.repaint();
        return bck;
    }

    public static FullBackup importSession(String path) throws ExceptionLoadingFailed {
        try {
            FileInputStream fis = new FileInputStream(path);
            FullBackup h = VARNAPanel.importSession(fis, path);
            return h;
        }
        catch (FileNotFoundException e) {
            throw new ExceptionLoadingFailed("File not found.", path);
        }
        catch (IOException e) {
            throw new ExceptionLoadingFailed("I/O error while loading session.", path);
        }
    }

    public static FullBackup importSession(InputStream fis, String path) throws ExceptionLoadingFailed {
        System.setProperty("javax.xml.parsers.SAXParserFactory", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
        SAXParserFactory saxFact = SAXParserFactory.newInstance();
        saxFact.setValidating(false);
        saxFact.setXIncludeAware(false);
        saxFact.setNamespaceAware(false);
        try {
            SAXParser sp = saxFact.newSAXParser();
            VARNASessionParser sessionData = new VARNASessionParser();
            sp.parse(fis, (DefaultHandler)sessionData);
            FullBackup res = new FullBackup(sessionData.getVARNAConfig(), sessionData.getRNA(), "test");
            return res;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new ExceptionLoadingFailed("Bad XML parser configuration", path);
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new ExceptionLoadingFailed("XML parser Exception", path);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ExceptionLoadingFailed("I/O error", path);
        }
    }

    public void loadFile(String path) {
        this.loadFile(path, false);
    }

    public boolean getDrawBackbone() {
        return this._conf._drawBackbone;
    }

    public void setDrawBackbone(boolean b) {
        this._conf._drawBackbone = b;
    }

    public void addHighlightRegion(HighlightRegionAnnotation n) {
        this._RNA.addHighlightRegion(n);
    }

    public void removeHighlightRegion(HighlightRegionAnnotation n) {
        this._RNA.removeHighlightRegion(n);
    }

    public void addHighlightRegion(int i, int j) {
        this._RNA.addHighlightRegion(i, j);
    }

    public void addHighlightRegion(int i, int j, Color fill, Color outline, double radius) {
        this._RNA.addHighlightRegion(i, j, fill, outline, radius);
    }

    public void loadFile(String path, boolean interpolate) {
        try {
            this.loadSession(path);
        }
        catch (Exception e1) {
            try {
                ArrayList<RNA> rnas = RNAFactory.loadSecStr(path);
                if (rnas.isEmpty()) {
                    throw new ExceptionFileFormatOrSyntax("No RNA could be parsed from that source.");
                }
                RNA rna = (RNA)rnas.iterator().next();
                try {
                    rna.drawRNA(this._conf);
                }
                catch (ExceptionNAViewAlgorithm e) {
                    e.printStackTrace();
                }
                if (!interpolate) {
                    this.showRNA(rna);
                } else {
                    this.showRNAInterpolated(rna);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (ExceptionFileFormatOrSyntax e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setConfig(VARNAConfig cfg) {
        this._conf = cfg;
    }

    public void toggleDrawOutlineBase() {
        this._conf._drawOutlineBase = !this._conf._drawOutlineBase;
    }

    public void toggleFillBase() {
        this._conf._fillBase = !this._conf._fillBase;
    }

    public void readValues(Reader r) {
        this._RNA.readValues(r, this._conf._cm);
    }

    public void addVARNAListener(InterfaceVARNAListener v) {
        this._VARNAListeners.add(v);
    }

    public void fireLayoutChanged() {
        for (InterfaceVARNAListener v : this._VARNAListeners) {
            v.onStructureRedrawn();
        }
    }

    public void fireUINewStructure(RNA r) {
        for (InterfaceVARNAListener v : this._VARNAListeners) {
            v.onUINewStructure(this._conf, r);
        }
    }

    public void addSelectionListener(InterfaceVARNASelectionListener v) {
        this._selectionListeners.add(v);
    }

    public void fireSelectionChanged(BaseList mold, BaseList mnew) {
        BaseList addedBases = mnew.removeAll(mold);
        BaseList removedBases = mold.removeAll(mnew);
        for (InterfaceVARNASelectionListener v2 : this._selectionListeners) {
            v2.onSelectionChanged(mnew, addedBases, removedBases);
        }
    }

    public void fireHoverChanged(ModeleBase mold, ModeleBase mnew) {
        for (InterfaceVARNASelectionListener v2 : this._selectionListeners) {
            v2.onHoverChanged(mold, mnew);
        }
    }

    public void addRNAListener(InterfaceVARNARNAListener v) {
        this._RNAListeners.add(v);
    }

    public void fireSequenceChanged(int index, String oldseq, String newseq) {
        for (InterfaceVARNARNAListener v2 : this._RNAListeners) {
            v2.onSequenceChanged(index, oldseq, newseq);
        }
    }

    public void fireStructureChanged(Set<ModeleBP> current, Set<ModeleBP> addedBasePairs, Set<ModeleBP> removedBasePairs) {
        for (InterfaceVARNARNAListener v2 : this._RNAListeners) {
            v2.onStructureChanged(current, addedBasePairs, removedBasePairs);
        }
    }

    public void fireLayoutChanged(Hashtable<Integer, Point2D.Double> movedPositions) {
        for (InterfaceVARNARNAListener v2 : this._RNAListeners) {
            v2.onLayoutChanged(movedPositions);
        }
    }

    public double getOrientation() {
        return this._RNA.getOrientation();
    }

    public void setHoverBase(ModeleBase m) {
        if (m != this._hoveredBase) {
            ModeleBase bck = this._hoveredBase;
            this._hoveredBase = m;
            this.repaint();
            this.fireHoverChanged(bck, m);
        }
    }

    public void toXML(String path) {
        try {
            FileOutputStream fis = new FileOutputStream(path);
            PrintWriter pw = new PrintWriter(fis);
            this.toXML(pw);
            pw.flush();
            fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toXML(PrintWriter out) {
        try {
            StreamResult streamResult = new StreamResult(out);
            SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler hd = tf.newTransformerHandler();
            Transformer serializer = hd.getTransformer();
            serializer.setOutputProperty("encoding", "ISO-8859-1");
            serializer.setOutputProperty("doctype-system", "users.dtd");
            serializer.setOutputProperty("indent", "yes");
            hd.setResult(streamResult);
            hd.startDocument();
            this.toXML(hd);
            hd.endDocument();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void toXML(TransformerHandler hd) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        hd.startElement("", "", XML_ELEMENT_NAME, atts);
        this._RNA.toXML(hd);
        this._conf.toXML(hd);
        hd.endElement("", "", XML_ELEMENT_NAME);
    }
}

