/*
 * Decompiled with CFR 0.152.
 */
import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.controlers.ControleurScriptParser;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionModeleStyleBaseSyntaxError;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.exceptions.ExceptionParameterError;
import fr.orsay.lri.varna.interfaces.InterfaceParameterLoader;
import fr.orsay.lri.varna.models.VARNAConfigLoader;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JApplet;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VARNA
extends JApplet
implements InterfaceParameterLoader,
DropTargetListener {
    ArrayList<VARNAPanel> _vpl = null;
    private static final long serialVersionUID = -2598221520127067670L;

    @Override
    public void init() {
        try {
            VARNAConfigLoader VARNAcfg = new VARNAConfigLoader(this);
            try {
                this._vpl = VARNAcfg.createVARNAPanels();
                int i = 0;
                while (i < this._vpl.size()) {
                    new DropTarget(this._vpl.get(i), this);
                    ++i;
                }
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "VARNA Error", 0);
            }
            catch (ExceptionFileFormatOrSyntax e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "VARNA Error", 0);
            }
            catch (ExceptionLoadingFailed e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "VARNA Error", 0);
            }
            this.setLayout(new GridLayout(VARNAcfg.getNbColumns(), VARNAcfg.getNbRows()));
            int i = 0;
            while (i < this._vpl.size()) {
                this.getContentPane().add(this._vpl.get(i));
                ++i;
            }
            this.getContentPane().setVisible(true);
            this.getContentPane().repaint();
        }
        catch (ExceptionParameterError e) {
            VARNAPanel.errorDialogStatic(e, this);
        }
        catch (ExceptionModeleStyleBaseSyntaxError e) {
            VARNAPanel.errorDialogStatic(e, this);
        }
        catch (ExceptionNonEqualLength e) {
            VARNAPanel.errorDialogStatic(e, this);
        }
    }

    @Override
    public String getParameterValue(String key, String def) {
        if (this.getParameter(key) == null) {
            return def;
        }
        return this.getParameter(key);
    }

    @Override
    public String[][] getParameterInfo() {
        return VARNAConfigLoader.getParameterInfo();
    }

    public ArrayList<VARNAPanel> getPanels() {
        return this._vpl;
    }

    public String getSelection() {
        return this.getSelection(0);
    }

    public String getSelection(int panel) {
        String result = "[";
        VARNAPanel v = this._vpl.get(panel);
        ArrayList<Integer> l = v.getSelectionIndices();
        int i = 0;
        while (i < l.size()) {
            int n = (Integer)l.get(i);
            if (i > 0) {
                result = String.valueOf(result) + ",";
            }
            result = String.valueOf(result) + n;
            ++i;
        }
        result = String.valueOf(result) + "]";
        return result;
    }

    public void runScript(String script) {
        if (this._vpl.size() > 0) {
            VARNAPanel _vp = this._vpl.get(0);
            try {
                ControleurScriptParser.executeScript(_vp, script);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setRNA(String seq, String str) {
        if (this._vpl.size() > 0) {
            try {
                this._vpl.get(0).drawRNA(seq, str);
            }
            catch (ExceptionNonEqualLength e) {
                e.printStackTrace();
            }
        }
    }

    public void setSmoothedRNA(String seq, String str) {
        if (this._vpl.size() > 0) {
            try {
                this._vpl.get(0).drawRNAInterpolated(seq, str);
                this._vpl.get(0).repaint();
            }
            catch (ExceptionNonEqualLength e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent arg0) {
    }

    @Override
    public void dragExit(DropTargetEvent arg0) {
    }

    @Override
    public void dragOver(DropTargetDragEvent arg0) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            DataFlavor[] flavors = tr.getTransferDataFlavors();
            int i = 0;
            while (i < flavors.length) {
                if (flavors[i].isFlavorJavaFileListType()) {
                    dtde.acceptDrop(3);
                    List list = (List)tr.getTransferData(flavors[i]);
                    int j = 0;
                    while (j < list.size()) {
                        DropTarget dt;
                        Component c;
                        Object o = list.get(j);
                        if (dtde.getSource() instanceof DropTarget && (c = (dt = (DropTarget)dtde.getSource()).getComponent()) instanceof VARNAPanel) {
                            VARNAPanel vp = (VARNAPanel)c;
                            String path = o.toString();
                            vp.loadFile(path, true);
                            vp.repaint();
                        }
                        ++j;
                    }
                    dtde.dropComplete(true);
                    return;
                }
                ++i;
            }
            dtde.rejectDrop();
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent arg0) {
    }
}

