/*
 * Decompiled with CFR 0.152.
 */
package org.forester.ws.uniprot;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.util.ForesterUtil;
import org.forester.ws.uniprot.EbiDbEntry;
import org.forester.ws.uniprot.SequenceDatabaseEntry;
import org.forester.ws.uniprot.UniProtEntry;
import org.forester.ws.uniprot.UniProtTaxonomy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UniProtWsTools {
    public static final String BASE_URL = "http://www.uniprot.org/";
    public static final String BASE_EMBL_DB_URL = "http://www.ebi.ac.uk/Tools/dbfetch/dbfetch/embl/";
    private static final String URL_ENC = "UTF-8";
    private static final Pattern UNIPROT_AC_PATTERN = Pattern.compile("(?:\\A|.*[^a-zA-Z0-9])([A-Z]\\d[A-Z0-9]{3}\\d)(?:[^a-zA-Z0-9]|\\Z)");
    private static final boolean DEBUG = false;

    private static String encode(String string) throws UnsupportedEncodingException {
        return URLEncoder.encode(string.trim(), URL_ENC);
    }

    public static String parseUniProtAccessor(String string) {
        Matcher matcher = UNIPROT_AC_PATTERN.matcher(string);
        if (matcher.lookingAt()) {
            return matcher.group(1);
        }
        return null;
    }

    public static List<UniProtTaxonomy> getTaxonomiesFromCommonName(String string, int n) throws IOException {
        List<String> list = UniProtWsTools.getTaxonomyStringFromCommonName(string, n);
        if (list.size() > 0) {
            return UniProtWsTools.parseUniProtTaxonomy(list);
        }
        return null;
    }

    public static List<UniProtTaxonomy> getTaxonomiesFromCommonNameStrict(String string, int n) throws IOException {
        List<UniProtTaxonomy> list = UniProtWsTools.getTaxonomiesFromCommonName(string, n);
        if (list != null && list.size() > 0) {
            ArrayList<UniProtTaxonomy> arrayList = new ArrayList<UniProtTaxonomy>();
            for (UniProtTaxonomy uniProtTaxonomy : list) {
                if (!uniProtTaxonomy.getCommonName().equalsIgnoreCase(string)) continue;
                arrayList.add(uniProtTaxonomy);
            }
            return arrayList;
        }
        return null;
    }

    public static List<UniProtTaxonomy> getTaxonomiesFromId(String string, int n) throws IOException {
        List<String> list = UniProtWsTools.getTaxonomyStringFromId(string, n);
        if (list.size() > 0) {
            return UniProtWsTools.parseUniProtTaxonomy(list);
        }
        return null;
    }

    public static List<UniProtTaxonomy> getTaxonomiesFromScientificName(String string, int n) throws IOException {
        if (string.equals("Drosophila")) {
            return UniProtWsTools.hack(UniProtTaxonomy.DROSOPHILA_GENUS);
        }
        if (string.equals("Xenopus")) {
            return UniProtWsTools.hack(UniProtTaxonomy.XENOPUS_GENUS);
        }
        List<String> list = UniProtWsTools.getTaxonomyStringFromScientificName(string, n);
        if (list.size() > 0) {
            return UniProtWsTools.parseUniProtTaxonomy(list);
        }
        return null;
    }

    public static List<UniProtTaxonomy> getTaxonomiesFromScientificNameStrict(String string, int n) throws IOException {
        List<UniProtTaxonomy> list = UniProtWsTools.getTaxonomiesFromScientificName(string, n);
        if (list != null && list.size() > 0) {
            ArrayList<UniProtTaxonomy> arrayList = new ArrayList<UniProtTaxonomy>();
            for (UniProtTaxonomy uniProtTaxonomy : list) {
                if (!uniProtTaxonomy.getScientificName().equalsIgnoreCase(string)) continue;
                arrayList.add(uniProtTaxonomy);
            }
            return arrayList;
        }
        return null;
    }

    public static List<UniProtTaxonomy> getTaxonomiesFromTaxonomyCode(String string, int n) throws IOException {
        String string2 = new String(string);
        if (string2.equals("FUGRU")) {
            string2 = "TAKRU";
        } else if (string2.equals("CAP")) {
            return UniProtWsTools.hack(UniProtTaxonomy.CAPITELLA_TELATA_SPECIES);
        }
        List<String> list = UniProtWsTools.getTaxonomyStringFromTaxonomyCode(string2, n);
        if (list.size() > 0) {
            return UniProtWsTools.parseUniProtTaxonomy(list);
        }
        return null;
    }

    private static List<String> getTaxonomyStringFromCommonName(String string, int n) throws IOException {
        return UniProtWsTools.queryUniprot("taxonomy/?query=common%3a%22" + UniProtWsTools.encode(string) + "%22&format=tab", n);
    }

    private static List<String> getTaxonomyStringFromId(String string, int n) throws IOException {
        return UniProtWsTools.queryUniprot("taxonomy/?query=id%3a%22" + UniProtWsTools.encode(string) + "%22&format=tab", n);
    }

    private static List<String> getTaxonomyStringFromScientificName(String string, int n) throws IOException {
        return UniProtWsTools.queryUniprot("taxonomy/?query=scientific%3a%22" + UniProtWsTools.encode(string) + "%22&format=tab", n);
    }

    private static List<String> getTaxonomyStringFromTaxonomyCode(String string, int n) throws IOException {
        return UniProtWsTools.queryUniprot("taxonomy/?query=mnemonic%3a%22" + UniProtWsTools.encode(string) + "%22&format=tab", n);
    }

    private static List<UniProtTaxonomy> hack(UniProtTaxonomy uniProtTaxonomy) {
        ArrayList<UniProtTaxonomy> arrayList = new ArrayList<UniProtTaxonomy>();
        arrayList.add(uniProtTaxonomy);
        return arrayList;
    }

    private static List<UniProtTaxonomy> parseUniProtTaxonomy(List<String> list) throws IOException {
        ArrayList<UniProtTaxonomy> arrayList = new ArrayList<UniProtTaxonomy>();
        for (String string : list) {
            if (ForesterUtil.isEmpty(string)) continue;
            if (string.startsWith("Taxon")) {
                String[] stringArray = string.split("\t");
                if (stringArray[1].equalsIgnoreCase("Mnemonic") && stringArray[2].equalsIgnoreCase("Scientific name") && stringArray[3].equalsIgnoreCase("Common name") && stringArray[4].equalsIgnoreCase("Synonym") && stringArray[5].equalsIgnoreCase("Other Names") && stringArray[6].equalsIgnoreCase("Reviewed") && stringArray[7].equalsIgnoreCase("Rank") && stringArray[8].equalsIgnoreCase("Lineage")) continue;
                throw new IOException("Unreconized UniProt Taxonomy format: " + string);
            }
            if (string.split("\t").length <= 4) continue;
            arrayList.add(new UniProtTaxonomy(string));
        }
        return arrayList;
    }

    public static List<String> queryEmblDb(String string, int n) throws IOException {
        return UniProtWsTools.queryDb(string, n, BASE_EMBL_DB_URL);
    }

    public static List<String> queryUniprot(String string, int n) throws IOException {
        return UniProtWsTools.queryDb(string, n, BASE_URL);
    }

    public static List<String> queryDb(String string, int n, String string2) throws IOException {
        String string3;
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("illegal attempt to use empty query ");
        }
        if (n < 1) {
            n = 1;
        }
        URL uRL = new URL(string2 + string);
        URLConnection uRLConnection = uRL.openConnection();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string3 = bufferedReader.readLine()) != null) {
            arrayList.add(string3);
            if (arrayList.size() <= n) continue;
        }
        bufferedReader.close();
        return arrayList;
    }

    public static SequenceDatabaseEntry obtainUniProtEntry(String string, int n) throws IOException {
        List<String> list = UniProtWsTools.queryUniprot("uniprot/" + string + ".txt", n);
        return UniProtEntry.createInstanceFromPlainText(list);
    }

    public static SequenceDatabaseEntry obtainEmblEntry(String string, int n) throws IOException {
        List<String> list = UniProtWsTools.queryEmblDb(string, n);
        return EbiDbEntry.createInstanceFromPlainText(list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Db {
        UNKNOWN,
        UNIPROT;

    }
}

