/*
 * Decompiled with CFR 0.152.
 */
package org.forester.ws.uniprot;

import java.util.ArrayList;
import java.util.List;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UniProtTaxonomy {
    private static final String ARCHAEA = "Archaea";
    private static final String BACTERIA = "Bacteria";
    private static final String EUKARYOTA = "Eukaryota";
    private final List<String> _lineage;
    private final String _code;
    private final String _scientific_name;
    private final String _common_name;
    private final String _synonym;
    private final String _rank;
    private final String _id;
    public static final String CELLULAR_ORGANISMS = "cellular organisms";
    public static final String VIRUSES = "Viruses";
    public static final UniProtTaxonomy DROSOPHILA_GENUS = new UniProtTaxonomy(new String[]{"cellular organisms", "Eukaryota", "Metazoa", "Arthropoda", "Hexapoda", "Insecta", "Pterygota", "Neoptera", "Endopterygota", "Diptera", "Brachycera", "Muscomorpha", "Ephydroidea", "Drosophilidae", "Drosophila"}, "", "fruit flies", "Drosophila", "", "genus", "7215");
    public static final UniProtTaxonomy XENOPUS_GENUS = new UniProtTaxonomy(new String[]{"cellular organisms", "Eukaryota", "Metazoa", "Chordata", "Craniata", "Vertebrata", "Euteleostomi", "Amphibia", "Batrachia", "Anura", "Mesobatrachia", "Pipoidea", "Pipidae", "Xenopodinae", "Xenopus"}, "", "", "Xenopus", "", "genus", "8353");
    public static final UniProtTaxonomy CAPITELLA_TELATA_SPECIES = new UniProtTaxonomy(new String[]{"cellular organisms", "Eukaryota", "Metazoa", "Annelida", "Polychaeta", "Scolecida", "Capitellida", "Capitellidae", "Capitella", "Capitella teleta"}, "", "", "Capitella teleta", "Capitella sp. I", "species", "283909");

    public UniProtTaxonomy(String string) {
        String[] stringArray = string.split("\t");
        if (stringArray.length < 5) {
            throw new IllegalArgumentException("cannot parse uniprot taxonomy from: " + string);
        }
        this._id = stringArray[0].trim();
        this._code = stringArray[1].trim();
        this._scientific_name = stringArray[2].trim();
        this._common_name = stringArray[3].trim();
        this._synonym = stringArray[4].trim();
        this._rank = stringArray.length > 6 ? stringArray[7].trim() : "";
        String[] stringArray2 = null;
        if (stringArray.length > 8) {
            stringArray2 = stringArray[8].split("; ");
        }
        this._lineage = new ArrayList<String>();
        if (stringArray2 != null && stringArray2.length > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : stringArray2) {
                if (ForesterUtil.isEmpty(string2)) continue;
                arrayList.add(string2.trim());
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                if (i == 0 && (((String)arrayList.get(i)).equalsIgnoreCase(EUKARYOTA) || ((String)arrayList.get(i)).equalsIgnoreCase(BACTERIA) || ((String)arrayList.get(i)).equalsIgnoreCase(ARCHAEA))) {
                    this._lineage.add(CELLULAR_ORGANISMS);
                }
                this._lineage.add((String)arrayList.get(i));
            }
        }
        if (this._lineage.isEmpty() && (this._scientific_name.equalsIgnoreCase(EUKARYOTA) || this._scientific_name.equalsIgnoreCase(BACTERIA) || this._scientific_name.equalsIgnoreCase(ARCHAEA))) {
            this._lineage.add(CELLULAR_ORGANISMS);
        }
        this._lineage.add(this._scientific_name);
        if (this._lineage.isEmpty()) {
            throw new IllegalArgumentException("lineage in a UniProt Taxonomy can not be empty\n: " + string);
        }
    }

    public UniProtTaxonomy(List<String> list, String string, String string2, String string3, String string4, String string5, String string6) {
        this._lineage = list;
        this._code = string;
        this._scientific_name = string3;
        this._common_name = string2;
        this._synonym = string4;
        this._rank = string5;
        this._id = string6;
        if (this._lineage != null && !this._lineage.get(this._lineage.size() - 1).equalsIgnoreCase(this._scientific_name)) {
            this._lineage.add(this._scientific_name);
        }
    }

    public UniProtTaxonomy(String[] stringArray, String string, String string2, String string3, String string4, String string5, String string6) {
        this._lineage = new ArrayList<String>();
        if (stringArray != null) {
            for (String string7 : stringArray) {
                this._lineage.add(string7);
            }
        }
        this._code = string;
        this._scientific_name = string3;
        this._common_name = string2;
        this._synonym = string4;
        this._rank = string5;
        this._id = string6;
        if (this._lineage != null && !this._lineage.get(this._lineage.size() - 1).equalsIgnoreCase(this._scientific_name)) {
            this._lineage.add(this._scientific_name);
        }
    }

    public UniProtTaxonomy copy() {
        return new UniProtTaxonomy(this.getLineage(), this.getCode() != null ? new String(this.getCode()) : null, this.getCommonName() != null ? new String(this.getCommonName()) : null, this.getScientificName() != null ? new String(this.getScientificName()) : null, this.getSynonym() != null ? new String(this.getSynonym()) : null, this.getRank() != null ? new String(this.getRank()) : null, this.getId() != null ? new String(this.getId()) : null);
    }

    public String getCode() {
        return this._code;
    }

    public String getCommonName() {
        return this._common_name;
    }

    public String getId() {
        return this._id;
    }

    public List<String> getLineage() {
        return this._lineage;
    }

    public String getRank() {
        return this._rank;
    }

    public String getScientificName() {
        return this._scientific_name;
    }

    public String getSynonym() {
        return this._synonym;
    }
}

