/*
 * Decompiled with CFR 0.152.
 */
package org.forester.ws.uniprot;

import java.util.List;
import org.forester.util.ForesterUtil;
import org.forester.ws.uniprot.DatabaseTools;
import org.forester.ws.uniprot.SequenceDatabaseEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EbiDbEntry
implements SequenceDatabaseEntry {
    private String _pa;
    private String _de;
    private String _os;
    private String _tax_id;
    private String _symbol;

    private EbiDbEntry() {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public static SequenceDatabaseEntry createInstanceFromPlainText(List<String> list) {
        EbiDbEntry ebiDbEntry = new EbiDbEntry();
        for (String string : list) {
            if (string.startsWith("PA")) {
                ebiDbEntry.setPA(DatabaseTools.extract(string, "PA"));
                continue;
            }
            if (string.startsWith("DE")) {
                ebiDbEntry.setDe(DatabaseTools.extract(string, "DE"));
                continue;
            }
            if (string.startsWith("OS")) {
                if (string.indexOf("(") > 0) {
                    ebiDbEntry.setOs(DatabaseTools.extract(string, "OS", "("));
                    continue;
                }
                ebiDbEntry.setOs(DatabaseTools.extract(string, "OS"));
                continue;
            }
            if (!string.startsWith("OX") || string.indexOf("NCBI_TaxID=") <= 0) continue;
            ebiDbEntry.setTaxId(DatabaseTools.extract(string, "NCBI_TaxID=", ";"));
        }
        return ebiDbEntry;
    }

    @Override
    public String getAccession() {
        return this._pa;
    }

    private void setPA(String string) {
        if (this._pa == null) {
            this._pa = string;
        }
    }

    @Override
    public String getSequenceName() {
        return this._de;
    }

    private void setDe(String string) {
        if (this._de == null) {
            this._de = string;
        }
    }

    @Override
    public String getTaxonomyScientificName() {
        return this._os;
    }

    private void setOs(String string) {
        if (this._os == null) {
            this._os = string;
        }
    }

    @Override
    public String getTaxonomyIdentifier() {
        return this._tax_id;
    }

    private void setTaxId(String string) {
        if (this._tax_id == null) {
            this._tax_id = string;
        }
    }

    @Override
    public String getSequenceSymbol() {
        return this._symbol;
    }

    private void setSymbol(String string) {
        if (this._symbol == null) {
            this._symbol = string;
        }
    }

    @Override
    public boolean isEmpty() {
        return ForesterUtil.isEmpty(this.getAccession()) && ForesterUtil.isEmpty(this.getSequenceName()) && ForesterUtil.isEmpty(this.getTaxonomyScientificName()) && ForesterUtil.isEmpty(this.getTaxonomyIdentifier()) && ForesterUtil.isEmpty(this.getSequenceSymbol());
    }
}

