/*
 * Decompiled with CFR 0.152.
 */
package org.forester.ws.uniprot;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DatabaseTools {
    private static final Pattern GENBANK_NUCLEOTIDE_AC_PATTERN_1 = Pattern.compile("(?:\\A|.*[^a-zA-Z0-9])([A-Z]\\d{5})(?:[^a-zA-Z0-9]|\\Z)");
    private static final Pattern GENBANK_NUCLEOTIDE_AC_PATTERN_2 = Pattern.compile("(?:\\A|.*[^a-zA-Z0-9])([A-Z]{2}\\d{6})(?:[^a-zA-Z0-9]|\\Z)");
    private static final Pattern GENBANK_PROTEIN_AC_PATTERN = Pattern.compile("(?:\\A|.*[^a-zA-Z0-9])([A-Z]{3}\\d{5})(?:[^a-zA-Z0-9]|\\Z)");
    private static final boolean DEBUG = false;

    public static String parseGenbankAccessor(String string) {
        Matcher matcher = GENBANK_NUCLEOTIDE_AC_PATTERN_1.matcher(string);
        if (matcher.lookingAt()) {
            return matcher.group(1);
        }
        matcher = GENBANK_NUCLEOTIDE_AC_PATTERN_2.matcher(string);
        if (matcher.lookingAt()) {
            return matcher.group(1);
        }
        matcher = GENBANK_PROTEIN_AC_PATTERN.matcher(string);
        if (matcher.lookingAt()) {
            return matcher.group(1);
        }
        return null;
    }

    static String extract(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        int n2 = string.indexOf(string3);
        if (n < 0 || n2 < n) {
            throw new IllegalArgumentException("attempt to extract from [" + string + "] between [" + string2 + "] and [" + string3 + "]");
        }
        return string.substring(n + string2.length(), n2).trim();
    }

    static String extract(String string, String string2) {
        int n = string.indexOf(string2);
        return string.substring(n + string2.length()).trim();
    }
}

