/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.forester.util.ThreadedStreamHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemCommandExecutor {
    private final List<String> commandInformation;
    private final String adminPassword;
    private ThreadedStreamHandler inputStreamHandler;
    private ThreadedStreamHandler errorStreamHandler;

    public SystemCommandExecutor(List<String> list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("The commandInformation is required.");
        }
        this.checkCmdFile(new File(list.get(0)));
        this.commandInformation = list;
        this.adminPassword = null;
    }

    public static boolean isExecuteableFile(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        return file.canExecute();
    }

    private void checkCmdFile(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("[" + file.getAbsolutePath() + "] does not exist");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("[" + file.getAbsolutePath() + "] is a directory");
        }
        if (!file.canExecute()) {
            throw new IllegalArgumentException("[" + file.getAbsolutePath() + "] is not executeable");
        }
    }

    public int executeCommand() throws IOException, InterruptedException {
        int n = -99;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(this.commandInformation);
            Process process = processBuilder.start();
            OutputStream outputStream = process.getOutputStream();
            InputStream inputStream = process.getInputStream();
            InputStream inputStream2 = process.getErrorStream();
            this.inputStreamHandler = new ThreadedStreamHandler(inputStream, outputStream, this.adminPassword);
            this.errorStreamHandler = new ThreadedStreamHandler(inputStream2);
            this.inputStreamHandler.start();
            this.errorStreamHandler.start();
            n = process.waitFor();
            this.inputStreamHandler.interrupt();
            this.errorStreamHandler.interrupt();
            this.inputStreamHandler.join();
            this.errorStreamHandler.join();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        finally {
            return n;
        }
    }

    public StringBuilder getStandardErrorFromCommand() {
        return this.errorStreamHandler.getOutputBuffer();
    }

    public StringBuilder getStandardOutputFromCommand() {
        return this.inputStreamHandler.getOutputBuffer();
    }
}

