/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sequence;

import org.forester.sequence.Sequence;

public class BasicSequence
implements Sequence {
    private final char[] _mol_sequence;
    private final Object _identifier;
    private final Sequence.TYPE _type;

    private BasicSequence(Object object, String string, Sequence.TYPE tYPE) {
        this._mol_sequence = string.toCharArray();
        this._identifier = object;
        this._type = tYPE;
    }

    public BasicSequence(Object object, char[] cArray, Sequence.TYPE tYPE) {
        this._mol_sequence = cArray;
        this._identifier = object;
        this._type = tYPE;
    }

    public Object getIdentifier() {
        return this._identifier;
    }

    public int getLength() {
        return this._mol_sequence.length;
    }

    public char[] getMolecularSequence() {
        return this._mol_sequence;
    }

    public char getResidueAt(int n) {
        return this._mol_sequence[n];
    }

    public Sequence.TYPE getType() {
        return this._type;
    }

    public int getNumberOfGapResidues() {
        int n = 0;
        for (int i = 0; i < this._mol_sequence.length; ++i) {
            if (this._mol_sequence[i] != '-') continue;
            ++n;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._identifier.toString());
        stringBuffer.append(" ");
        stringBuffer.append(new String(this._mol_sequence));
        return stringBuffer.toString();
    }

    public static Sequence createAaSequence(Object object, String string) {
        return new BasicSequence(object, string.toUpperCase().replaceAll("\\.", GAP_STR).replaceAll("[^ARNDBCQEZGHILKMFPSTWYVXU\\-\\*]", Character.toString('X')), Sequence.TYPE.AA);
    }

    public static Sequence createDnaSequence(Object object, String string) {
        return new BasicSequence(object, string.toUpperCase().replaceAll("\\.", GAP_STR).replaceAll("[^ACGTRYMKWSN\\-\\*]", Character.toString('N')), Sequence.TYPE.DNA);
    }

    public static Sequence createRnaSequence(Object object, String string) {
        return new BasicSequence(object, string.toUpperCase().replaceAll("\\.", GAP_STR).replaceAll("[^ACGURYMKWSN\\-\\*]", Character.toString('N')), Sequence.TYPE.RNA);
    }
}

