/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.SDIR;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDIx {
    private void analyze(Phylogeny phylogeny, String string, Phylogeny[] phylogenyArray, File file) throws IOException {
        System.out.println(string + ": " + phylogeny.getName());
        Set<Taxonomy> set = SDIx.getAllExternalSpecies(phylogenyArray[0]);
        PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
        for (Phylogeny phylogeny2 : phylogenyArray) {
            PhylogenyMethods.deleteExternalNodesPositiveSelection(set, phylogeny);
            if (phylogeny.isEmpty()) {
                System.out.println(" >> empty: " + string + ": " + phylogeny.getName());
                continue;
            }
            File file2 = new File(file + ForesterUtil.FILE_SEPARATOR + string);
            if (file2.exists()) {
                System.out.println(" >> already exists, skipping: " + string + ": " + phylogeny.getName());
            }
            SDIR sDIR = new SDIR();
            Phylogeny[] phylogenyArray2 = sDIR.infer(phylogeny, phylogeny2, true, true, true, true, 1);
            int n = sDIR.getMinimalDuplications();
            int n2 = sDIR.getMinimalMappingCost();
            ArrayList<Phylogeny> arrayList = new ArrayList<Phylogeny>();
            for (Phylogeny phylogeny3 : phylogenyArray2) {
                arrayList.add(phylogeny3);
            }
            phylogenyWriter.toPhyloXML(file2, arrayList, 0, ForesterUtil.LINE_SEPARATOR);
        }
    }

    private void checkSpeciesTreesForEqualNumberOfExtNodes(Phylogeny[] phylogenyArray) {
        int n = -1;
        for (Phylogeny phylogeny : phylogenyArray) {
            if (n < 0) {
                n = phylogeny.getNumberOfExternalNodes();
                continue;
            }
            if (n == phylogeny.getNumberOfExternalNodes()) continue;
            throw new IllegalArgumentException("species trees must have all the same number of external nodes");
        }
    }

    public void method1(List<File> list, Phylogeny[] phylogenyArray, File file) throws IOException {
        this.checkSpeciesTreesForEqualNumberOfExtNodes(phylogenyArray);
        PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
        for (File file2 : list) {
            if (ForesterUtil.isReadableFile(file2) != null) {
                throw new IOException("[" + file2 + "] is not readable");
            }
            Phylogeny[] phylogenyArray2 = null;
            phylogenyArray2 = phylogenyFactory.create(file2, new PhyloXmlParser());
            if (phylogenyArray2.length != 1) {
                throw new IOException("[" + file2 + "] contains " + phylogenyArray2.length + " gene trees, expecting precisely one");
            }
            this.analyze(phylogenyArray2[0], file2.getName(), phylogenyArray, file);
        }
    }

    private static Set<Taxonomy> getAllExternalSpecies(Phylogeny phylogeny) {
        HashSet<Taxonomy> hashSet = new HashSet<Taxonomy>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.getNodeData().isHasTaxonomy()) {
                hashSet.add(phylogenyNode.getNodeData().getTaxonomy());
                continue;
            }
            throw new IllegalArgumentException("node " + phylogenyNode.getId() + " has no taxonomic data");
        }
        return hashSet;
    }
}

