/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.forester.evoinference.matrix.distance.DistanceMatrix;
import org.forester.io.parsers.SymmetricalDistanceMatrixParser;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.SDIR;
import org.forester.sdi.Tuplet;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RIO {
    private static final boolean ROOT_BY_MINIMIZING_MAPPING_COST = false;
    private static final boolean ROOT_BY_MINIMIZING_SUM_OF_DUPS = true;
    private static final boolean ROOT_BY_MINIMIZING_TREE_HEIGHT = true;
    private static final boolean TIME = false;
    private HashMap<String, HashMap<String, Integer>> _o_hash_maps;
    private HashMap<String, HashMap<String, Integer>> _so_hash_maps;
    private HashMap<String, HashMap<String, Integer>> _up_hash_maps;
    private HashMap<String, HashMap<String, Integer>> _sn_hash_maps;
    private DistanceMatrix _m;
    private HashMap<String, Double> _l;
    private String[] _seq_names;
    private int _bootstraps;
    private int _ext_nodes_;
    private long _time;

    public RIO() {
        this.reset();
    }

    public final int getBootstraps() {
        return this._bootstraps;
    }

    private final double getBootstrapValueFromHash(HashMap<String, Integer> hashMap, String string) {
        if (!hashMap.containsKey(string)) {
            return 0.0;
        }
        int n = hashMap.get(string);
        return (double)n * 100.0 / (double)this.getBootstraps();
    }

    public final double getDistance(String string) {
        double d = 0.0;
        string = string.trim();
        if (this._l == null) {
            throw new RuntimeException("Distance list has probably not been read in (successfully).");
        }
        if (this._l.get(string) == null) {
            throw new IllegalArgumentException(string + " not found.");
        }
        d = this._l.get(string);
        return d;
    }

    public final double getDistance(String string, String string2) {
        try {
            return this._m.getValue(this._m.getIndex(string), this._m.getIndex(string2));
        }
        catch (Exception exception) {
            return 1.0;
        }
    }

    public final int getExtNodesOfAnalyzedGeneTrees() {
        return this._ext_nodes_;
    }

    public final HashMap<String, Integer> getInferredOrthologs(String string) {
        if (this._o_hash_maps == null) {
            return null;
        }
        return this._o_hash_maps.get(string);
    }

    private final HashMap<String, Integer> getInferredSubtreeNeighbors(String string) {
        if (this._sn_hash_maps == null) {
            return null;
        }
        return this._sn_hash_maps.get(string);
    }

    public final HashMap<String, Integer> getInferredSuperOrthologs(String string) {
        if (this._so_hash_maps == null) {
            return null;
        }
        return this._so_hash_maps.get(string);
    }

    public final HashMap<String, Integer> getInferredUltraParalogs(String string) {
        if (this._up_hash_maps == null) {
            return null;
        }
        return this._up_hash_maps.get(string);
    }

    public long getTime() {
        return this._time;
    }

    public void inferOrthologs(File file, Phylogeny phylogeny, String string) throws IOException {
        Phylogeny[] phylogenyArray;
        int n = 0;
        if (!file.exists()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " does not exist.");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is not a file.");
        }
        PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
        Phylogeny phylogeny2 = phylogenyFactory.create(file, new PhyloXmlParser())[0];
        PhylogenyMethods.taxonomyBasedDeletionOfExternalNodes(phylogeny2, phylogeny);
        PhylogenyMethods.taxonomyBasedDeletionOfExternalNodes(phylogeny, phylogeny2);
        this._seq_names = RIO.getAllExternalSequenceNames(phylogeny2);
        if (this._seq_names == null || this._seq_names.length < 1) {
            return;
        }
        this._o_hash_maps = new HashMap();
        this._so_hash_maps = new HashMap();
        this._up_hash_maps = new HashMap();
        this._sn_hash_maps = new HashMap();
        this._o_hash_maps.put(string, new HashMap(this._seq_names.length));
        this._so_hash_maps.put(string, new HashMap(this._seq_names.length));
        this._up_hash_maps.put(string, new HashMap(this._seq_names.length));
        this._sn_hash_maps.put(string, new HashMap(this._seq_names.length));
        for (Phylogeny phylogeny3 : phylogenyArray = phylogenyFactory.create(file, new PhyloXmlParser())) {
            ++n;
            PhylogenyMethods.taxonomyBasedDeletionOfExternalNodes(phylogeny, phylogeny3);
            this.inferOrthologsHelper(phylogeny3, phylogeny, string);
        }
        this.setBootstraps(n);
    }

    private void inferOrthologsHelper(Phylogeny phylogeny, Phylogeny phylogeny2, String string) {
        Phylogeny phylogeny3 = null;
        List<PhylogenyNode> list = null;
        SDIR sDIR = new SDIR();
        List<PhylogenyNode> list2 = null;
        List<PhylogenyNode> list3 = null;
        List<PhylogenyNode> list4 = null;
        List<PhylogenyNode> list5 = null;
        phylogeny3 = sDIR.infer(phylogeny, phylogeny2, false, true, true, true, 1)[0];
        this.setExtNodesOfAnalyzedGeneTrees(phylogeny3.getNumberOfExternalNodes());
        list = phylogeny3.getNodesViaSequenceName(string);
        if (list.size() > 1) {
            throw new IllegalArgumentException("node named [" + string + "] not unique");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("no node containing a sequence named [" + string + "] found");
        }
        PhylogenyNode phylogenyNode = list.get(0);
        PhylogenyMethods phylogenyMethods = PhylogenyMethods.getInstance();
        list2 = phylogenyMethods.getOrthologousNodes(phylogeny3, phylogenyNode);
        this.updateHash(this._o_hash_maps, string, list2);
        list3 = PhylogenyMethods.getSuperOrthologousNodes(phylogenyNode);
        this.updateHash(this._so_hash_maps, string, list3);
        list5 = RIO.getSubtreeNeighbors(phylogenyNode, 2);
        this.updateHash(this._sn_hash_maps, string, list5);
        list4 = PhylogenyMethods.getUltraParalogousNodes(phylogenyNode);
        this.updateHash(this._up_hash_maps, string, list4);
    }

    public ArrayList<String> inferredOrthologsToArrayList(String string, double d) {
        HashMap<String, Integer> hashMap = null;
        String string2 = null;
        double d2 = 0.0;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this._o_hash_maps == null) {
            throw new RuntimeException("Orthologs have not been calculated (successfully).");
        }
        if (d < 0.0) {
            d = 0.0;
        } else if (d > 100.0) {
            d = 100.0;
        }
        hashMap = this.getInferredOrthologs(string);
        if (hashMap == null) {
            throw new RuntimeException("Orthologs for " + string + " were not established.");
        }
        if (this._seq_names.length > 0) {
            for (int i = 0; i < this._seq_names.length; ++i) {
                string2 = this._seq_names[i];
                if (string2.equals(string) || (d2 = this.getBootstrapValueFromHash(hashMap, string2)) < d) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public StringBuffer inferredOrthologsToString(String string, int n, double d, double d2) {
        HashMap<String, Integer> hashMap = null;
        HashMap<String, Integer> hashMap2 = null;
        HashMap<String, Integer> hashMap3 = null;
        String string2 = "";
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        ArrayList<Tuplet> arrayList = new ArrayList<Tuplet>();
        if (this._o_hash_maps == null || this._so_hash_maps == null || this._sn_hash_maps == null) {
            throw new RuntimeException("Orthologs have not been calculated (successfully)");
        }
        if (n < 0 || n > 17) {
            n = 12;
        }
        if (n > 2 && this._m == null && this._l == null) {
            throw new RuntimeException("Distance list or matrix have not been read in (successfully)");
        }
        if (d < 0.0) {
            d = 0.0;
        } else if (d > 100.0) {
            d = 100.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > 100.0) {
            d2 = 100.0;
        }
        hashMap = this.getInferredOrthologs(string);
        hashMap2 = this.getInferredSuperOrthologs(string);
        hashMap3 = this.getInferredSubtreeNeighbors(string);
        if (hashMap == null || hashMap2 == null || hashMap3 == null) {
            throw new RuntimeException("Orthologs for " + string + " were not established");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this._seq_names.length > 0) {
            block20: for (int i = 0; i < this._seq_names.length; ++i) {
                string2 = this._seq_names[i];
                if (string2.equals(string) || (d3 = this.getBootstrapValueFromHash(hashMap, string2)) < d || (d5 = this.getBootstrapValueFromHash(hashMap3, string2)) < d2) continue;
                d4 = this.getBootstrapValueFromHash(hashMap2, string2);
                if (n >= 3) {
                    d10 = this._m != null ? this.getDistance(string, string2) : this.getDistance(string2);
                }
                switch (n) {
                    case 0: {
                        arrayList.add(new Tuplet(string2, d3, 5));
                        continue block20;
                    }
                    case 1: {
                        arrayList.add(new Tuplet(string2, d3, d4, 5));
                        continue block20;
                    }
                    case 2: {
                        arrayList.add(new Tuplet(string2, d4, d3, 5));
                        continue block20;
                    }
                    case 3: {
                        arrayList.add(new Tuplet(string2, d3, d10, 1));
                        continue block20;
                    }
                    case 4: {
                        arrayList.add(new Tuplet(string2, d10, d3, 0));
                        continue block20;
                    }
                    case 5: {
                        arrayList.add(new Tuplet(string2, d3, d4, d10, 2));
                        continue block20;
                    }
                    case 6: {
                        arrayList.add(new Tuplet(string2, d3, d10, d4, 1));
                        continue block20;
                    }
                    case 7: {
                        arrayList.add(new Tuplet(string2, d4, d3, d10, 2));
                        continue block20;
                    }
                    case 8: {
                        arrayList.add(new Tuplet(string2, d4, d10, d3, 1));
                        continue block20;
                    }
                    case 9: {
                        arrayList.add(new Tuplet(string2, d10, d3, d4, 0));
                        continue block20;
                    }
                    case 10: {
                        arrayList.add(new Tuplet(string2, d10, d4, d3, 0));
                        continue block20;
                    }
                    case 11: {
                        arrayList.add(new Tuplet(string2, d3, d5, d10, 2));
                        continue block20;
                    }
                    case 12: {
                        arrayList.add(new Tuplet(string2, d3, d5, d4, d10, 3));
                        continue block20;
                    }
                    case 13: {
                        arrayList.add(new Tuplet(string2, d3, d4, d5, d10, 3));
                        continue block20;
                    }
                    case 14: {
                        arrayList.add(new Tuplet(string2, d5, d3, d4, d10, 3));
                        continue block20;
                    }
                    case 15: {
                        arrayList.add(new Tuplet(string2, d5, d10, d3, d4, 1));
                        continue block20;
                    }
                    case 16: {
                        arrayList.add(new Tuplet(string2, d3, d10, d5, d4, 1));
                        continue block20;
                    }
                    case 17: {
                        arrayList.add(new Tuplet(string2, d3, d5, d10, d4, 2));
                        continue block20;
                    }
                    default: {
                        arrayList.add(new Tuplet(string2, d3, 5));
                    }
                }
            }
            if (arrayList != null && arrayList.size() > 0) {
                int n2;
                stringBuffer.append("[seq name]\t\t[ortho]\t[st-n]\t[sup-o]\t[dist]" + ForesterUtil.LINE_SEPARATOR);
                Object[] objectArray = new Tuplet[arrayList.size()];
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    objectArray[n2] = (Tuplet)arrayList.get(n2);
                }
                Arrays.sort(objectArray);
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    string2 = ((Tuplet)objectArray[n2]).getKey();
                    d6 = ((Tuplet)objectArray[n2]).getValue1();
                    d7 = ((Tuplet)objectArray[n2]).getValue2();
                    d8 = ((Tuplet)objectArray[n2]).getValue3();
                    d9 = ((Tuplet)objectArray[n2]).getValue4();
                    stringBuffer.append(RIO.addNameAndValues(string2, d6, d7, d8, d9, n));
                }
            }
        }
        if (stringBuffer == null || stringBuffer.length() < 1) {
            stringBuffer.append("-");
        }
        return stringBuffer;
    }

    private String inferredOrthologsToTableHelper(String string, String[] stringArray, int n, boolean bl) {
        HashMap<String, Integer> hashMap = null;
        String string2 = null;
        String string3 = new String("");
        int n2 = 0;
        hashMap = !bl ? this.getInferredOrthologs(string) : this.getInferredSuperOrthologs(string);
        if (hashMap == null) {
            throw new RuntimeException("Unexpected failure in method inferredOrthologsToTableHelper");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = stringArray[i];
            n2 = !hashMap.containsKey(string2) ? 0 : hashMap.get(string2);
            if (i == n) {
                if (n2 != 0) {
                    throw new RuntimeException("Failed sanity check in method inferredOrthologsToTableHelper: value not 0.");
                }
                string3 = string3 + " \t";
                continue;
            }
            string3 = string3 + n2 + "\t";
        }
        return string3;
    }

    public void inferredOrthologTableToFile(File file) throws IOException {
        if (this._o_hash_maps == null) {
            return;
        }
        this.inferredOrthologTableToFile(file, false);
    }

    private void inferredOrthologTableToFile(File file, boolean bl) throws IOException {
        int n;
        String string = "";
        String string2 = "";
        PrintWriter printWriter = null;
        if (this._seq_names == null) {
            throw new RuntimeException("inferredOrthologTableToFile: seq_names_ is null.");
        }
        Arrays.sort(this._seq_names);
        printWriter = new PrintWriter((Writer)new FileWriter(file), true);
        if (printWriter == null) {
            throw new RuntimeException("inferredOrthologTableToFile: failure to create PrintWriter.");
        }
        string2 = "\t\t\t\t";
        for (n = 0; n < this._seq_names.length; ++n) {
            string2 = string2 + n + ")\t";
        }
        string2 = string2 + "\n";
        printWriter.println(string2);
        for (n = 0; n < this._seq_names.length; ++n) {
            string = this._seq_names[n];
            string2 = string.length() < 8 ? n + ")\t" + string + "\t\t\t" : (string.length() < 16 ? n + ")\t" + string + "\t\t" : n + ")\t" + string + "\t");
            string2 = string2 + this.inferredOrthologsToTableHelper(string, this._seq_names, n, bl);
            printWriter.println(string2);
        }
        printWriter.close();
    }

    public void inferredSuperOrthologTableToFile(File file) throws IOException {
        if (this._so_hash_maps == null) {
            return;
        }
        this.inferredOrthologTableToFile(file, true);
    }

    public String inferredUltraParalogsToString(String string, boolean bl, double d) {
        HashMap<String, Integer> hashMap = null;
        String string2 = "";
        String string3 = "";
        int n = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        ArrayList<Tuplet> arrayList = new ArrayList<Tuplet>();
        if (d < 1.0) {
            d = 1.0;
        } else if (d > 100.0) {
            d = 100.0;
        }
        if (this._up_hash_maps == null) {
            throw new RuntimeException("Ultra paralogs have not been calculated (successfully).");
        }
        if (bl && this._m == null && this._l == null) {
            throw new RuntimeException("Distance list or matrix have not been read in (successfully).");
        }
        hashMap = this.getInferredUltraParalogs(string);
        if (hashMap == null) {
            throw new RuntimeException("Ultra paralogs for " + string + " were not established");
        }
        if (this._seq_names.length > 0) {
            for (int i = 0; i < this._seq_names.length; ++i) {
                string2 = this._seq_names[i];
                if (string2.equals(string) || (d2 = this.getBootstrapValueFromHash(hashMap, string2)) < d) continue;
                if (bl) {
                    d5 = this._m != null ? this.getDistance(string, string2) : this.getDistance(string2);
                    arrayList.add(new Tuplet(string2, d2, d5, 1));
                    continue;
                }
                arrayList.add(new Tuplet(string2, d2, 5));
            }
            if (arrayList != null && arrayList.size() > 0) {
                int n2;
                Object[] objectArray = new Tuplet[arrayList.size()];
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    objectArray[n2] = (Tuplet)arrayList.get(n2);
                }
                Arrays.sort(objectArray);
                n = bl ? 91 : 90;
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    string2 = ((Tuplet)objectArray[n2]).getKey();
                    d3 = ((Tuplet)objectArray[n2]).getValue1();
                    d4 = ((Tuplet)objectArray[n2]).getValue2();
                    string3 = string3 + RIO.addNameAndValues(string2, d3, d4, 0.0, 0.0, n);
                }
            }
        }
        if (string3 == null || string3.length() < 1) {
            string3 = "-";
        }
        return string3;
    }

    public final void readDistanceMatrix(File file) throws IOException {
        DistanceMatrix[] distanceMatrixArray = null;
        SymmetricalDistanceMatrixParser symmetricalDistanceMatrixParser = SymmetricalDistanceMatrixParser.createInstance();
        distanceMatrixArray = symmetricalDistanceMatrixParser.parse(file);
        if (distanceMatrixArray == null || distanceMatrixArray.length == 0) {
            throw new IOException("failed to parse distance matrix from [" + file + "]");
        }
        if (distanceMatrixArray.length > 1) {
            throw new IOException("[" + file + "] contains more than once distance matrix");
        }
        this._m = distanceMatrixArray[0];
    }

    private final void reset() {
        this._o_hash_maps = null;
        this._so_hash_maps = null;
        this._up_hash_maps = null;
        this._seq_names = null;
        this._m = null;
        this._l = null;
        this._bootstraps = 1;
        this._ext_nodes_ = 0;
        this._time = 0L;
    }

    private void setBootstraps(int n) {
        if (n < 1) {
            n = 1;
        }
        this._bootstraps = n;
    }

    private void setExtNodesOfAnalyzedGeneTrees(int n) {
        if (n < 1) {
            n = 0;
        }
        this._ext_nodes_ = n;
    }

    private void updateHash(HashMap<String, HashMap<String, Integer>> hashMap, String string, List<PhylogenyNode> list) {
        HashMap<String, Integer> hashMap2 = hashMap.get(string);
        if (hashMap2 == null) {
            throw new RuntimeException("Unexpected failure in method updateHash.");
        }
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i).getNodeData().getSequence().getName();
            if (hashMap2.containsKey(string2)) {
                hashMap2.put(string2, hashMap2.get(string2) + 1);
                continue;
            }
            hashMap2.put(string2, 1);
        }
    }

    private static final String addNameAndValues(String string, double d, double d2, double d3, double d4, int n) {
        DecimalFormat decimalFormat = new DecimalFormat("0.#####");
        decimalFormat.setDecimalSeparatorAlwaysShown(false);
        String string2 = "";
        string2 = string.length() < 8 ? string2 + string + "\t\t\t" : (string.length() < 16 ? string2 + string + "\t\t" : string2 + string + "\t");
        switch (n) {
            case 0: {
                string2 = string2 + RIO.addToLine(d, decimalFormat);
                string2 = string2 + "-\t";
                string2 = string2 + "-\t";
                string2 = string2 + "-\t";
                break;
            }
            case 1: {
                string2 = string2 + RIO.addToLine(d, decimalFormat);
                string2 = string2 + "-\t";
                string2 = string2 + RIO.addToLine(d2, decimalFormat);
                string2 = string2 + "-\t";
                break;
            }
            case 2: {
                string2 = string2 + RIO.addToLine(d2, decimalFormat);
                string2 = string2 + "-\t";
                string2 = string2 + RIO.addToLine(d, decimalFormat);
                string2 = string2 + "-\t";
                break;
            }
            case 3: {
                string2 = string2 + RIO.addToLine(d, decimalFormat);
                string2 = string2 + "-\t";
                string2 = string2 + "-\t";
                string2 = string2 + RIO.addToLine(d2, decimalFormat);
                break;
            }
            case 4: {
                string2 = string2 + RIO.addToLine(d2, decimalFormat);
                string2 = string2 + "-\t";
                string2 = string2 + "-\t";
                string2 = string2 + RIO.addToLine(d, decimalFormat);
                break;
            }
            case 5: {
                string2 = string2 + RIO.addToLine(d, decimalFormat);
                string2 = string2 + "-\t";
                string2 = string2 + RIO.addToLine(d2, decimalFormat);
                string2 = string2 + RIO.addToLine(d3, decimalFormat);
                break;
            }
            case 6: {
                string2 = string2 + RIO.addToLine(d, decimalFormat);
                string2 = string2 + "-\t";
                string2 = string2 + RIO.addToLine(d3, decimalFormat);
                string2 = string2 + RIO.addToLine(d2, decimalFormat);
                break;
            }
            case 7: {
                string2 = string2 + RIO.addToLine(d2, decimalFormat);
                string2 = string2 + "-\t";
                string2 = string2 + RIO.addToLine(d, decimalFormat);
                string2 = string2 + RIO.addToLine(d3, decimalFormat);
                break;
            }
            case 8: {
                string2 = string2 + RIO.addToLine(d3, decimalFormat);
                string2 = string2 + "-\t";
                string2 = string2 + RIO.addToLine(d, decimalFormat);
                string2 = string2 + RIO.addToLine(d2, decimalFormat);
                break;
            }
            case 9: {
                string2 = string2 + RIO.addToLine(d2, decimalFormat);
                string2 = string2 + "-\t";
                string2 = string2 + RIO.addToLine(d3, decimalFormat);
                string2 = string2 + RIO.addToLine(d, decimalFormat);
                break;
            }
            case 10: {
                string2 = string2 + RIO.addToLine(d3, decimalFormat);
                string2 = string2 + "-\t";
                string2 = string2 + RIO.addToLine(d2, decimalFormat);
                string2 = string2 + RIO.addToLine(d, decimalFormat);
                break;
            }
            case 11: {
                string2 = string2 + RIO.addToLine(d, decimalFormat);
                string2 = string2 + RIO.addToLine(d2, decimalFormat);
                string2 = string2 + "-\t";
                string2 = string2 + RIO.addToLine(d3, decimalFormat);
                break;
            }
            case 12: {
                string2 = string2 + RIO.addToLine(d, decimalFormat);
                string2 = string2 + RIO.addToLine(d2, decimalFormat);
                string2 = string2 + RIO.addToLine(d3, decimalFormat);
                string2 = string2 + RIO.addToLine(d4, decimalFormat);
                break;
            }
            case 13: {
                string2 = string2 + RIO.addToLine(d, decimalFormat);
                string2 = string2 + RIO.addToLine(d3, decimalFormat);
                string2 = string2 + RIO.addToLine(d2, decimalFormat);
                string2 = string2 + RIO.addToLine(d4, decimalFormat);
                break;
            }
            case 14: {
                string2 = string2 + RIO.addToLine(d2, decimalFormat);
                string2 = string2 + RIO.addToLine(d, decimalFormat);
                string2 = string2 + RIO.addToLine(d3, decimalFormat);
                string2 = string2 + RIO.addToLine(d4, decimalFormat);
                break;
            }
            case 15: {
                string2 = string2 + RIO.addToLine(d3, decimalFormat);
                string2 = string2 + RIO.addToLine(d, decimalFormat);
                string2 = string2 + RIO.addToLine(d4, decimalFormat);
                string2 = string2 + RIO.addToLine(d2, decimalFormat);
                break;
            }
            case 16: {
                string2 = string2 + RIO.addToLine(d, decimalFormat);
                string2 = string2 + RIO.addToLine(d3, decimalFormat);
                string2 = string2 + RIO.addToLine(d4, decimalFormat);
                string2 = string2 + RIO.addToLine(d2, decimalFormat);
                break;
            }
            case 17: {
                string2 = string2 + RIO.addToLine(d, decimalFormat);
                string2 = string2 + RIO.addToLine(d2, decimalFormat);
                string2 = string2 + RIO.addToLine(d4, decimalFormat);
                string2 = string2 + RIO.addToLine(d3, decimalFormat);
                break;
            }
            case 90: {
                string2 = string2 + RIO.addToLine(d, decimalFormat);
                string2 = string2 + "-\t";
                break;
            }
            case 91: {
                string2 = string2 + RIO.addToLine(d, decimalFormat);
                string2 = string2 + RIO.addToLine(d2, decimalFormat);
            }
        }
        string2 = string2 + ForesterUtil.LINE_SEPARATOR;
        return string2;
    }

    private static final String addToLine(double d, DecimalFormat decimalFormat) {
        String string = "";
        string = d != -999.0 ? decimalFormat.format(d) + "\t" : "-\t";
        return string;
    }

    private static String[] getAllExternalSequenceNames(Phylogeny phylogeny) {
        if (phylogeny.isEmpty()) {
            return null;
        }
        int n = 0;
        String[] stringArray = new String[phylogeny.getNumberOfExternalNodes()];
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            stringArray[n++] = phylogenyNodeIterator.next().getNodeData().getSequence().getName();
        }
        return stringArray;
    }

    public static final String getOrder(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "orthologies";
                break;
            }
            case 1: {
                string = "orthologies > super orthologies";
                break;
            }
            case 2: {
                string = "super orthologies > orthologies";
                break;
            }
            case 3: {
                string = "orthologies > distance to query";
                break;
            }
            case 4: {
                string = "distance to query > orthologies";
                break;
            }
            case 5: {
                string = "orthologies > super orthologies > distance to query";
                break;
            }
            case 6: {
                string = "orthologies > distance to query > super orthologies";
                break;
            }
            case 7: {
                string = "super orthologies > orthologies > distance to query";
                break;
            }
            case 8: {
                string = "super orthologies > distance to query > orthologies";
                break;
            }
            case 9: {
                string = "distance to query > orthologies > super orthologies";
                break;
            }
            case 10: {
                string = "distance to query > super orthologies > orthologies";
                break;
            }
            case 11: {
                string = "orthologies > subtree neighbors > distance to query";
                break;
            }
            case 12: {
                string = "orthologies > subtree neighbors > super orthologies > distance to query";
                break;
            }
            case 13: {
                string = "orthologies > super orthologies > subtree neighbors > distance to query";
                break;
            }
            case 14: {
                string = "subtree neighbors > orthologies > super orthologies > distance to query";
                break;
            }
            case 15: {
                string = "subtree neighbors > distance to query > orthologies > super orthologies";
                break;
            }
            case 16: {
                string = "orthologies > distance to query > subtree neighbors > super orthologies";
                break;
            }
            case 17: {
                string = "orthologies > subtree neighbors > distance to query > super orthologies";
                break;
            }
            default: {
                string = "orthologies";
            }
        }
        return string;
    }

    public static final StringBuffer getOrderHelp() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  0: orthologies" + ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append("  1: orthologies > super orthologies" + ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append("  2: super orthologies > orthologies" + ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append("  3: orthologies > distance to query" + ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append("  4: distance to query > orthologies" + ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append("  5: orthologies > super orthologies > distance to query" + ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append("  6: orthologies > distance to query > super orthologies" + ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append("  7: super orthologies > orthologies > distance to query" + ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append("  8: super orthologies > distance to query > orthologies" + ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append("  9: distance to query > orthologies > super orthologies" + ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append(" 10: distance to query > super orthologies > orthologies" + ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append(" 11: orthologies > subtree neighbors > distance to query" + ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append(" 12: orthologies > subtree neighbors > super orthologies > distance to query" + ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append(" 13: orthologies > super orthologies > subtree neighbors > distance to query" + ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append(" 14: subtree neighbors > orthologies > super orthologies > distance to query" + ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append(" 15: subtree neighbors > distance to query > orthologies > super orthologies" + ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append(" 16: orthologies > distance to query > subtree neighbors > super orthologies" + ForesterUtil.LINE_SEPARATOR);
        stringBuffer.append(" 17: orthologies > subtree neighbors > distance to query > super orthologies" + ForesterUtil.LINE_SEPARATOR);
        return stringBuffer;
    }

    private static final List<PhylogenyNode> getSubtreeNeighbors(PhylogenyNode phylogenyNode, int n) {
        PhylogenyNode phylogenyNode2 = phylogenyNode;
        if (!phylogenyNode2.isExternal()) {
            return null;
        }
        if (!phylogenyNode2.isRoot()) {
            phylogenyNode2 = phylogenyNode2.getParent();
        }
        if (n == 2) {
            if (!phylogenyNode2.isRoot()) {
                phylogenyNode2 = phylogenyNode2.getParent();
            }
        } else {
            throw new IllegalArgumentException("currently only supporting level 2 subtree neighbors ");
        }
        List<PhylogenyNode> list = phylogenyNode2.getAllExternalDescendants();
        list.remove(phylogenyNode);
        return list;
    }
}

