/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORcount {
    private static final String[] group_1 = new String[]{"ANOGA", "DROME", "CAEBR", "CAEEL"};
    private static final String[] group_2 = new String[]{"CIOIN", "FUGRU", "MOUSE", "RAT", "HUMAN"};
    private static final String[] all_species = new String[]{"ANOGA", "DROME", "CAEBR", "CAEEL", "CIOIN", "FUGRU", "MOUSE", "RAT", "HUMAN"};
    private final Phylogeny[] _trees;
    private HashMap<String, HashMap<Object, Integer>> _species = null;
    private ArrayList<String> _names = null;
    private int _group1_vs_2_counter = 0;

    public ORcount(Phylogeny[] phylogenyArray) {
        this._trees = phylogenyArray;
    }

    private void count(PhylogenyNode phylogenyNode) {
        List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
        for (int i = 1; i < list.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                PhylogenyNode phylogenyNode2 = list.get(i);
                PhylogenyNode phylogenyNode3 = list.get(j);
                String string = PhylogenyMethods.getSpecies(phylogenyNode2);
                String string2 = PhylogenyMethods.getSpecies(phylogenyNode3);
                this.count(string, string2, phylogenyNode2.getName(), phylogenyNode3.getName());
            }
        }
    }

    private void count(String string, String string2, String string3, String string4) {
        HashMap<Object, Integer> hashMap = this._species.get(string);
        if (hashMap == null) {
            throw new RuntimeException("Unexpected error: Species \"" + string + "\" not present in species matrix.");
        }
        Integer n = hashMap.get(string2);
        String string5 = string2;
        if (n == null) {
            hashMap = this._species.get(string2);
            if (hashMap == null) {
                throw new RuntimeException("Unexpected error: Species \"" + string2 + "\" not present in species matrix.");
            }
            n = hashMap.get(string);
            string5 = string;
        }
        if (n == null) {
            throw new RuntimeException("Unexpected error: Species \"" + string + "\" not present in species matrix.");
        }
        hashMap.put(string5, new Integer(n + 1));
        this._names.add(string + "-" + string3 + " = " + string2 + "-" + string4);
    }

    public void countSharedAncestralClades(Phylogeny phylogeny, int n, String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null) {
            throw new IllegalArgumentException("String[](s) in arguments to method \"ORcount.countSharedAncestralClades\" is (are) null.");
        }
        if (!phylogeny.isRooted()) {
            throw new IllegalArgumentException("Phylogeny must be rooted in order to count shared ancestral clades.");
        }
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        phylogeny.setIndicatorsToZero();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.getNumberOfDescendants() != 2) {
                throw new IllegalArgumentException("Phylogeny can not contain multifurcations in order to count shared ancestral clades.");
            }
            if (phylogenyNode.isExternal()) continue;
            PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode1();
            PhylogenyNode phylogenyNode3 = phylogenyNode.getChildNode2();
            if (phylogenyNode2.getIndicator() == 1 || phylogenyNode3.getIndicator() == 1) {
                phylogenyNode.setIndicator((byte)1);
                continue;
            }
            List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
            String[] stringArray3 = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                PhylogenyNode phylogenyNode4 = list.get(i);
                stringArray3[i] = PhylogenyMethods.getSpecies(phylogenyNode4).trim().toUpperCase();
            }
            if (!ForesterUtil.isIntersecting(stringArray3, stringArray) || !ForesterUtil.isIntersecting(stringArray3, stringArray2)) continue;
            phylogenyNode.setIndicator((byte)1);
            if (stringArray.length == 1 && stringArray2.length == 1) {
                this.count(stringArray[0], stringArray2[0], "name a", "name b");
                continue;
            }
            this.increaseGroup1Vs2Counter();
        }
    }

    public void countSharedAncestralClades(Phylogeny[] phylogenyArray, int n) {
        int n2;
        for (n2 = 1; n2 < all_species.length; ++n2) {
            for (int i = 0; i < n2; ++i) {
                String string = all_species[n2].trim().toUpperCase();
                String string2 = all_species[i].trim().toUpperCase();
                String[] stringArray = new String[]{string};
                String[] stringArray2 = new String[]{string2};
                for (int j = 0; j < phylogenyArray.length; ++j) {
                    this.countSharedAncestralClades(phylogenyArray[j], n, stringArray, stringArray2);
                }
            }
        }
        if (group_1 != null && group_2 != null && group_1.length > 0 && group_2.length > 0) {
            this.setGroup1Vs2Counter(0);
            for (n2 = 0; n2 < phylogenyArray.length; ++n2) {
                this.countSharedAncestralClades(phylogenyArray[n2], n, group_1, group_2);
            }
            System.out.println("\nCount [(" + ForesterUtil.stringArrayToString(group_1) + ") vs (" + ForesterUtil.stringArrayToString(group_2) + ")] = " + this.getGroup1Vs2Counter());
        }
    }

    public void countSuperOrthologousRelations(int n) {
        this.reset();
        for (int i = 0; i < this._trees.length; ++i) {
            this.countSuperOrthologousRelations(this._trees[i], n);
        }
    }

    private void countSuperOrthologousRelations(Phylogeny phylogeny, int n) {
        PhylogenyNode phylogenyNode;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        if (!phylogeny.isRooted()) {
            throw new IllegalArgumentException("Phylogeny must be rooted in order to count 1:1 orthologous relationships.");
        }
        phylogeny.setIndicatorsToZero();
        phylogenyNodeIterator.reset();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.getNumberOfDescendants() != 2) {
                throw new IllegalArgumentException("Phylogeny can not contain multifurcations in order to count 1:1 orthologous relationships.");
            }
            if (!phylogenyNode.isExternal() && !phylogenyNode.isHasAssignedEvent()) {
                throw new IllegalArgumentException("All nodes must have duplication or speciation assigned in order to count 1:1 orthologous relationships.");
            }
            if (phylogenyNode.isExternal() || !phylogenyNode.isDuplication() && phylogenyNode.getChildNode1().getIndicator() != 1 && phylogenyNode.getChildNode2().getIndicator() != 1) continue;
            phylogenyNode.setIndicator((byte)1);
        }
        phylogenyNodeIterator.reset();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || phylogenyNode.getIndicator() != 0 || !phylogenyNode.isRoot() && phylogenyNode.getParent().getIndicator() != 1 || n >= 1 && (!(PhylogenyMethods.getConfidenceValue(phylogenyNode) >= (double)n) || !(PhylogenyMethods.getConfidenceValue(phylogenyNode.getChildNode1()) >= (double)n) || !(PhylogenyMethods.getConfidenceValue(phylogenyNode.getChildNode2()) >= (double)n))) continue;
            this.count(phylogenyNode);
        }
    }

    private void getAllSpecies() {
        if (this.getTrees() == null || this.getTrees().length < 1) {
            throw new RuntimeException("Phylogeny array in method \"getAllSpecies( HashMap hash )\" is null or empty.");
        }
        this.setSpecies(new HashMap<String, HashMap<Object, Integer>>());
        for (int i = 0; i < this.getTrees().length; ++i) {
            for (PhylogenyNode phylogenyNode = this.getTrees()[i].getFirstExternalNode(); phylogenyNode != null; phylogenyNode = phylogenyNode.getNextExternalNode()) {
                this.getSpecies().put(PhylogenyMethods.getSpecies(phylogenyNode), null);
            }
        }
    }

    private int getGroup1Vs2Counter() {
        return this._group1_vs_2_counter;
    }

    private HashMap<String, HashMap<Object, Integer>> getSpecies() {
        return this._species;
    }

    private Phylogeny[] getTrees() {
        return this._trees;
    }

    private void increaseGroup1Vs2Counter() {
        ++this._group1_vs_2_counter;
    }

    private void printCount() {
        if (this._species == null || this._species.size() < 2) {
            throw new RuntimeException("Species HashMap in method \"setUpCountingMatrix()\" is null or contains less than two species.");
        }
        Object[] objectArray = this._species.keySet().toArray();
        int n = objectArray.length;
        for (int i = 0; i < n - 1; ++i) {
            String string = (String)objectArray[i];
            System.out.println();
            System.out.println(string + ":");
            HashMap<Object, Integer> hashMap = this._species.get(string);
            for (int j = 1 + i; j < n; ++j) {
                String string2 = (String)objectArray[j];
                int n2 = hashMap.get(string2);
                System.out.println(string + "-" + string2 + ": " + n2);
            }
        }
    }

    private void printNames() {
        for (int i = 0; i < this._names.size(); ++i) {
            System.out.println(i + ": " + this._names.get(i));
        }
    }

    public void reset() {
        this.getAllSpecies();
        this.setUpCountingMatrix();
        this.setGroup1Vs2Counter(0);
        this._names = new ArrayList();
    }

    private void setGroup1Vs2Counter(int n) {
        this._group1_vs_2_counter = n;
    }

    private void setSpecies(HashMap<String, HashMap<Object, Integer>> hashMap) {
        this._species = hashMap;
    }

    private void setUpCountingMatrix() {
        if (this.getSpecies() == null || this.getSpecies().size() < 2) {
            throw new RuntimeException("Species HashMap in method \"setUpCountingMatrix()\" is null or contains less than two species.");
        }
        Object[] objectArray = this.getSpecies().keySet().toArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            String string = (String)objectArray[i];
            HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
            for (int j = 1 + i; j < n; ++j) {
                hashMap.put(objectArray[j], new Integer(0));
            }
            this.getSpecies().put(string, hashMap);
        }
    }

    private static void errorInCommandLine() {
        System.out.println("\nORcount: Error in command line.\n");
        System.out.println("Usage: \"\"");
        System.out.println("\nOptions:");
        System.out.println(" -");
        System.out.println("");
        System.exit(-1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            ORcount.errorInCommandLine();
        }
        Phylogeny[] phylogenyArray = new Phylogeny[stringArray.length];
        PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
        for (int i = 0; i < phylogenyArray.length; ++i) {
            try {
                System.out.println("Reading tree #" + i + "  [" + stringArray[i] + "]");
                PhylogenyParser phylogenyParser = ForesterUtil.createParserDependingOnFileType(new File(stringArray[i]), true);
                phylogenyArray[i] = phylogenyFactory.create(new File(stringArray[i]), phylogenyParser)[0];
                continue;
            }
            catch (Exception exception) {
                System.out.println("\nFailed to read \"" + stringArray[i] + "\". Terminating.\n");
                System.exit(-1);
            }
        }
        System.out.println("Finished reading in trees.\n\n");
        ORcount oRcount = new ORcount(phylogenyArray);
        try {
            System.out.println("\n\n\n\"1:1 ORTHOLOGOUS GENE PAIRS\":\n");
            System.out.println("\n\n\n\"SUPER ORTHOLOGOUS GENE PAIRS\":\n");
            oRcount.countSuperOrthologousRelations(0);
            oRcount.printNames();
            oRcount.printCount();
        }
        catch (Exception exception) {
            System.out.println("\nException. Terminating.\n");
            System.out.println("\nException is: " + exception + "\n");
            exception.printStackTrace();
            System.exit(-1);
        }
        System.out.println("\nDone.");
        System.exit(0);
    }
}

