/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.io.File;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Vector;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistanceCalculator {
    public static final double DEFAULT = -1.0;
    private Phylogeny tree_;
    private ArrayList<PhylogenyNode> nodes_;
    private int n_;
    private double mean_;
    private double variance_;
    private double stand_dev_;
    private PhylogenyNode lca_;

    public DistanceCalculator() {
        this.tree_ = null;
        this.nodes_ = null;
        this.n_ = 0;
        this.mean_ = -1.0;
        this.variance_ = -1.0;
        this.stand_dev_ = -1.0;
        this.lca_ = null;
    }

    public DistanceCalculator(Phylogeny phylogeny) {
        this.setTree(phylogeny);
    }

    public DistanceCalculator(Phylogeny phylogeny, Vector<PhylogenyNode> vector) {
        this.setTreeAndExtNodes(phylogeny, vector);
    }

    private PhylogenyNode calculateLCA(ArrayList<PhylogenyNode> arrayList) {
        if (arrayList == null || arrayList.isEmpty()) {
            return null;
        }
        PhylogenyNode phylogenyNode = arrayList.get(0);
        int n = phylogenyNode.getNumberOfExternalNodes();
        int n2 = arrayList.size();
        while (!phylogenyNode.isRoot() && n < n2) {
            phylogenyNode = phylogenyNode.getParent();
            n = phylogenyNode.getNumberOfExternalNodes();
        }
        ArrayList<PhylogenyNode> arrayList2 = new ArrayList<PhylogenyNode>(phylogenyNode.getAllExternalDescendants());
        while (!phylogenyNode.isRoot() && !arrayList2.containsAll(arrayList)) {
            phylogenyNode = phylogenyNode.getParent();
            arrayList2 = new ArrayList<PhylogenyNode>(phylogenyNode.getAllExternalDescendants());
        }
        return phylogenyNode;
    }

    private void calculateMean() {
        if (this.nodes_ == null || this.nodes_.isEmpty() || this.tree_ == null || this.tree_.isEmpty()) {
            return;
        }
        double d = 0.0;
        ListIterator<PhylogenyNode> listIterator = this.nodes_.listIterator();
        this.n_ = 0;
        try {
            while (listIterator.hasNext()) {
                ++this.n_;
                d += this.getDistanceToNode(listIterator.next(), this.lca_);
            }
        }
        catch (Exception exception) {
            System.err.println("calculateMean(): Exception: " + exception);
            System.exit(-1);
        }
        this.setMean(d / (double)this.n_);
    }

    private void calculateMeanDistToRoot() {
        if (this.tree_ == null || this.tree_.isEmpty()) {
            return;
        }
        double d = 0.0;
        this.n_ = 0;
        for (PhylogenyNode phylogenyNode = this.tree_.getFirstExternalNode(); phylogenyNode != null; phylogenyNode = phylogenyNode.getNextExternalNode()) {
            ++this.n_;
            d += this.getDistanceToRoot(phylogenyNode);
        }
        this.setMean(d / (double)this.n_);
    }

    private void calculateStandardDeviation() {
        if (this.getVariance() == -1.0 || this.getVariance() < 0.0) {
            return;
        }
        this.setStandardDeviation(Math.sqrt(this.getVariance()));
    }

    private void calculateVariance() {
        if (this.getMean() == -1.0 || this.nodes_ == null || this.nodes_.isEmpty() || this.tree_ == null || this.tree_.isEmpty() || (double)this.n_ <= 1.0) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        ListIterator<PhylogenyNode> listIterator = this.nodes_.listIterator();
        try {
            while (listIterator.hasNext()) {
                d = this.getDistanceToNode(listIterator.next(), this.lca_) - this.getMean();
                d2 += d * d;
            }
        }
        catch (Exception exception) {
            System.err.println("calculateVariance(): Exception: " + exception);
            System.exit(-1);
        }
        this.setVariance(d2 / (double)(this.n_ - 1));
    }

    private void calculateVarianceDistToRoot() {
        if (this.getMean() == -1.0 || this.tree_ == null || this.tree_.isEmpty() || (double)this.n_ <= 1.0) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        for (PhylogenyNode phylogenyNode = this.tree_.getFirstExternalNode(); phylogenyNode != null; phylogenyNode = phylogenyNode.getNextExternalNode()) {
            d = this.getDistanceToRoot(phylogenyNode) - this.getMean();
            d2 += d * d;
        }
        this.setVariance(d2 / (double)(this.n_ - 1));
    }

    public double getDistanceToLCA(String string) {
        if (this.tree_ == null || this.tree_.isEmpty() || this.lca_ == null) {
            return 0.0;
        }
        return this.getDistanceToNode(string, this.lca_);
    }

    public double getDistanceToNode(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        double d = 0.0;
        double d2 = 0.0;
        while (phylogenyNode2 != phylogenyNode && !phylogenyNode.isRoot()) {
            d = phylogenyNode.getDistanceToParent();
            if (d > 0.0) {
                d2 += d;
            }
            phylogenyNode = phylogenyNode.getParent();
        }
        if (!phylogenyNode2.isRoot() && phylogenyNode.isRoot()) {
            throw new IllegalArgumentException("getDistanceToNode(PhylogenyNode outer,PhylogenyNode inner): PhylogenyNode inner is not closer to the root than PhylogenyNode outer or is not on the same \"subtree\"");
        }
        return d2;
    }

    public double getDistanceToNode(String string, PhylogenyNode phylogenyNode) {
        if (this.tree_ == null || this.tree_.isEmpty()) {
            return 0.0;
        }
        return this.getDistanceToNode(this.tree_.getNodeViaSequenceName(string), phylogenyNode);
    }

    public double getDistanceToRoot(PhylogenyNode phylogenyNode) {
        if (this.tree_ == null || this.tree_.isEmpty()) {
            return 0.0;
        }
        double d = 0.0;
        try {
            d = this.getDistanceToNode(phylogenyNode, this.tree_.getRoot());
        }
        catch (Exception exception) {
            System.err.println("getDistanceToRoot(PhylogenyNode): Unexpected exception: " + exception);
            System.exit(-1);
        }
        return d;
    }

    public double getDistanceToRoot(String string) {
        if (this.tree_ == null || this.tree_.isEmpty()) {
            return 0.0;
        }
        return this.getDistanceToNode(string, this.tree_.getRoot());
    }

    public double getMean() {
        return this.mean_;
    }

    public int getN() {
        return this.n_;
    }

    public double getStandardDeviation() {
        return this.stand_dev_;
    }

    public double getVariance() {
        return this.variance_;
    }

    private void setMean(double d) {
        this.mean_ = d;
    }

    private void setStandardDeviation(double d) {
        this.stand_dev_ = d;
    }

    public void setTree(Phylogeny phylogeny) {
        this.tree_ = phylogeny;
        this.nodes_ = null;
        this.n_ = 0;
        this.mean_ = -1.0;
        this.variance_ = -1.0;
        this.stand_dev_ = -1.0;
        this.lca_ = null;
        this.calculateMeanDistToRoot();
        this.calculateVarianceDistToRoot();
        this.calculateStandardDeviation();
    }

    public void setTreeAndExtNodes(Phylogeny phylogeny, ArrayList<PhylogenyNode> arrayList) {
        this.tree_ = phylogeny;
        this.nodes_ = arrayList;
        this.n_ = 0;
        this.mean_ = -1.0;
        this.variance_ = -1.0;
        this.stand_dev_ = -1.0;
        this.lca_ = this.calculateLCA(this.nodes_);
        this.calculateMean();
        this.calculateVariance();
        this.calculateStandardDeviation();
    }

    public void setTreeAndExtNodes(Phylogeny phylogeny, Vector<PhylogenyNode> vector) {
        this.setTreeAndExtNodes(phylogeny, new ArrayList<PhylogenyNode>(vector));
    }

    private void setVariance(double d) {
        this.variance_ = d;
    }

    public static void main(String[] stringArray) {
        File file = null;
        Phylogeny phylogeny = null;
        DistanceCalculator distanceCalculator = null;
        file = new File(stringArray[0]);
        try {
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            PhylogenyParser phylogenyParser = ForesterUtil.createParserDependingOnFileType(file, true);
            phylogeny = phylogenyFactory.create(file, phylogenyParser)[0];
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            System.exit(-1);
        }
        double d = System.currentTimeMillis();
        distanceCalculator = new DistanceCalculator(phylogeny);
        double d2 = distanceCalculator.getMean();
        double d3 = distanceCalculator.getVariance();
        double d4 = distanceCalculator.getStandardDeviation();
        d = (double)System.currentTimeMillis() - d;
        System.out.println("\nn   = " + distanceCalculator.getN());
        System.out.println("mea = " + d2);
        System.out.println("var = " + d3);
        System.out.println("sd  = " + d4 + "\n");
        System.out.println("t=" + d + "\n");
    }
}

