/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.iterators;

import java.util.NoSuchElementException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public class ExternalForwardIterator
implements PhylogenyNodeIterator {
    private PhylogenyNode _current_node;
    private final PhylogenyNode _last_ext_node;
    private final PhylogenyNode _first_ext_node;

    public ExternalForwardIterator(Phylogeny phylogeny) throws IllegalArgumentException {
        if (phylogeny.isEmpty()) {
            throw new IllegalArgumentException("attempt to use ExternalForwardIterator on an empty phylogeny");
        }
        PhylogenyNode phylogenyNode = phylogeny.getRoot();
        while (!phylogenyNode.isExternal()) {
            phylogenyNode = phylogenyNode.getLastChildNode();
        }
        this._last_ext_node = phylogenyNode;
        this._first_ext_node = phylogeny.getFirstExternalNode();
        this.reset();
    }

    private PhylogenyNode getCurrentNode() {
        return this._current_node;
    }

    private PhylogenyNode getFirstExtNode() {
        return this._first_ext_node;
    }

    private PhylogenyNode getLastExtNode() {
        return this._last_ext_node;
    }

    public boolean hasNext() {
        return this.getCurrentNode() != null;
    }

    public PhylogenyNode next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("attempt to call \"next()\" on iterator which has no more next elements");
        }
        PhylogenyNode phylogenyNode = this.getCurrentNode();
        if (phylogenyNode == this.getLastExtNode()) {
            this.setCurrentNode(null);
        } else {
            this.setCurrentNode(phylogenyNode.getNextExternalNode());
        }
        return phylogenyNode;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        this.setCurrentNode(this.getFirstExtNode());
    }

    private void setCurrentNode(PhylogenyNode phylogenyNode) {
        this._current_node = phylogenyNode;
    }
}

