/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlUtil;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class Reference
implements PhylogenyData {
    String _desc;
    String _doi;

    public Reference(String string) {
        this._desc = string;
        this._doi = "";
    }

    public Reference(String string, String string2) {
        this._desc = string;
        this._doi = string2;
    }

    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getDescription());
    }

    public StringBuffer asText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!ForesterUtil.isEmpty(this.getDoi())) {
            stringBuffer.append("[doi:");
            stringBuffer.append(this.getDoi());
            stringBuffer.append("] ");
        }
        stringBuffer.append(this.getDescription());
        return stringBuffer;
    }

    public PhylogenyData copy() {
        return new Reference(this.getDescription(), this.getDoi());
    }

    public String getDoi() {
        return this._doi;
    }

    public String getDescription() {
        return this._desc;
    }

    public boolean isEqual(PhylogenyData phylogenyData) {
        if (phylogenyData == null || this.getDescription() == null) {
            return false;
        }
        return ((Reference)phylogenyData).getDescription().equals(this.getDescription()) && ((Reference)phylogenyData).getDoi().equals(this.getDoi());
    }

    public void setDoi(String string) {
        if (!ForesterUtil.isEmpty(string) && !PhyloXmlUtil.LIT_REF_DOI_PATTERN.matcher(string).matches()) {
            throw new PhyloXmlDataFormatException("illegal doi: [" + string + "]");
        }
        this._doi = string;
    }

    public void setValue(String string) {
        this._desc = string;
    }

    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendOpen(writer, "reference", "doi", this.getDoi());
        if (!ForesterUtil.isEmpty(this.getDescription())) {
            PhylogenyDataUtil.appendElement(writer, "desc", this.getDescription(), string);
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendClose(writer, "reference");
    }

    public String toString() {
        return this.asText().toString();
    }
}

