/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class Identifier
implements PhylogenyData {
    final String _value;
    final String _provider;

    public Identifier() {
        this._value = "";
        this._provider = "";
    }

    public Identifier(String string) {
        this._value = string;
        this._provider = "";
    }

    public Identifier(String string, String string2) {
        this._value = string;
        this._provider = string2;
    }

    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getValue());
    }

    public StringBuffer asText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!ForesterUtil.isEmpty(this.getProvider())) {
            stringBuffer.append("[");
            stringBuffer.append(this.getProvider());
            stringBuffer.append("] ");
        }
        stringBuffer.append(this.getValue());
        return stringBuffer;
    }

    public PhylogenyData copy() {
        return new Identifier(this.getValue(), this.getProvider());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + object + " [" + object.getClass() + "]");
        }
        return this.isEqual((Identifier)object);
    }

    public String getProvider() {
        return this._provider;
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        if (this.getProvider() != null) {
            return (this.getProvider() + this.getValue()).hashCode();
        }
        return this.getValue().hashCode();
    }

    public boolean isEqual(PhylogenyData phylogenyData) {
        if (this == phylogenyData) {
            return true;
        }
        if (phylogenyData == null || this.getValue() == null) {
            return false;
        }
        Identifier identifier = (Identifier)phylogenyData;
        if (this.getProvider() != null && identifier.getProvider() != null) {
            return identifier.getValue().equals(this.getValue()) && identifier.getProvider().equals(this.getProvider());
        }
        return identifier.getValue().equals(this.getValue());
    }

    public StringBuffer toNHX() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(":");
        stringBuffer.append("ID=");
        stringBuffer.append(ForesterUtil.replaceIllegalNhxCharacters(this.getValue()));
        return stringBuffer;
    }

    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        if (!ForesterUtil.isEmpty(this.getProvider())) {
            PhylogenyDataUtil.appendElement(writer, "id", this.getValue(), "provider", this.getProvider(), string);
        } else {
            PhylogenyDataUtil.appendElement(writer, "id", this.getValue(), string);
        }
    }

    public String toString() {
        return this.asText().toString();
    }
}

