/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Confidence
implements PhylogenyData,
Comparable<Confidence> {
    public static final double CONFIDENCE_DEFAULT_VALUE = -9999.0;
    private double _value;
    private String _type;

    public Confidence() {
        this.init();
    }

    public Confidence(double d, String string) {
        this.setValue(d);
        this.setType(string);
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer().append(ForesterUtil.FORMATTER_6.format(this.getValue()));
    }

    @Override
    public StringBuffer asText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!ForesterUtil.isEmpty(this.getType())) {
            stringBuffer.append("[");
            stringBuffer.append(this.getType());
            stringBuffer.append("] ");
        }
        stringBuffer.append(ForesterUtil.FORMATTER_6.format(this.getValue()));
        return stringBuffer;
    }

    @Override
    public int compareTo(Confidence confidence) {
        if (this == confidence) {
            return 0;
        }
        return this.getType().compareToIgnoreCase(confidence.getType());
    }

    @Override
    public PhylogenyData copy() {
        return new Confidence(this.getValue(), this.getType());
    }

    public String getType() {
        return this._type;
    }

    public double getValue() {
        return this._value;
    }

    public void init() {
        this.setValue(-9999.0);
        this.setType("");
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        if (phylogenyData == null) {
            return false;
        }
        if (!(phylogenyData instanceof Confidence)) {
            return false;
        }
        Confidence confidence = (Confidence)phylogenyData;
        if (confidence.getValue() != this.getValue()) {
            return false;
        }
        return confidence.getType().equals(this.getType());
    }

    public void setType(String string) {
        this._type = string;
    }

    public void setValue(double d) {
        this._value = d;
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("B=");
        stringBuffer.append(this.getValue());
        return stringBuffer;
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        if (this.getValue() == -9999.0) {
            return;
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendElement(writer, "confidence", String.valueOf(ForesterUtil.round(this.getValue(), 9)), "type", ForesterUtil.isEmpty(this.getType()) ? "unknown" : this.getType());
    }

    public String toString() {
        return this.asText().toString();
    }
}

