/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class BranchWidth
implements PhylogenyData {
    public static final double BRANCH_WIDTH_DEFAULT_VALUE = 1.0;
    private final double _value;

    public BranchWidth() {
        this._value = 1.0;
    }

    public BranchWidth(double d) {
        this._value = d;
    }

    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getValue() + "");
    }

    public StringBuffer asText() {
        return this.asSimpleText();
    }

    public PhylogenyData copy() {
        return new BranchWidth(this.getValue());
    }

    public double getValue() {
        return this._value;
    }

    public boolean isEqual(PhylogenyData phylogenyData) {
        return this.getValue() == ((BranchWidth)phylogenyData).getValue();
    }

    public StringBuffer toNHX() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("W=");
        stringBuffer.append(this.getValue());
        return stringBuffer;
    }

    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendElement(writer, "width", this.getValue() + "");
    }

    public String toString() {
        return this.asText().toString();
    }
}

