/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class BranchColor
implements PhylogenyData {
    private Color _color;

    public BranchColor() {
        this._color = null;
    }

    public BranchColor(Color color) {
        this._color = color;
    }

    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getValue().toString());
    }

    public StringBuffer asText() {
        return new StringBuffer(this.getValue().toString());
    }

    public PhylogenyData copy() {
        BranchColor branchColor = new BranchColor();
        branchColor.setValue(this.getValue());
        return branchColor;
    }

    public Color getValue() {
        return this._color;
    }

    public boolean isEqual(PhylogenyData phylogenyData) {
        return this.getValue().equals(((BranchColor)phylogenyData).getValue());
    }

    public void setValue(Color color) {
        this._color = color;
    }

    public StringBuffer toNHX() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("C=");
        stringBuffer.append(this.getValue().getRed());
        stringBuffer.append(".");
        stringBuffer.append(this.getValue().getGreen());
        stringBuffer.append(".");
        stringBuffer.append(this.getValue().getBlue());
        return stringBuffer;
    }

    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendOpen(writer, "color");
        PhylogenyDataUtil.appendElement(writer, "red", this.getValue().getRed() + "", string);
        PhylogenyDataUtil.appendElement(writer, "green", this.getValue().getGreen() + "", string);
        PhylogenyDataUtil.appendElement(writer, "blue", this.getValue().getBlue() + "", string);
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendClose(writer, "color");
    }

    public String toString() {
        return this.asText().toString();
    }
}

