/*
 * Decompiled with CFR 0.152.
 */
package org.forester.msa;

import java.util.ArrayList;
import org.forester.msa.BasicMsa;
import org.forester.msa.Msa;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.Sequence;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MsaTools {
    private ArrayList<String> _ignored_seqs_ids;

    public synchronized ArrayList<String> getIgnoredSequenceIds() {
        return this._ignored_seqs_ids;
    }

    public static synchronized MsaTools createInstance() {
        return new MsaTools();
    }

    private MsaTools() {
        this.init();
    }

    private synchronized void init() {
        this._ignored_seqs_ids = new ArrayList();
    }

    public Object clone() {
        throw new NoSuchMethodError();
    }

    public static int calcGapSumPerColumn(Msa msa, int n) {
        int n2 = 0;
        for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
            if (msa.getResidueAt(i, n) != '-') continue;
            ++n2;
        }
        return n2;
    }

    public synchronized Msa removeGapColumns(double d, int n, Msa msa) {
        this.init();
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("max allowed gap ration is out of range: " + d);
        }
        boolean bl = n > 0;
        boolean[] blArray = new boolean[msa.getLength()];
        int n2 = 0;
        for (int i = 0; i < msa.getLength(); ++i) {
            boolean bl2 = blArray[i] = (double)MsaTools.calcGapSumPerColumn(msa, i) / (double)msa.getNumberOfSequences() > d;
            if (blArray[i]) continue;
            ++n2;
        }
        ArrayList<Sequence> arrayList = new ArrayList<Sequence>(msa.getNumberOfSequences());
        for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
            char[] cArray = new char[n2];
            int n3 = 0;
            int n4 = 0;
            for (int j = 0; j < msa.getLength(); ++j) {
                if (blArray[j]) continue;
                char c = msa.getResidueAt(i, j);
                cArray[n3++] = c;
                if (c == '-') continue;
                ++n4;
            }
            if (bl) {
                if (n4 >= n) {
                    arrayList.add(new BasicSequence(msa.getIdentifier(i), cArray, msa.getType()));
                    continue;
                }
                this._ignored_seqs_ids.add(msa.getIdentifier(i).toString());
                continue;
            }
            arrayList.add(new BasicSequence(msa.getIdentifier(i), cArray, msa.getType()));
        }
        if (arrayList.size() < 1) {
            return null;
        }
        return BasicMsa.createInstance(arrayList);
    }

    public static DescriptiveStatistics calcBasicGapinessStatistics(Msa msa) {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        for (int i = 0; i < msa.getLength(); ++i) {
            basicDescriptiveStatistics.addValue((double)MsaTools.calcGapSumPerColumn(msa, i) / (double)msa.getNumberOfSequences());
        }
        return basicDescriptiveStatistics;
    }
}

