/*
 * Decompiled with CFR 0.152.
 */
package org.forester.msa;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.forester.io.parsers.FastaParser;
import org.forester.msa.Msa;
import org.forester.msa.MsaInferrer;
import org.forester.util.ForesterUtil;
import org.forester.util.SystemCommandExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Mafft
implements MsaInferrer {
    private static final String DEFAULT_PARAMETERS = "--maxiterate 1000 --localpair";
    private String _error;
    private int _exit_code;
    private final String _path_to_prg;

    public static MsaInferrer createInstance(String string) {
        return new Mafft(string);
    }

    private static String getPathToCmd() {
        String string = "";
        String string2 = ForesterUtil.OS_NAME.toLowerCase();
        string = string2.indexOf("mac") >= 0 && string2.indexOf("os") > 0 ? "/usr/local/bin/mafft" : (string2.indexOf("win") >= 0 ? "C:\\Program Files\\mafft-win\\mafft.bat" : "/home/czmasek/SOFTWARE/MSA/MAFFT/mafft-6.832-without-extensions/scripts/mafft");
        return string;
    }

    public static boolean isInstalled() {
        return SystemCommandExecutor.isExecuteableFile(new File(Mafft.getPathToCmd()));
    }

    public static MsaInferrer createInstance() {
        return Mafft.createInstance(Mafft.getPathToCmd());
    }

    private Mafft(String string) {
        if (!SystemCommandExecutor.isExecuteableFile(new File(string))) {
            throw new IllegalArgumentException("cannot execute MAFFT via [" + string + "]");
        }
        this._path_to_prg = new String(string);
        this.init();
    }

    public static String getDefaultParameters() {
        return DEFAULT_PARAMETERS;
    }

    public Object clone() {
        throw new NoSuchMethodError();
    }

    @Override
    public String getErrorDescription() {
        return this._error;
    }

    @Override
    public int getExitCode() {
        return this._exit_code;
    }

    @Override
    public Msa infer(File file, List<String> list) throws IOException, InterruptedException {
        this.init();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this._path_to_prg);
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(list.get(i));
        }
        arrayList.add(file.getAbsolutePath());
        SystemCommandExecutor systemCommandExecutor = new SystemCommandExecutor(arrayList);
        int n = systemCommandExecutor.executeCommand();
        if (n != 0) {
            throw new IOException("MAFFT failed, exit code: " + n);
        }
        StringBuilder stringBuilder = systemCommandExecutor.getStandardOutputFromCommand();
        StringBuilder stringBuilder2 = systemCommandExecutor.getStandardErrorFromCommand();
        System.out.println(stringBuilder);
        System.out.println();
        System.out.println(stringBuilder2);
        this._error = stringBuilder2.toString();
        Msa msa = FastaParser.parseMsa(stringBuilder.toString());
        return msa;
    }

    private void init() {
        this._error = null;
        this._exit_code = -100;
    }
}

