/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.tol;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.tol.TolXmlHandler;
import org.forester.io.parsers.util.PhylogenyParserException;
import org.forester.phylogeny.Phylogeny;
import org.forester.util.ForesterUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class TolParser
implements PhylogenyParser {
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String SAX_FEATURES_VALIDATION = "http://xml.org/sax/features/validation";
    public static final String APACHE_FEATURES_VALIDATION_SCHEMA = "http://apache.org/xml/features/validation/schema";
    public static final String APACHE_FEATURES_VALIDATION_SCHEMA_FULL = "http://apache.org/xml/features/validation/schema-full-checking";
    public static final String APACHE_PROPERTIES_SCHEMA_EXTERNAL_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    private Object _source;
    private boolean _valid;
    private boolean _zipped_inputstream;
    private int _error_count;
    private int _warning_count;
    private String _schema_location;
    private StringBuffer _error_messages;
    private StringBuffer _warning_messages;

    public TolParser() {
        this.init();
        this.reset();
    }

    public int getErrorCount() {
        return this._error_count;
    }

    public StringBuffer getErrorMessages() {
        return this._error_messages;
    }

    private Reader getReaderFromZipFile() throws IOException {
        InputStreamReader inputStreamReader = null;
        ZipFile zipFile = new ZipFile(this.getSource().toString());
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || zipEntry.getSize() <= 0L) continue;
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            inputStreamReader = new InputStreamReader(inputStream);
            break;
        }
        return inputStreamReader;
    }

    private String getSchemaLocation() {
        return this._schema_location;
    }

    private Object getSource() {
        return this._source;
    }

    public int getWarningCount() {
        return this._warning_count;
    }

    public StringBuffer getWarningMessages() {
        return this._warning_messages;
    }

    private void init() {
        this.setZippedInputstream(false);
    }

    public boolean isValid() {
        return this._valid;
    }

    private boolean isZippedInputstream() {
        return this._zipped_inputstream;
    }

    public Phylogeny[] parse() throws IOException, PhylogenyParserException {
        Phylogeny[] phylogenyArray;
        TolXmlHandler tolXmlHandler;
        block25: {
            this.reset();
            tolXmlHandler = new TolXmlHandler();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            try {
                if (!ForesterUtil.isEmpty(this.getSchemaLocation())) {
                    sAXParserFactory.setFeature(SAX_FEATURES_VALIDATION, true);
                    sAXParserFactory.setFeature(APACHE_FEATURES_VALIDATION_SCHEMA, true);
                    sAXParserFactory.setFeature(APACHE_FEATURES_VALIDATION_SCHEMA_FULL, true);
                }
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                sAXNotRecognizedException.printStackTrace();
                throw new PhylogenyParserException("sax not recognized exception: " + sAXNotRecognizedException.getMessage());
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                sAXNotSupportedException.printStackTrace();
                throw new PhylogenyParserException("sax not supported exception: " + sAXNotSupportedException.getMessage());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
                throw new PhylogenyParserException("parser _configuration exception: " + parserConfigurationException.getMessage());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new PhylogenyParserException("error while configuring sax parser: " + exception.getMessage());
            }
            try {
                Object object2;
                phylogenyArray = sAXParserFactory.newSAXParser();
                if (!ForesterUtil.isEmpty(this.getSchemaLocation())) {
                    phylogenyArray.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                    phylogenyArray.setProperty(JAXP_SCHEMA_SOURCE, this.getSchemaLocation());
                    phylogenyArray.setProperty(APACHE_PROPERTIES_SCHEMA_EXTERNAL_LOCATION, this.getSchemaLocation());
                }
                XMLReader xMLReader = phylogenyArray.getXMLReader();
                xMLReader.setContentHandler(tolXmlHandler);
                xMLReader.setErrorHandler(new TolParserErrorHandler());
                if (this.getSource() instanceof File) {
                    if (!this.getSource().toString().toLowerCase().endsWith(".zip")) {
                        xMLReader.parse(new InputSource(new FileReader((File)this.getSource())));
                    } else {
                        object2 = this.getReaderFromZipFile();
                        if (object2 == null) {
                            throw new PhylogenyParserException("Zip file \"" + this.getSource() + "\" appears not to contain any entries");
                        }
                        xMLReader.parse(new InputSource((Reader)object2));
                    }
                    break block25;
                }
                if (this.getSource() instanceof InputSource) {
                    xMLReader.parse((InputSource)this.getSource());
                    break block25;
                }
                if (this.getSource() instanceof InputStream) {
                    if (!this.isZippedInputstream()) {
                        object2 = (InputStream)this.getSource();
                        InputStreamReader object = new InputStreamReader((InputStream)object2);
                        xMLReader.parse(new InputSource(object));
                    } else {
                        object2 = new ZipInputStream((InputStream)this.getSource());
                        ((ZipInputStream)object2).getNextEntry();
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object2);
                        if (inputStreamReader == null) {
                            throw new PhylogenyParserException("Zip input stream \"" + this.getSource() + "\" appears not to contain any data");
                        }
                        xMLReader.parse(new InputSource(inputStreamReader));
                    }
                    break block25;
                }
                if (this.getSource() instanceof String) {
                    object2 = new File(this.getSource().toString());
                    FileReader fileReader = new FileReader((File)object2);
                    xMLReader.parse(new InputSource(fileReader));
                    break block25;
                }
                if (this.getSource() instanceof StringBuffer) {
                    object2 = new StringReader(this.getSource().toString());
                    xMLReader.parse(new InputSource((Reader)object2));
                    break block25;
                }
                throw new PhylogenyParserException("attempt to parse object of unsupported type: \"" + this.getSource().getClass() + "\"");
            }
            catch (SAXException sAXException) {
                throw new PhylogenyParserException("Failed to parse [" + this.getSource() + "]: " + sAXException.getMessage());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new PhylogenyParserException("Failed to parse [" + this.getSource() + "] Problem with xml parser _configuration: " + parserConfigurationException.getMessage());
            }
            catch (IOException iOException) {
                throw new PhylogenyParserException("Problem with input source [" + this.getSource() + "]: \n" + iOException.getMessage());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new PhylogenyParserException("Failed to parse [" + this.getSource() + "]: " + exception.getMessage());
            }
            catch (Error error) {
                error.printStackTrace();
                throw new PhylogenyParserException("Severe error: " + error.getMessage());
            }
        }
        phylogenyArray = new Phylogeny[tolXmlHandler.getPhylogenies().size()];
        int n = 0;
        for (Phylogeny phylogeny : tolXmlHandler.getPhylogenies()) {
            phylogenyArray[n++] = phylogeny;
        }
        return phylogenyArray;
    }

    private void reset() {
        this._valid = true;
        this._error_count = 0;
        this._warning_count = 0;
        this._error_messages = new StringBuffer();
        this._warning_messages = new StringBuffer();
    }

    public void setSource(Object object) {
        this._source = object;
    }

    public void setValidateAgainstSchema(String string) {
        this._schema_location = string;
    }

    public void setZippedInputstream(boolean bl) {
        this._zipped_inputstream = bl;
    }

    private class TolParserErrorHandler
    extends DefaultHandler {
        private TolParserErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) {
            ++TolParser.this._error_count;
            TolParser.this._valid = false;
            throw new RuntimeException("XML error at line " + sAXParseException.getLineNumber() + ": \n" + sAXParseException.getMessage());
        }

        public void fatalError(SAXParseException sAXParseException) {
            ++TolParser.this._error_count;
            TolParser.this._valid = false;
            throw new RuntimeException("Fatal XML error at line " + sAXParseException.getLineNumber() + ": \n" + sAXParseException.getMessage());
        }

        public void warning(SAXParseException sAXParseException) {
            ++TolParser.this._warning_count;
            if (TolParser.this._error_messages.length() > 1) {
                TolParser.this._error_messages.append(ForesterUtil.LINE_SEPARATOR);
            }
            TolParser.this._warning_messages.append("[line: " + sAXParseException.getLineNumber() + "] " + sAXParseException.getMessage());
        }
    }
}

