/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.AccessionParser;
import org.forester.io.parsers.phyloxml.data.AnnotationParser;
import org.forester.io.parsers.phyloxml.data.DomainArchitectureParser;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.io.parsers.phyloxml.data.UriParser;
import org.forester.io.parsers.util.PhylogenyParserException;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Uri;

public class SequenceParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private SequenceParser() {
    }

    public Sequence parse(XmlElement xmlElement) throws PhylogenyParserException {
        Sequence sequence = new Sequence();
        if (xmlElement.isHasAttribute("type")) {
            sequence.setType(xmlElement.getAttribute("type"));
        }
        if (xmlElement.isHasAttribute("id_source")) {
            sequence.setSourceId(xmlElement.getAttribute("id_source"));
        }
        for (int i = 0; i < xmlElement.getNumberOfChildElements(); ++i) {
            XmlElement xmlElement2 = xmlElement.getChildElement(i);
            if (xmlElement2.getQualifiedName().equals("location")) {
                sequence.setLocation(xmlElement2.getValueAsString());
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("name")) {
                sequence.setName(xmlElement2.getValueAsString());
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("mol_seq")) {
                if (xmlElement2.isHasAttribute("is_aligned")) {
                    sequence.setMolecularSequenceAligned(Boolean.parseBoolean(xmlElement2.getAttribute("is_aligned")));
                }
                sequence.setMolecularSequence(xmlElement2.getValueAsString());
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("accession")) {
                sequence.setAccession((Accession)AccessionParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("symbol")) {
                sequence.setSymbol(xmlElement2.getValueAsString());
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("annotation")) {
                sequence.addAnnotation((Annotation)AnnotationParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("domain_architecture")) {
                sequence.setDomainArchitecture((DomainArchitecture)DomainArchitectureParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (!xmlElement2.getQualifiedName().equals("uri")) continue;
            sequence.addUri((Uri)UriParser.getInstance().parse(xmlElement2));
        }
        return sequence;
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new SequenceParser();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
    }
}

