/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.ConfidenceParser;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.io.parsers.util.PhylogenyParserException;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.util.ForesterUtil;

public class EventParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private EventParser() {
    }

    public PhylogenyData parse(XmlElement xmlElement) throws PhylogenyParserException {
        String string = "";
        Confidence confidence = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < xmlElement.getNumberOfChildElements(); ++i) {
            XmlElement xmlElement2 = xmlElement.getChildElement(i);
            if (xmlElement2.getQualifiedName().equals("type")) {
                string = xmlElement2.getValueAsString();
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("confidence")) {
                confidence = (Confidence)ConfidenceParser.getInstance().parse(xmlElement2);
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("duplications")) {
                n = xmlElement2.getValueAsInt();
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("speciations")) {
                n2 = xmlElement2.getValueAsInt();
                continue;
            }
            if (!xmlElement2.getQualifiedName().equals("losses")) continue;
            n3 = xmlElement2.getValueAsInt();
        }
        Event event = null;
        if (ForesterUtil.isEmpty(string)) {
            event = new Event(n, n2, n3);
        } else {
            try {
                event = new Event(n, n2, n3, string);
            }
            catch (Exception exception) {
                throw new PhylogenyParserException("problem with " + xmlElement.toString() + ": " + exception.getMessage());
            }
        }
        if (confidence != null) {
            event.setConfidence(confidence);
        }
        return event;
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new EventParser();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
    }
}

