/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import java.util.ArrayList;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.io.parsers.phyloxml.data.PointParser;
import org.forester.io.parsers.phyloxml.data.PolygonParser;
import org.forester.io.parsers.util.PhylogenyParserException;
import org.forester.phylogeny.data.Distribution;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.Point;
import org.forester.phylogeny.data.Polygon;

public class DistributionParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private DistributionParser() {
    }

    public PhylogenyData parse(XmlElement xmlElement) throws PhylogenyParserException {
        String string = "";
        ArrayList<Point> arrayList = null;
        ArrayList<Polygon> arrayList2 = null;
        for (int i = 0; i < xmlElement.getNumberOfChildElements(); ++i) {
            XmlElement xmlElement2 = xmlElement.getChildElement(i);
            if (xmlElement2.getQualifiedName().equals("desc")) {
                string = xmlElement2.getValueAsString();
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("point")) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Point>();
                }
                arrayList.add((Point)PointParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (!xmlElement2.getQualifiedName().equals("polygon")) continue;
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<Polygon>();
            }
            arrayList2.add((Polygon)PolygonParser.getInstance().parse(xmlElement2));
        }
        return new Distribution(string, arrayList, arrayList2);
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new DistributionParser();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
    }
}

