/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.io.parsers.util.PhylogenyParserException;
import org.forester.phylogeny.data.BinaryCharacters;
import org.forester.phylogeny.data.PhylogenyData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryCharactersParser
implements PhylogenyDataPhyloXmlParser {
    private static final BinaryCharactersParser _instance;

    private BinaryCharactersParser() {
    }

    @Override
    public PhylogenyData parse(XmlElement xmlElement) throws PhylogenyParserException {
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        TreeSet<String> treeSet3 = new TreeSet<String>();
        String string = "";
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        if (xmlElement.isHasAttribute("type")) {
            string = xmlElement.getAttribute("type");
        }
        try {
            if (xmlElement.isHasAttribute("present_count")) {
                n = Integer.parseInt(xmlElement.getAttribute("present_count"));
            }
            if (xmlElement.isHasAttribute("gained_count")) {
                n2 = Integer.parseInt(xmlElement.getAttribute("gained_count"));
            }
            if (xmlElement.isHasAttribute("lost_count")) {
                n3 = Integer.parseInt(xmlElement.getAttribute("lost_count"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PhylogenyParserException("failed to parse integer from element " + xmlElement.getQualifiedName());
        }
        for (int i = 0; i < xmlElement.getNumberOfChildElements(); ++i) {
            XmlElement xmlElement2 = xmlElement.getChildElement(i);
            if (xmlElement2.getQualifiedName().equals("present")) {
                this.parseCharacters(treeSet, xmlElement2);
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("gained")) {
                this.parseCharacters(treeSet2, xmlElement2);
                continue;
            }
            if (!xmlElement2.getQualifiedName().equals("lost")) continue;
            this.parseCharacters(treeSet3, xmlElement2);
        }
        BinaryCharacters binaryCharacters = null;
        binaryCharacters = n != -1 ? new BinaryCharacters(treeSet, treeSet2, treeSet3, string, n, n2, n3) : new BinaryCharacters(treeSet, treeSet2, treeSet3, string);
        return binaryCharacters;
    }

    private void parseCharacters(SortedSet<String> sortedSet, XmlElement xmlElement) {
        for (int i = 0; i < xmlElement.getNumberOfChildElements(); ++i) {
            XmlElement xmlElement2 = xmlElement.getChildElement(i);
            if (!xmlElement2.getQualifiedName().equals("bc")) continue;
            sortedSet.add(xmlElement2.getValueAsString());
        }
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new BinaryCharactersParser();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
    }
}

