/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.nexus;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.forester.evoinference.matrix.character.BasicCharacterStateMatrix;
import org.forester.evoinference.matrix.character.CharacterStateMatrix;
import org.forester.io.parsers.nexus.NexusFormatException;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.parsers.util.PhylogenyParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaupLogParser {
    private static final String DATA_MATRIX_AND_RECONSTRUCTED_STATES_FOR_INTERNAL_NODES = "data matrix and reconstructed states for internal nodes";
    private Object _nexus_source;

    private Object getNexusSource() {
        return this._nexus_source;
    }

    public CharacterStateMatrix<CharacterStateMatrix.BinaryStates> parse() throws IOException {
        String[] stringArray;
        String string;
        BufferedReader bufferedReader = ParserUtils.createReader(this.getNexusSource());
        boolean bl = false;
        int n = 0;
        boolean bl2 = true;
        boolean bl3 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        boolean bl4 = false;
        while ((string = bufferedReader.readLine()) != null && !bl4) {
            if ((string = string.trim()).length() <= 0 || string.startsWith("#") || string.startsWith(">")) continue;
            if (n > 0 && string.startsWith("Tree ") || string.startsWith("Character change list")) {
                bl4 = true;
                continue;
            }
            if (string.toLowerCase().startsWith(DATA_MATRIX_AND_RECONSTRUCTED_STATES_FOR_INTERNAL_NODES)) {
                bl = false;
                bl3 = true;
                n = 0;
                if (bl2 && string.indexOf("continued") > 0) {
                    bl2 = false;
                }
            }
            if (bl3 && string.startsWith("----------")) {
                bl = true;
                continue;
            }
            if (!bl || string.indexOf(32) <= 0) continue;
            stringArray = string.split("\\s+");
            if (stringArray.length != 2) {
                throw new NexusFormatException("unexpected format at line: " + string);
            }
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            if (bl2) {
                if (arrayList.contains(string2)) {
                    throw new NexusFormatException("identifier [" + string2 + "] is not unique in line: " + string);
                }
                arrayList.add(string2);
                arrayList2.add(new ArrayList());
            } else if (!arrayList.contains(string2)) {
                throw new NexusFormatException("new identifier [" + string2 + "] at line: " + string);
            }
            for (int i = 0; i < string3.length(); ++i) {
                char c = string3.charAt(i);
                if (c == '0') {
                    ((List)arrayList2.get(n)).add(CharacterStateMatrix.BinaryStates.ABSENT);
                    continue;
                }
                if (c == '1') {
                    ((List)arrayList2.get(n)).add(CharacterStateMatrix.BinaryStates.PRESENT);
                    continue;
                }
                throw new NexusFormatException("unknown character state [" + c + "] at line: " + string);
            }
            ++n;
        }
        stringArray = new BasicCharacterStateMatrix(arrayList2);
        int n2 = 0;
        for (String string4 : arrayList) {
            stringArray.setIdentifier(n2++, string4);
        }
        return stringArray;
    }

    public void setSource(Object object) throws PhylogenyParserException, IOException {
        if (object == null) {
            throw new PhylogenyParserException(this.getClass() + ": attempt to parse null object.");
        }
        this._nexus_source = object;
    }
}

