/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers;

import java.io.IOException;
import java.util.List;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.evoinference.matrix.distance.DistanceMatrix;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymmetricalDistanceMatrixParser {
    private static final InputMatrixType INPUT_MATRIX_TYPE_DEFAULT = InputMatrixType.LOWER_TRIANGLE;
    private static final String COMMENT = "#";
    private static final String VALUE_SEPARATOR = " ";
    private int _matrix_size;
    private InputMatrixType _input_matrix_type;

    private SymmetricalDistanceMatrixParser() {
        this.init();
    }

    private void checkValueIsZero(BasicTable<String> basicTable, int n, int n2, int n3) throws IOException {
        double d = 0.0;
        String string = basicTable.getValue(n2, n + n3);
        if (ForesterUtil.isEmpty(string)) {
            throw new IOException("value is null or empty at [" + (n2 - 1) + ", " + n + "]");
        }
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("illegal format for distance [" + string + "] at [" + (n2 - 1) + ", " + n + "]");
        }
        if (!ForesterUtil.isEqual(0.0, d)) {
            throw new IOException("attempt to use non-zero diagonal value [" + string + "] at [" + (n2 - 1) + ", " + n + "]");
        }
    }

    private InputMatrixType getInputMatrixType() {
        return this._input_matrix_type;
    }

    private int getMatrixSize() {
        return this._matrix_size;
    }

    private void init() {
        this.setInputMatrixType(INPUT_MATRIX_TYPE_DEFAULT);
        this.reset();
    }

    public DistanceMatrix[] parse(Object object) throws IOException {
        this.reset();
        List<BasicTable<String>> list = BasicTableParser.parse(object, VALUE_SEPARATOR, false, COMMENT, true);
        DistanceMatrix[] distanceMatrixArray = new DistanceMatrix[list.size()];
        int n = 0;
        for (BasicTable<String> basicTable : list) {
            distanceMatrixArray[n++] = this.transform(basicTable);
        }
        return distanceMatrixArray;
    }

    private void reset() {
        this.setMatrixSize(-1);
    }

    public void setInputMatrixType(InputMatrixType inputMatrixType) {
        this._input_matrix_type = inputMatrixType;
    }

    private void setMatrixSize(int n) {
        this._matrix_size = n;
    }

    private void transferValue(BasicTable<String> basicTable, DistanceMatrix distanceMatrix, int n, int n2, int n3, int n4) throws IOException {
        double d = 0.0;
        String string = basicTable.getValue(n2, n + n3);
        if (ForesterUtil.isEmpty(string)) {
            throw new IOException("value is null or empty at [" + (n2 - 1) + ", " + n + "]");
        }
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("illegal format for distance [" + string + "] at [" + (n2 - 1) + ", " + n + "]");
        }
        distanceMatrix.setValue(n2 - 1 + n4, n, d);
    }

    private DistanceMatrix transform(BasicTable<String> basicTable) throws IllegalArgumentException, IOException {
        boolean bl = false;
        if (basicTable.getNumberOfColumns() < 3) {
            throw new IllegalArgumentException("attempt to create distance matrix with with less than 3 columns [columns: " + basicTable.getNumberOfColumns() + ", rows: " + basicTable.getNumberOfRows() + "]");
        }
        if (basicTable.getNumberOfColumns() == basicTable.getNumberOfRows()) {
            bl = true;
        } else if (basicTable.getNumberOfColumns() != basicTable.getNumberOfRows() + 1) {
            throw new IllegalArgumentException("attempt to create distance matrix with illegal dimensions [columns: " + basicTable.getNumberOfColumns() + ", rows: " + basicTable.getNumberOfRows() + "]");
        }
        BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix = new BasicSymmetricalDistanceMatrix(basicTable.getNumberOfColumns() - 1);
        int n = 0;
        if (bl) {
            n = 1;
        }
        block4: for (int i = 0; i < basicTable.getNumberOfRows() - n; ++i) {
            basicSymmetricalDistanceMatrix.setIdentifier(i, basicTable.getValue(0, i + n));
            switch (this.getInputMatrixType()) {
                case LOWER_TRIANGLE: {
                    int n2;
                    for (n2 = 1; n2 <= i; ++n2) {
                        this.transferValue(basicTable, (DistanceMatrix)basicSymmetricalDistanceMatrix, i, n2, n, 0);
                    }
                    this.checkValueIsZero(basicTable, i, i + 1, n);
                    continue block4;
                }
                case UPPER_TRIANGLE: {
                    int n2;
                    for (n2 = 1; n2 < basicTable.getNumberOfColumns() - i; ++n2) {
                        this.transferValue(basicTable, (DistanceMatrix)basicSymmetricalDistanceMatrix, i, n2, n, i);
                    }
                    continue block4;
                }
                default: {
                    throw new AssertionError((Object)("unkwnown input matrix type [" + (Object)((Object)this.getInputMatrixType()) + "]"));
                }
            }
        }
        if (this.getMatrixSize() < 1) {
            this.setMatrixSize(basicSymmetricalDistanceMatrix.getSize());
        } else if (this.getMatrixSize() != basicSymmetricalDistanceMatrix.getSize()) {
            throw new IOException("attempt to use matrices of unequal size: [" + this.getMatrixSize() + "] vs [" + basicSymmetricalDistanceMatrix.getSize() + "]");
        }
        return basicSymmetricalDistanceMatrix;
    }

    public static SymmetricalDistanceMatrixParser createInstance() {
        return new SymmetricalDistanceMatrixParser();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InputMatrixType {
        UPPER_TRIANGLE,
        LOWER_TRIANGLE;

    }
}

