/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.msa.BasicMsa;
import org.forester.msa.Msa;
import org.forester.msa.MsaFormatException;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.Sequence;

public final class GeneralMsaParser {
    private static final Pattern NAME_SEQ_PATTERN = Pattern.compile("(\\S+)\\s+(\\S+)\\s*");
    private static final Pattern INDENTED_SEQ_PATTERN = Pattern.compile("\\s+(\\S+)\\s*");
    private static final Pattern NON_INDENTED_SEQ_PATTERN = Pattern.compile("(\\S+).*");
    private static final Pattern PROBCONS_REGEX = Pattern.compile("^CLUSTAL\\s");
    private static final Pattern MUSCLE_REGEX = Pattern.compile("^MUSCLE\\s\\(");
    private static final Pattern CLUSTAL_REGEX = Pattern.compile("^PROBCONS\\s");
    private static final Pattern ANYTHING_REGEX = Pattern.compile("[\\d\\s]+");
    private static final Pattern SELEX_SPECIAL_LINES_REGEX = Pattern.compile("\\s+[*\\.:\\s]+");
    private static final Pattern SPECIAL_LINES_REGEX = Pattern.compile("^\\s*(#|%|//|!!)");
    private static final Pattern ERROR_REGEX = Pattern.compile("\\S+\\s+\\S+\\s+\\S+");

    private static boolean canIgnore(String string) {
        if (string.length() < 1 || ANYTHING_REGEX.matcher(string).matches()) {
            return true;
        }
        return SELEX_SPECIAL_LINES_REGEX.matcher(string).matches() || SPECIAL_LINES_REGEX.matcher(string).lookingAt();
    }

    private static boolean isProgramNameLine(String string) {
        return PROBCONS_REGEX.matcher(string).lookingAt() || CLUSTAL_REGEX.matcher(string).lookingAt() || MUSCLE_REGEX.matcher(string).lookingAt();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Msa parse(InputStream inputStream) throws IOException {
        Object object;
        int n = -1;
        int n2 = -1;
        String string = null;
        boolean bl = true;
        boolean bl2 = true;
        HashMap<String, StringBuilder> hashMap = new HashMap<String, StringBuilder>();
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String string2 = null;
        int n3 = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            String string3;
            ++n3;
            if (GeneralMsaParser.canIgnore(string2)) {
                bl = true;
                continue;
            }
            if (bl2 && GeneralMsaParser.isProgramNameLine(string2)) continue;
            if (ERROR_REGEX.matcher(string2).lookingAt()) {
                throw new MsaFormatException("unrecognized msa format (line: " + n3 + "):\n\"" + GeneralMsaParser.trim(string2) + "\"");
            }
            if (GeneralMsaParser.canIgnore(string2)) {
                bl = true;
            }
            object = NAME_SEQ_PATTERN.matcher(string2);
            Matcher matcher = null;
            Matcher matcher2 = null;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = ((Matcher)object).matches();
            if (!bl5 && !(bl3 = (matcher = INDENTED_SEQ_PATTERN.matcher(string2)).matches())) {
                matcher2 = NON_INDENTED_SEQ_PATTERN.matcher(string2);
                bl4 = matcher2.lookingAt();
            }
            if (!bl5 && !bl3) {
                if (!bl4) throw new MsaFormatException("illegal msa format (line: " + n3 + "):\n\"" + GeneralMsaParser.trim(string2) + "\"");
            }
            if (bl) {
                ++n;
                n2 = -1;
                bl = false;
            }
            ++n2;
            if (bl5) {
                string3 = ((Matcher)object).group(1);
                String string4 = ((Matcher)object).group(2);
                if (hashMap.containsKey(string3)) {
                    ((StringBuilder)hashMap.get(string3)).append(string4);
                } else {
                    hashMap.put(string3, new StringBuilder(string4));
                    arrayList.add(string3);
                }
                string = string3;
            } else if (bl3) {
                if (!hashMap.containsKey(string)) throw new MsaFormatException("illegal msa format (line: " + n3 + "):\n\"" + GeneralMsaParser.trim(string2) + "\"");
                ((StringBuilder)hashMap.get(string)).append(matcher.group(1));
            } else if (bl4) {
                if (n == 0) {
                    throw new MsaFormatException("illegal msa format: first block cannot contain un-named sequence (line: " + n3 + "):\n\"" + GeneralMsaParser.trim(string2) + "\"");
                }
                string3 = "";
                try {
                    string3 = (String)arrayList.get(n2);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new MsaFormatException("illegalmsa format (line: " + n3 + "):\n\"" + GeneralMsaParser.trim(string2) + "\"");
                }
                if (!hashMap.containsKey(string3)) throw new MsaFormatException("illegal msa format (line: " + n3 + "):\n\"" + GeneralMsaParser.trim(string2) + "\"");
                ((StringBuilder)hashMap.get(string3)).append(matcher2.group(1));
                string = null;
            }
            if (!bl2) continue;
            bl2 = false;
        }
        object = new ArrayList<Sequence>();
        int n4 = 0;
        while (n4 < arrayList.size()) {
            object.add((Sequence)BasicSequence.createAaSequence(arrayList.get(n4), ((StringBuilder)hashMap.get(arrayList.get(n4))).toString()));
            ++n4;
        }
        return BasicMsa.createInstance(object);
    }

    private static String trim(String string) {
        if (string.length() > 100) {
            return string.substring(0, 100) + " ...";
        }
        return string;
    }
}

