/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.webservices;

import java.util.ArrayList;
import java.util.List;
import org.forester.archaeopteryx.webservices.BasicPhylogeniesWebserviceClient;
import org.forester.archaeopteryx.webservices.PhylogeniesWebserviceClient;
import org.forester.archaeopteryx.webservices.WebservicesManager;
import org.forester.io.parsers.phyloxml.PhyloXmlUtil;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebserviceUtil {
    public static final String TAX_CODE_TO_SCI_NAME = "tax_code_to_sci_name";
    public static final String TREE_FAM_INST = "tree_fam";
    public static final String PFAM_INST = "pfam";
    public static final String TOL_WEBSERVER = "http://tolweb.org/onlinecontributors/app?service=external&page=xml/TreeStructureService&node_id=__query__";
    public static final String TOL_NAME = "Tree of Life";
    public static final String TREE_BASE_NAME = "TreeBASE";
    public static final String TREE_FAM_NAME = "TreeFam";
    public static final String PFAM_NAME = "Pfam";
    public static final String PFAM_SERVER = "http://pfam.janelia.org";

    public static List<PhylogeniesWebserviceClient> createDefaultClients() {
        ArrayList<PhylogeniesWebserviceClient> arrayList = new ArrayList<PhylogeniesWebserviceClient>();
        arrayList.add(new BasicPhylogeniesWebserviceClient(TOL_NAME, "Read Tree from Tree of Life...", "Use ToL webservice to obtain a phylogeny", "Please enter a Tree of Life node identifier\n(Examples: 19386 for Cephalopoda, 2461 for Cnidaria, 2466 for Deuterostomia)", WebservicesManager.WsPhylogenyFormat.TOL_XML_RESPONSE, ForesterUtil.PhylogenyNodeField.TAXONOMY_SCIENTIFIC_NAME, TOL_WEBSERVER, true, "http://tolweb.org", null));
        arrayList.add(new BasicPhylogeniesWebserviceClient(TREE_BASE_NAME, "Read Tree from TreeBASE...", "Use TreeBASE to obtain a phylogeny", "Please enter a TreeBASE tree identifier\n(Examples: 2654, 825, 4931, 2518, 2406, 4934)", WebservicesManager.WsPhylogenyFormat.NEXUS, ForesterUtil.PhylogenyNodeField.TAXONOMY_SCIENTIFIC_NAME, "http://purl.org/phylo/treebase/phylows/tree/TB2:Tr__query__?format=nexus", true, "http://treebase.nescent.org", null));
        arrayList.add(new BasicPhylogeniesWebserviceClient(PFAM_NAME, "Read Gene Tree from Pfam...", "Use  Pfam to obtain a (full) gene tree", "Please enter a Pfam (PF) accession number\n(Examples: 01849 for NAC, 00452 for Bcl-2, 00046 for Homeobox)", WebservicesManager.WsPhylogenyFormat.PFAM, null, "http://pfam.janelia.org/family/tree/download?alnType=full&acc=PF__query__", false, PFAM_SERVER, PFAM_INST));
        arrayList.add(new BasicPhylogeniesWebserviceClient(TREE_FAM_NAME, "Read Full Gene Tree from TreeFam...", "Use TreeFam to obtain a (full) gene tree", "Please enter a TreeFam (TF) accession number\n(Examples: 101004 for Cyclin D, 315938 for Hox, 105310 for Wnt)", WebservicesManager.WsPhylogenyFormat.NHX, null, "http://www.treefam.org/cgi-bin/getdata.pl?ac=TF__query__&f=full.nhx", true, "http://www.treefam.org", TREE_FAM_INST));
        arrayList.add(new BasicPhylogeniesWebserviceClient(TREE_FAM_NAME, "Read Clean Gene Tree from TreeFam...", "Use TreeFam to obtain a (\"clean\") gene tree", "Please enter a TreeFam (TF) accession number\n(Examples: 101004 for Cyclin D, 315938 for Hox, 105310 for Wnt)", WebservicesManager.WsPhylogenyFormat.NHX, null, "http://www.treefam.org/cgi-bin/getdata.pl?ac=TF__query__&f=clean.nhx", true, "http://www.treefam.org", TREE_FAM_INST));
        return arrayList;
    }

    static void extractSpTremblAccFromNodeName(Phylogeny phylogeny, String string) {
        PreorderTreeIterator preorderTreeIterator = new PreorderTreeIterator(phylogeny);
        while (preorderTreeIterator.hasNext()) {
            String string2;
            String string3;
            int n;
            PhylogenyNode phylogenyNode = preorderTreeIterator.next();
            if (ForesterUtil.isEmpty(phylogenyNode.getName()) || (n = (string3 = phylogenyNode.getName()).lastIndexOf("/")) <= 0 || ForesterUtil.isEmpty(string2 = string3.substring(0, n))) continue;
            Sequence sequence = new Sequence();
            Accession accession = new Accession(string2, string);
            sequence.setAccession(accession);
            phylogenyNode.getNodeData().setSequence(sequence);
        }
    }

    public static void processInstructions(PhylogeniesWebserviceClient phylogeniesWebserviceClient, Phylogeny phylogeny) {
        if (phylogeniesWebserviceClient.getProcessingInstructions().equals(TAX_CODE_TO_SCI_NAME)) {
            WebserviceUtil.transferTaxonomyCodeToScientificName(phylogeny);
        } else if (phylogeniesWebserviceClient.getProcessingInstructions().equals(TREE_FAM_INST)) {
            WebserviceUtil.transferInternalTaxonomyCodeToScientificName(phylogeny);
            WebserviceUtil.transferExternalScientificNameToTaxonomyCode(phylogeny);
            WebserviceUtil.transferSequenceNameToSequenceAccession(phylogeny, "ensembl");
            WebserviceUtil.setTaxonomyIdentifierType(phylogeny, "ncbi");
        } else if (phylogeniesWebserviceClient.getProcessingInstructions().equals(PFAM_INST)) {
            WebserviceUtil.extractSpTremblAccFromNodeName(phylogeny, "sptrembl");
        }
    }

    static void setTaxonomyIdentifierType(Phylogeny phylogeny, String string) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasTaxonomy() || phylogenyNode.getNodeData().getTaxonomy().getIdentifier() == null) continue;
            phylogenyNode.getNodeData().getTaxonomy().setIdentifier(new Identifier(phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getValue(), string));
        }
    }

    static void transferExternalScientificNameToTaxonomyCode(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            String string;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.isExternal() || !phylogenyNode.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(string = phylogenyNode.getNodeData().getTaxonomy().getScientificName()) || !PhyloXmlUtil.TAXOMONY_CODE_PATTERN.matcher(string).matches()) continue;
            phylogenyNode.getNodeData().getTaxonomy().setScientificName("");
            phylogenyNode.getNodeData().getTaxonomy().setTaxonomyCode(string);
        }
    }

    static void transferInternalTaxonomyCodeToScientificName(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            String string;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || !phylogenyNode.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(string = phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode())) continue;
            phylogenyNode.getNodeData().getTaxonomy().setScientificName(string);
            phylogenyNode.getNodeData().getTaxonomy().setTaxonomyCode("");
        }
    }

    static void transferSequenceNameToSequenceAccession(Phylogeny phylogeny, String string) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            String string2;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasSequence() || ForesterUtil.isEmpty(string2 = phylogenyNode.getNodeData().getSequence().getName())) continue;
            phylogenyNode.getNodeData().getSequence().setName("");
            phylogenyNode.getNodeData().getSequence().setAccession(new Accession(string2, string));
        }
    }

    static void transferTaxonomyCodeToScientificName(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            String string;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(string = phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode())) continue;
            phylogenyNode.getNodeData().getTaxonomy().setScientificName(string);
            phylogenyNode.getNodeData().getTaxonomy().setTaxonomyCode("");
        }
    }
}

