/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.SortedSet;
import javax.swing.JOptionPane;
import org.forester.analysis.AncestralTaxonomyInference;
import org.forester.analysis.AncestralTaxonomyInferenceException;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.Phylogeny;

public class TaxonomyDataObtainer
implements Runnable {
    private final Phylogeny _phy;
    private final MainFrameApplication _mf;
    private final TreePanel _treepanel;
    private final boolean _delete;

    public TaxonomyDataObtainer(MainFrameApplication mainFrameApplication, TreePanel treePanel, Phylogeny phylogeny, boolean bl) {
        this._phy = phylogeny;
        this._mf = mainFrameApplication;
        this._treepanel = treePanel;
        this._delete = bl;
    }

    public TaxonomyDataObtainer(MainFrameApplication mainFrameApplication, TreePanel treePanel, Phylogeny phylogeny) {
        this._phy = phylogeny;
        this._mf = mainFrameApplication;
        this._treepanel = treePanel;
        this._delete = false;
    }

    private String getBaseUrl() {
        return "http://www.uniprot.org/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        this._mf.getMainPanel().getCurrentTreePanel().setWaitCursor();
        SortedSet<String> sortedSet = null;
        try {
            sortedSet = AncestralTaxonomyInference.obtainDetailedTaxonomicInformation(this._phy, this._delete);
        }
        catch (UnknownHostException unknownHostException) {
            this._mf.getMainPanel().getCurrentTreePanel().setArrowCursor();
            JOptionPane.showMessageDialog(this._mf, "Could not connect to \"" + this.getBaseUrl() + "\"", "Network error during taxonomic information gathering", 0);
            return;
        }
        catch (IOException iOException) {
            this._mf.getMainPanel().getCurrentTreePanel().setArrowCursor();
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(this._mf, iOException.toString(), "Failed to obtain taxonomic information", 0);
            return;
        }
        catch (AncestralTaxonomyInferenceException ancestralTaxonomyInferenceException) {
            this._mf.getMainPanel().getCurrentTreePanel().setArrowCursor();
            ancestralTaxonomyInferenceException.printStackTrace();
            JOptionPane.showMessageDialog(this._mf, ancestralTaxonomyInferenceException.toString(), "Failed to obtain taxonomic information", 0);
            return;
        }
        finally {
            this._mf.getMainPanel().getCurrentTreePanel().setArrowCursor();
        }
        this._treepanel.setTree(this._phy);
        this._mf.showWhole();
        this._treepanel.setEdited(true);
        if (sortedSet != null && sortedSet.size() > 0) {
            int n = sortedSet.size();
            boolean bl = false;
            if (n > 20) {
                bl = true;
                n = 20;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Not all taxonomies could be resolved.\n");
            if (sortedSet.size() == 1) {
                if (this._delete) {
                    stringBuffer.append("The following taxonomy was not found and deleted (if external):\n");
                } else {
                    stringBuffer.append("The following taxonomy was not found:\n");
                }
            } else if (this._delete) {
                stringBuffer.append("The following taxonomies were not found and deleted (if external) (total: " + sortedSet.size() + "):\n");
            } else {
                stringBuffer.append("The following taxonomies were not found (total: " + sortedSet.size() + "):\n");
            }
            int n2 = 0;
            for (String string : sortedSet) {
                if (n2 > 19) break;
                stringBuffer.append(string);
                stringBuffer.append("\n");
                ++n2;
            }
            if (bl) {
                stringBuffer.append("...");
            }
            try {
                JOptionPane.showMessageDialog(this._mf, stringBuffer.toString(), "Taxonomy Tool Completed", 2);
            }
            catch (Exception exception) {}
        } else {
            try {
                JOptionPane.showMessageDialog(this._mf, "Taxonomy tool successfully completed", "Taxonomy Tool Completed", 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void run() {
        this.execute();
    }
}

