/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;
import org.forester.ws.uniprot.DatabaseTools;
import org.forester.ws.uniprot.SequenceDatabaseEntry;
import org.forester.ws.uniprot.UniProtWsTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SequenceDataRetriver
implements Runnable {
    private final Phylogeny _phy;
    private final MainFrameApplication _mf;
    private final TreePanel _treepanel;
    private static final boolean DEBUG = false;

    public SequenceDataRetriver(MainFrameApplication mainFrameApplication, TreePanel treePanel, Phylogeny phylogeny) {
        this._phy = phylogeny;
        this._mf = mainFrameApplication;
        this._treepanel = treePanel;
    }

    private String getBaseUrl() {
        return "http://www.uniprot.org/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        this._mf.getMainPanel().getCurrentTreePanel().setWaitCursor();
        SortedSet<String> sortedSet = null;
        try {
            sortedSet = SequenceDataRetriver.obtainSeqInformation(this._phy);
        }
        catch (UnknownHostException unknownHostException) {
            this._mf.getMainPanel().getCurrentTreePanel().setArrowCursor();
            JOptionPane.showMessageDialog(this._mf, "Could not connect to \"" + this.getBaseUrl() + "\"", "Network error during taxonomic information gathering", 0);
            return;
        }
        catch (IOException iOException) {
            this._mf.getMainPanel().getCurrentTreePanel().setArrowCursor();
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(this._mf, iOException.toString(), "Failed to obtain taxonomic information", 0);
            return;
        }
        finally {
            this._mf.getMainPanel().getCurrentTreePanel().setArrowCursor();
        }
        this._treepanel.setTree(this._phy);
        this._mf.showWhole();
        this._treepanel.setEdited(true);
        if (sortedSet != null && sortedSet.size() > 0) {
            int n = sortedSet.size();
            boolean bl = false;
            if (n > 20) {
                bl = true;
                n = 20;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (sortedSet.size() == 1) {
                stringBuffer.append("Data for the following sequence identifier was not found:\n");
            } else {
                stringBuffer.append("Data for the following sequence identifiers was not found (total: " + sortedSet.size() + "):\n");
            }
            int n2 = 0;
            for (String string : sortedSet) {
                if (n2 > 19) break;
                stringBuffer.append(string);
                stringBuffer.append("\n");
                ++n2;
            }
            if (bl) {
                stringBuffer.append("...");
            }
            try {
                JOptionPane.showMessageDialog(this._mf, stringBuffer.toString(), "Sequence Tool Completed", 2);
            }
            catch (Exception exception) {}
        } else {
            try {
                JOptionPane.showMessageDialog(this._mf, "UniProt sequence tool successfully completed", "UniProt Sequence Tool Completed", 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static SortedSet<String> obtainSeqInformation(Phylogeny phylogeny) throws IOException {
        TreeSet<String> treeSet = new TreeSet<String>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            Sequence sequence = null;
            Taxonomy taxonomy = null;
            sequence = phylogenyNode.getNodeData().isHasSequence() ? phylogenyNode.getNodeData().getSequence() : new Sequence();
            taxonomy = phylogenyNode.getNodeData().isHasTaxonomy() ? phylogenyNode.getNodeData().getTaxonomy() : new Taxonomy();
            String string = null;
            Db db = Db.UNKNOWN;
            if (phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getSource()) && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getValue()) && phylogenyNode.getNodeData().getSequence().getAccession().getValue().toLowerCase().startsWith("uniprot")) {
                string = phylogenyNode.getNodeData().getSequence().getAccession().getValue();
                db = Db.UNIPROT;
            } else if (phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getSource()) && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getValue()) && (phylogenyNode.getNodeData().getSequence().getAccession().getValue().toLowerCase().startsWith("embl") || phylogenyNode.getNodeData().getSequence().getAccession().getValue().toLowerCase().startsWith("ebi"))) {
                string = phylogenyNode.getNodeData().getSequence().getAccession().getValue();
                db = Db.EMBL;
            } else if (!ForesterUtil.isEmpty(phylogenyNode.getName())) {
                string = UniProtWsTools.parseUniProtAccessor(phylogenyNode.getName());
                if (string != null) {
                    db = Db.UNIPROT;
                } else {
                    string = DatabaseTools.parseGenbankAccessor(phylogenyNode.getName());
                    if (string != null) {
                        db = Db.EMBL;
                    }
                }
            }
            if (ForesterUtil.isEmpty(string)) continue;
            SequenceDatabaseEntry sequenceDatabaseEntry = null;
            if (db == Db.UNIPROT) {
                try {
                    sequenceDatabaseEntry = UniProtWsTools.obtainUniProtEntry(string, 200);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (db == Db.EMBL || db == Db.UNIPROT && sequenceDatabaseEntry == null) {
                try {
                    sequenceDatabaseEntry = UniProtWsTools.obtainEmblEntry(string, 200);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                if (db == Db.UNIPROT && sequenceDatabaseEntry != null) {
                    db = Db.EMBL;
                }
            }
            if (sequenceDatabaseEntry != null && !sequenceDatabaseEntry.isEmpty()) {
                if (!ForesterUtil.isEmpty(sequenceDatabaseEntry.getAccession())) {
                    String string2 = null;
                    if (db == Db.EMBL) {
                        string2 = "embl";
                    } else if (db == Db.UNIPROT) {
                        string2 = "uniprot";
                    }
                    sequence.setAccession(new Accession(sequenceDatabaseEntry.getAccession(), string2));
                }
                if (!ForesterUtil.isEmpty(sequenceDatabaseEntry.getSequenceName())) {
                    sequence.setName(sequenceDatabaseEntry.getSequenceName());
                }
                if (!ForesterUtil.isEmpty(sequenceDatabaseEntry.getSequenceSymbol())) {
                    sequence.setSymbol(sequenceDatabaseEntry.getSequenceSymbol());
                }
                if (!ForesterUtil.isEmpty(sequenceDatabaseEntry.getTaxonomyScientificName())) {
                    taxonomy.setScientificName(sequenceDatabaseEntry.getTaxonomyScientificName());
                }
                if (!ForesterUtil.isEmpty(sequenceDatabaseEntry.getTaxonomyIdentifier())) {
                    taxonomy.setIdentifier(new Identifier(sequenceDatabaseEntry.getTaxonomyIdentifier(), "uniprot"));
                }
                phylogenyNode.getNodeData().setTaxonomy(taxonomy);
                phylogenyNode.getNodeData().setSequence(sequence);
                continue;
            }
            treeSet.add(phylogenyNode.getName());
        }
        return treeSet;
    }

    @Override
    public void run() {
        this.execute();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Db {
        UNKNOWN,
        UNIPROT,
        EMBL;

    }
}

