/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.tools.PhylogeneticInferenceOptions;
import org.forester.evoinference.distance.NeighborJoining;
import org.forester.evoinference.distance.PairwiseDistanceCalculator;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.evoinference.matrix.distance.DistanceMatrix;
import org.forester.evoinference.tools.BootstrapResampler;
import org.forester.io.parsers.FastaParser;
import org.forester.io.writers.SequenceWriter;
import org.forester.msa.BasicMsa;
import org.forester.msa.Mafft;
import org.forester.msa.Msa;
import org.forester.msa.MsaInferrer;
import org.forester.msa.MsaTools;
import org.forester.msa.ResampleableMsa;
import org.forester.phylogeny.Phylogeny;
import org.forester.sequence.Sequence;
import org.forester.tools.ConfidenceAssessor;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhylogeneticInferrer
implements Runnable {
    private Msa _msa;
    private final MainFrameApplication _mf;
    private final PhylogeneticInferenceOptions _options;
    private final List<Sequence> _seqs;
    public static final String MSA_FILE_SUFFIX = ".aln";
    public static final String PWD_FILE_SUFFIX = ".pwd";

    public PhylogeneticInferrer(List<Sequence> list, PhylogeneticInferenceOptions phylogeneticInferenceOptions, MainFrameApplication mainFrameApplication) {
        this._msa = null;
        this._seqs = list;
        this._mf = mainFrameApplication;
        this._options = phylogeneticInferenceOptions;
    }

    public PhylogeneticInferrer(Msa msa, PhylogeneticInferenceOptions phylogeneticInferenceOptions, MainFrameApplication mainFrameApplication) {
        this._msa = msa;
        this._seqs = null;
        this._mf = mainFrameApplication;
        this._options = phylogeneticInferenceOptions;
    }

    private Msa inferMsa() throws IOException {
        File file = File.createTempFile("aptx", ".fasta");
        System.out.println("temp file: " + file);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        SequenceWriter.writeSeqs(this._seqs, bufferedWriter, SequenceWriter.SEQ_FORMAT.FASTA, 100);
        bufferedWriter.close();
        List<String> list = this.processMafftOptions();
        Msa msa = null;
        try {
            msa = this.runMAFFT(file, list);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return msa;
    }

    private List<String> processMafftOptions() {
        String string = this._options.getMsaPrgParameters().trim().toLowerCase();
        String[] stringArray = string.split(" ");
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (String string2 : stringArray) {
            arrayList.add(string2);
            if (!string2.equals("--quiet")) continue;
            bl = true;
        }
        if (!bl) {
            arrayList.add("--quiet");
        }
        return arrayList;
    }

    private Phylogeny inferPhylogeny(Msa msa) {
        Object object;
        BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix = null;
        switch (this._options.getPwdDistanceMethod()) {
            case KIMURA_DISTANCE: {
                basicSymmetricalDistanceMatrix = PairwiseDistanceCalculator.calcKimuraDistances((Msa)msa);
                break;
            }
            case POISSON_DISTANCE: {
                basicSymmetricalDistanceMatrix = PairwiseDistanceCalculator.calcPoissonDistances((Msa)msa);
                break;
            }
            case FRACTIONAL_DISSIMILARITY: {
                basicSymmetricalDistanceMatrix = PairwiseDistanceCalculator.calcFractionalDissimilarities((Msa)msa);
                break;
            }
            default: {
                throw new RuntimeException("invalid pwd method");
            }
        }
        if (!ForesterUtil.isEmpty(this._options.getIntermediateFilesBase())) {
            try {
                object = new BufferedWriter(new FileWriter(this._options.getIntermediateFilesBase() + PWD_FILE_SUFFIX));
                basicSymmetricalDistanceMatrix.write((Writer)object);
                ((BufferedWriter)object).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        object = new NeighborJoining();
        Phylogeny phylogeny = object.execute((DistanceMatrix)basicSymmetricalDistanceMatrix);
        FastaParser.extractFastaInformation(phylogeny);
        return phylogeny;
    }

    private void infer() {
        if (this._msa == null && this._seqs == null) {
            throw new IllegalArgumentException("cannot run phylogenetic analysis with null msa and seq array");
        }
        if (this._msa == null) {
            Msa msa = null;
            try {
                msa = this.inferMsa();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this._mf, "Could not create multiple sequence alignment with " + this._options.getMsaPrg() + "\nand the following parameters:\n\"" + this._options.getMsaPrgParameters() + "\"\nError:" + iOException.getLocalizedMessage(), "Failed to Calculate MSA", 0);
                return;
            }
            if (msa == null) {
                JOptionPane.showMessageDialog(this._mf, "Could not create multiple sequence alignment with " + this._options.getMsaPrg() + "\nand the following parameters:\n\"" + this._options.getMsaPrgParameters() + "\"", "Failed to Calculate MSA", 0);
                return;
            }
            System.out.println(msa.toString());
            System.out.println(((Object)MsaTools.calcBasicGapinessStatistics(msa)).toString());
            MsaTools msaTools = MsaTools.createInstance();
            if (this._options.isExecuteMsaProcessing() && (msa = msaTools.removeGapColumns(this._options.getMsaProcessingMaxAllowedGapRatio(), this._options.getMsaProcessingMinAllowedLength(), msa)) == null) {
                JOptionPane.showMessageDialog(this._mf, "Less than two sequences longer than " + this._options.getMsaProcessingMinAllowedLength() + " residues left after MSA processing", "MSA Processing Settings Too Stringent", 0);
                return;
            }
            System.out.println(msaTools.getIgnoredSequenceIds());
            System.out.println(msa.toString());
            System.out.println(((Object)MsaTools.calcBasicGapinessStatistics(msa)).toString());
            this._msa = msa;
        }
        int n = this._options.getBootstrapSamples();
        long l = this._options.getRandomNumberGeneratorSeed();
        Phylogeny phylogeny = this.inferPhylogeny(this._msa);
        if (this._options.isPerformBootstrapResampling() && n > 0) {
            ResampleableMsa resampleableMsa = new ResampleableMsa((BasicMsa)this._msa);
            int[][] nArray = BootstrapResampler.createResampledColumnPositions((int)this._msa.getLength(), (int)n, (long)l);
            Phylogeny[] phylogenyArray = new Phylogeny[n];
            for (int i = 0; i < n; ++i) {
                resampleableMsa.resample(nArray[i]);
                phylogenyArray[i] = this.inferPhylogeny(resampleableMsa);
            }
            ConfidenceAssessor.evaluate((String)"bootstrap", (Phylogeny[])phylogenyArray, (Phylogeny)phylogeny, (boolean)true, (double)1.0);
        }
        this._mf.getMainPanel().addPhylogenyInNewTab(phylogeny, this._mf.getConfiguration(), "nj", "njpath");
        this._mf.getMainPanel().getCurrentTreePanel().setArrowCursor();
        JOptionPane.showMessageDialog(this._mf, "Inference successfully completed", "Inference Completed", 1);
    }

    @Override
    public void run() {
        this.infer();
    }

    private Msa runMAFFT(File file, List<String> list) throws IOException, InterruptedException {
        Msa msa = null;
        MsaInferrer msaInferrer = Mafft.createInstance();
        try {
            msa = msaInferrer.infer(file, list);
        }
        catch (IOException iOException) {
            System.out.println(msaInferrer.getErrorDescription());
        }
        return msa;
    }

    private void writeToFiles(BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix) {
        if (!ForesterUtil.isEmpty(this._options.getIntermediateFilesBase())) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this._options.getIntermediateFilesBase() + MSA_FILE_SUFFIX));
                this._msa.write(bufferedWriter);
                bufferedWriter.close();
                BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter(this._options.getIntermediateFilesBase() + PWD_FILE_SUFFIX));
                basicSymmetricalDistanceMatrix.write((Writer)bufferedWriter2);
                bufferedWriter2.close();
            }
            catch (Exception exception) {
                System.out.println("Error: " + exception.getMessage());
            }
        }
    }
}

