/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.net.UnknownHostException;
import javax.swing.JOptionPane;
import org.forester.analysis.AncestralTaxonomyInference;
import org.forester.analysis.AncestralTaxonomyInferenceException;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.Phylogeny;

public class AncestralTaxonomyInferrer
implements Runnable {
    private final Phylogeny _phy;
    private final MainFrameApplication _mf;
    private final TreePanel _treepanel;

    public AncestralTaxonomyInferrer(MainFrameApplication mainFrameApplication, TreePanel treePanel, Phylogeny phylogeny) {
        this._phy = phylogeny;
        this._mf = mainFrameApplication;
        this._treepanel = treePanel;
    }

    private String getBaseUrl() {
        return "http://www.uniprot.org/";
    }

    private void inferTaxonomies() {
        this._mf.getMainPanel().getCurrentTreePanel().setWaitCursor();
        try {
            AncestralTaxonomyInference.inferTaxonomyFromDescendents(this._phy);
        }
        catch (AncestralTaxonomyInferenceException ancestralTaxonomyInferenceException) {
            this._mf.getMainPanel().getCurrentTreePanel().setArrowCursor();
            JOptionPane.showMessageDialog(this._mf, ancestralTaxonomyInferenceException.getMessage(), "Error during ancestral taxonomy inference", 0);
            return;
        }
        catch (UnknownHostException unknownHostException) {
            this._mf.getMainPanel().getCurrentTreePanel().setArrowCursor();
            JOptionPane.showMessageDialog(this._mf, "Could not connect to \"" + this.getBaseUrl() + "\"", "Network error during ancestral taxonomy inference", 0);
            return;
        }
        catch (Exception exception) {
            this._mf.getMainPanel().getCurrentTreePanel().setArrowCursor();
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this._mf, exception.toString(), "Unexpected error during ancestral taxonomy inference", 0);
            return;
        }
        this._mf.getMainPanel().getCurrentTreePanel().setArrowCursor();
        this._phy.setRerootable(false);
        this._treepanel.setTree(this._phy);
        this._mf.showWhole();
        this._treepanel.setEdited(true);
        try {
            JOptionPane.showMessageDialog(this._mf, "Ancestral taxonomy inference successfully completed", "Ancestral Taxonomy Inference Completed", 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        this.inferTaxonomies();
    }
}

