/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.phylogeny.data;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.phylogeny.data.RenderablePhylogenyData;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RenderableVector
implements RenderablePhylogenyData {
    public static final int DEFAULT_HEIGHT = 12;
    public static final int DEFAULT_WIDTH = 120;
    private double _rendering_factor_width = 1.0;
    private List<Double> _values = null;
    private final Rectangle2D _rectangle = new Rectangle2D.Float();
    private Configuration _configuration = null;
    private double _height;
    private double _min;
    private double _max;
    private double _mean;
    private static RenderableVector _instance = null;

    public static RenderableVector createInstance(List<Double> list, DescriptiveStatistics descriptiveStatistics, Configuration configuration) {
        if (_instance == null) {
            _instance = new RenderableVector();
        }
        _instance.setRenderingHeight(12.0);
        RenderableVector._instance._values = list;
        RenderableVector._instance._configuration = configuration;
        RenderableVector._instance._min = descriptiveStatistics.getMin();
        RenderableVector._instance._max = descriptiveStatistics.getMax();
        RenderableVector._instance._mean = descriptiveStatistics.arithmeticMean();
        return _instance;
    }

    public Object clone() {
        throw new NoSuchMethodError();
    }

    private RenderableVector() {
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this._values.toString());
    }

    @Override
    public StringBuffer asText() {
        return this.asSimpleText();
    }

    public double getRenderingFactorWidth() {
        return this._rendering_factor_width;
    }

    public int getTotalLength() {
        return (int)((double)this._values.size() * this.getRenderingHeight());
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        throw new NoSuchMethodError();
    }

    @Override
    public void render(double d, double d2, Graphics2D graphics2D, TreePanel treePanel, boolean bl) {
        double d3 = d2;
        double d4 = d + 20.0;
        double d5 = 120.0 / (double)this._values.size();
        for (int i = 0; i < this._values.size(); ++i) {
            graphics2D.setColor(this.calculateColor(this._values.get(i)));
            this._rectangle.setFrame(d4 + (double)i * d5, d3 - 0.5, d5, this.getRenderingHeight());
            graphics2D.fill(this._rectangle);
        }
    }

    private Color calculateColor(double d) {
        return ForesterUtil.calcColor(d, this._min, this._max, this._mean, Color.MAGENTA, Color.GREEN, Color.WHITE);
    }

    public void setRenderingFactorWidth(double d) {
        this._rendering_factor_width = d;
    }

    @Override
    public StringBuffer toNHX() {
        throw new NoSuchMethodError();
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        throw new NoSuchMethodError();
    }

    @Override
    public PhylogenyData copy() {
        throw new NoSuchMethodError();
    }

    @Override
    public Dimension getOriginalSize() {
        return new Dimension(this.getTotalLength(), (int)this.getRenderingHeight());
    }

    @Override
    public Object getParameter() {
        return null;
    }

    @Override
    public Dimension getRenderingSize() {
        return this.getOriginalSize();
    }

    @Override
    public void setParameter(double d) {
        throw new NoSuchMethodError();
    }

    @Override
    public void setRenderingHeight(double d) {
        this._height = d;
    }

    private double getRenderingHeight() {
        return this._height;
    }
}

