/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import org.forester.archaeopteryx.ArchaeopteryxE;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.ControlPanel;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.MainPanelApplets;
import org.forester.archaeopteryx.MouseListener;
import org.forester.archaeopteryx.NodeFrame;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreeColorSet;
import org.forester.archaeopteryx.TreeFontSet;
import org.forester.archaeopteryx.Util;
import org.forester.archaeopteryx.WebLink;
import org.forester.archaeopteryx.phylogeny.data.RenderableDomainArchitecture;
import org.forester.archaeopteryx.phylogeny.data.RenderablePhylogenyData;
import org.forester.archaeopteryx.phylogeny.data.RenderableVector;
import org.forester.archaeopteryx.tools.Blast;
import org.forester.archaeopteryx.tools.ImageLoader;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.NodeVisualization;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PropertiesMap;
import org.forester.phylogeny.data.Property;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.SequenceRelation;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.data.Uri;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreePanel
extends JPanel
implements ActionListener,
MouseWheelListener,
Printable {
    private static final float PI = (float)Math.PI;
    private static final double TWO_PI = Math.PI * 2;
    private static final float ONEHALF_PI = 4.712389f;
    private static final float HALF_PI = 1.5707964f;
    private static final float ANGLE_ROTATION_UNIT = 0.09817477f;
    private static final short OV_BORDER = 10;
    static final Cursor CUT_CURSOR = Cursor.getPredefinedCursor(1);
    static final Cursor MOVE_CURSOR = Cursor.getPredefinedCursor(13);
    static final Cursor ARROW_CURSOR = Cursor.getPredefinedCursor(0);
    static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    static final Cursor WAIT_CURSOR = Cursor.getPredefinedCursor(3);
    private static final long serialVersionUID = -978349745916505029L;
    private static final int EURO_D = 10;
    private static final String NODE_POPMENU_NODE_CLIENT_PROPERTY = "node";
    private static final int MIN_ROOT_LENGTH = 3;
    private static final int MAX_SUBTREES = 100;
    private static final int MAX_NODE_FRAMES = 10;
    private static final int MOVE = 20;
    private static final NumberFormat FORMATTER_CONFIDENCE;
    private static final NumberFormat FORMATTER_BRANCH_LENGTH;
    private static final int WIGGLE = 2;
    private static final int LIMIT_FOR_HQ_RENDERING = 1000;
    private static final int CONFIDENCE_LEFT_MARGIN = 4;
    private final RenderingHints _rendering_hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
    private File _treefile = null;
    private Configuration _configuration = null;
    private final NodeFrame[] _node_frames = new NodeFrame[10];
    private int _node_frame_index = 0;
    private Phylogeny _phylogeny = null;
    private final Phylogeny[] _sub_phylogenies = new Phylogeny[100];
    private final PhylogenyNode[] _sub_phylogenies_temp_roots = new PhylogenyNode[100];
    private int _subtree_index = 0;
    private MainPanel _main_panel = null;
    private Set<Integer> _found_nodes = null;
    private PhylogenyNode _highlight_node = null;
    private JPopupMenu _node_popup_menu = null;
    private JMenuItem[] _node_popup_menu_items = null;
    private int _longest_ext_node_info = 0;
    private float _x_correction_factor = 0.0f;
    private float _ov_x_correction_factor = 0.0f;
    private float _x_distance = 0.0f;
    private float _y_distance = 0.0f;
    private Options.PHYLOGENY_GRAPHICS_TYPE _graphics_type = Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR;
    private double _domain_structure_width = 200.0;
    private int _domain_structure_e_value_thr_exp = 0;
    private float _last_drag_point_x = 0.0f;
    private float _last_drag_point_y = 0.0f;
    private ControlPanel _control_panel = null;
    private int _external_node_index = 0;
    private final Polygon _polygon = new Polygon();
    private final StringBuilder _sb = new StringBuilder();
    private JColorChooser _color_chooser = null;
    private double _scale_distance = 0.0;
    private String _scale_label = null;
    private final CubicCurve2D _cubic_curve = new CubicCurve2D.Float();
    private final QuadCurve2D _quad_curve = new QuadCurve2D.Float();
    private final Line2D _line = new Line2D.Float();
    private final Ellipse2D _ellipse = new Ellipse2D.Float();
    private final Rectangle2D _rectangle = new Rectangle2D.Float();
    private Options _options = null;
    private float _ov_max_width = 0.0f;
    private float _ov_max_height = 0.0f;
    private int _ov_x_position = 0;
    private int _ov_y_position = 0;
    private int _ov_y_start = 0;
    private float _ov_y_distance = 0.0f;
    private float _ov_x_distance = 0.0f;
    private boolean _ov_on = false;
    private double _urt_starting_angle = 1.5707963705062866;
    private float _urt_factor = 1.0f;
    private float _urt_factor_ov = 1.0f;
    private final boolean _phy_has_branch_lengths;
    private final Rectangle2D _ov_rectangle = new Rectangle2D.Float();
    private boolean _in_ov_rect = false;
    private boolean _in_ov = false;
    private final Rectangle _ov_virtual_rectangle = new Rectangle();
    private static final double _180_OVER_PI = 57.29577951308232;
    private static final float ROUNDED_D = 8.0f;
    private int _circ_max_depth;
    private PhylogenyNode _root;
    private final Arc2D _arc = new Arc2D.Double();
    private final HashMap<Integer, Double> _urt_nodeid_angle_map = new HashMap();
    private final HashMap<Integer, Integer> _urt_nodeid_index_map = new HashMap();
    private final Set<Integer> _collapsed_external_nodeid_set = new HashSet<Integer>();
    HashMap<Integer, Short> _nodeid_dist_to_leaf = new HashMap();
    private AffineTransform _at;
    private double _max_distance_to_root = -1.0;
    private int _dynamic_hiding_factor = 0;
    private boolean _edited = false;
    private Popup _node_desc_popup;
    private JTextArea _rollover_popup;
    private final StringBuffer _popup_buffer = new StringBuffer();
    private static final Font POPUP_FONT;
    private static final boolean DRAW_MEAN_COUNTS = true;
    private Sequence _query_sequence = null;
    private final FontRenderContext _frc = new FontRenderContext(null, false, false);
    private DescriptiveStatistics _statistics_for_vector_data;
    private PhylogenyNode[] _nodes_in_preorder = null;

    TreePanel(Phylogeny phylogeny, Configuration configuration, MainPanel mainPanel) {
        this.requestFocusInWindow();
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                TreePanel.this.keyPressedCalls(keyEvent);
                TreePanel.this.requestFocusInWindow();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                TreePanel.this.requestFocusInWindow();
            }
        });
        if (phylogeny == null || phylogeny.isEmpty()) {
            throw new IllegalArgumentException("attempt to draw phylogeny which is null or empty");
        }
        this._graphics_type = mainPanel.getOptions().getPhylogenyGraphicsType();
        this._main_panel = mainPanel;
        this._configuration = configuration;
        this._phylogeny = phylogeny;
        this._phy_has_branch_lengths = ForesterUtil.isHasAtLeastOneBranchLengthLargerThanZero(this._phylogeny);
        this.init();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.checkForVectorProperties(this._phylogeny);
        this.setBackground(this.getTreeColorSet().getBackgroundColor());
        MouseListener mouseListener = new MouseListener(this);
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
        this.addMouseWheelListener(this);
        this.calculateScaleDistance();
        FORMATTER_CONFIDENCE.setMaximumFractionDigits(configuration.getNumberOfDigitsAfterCommaForConfidenceValues());
        FORMATTER_BRANCH_LENGTH.setMaximumFractionDigits(configuration.getNumberOfDigitsAfterCommaForBranchLengthValues());
    }

    public void checkForVectorProperties(Phylogeny phylogeny) {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.getNodeData().getProperties() == null) continue;
            PropertiesMap propertiesMap = phylogenyNode.getNodeData().getProperties();
            double[] dArray = new double[propertiesMap.getProperties().size()];
            int n = 0;
            for (String string : propertiesMap.getProperties().keySet()) {
                if (!string.startsWith("vector:index=")) continue;
                Property property = propertiesMap.getProperty(string);
                String string2 = property.getValue();
                String string3 = string.substring("vector:index=".length(), string.length());
                double d = -100.0;
                try {
                    d = Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Could not parse \"" + string2 + "\" into a decimal value", "Problem with Vector Data", 0);
                    return;
                }
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Could not parse \"" + string3 + "\" into index for vector data", "Problem with Vector Data", 0);
                    return;
                }
                if (n2 < 0) {
                    JOptionPane.showMessageDialog(this, "Attempt to use negative index for vector data", "Problem with Vector Data", 0);
                    return;
                }
                dArray[n2] = d;
                ++n;
                basicDescriptiveStatistics.addValue(d);
            }
            ArrayList arrayList = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(dArray[i]);
            }
            phylogenyNode.getNodeData().setVector(arrayList);
        }
        if (basicDescriptiveStatistics.getN() > 0) {
            this._statistics_for_vector_data = basicDescriptiveStatistics;
        }
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        for (int i = 0; i < this._node_popup_menu_items.length && !bl; ++i) {
            if (jMenuItem != this._node_popup_menu_items[i]) continue;
            this._main_panel.getControlPanel().setClickToAction(i);
            PhylogenyNode phylogenyNode = (PhylogenyNode)this._node_popup_menu.getClientProperty(NODE_POPMENU_NODE_CLIENT_PROPERTY);
            this.handleClickToAction(this._control_panel.getActionWhenNodeClicked(), phylogenyNode);
            bl = true;
        }
        this.repaint();
        this.requestFocusInWindow();
    }

    private final void addEmptyNode(PhylogenyNode phylogenyNode) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            this.errorMessageNoCutCopyPasteInUnrootedDisplay();
            return;
        }
        String string = this.getASimpleTextRepresentationOfANode(phylogenyNode);
        String string2 = "";
        string2 = ForesterUtil.isEmpty(string) ? "How to add the new, empty node?" : "How to add the new, empty node to node" + string + "?";
        Object[] objectArray = new Object[]{"As sibling", "As descendant", "Cancel"};
        int n = JOptionPane.showOptionDialog(this, string2, "Addition of Empty New Node", -1, 3, null, objectArray, objectArray[2]);
        boolean bl = true;
        if (n == 1) {
            bl = false;
        } else if (n != 0) {
            return;
        }
        Phylogeny phylogeny = new Phylogeny();
        phylogeny.setRoot(new PhylogenyNode());
        phylogeny.setRooted(true);
        if (bl) {
            if (phylogenyNode.isRoot()) {
                JOptionPane.showMessageDialog(this, "Cannot add sibling to root", "Attempt to add sibling to root", 0);
                return;
            }
            phylogeny.addAsSibling(phylogenyNode);
        } else {
            phylogeny.addAsChild(phylogenyNode);
        }
        this._nodes_in_preorder = null;
        this._phylogeny.externalNodesHaveChanged();
        this._phylogeny.hashIDs();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.setEdited(true);
        this.repaint();
    }

    private final void assignGraphicsForBranchWithColorForParentBranch(PhylogenyNode phylogenyNode, boolean bl, Graphics graphics, boolean bl2, boolean bl3) {
        ControlPanel.NodeClickAction nodeClickAction = this._control_panel.getActionWhenNodeClicked();
        if ((bl2 || bl3) && this.getOptions().isPrintBlackAndWhite()) {
            graphics.setColor(Color.BLACK);
        } else if (!(nodeClickAction != ControlPanel.NodeClickAction.COPY_SUBTREE && nodeClickAction != ControlPanel.NodeClickAction.CUT_SUBTREE && nodeClickAction != ControlPanel.NodeClickAction.DELETE_NODE_OR_SUBTREE && nodeClickAction != ControlPanel.NodeClickAction.PASTE_SUBTREE && nodeClickAction != ControlPanel.NodeClickAction.ADD_NEW_NODE || this.getCutOrCopiedTree() == null || this.getCopiedAndPastedNodes() == null || bl2 || bl3 || !this.getCopiedAndPastedNodes().contains(phylogenyNode.getId()))) {
            graphics.setColor(this.getTreeColorSet().getFoundColor());
        } else if (this.getControlPanel().isColorBranches() && PhylogenyMethods.getBranchColorValue(phylogenyNode) != null) {
            graphics.setColor(PhylogenyMethods.getBranchColorValue(phylogenyNode));
        } else if (bl2) {
            graphics.setColor(this.getTreeColorSet().getBranchColorForPdf());
        } else {
            graphics.setColor(this.getTreeColorSet().getBranchColor());
        }
    }

    final Color getGraphicsForNodeBoxWithColorForParentBranch(PhylogenyNode phylogenyNode) {
        if (this.getControlPanel().isColorBranches() && PhylogenyMethods.getBranchColorValue(phylogenyNode) != null) {
            return PhylogenyMethods.getBranchColorValue(phylogenyNode);
        }
        return this.getTreeColorSet().getBranchColor();
    }

    private final void blast(PhylogenyNode phylogenyNode) {
        if (!this.isCanBlast(phylogenyNode)) {
            JOptionPane.showMessageDialog(this, "No sequence information present", "Cannot Blast", 2);
            return;
        }
        if (phylogenyNode.getNodeData().isHasSequence()) {
            String string = "";
            if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getName())) {
                string = phylogenyNode.getNodeData().getSequence().getName();
            } else if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getSymbol())) {
                string = phylogenyNode.getNodeData().getSequence().getSymbol();
            } else if (phylogenyNode.getNodeData().getSequence().getAccession() != null) {
                string = phylogenyNode.getNodeData().getSequence().getAccession().getValue();
            }
            if (!ForesterUtil.isEmpty(string)) {
                try {
                    System.out.println("trying: " + string);
                    Blast blast = new Blast();
                    blast.go(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    final void calcMaxDepth() {
        if (this._phylogeny != null) {
            this._circ_max_depth = PhylogenyMethods.calculateMaxDepth(this._phylogeny);
        }
    }

    private final float calculateBranchLengthToParent(PhylogenyNode phylogenyNode, float f) {
        if (this.getControlPanel().isDrawPhylogram()) {
            if (phylogenyNode.getDistanceToParent() < 0.0) {
                return 0.0f;
            }
            return (float)((double)this.getXcorrectionFactor() * phylogenyNode.getDistanceToParent());
        }
        if (f == 0.0f || this.isNonLinedUpCladogram()) {
            return this.getXdistance();
        }
        return this.getXdistance() * f;
    }

    private final Color calculateColorForAnnotation(PhylogenyData phylogenyData) {
        Color color = this.getTreeColorSet().getAnnotationColor();
        if (this.getControlPanel().isColorAccordingToAnnotation() && this.getControlPanel().getAnnotationColors() != null && (color = this.getControlPanel().getAnnotationColors().get(phylogenyData.asSimpleText().toString())) == null) {
            color = this.getTreeColorSet().getAnnotationColor();
        }
        return color;
    }

    final void calculateLongestExtNodeInfo() {
        if (this._phylogeny == null || this._phylogeny.isEmpty()) {
            return;
        }
        int n = 20;
        for (PhylogenyNode phylogenyNode : this._phylogeny.getExternalNodes()) {
            int n2 = 0;
            if (phylogenyNode.isCollapse()) continue;
            if (this.getControlPanel().isShowNodeNames()) {
                n2 += this.getTreeFontSet()._fm_large.stringWidth(phylogenyNode.getName() + " ");
            }
            if (phylogenyNode.getNodeData().isHasSequence()) {
                if (this.getControlPanel().isShowSequenceAcc() && phylogenyNode.getNodeData().getSequence().getAccession() != null) {
                    n2 += this.getTreeFontSet()._fm_large.stringWidth(phylogenyNode.getNodeData().getSequence().getAccession().getValue() + " ");
                }
                if (this.getControlPanel().isShowGeneNames() && phylogenyNode.getNodeData().getSequence().getName().length() > 0) {
                    n2 += this.getTreeFontSet()._fm_large.stringWidth(phylogenyNode.getNodeData().getSequence().getName() + " ");
                }
                if (this.getControlPanel().isShowGeneSymbols() && phylogenyNode.getNodeData().getSequence().getSymbol().length() > 0) {
                    n2 += this.getTreeFontSet()._fm_large.stringWidth(phylogenyNode.getNodeData().getSequence().getSymbol() + " ");
                }
                if (this.getControlPanel().isShowAnnotation() && phylogenyNode.getNodeData().getSequence().getAnnotations() != null && !phylogenyNode.getNodeData().getSequence().getAnnotations().isEmpty()) {
                    n2 += this.getTreeFontSet()._fm_large.stringWidth(phylogenyNode.getNodeData().getSequence().getAnnotation(0).asSimpleText() + " ");
                }
            }
            if (phylogenyNode.getNodeData().isHasTaxonomy()) {
                Taxonomy taxonomy = phylogenyNode.getNodeData().getTaxonomy();
                if (this.getControlPanel().isShowTaxonomyCode() && !ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
                    n2 += this.getTreeFontSet()._fm_large_italic.stringWidth(taxonomy.getTaxonomyCode() + " ");
                }
                if (this.getControlPanel().isShowTaxonomyScientificNames() && !ForesterUtil.isEmpty(taxonomy.getScientificName())) {
                    n2 += this.getTreeFontSet()._fm_large_italic.stringWidth(taxonomy.getScientificName() + " ");
                }
                if (this.getControlPanel().isShowTaxonomyCommonNames() && !ForesterUtil.isEmpty(taxonomy.getCommonName())) {
                    n2 += this.getTreeFontSet()._fm_large_italic.stringWidth(taxonomy.getCommonName() + " ()");
                }
            }
            if (this.getControlPanel().isShowProperties() && phylogenyNode.getNodeData().isHasProperties()) {
                n2 += this.getTreeFontSet()._fm_large.stringWidth(this.propertiesToString(phylogenyNode).toString());
            }
            if (this.getControlPanel().isShowBinaryCharacters() && phylogenyNode.getNodeData().isHasBinaryCharacters()) {
                n2 += this.getTreeFontSet()._fm_large.stringWidth(phylogenyNode.getNodeData().getBinaryCharacters().getGainedCharactersAsStringBuffer().toString());
            }
            if (this.getControlPanel().isShowDomainArchitectures() && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getDomainArchitecture() != null) {
                n2 = (int)((double)n2 + ((RenderableDomainArchitecture)phylogenyNode.getNodeData().getSequence().getDomainArchitecture()).getRenderingSize().getWidth());
            }
            if (n2 >= 300) {
                this.setLongestExtNodeInfo(300);
                return;
            }
            if (n2 <= n) continue;
            n = n2;
        }
        if (n >= 300) {
            this.setLongestExtNodeInfo(300);
        } else {
            this.setLongestExtNodeInfo(n);
        }
    }

    private final float calculateOvBranchLengthToParent(PhylogenyNode phylogenyNode, int n) {
        if (this.getControlPanel().isDrawPhylogram()) {
            if (phylogenyNode.getDistanceToParent() < 0.0) {
                return 0.0f;
            }
            return (float)((double)this.getOvXcorrectionFactor() * phylogenyNode.getDistanceToParent());
        }
        if (n == 0 || this.isNonLinedUpCladogram()) {
            return this.getOvXDistance();
        }
        return this.getOvXDistance() * (float)n;
    }

    final void calculateScaleDistance() {
        if (this._phylogeny == null || this._phylogeny.isEmpty()) {
            return;
        }
        double d = this.getMaxDistanceToRoot();
        if (d > 0.0) {
            if (d <= 0.5) {
                this.setScaleDistance(0.01);
            } else if (d <= 5.0) {
                this.setScaleDistance(0.1);
            } else if (d <= 50.0) {
                this.setScaleDistance(1.0);
            } else if (d <= 500.0) {
                this.setScaleDistance(10.0);
            } else {
                this.setScaleDistance(100.0);
            }
        } else {
            this.setScaleDistance(0.0);
        }
        String string = String.valueOf(this.getScaleDistance());
        if (!ForesterUtil.isEmpty(this._phylogeny.getDistanceUnit())) {
            string = string + " [" + this._phylogeny.getDistanceUnit() + "]";
        }
        this.setScaleLabel(string);
    }

    final Color calculateTaxonomyBasedColor(Taxonomy taxonomy) {
        String string = taxonomy.getTaxonomyCode();
        if (ForesterUtil.isEmpty(string) && ForesterUtil.isEmpty(string = taxonomy.getScientificName())) {
            string = taxonomy.getCommonName();
        }
        if (ForesterUtil.isEmpty(string)) {
            return this.getTreeColorSet().getTaxonomyColor();
        }
        Color color = this.getControlPanel().getSpeciesColors().get(string);
        if (color == null) {
            color = Util.calculateColorFromString(string);
            this.getControlPanel().getSpeciesColors().put(string, color);
        }
        return color;
    }

    private final void cannotOpenBrowserWarningMessage(String string) {
        JOptionPane.showMessageDialog(this, "Cannot launch web browser for " + string + " data of this node", "Cannot launch web browser", 2);
    }

    final void collapse(PhylogenyNode phylogenyNode) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            JOptionPane.showMessageDialog(this, "Cannot collapse in unrooted display type", "Attempt to collapse in unrooted display", 2);
            return;
        }
        if (!phylogenyNode.isExternal() && !phylogenyNode.isRoot()) {
            boolean bl = !phylogenyNode.isCollapse();
            Util.collapseSubtree(phylogenyNode, bl);
            this.updateSetOfCollapsedExternalNodes(this._phylogeny);
            this._phylogeny.recalculateNumberOfExternalDescendants(true);
            this.resetNodeIdToDistToLeafMap();
            this.calculateLongestExtNodeInfo();
            this._nodes_in_preorder = null;
            this.resetPreferredSize();
            this.updateOvSizes();
            this._main_panel.adjustJScrollPane();
            this.repaint();
        }
    }

    final void collapseSpeciesSpecificSubtrees() {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        this.setWaitCursor();
        Util.collapseSpeciesSpecificSubtrees(this._phylogeny);
        this.updateSetOfCollapsedExternalNodes(this._phylogeny);
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.calculateLongestExtNodeInfo();
        this._nodes_in_preorder = null;
        this.resetPreferredSize();
        this._main_panel.adjustJScrollPane();
        this.setArrowCursor();
        this.repaint();
    }

    private final void colorizeSubtree(Color color, PhylogenyNode phylogenyNode) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            JOptionPane.showMessageDialog(this, "Cannot colorize subtree in unrooted display type", "Attempt to colorize subtree in unrooted display", 2);
            return;
        }
        this._control_panel.setColorBranches(true);
        if (this._control_panel.getColorBranchesCb() != null) {
            this._control_panel.getColorBranchesCb().setSelected(true);
        }
        PreorderTreeIterator preorderTreeIterator = new PreorderTreeIterator(phylogenyNode);
        while (preorderTreeIterator.hasNext()) {
            preorderTreeIterator.next().getBranchData().setBranchColor(new BranchColor(color));
        }
        this.repaint();
    }

    private final void colorSubtree(PhylogenyNode phylogenyNode) {
        Color color = null;
        color = this.getControlPanel().isColorBranches() && PhylogenyMethods.getBranchColorValue(phylogenyNode) != null && (!phylogenyNode.isRoot() && phylogenyNode.getParent().getNumberOfDescendants() < 3 || phylogenyNode.isRoot()) ? PhylogenyMethods.getBranchColorValue(phylogenyNode) : this.getTreeColorSet().getBranchColor();
        this._color_chooser.setColor(color);
        this._color_chooser.setPreviewPanel(new JPanel());
        JDialog jDialog = JColorChooser.createDialog(this, "Subtree colorization", true, this._color_chooser, new SubtreeColorizationActionListener(this._color_chooser, phylogenyNode), null);
        jDialog.setVisible(true);
    }

    final void confColor() {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        this.setWaitCursor();
        Util.removeBranchColors(this._phylogeny);
        Util.colorPhylogenyAccordingToConfidenceValues(this._phylogeny, this);
        this._control_panel.setColorBranches(true);
        if (this._control_panel.getColorBranchesCb() != null) {
            this._control_panel.getColorBranchesCb().setSelected(true);
        }
        this.setArrowCursor();
        this.repaint();
    }

    final void colorRank(String string) {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        this.setWaitCursor();
        Util.removeBranchColors(this._phylogeny);
        int n = Util.colorPhylogenyAccordingToRanks(this._phylogeny, string, this);
        if (n > 0) {
            this._control_panel.setColorBranches(true);
            if (this._control_panel.getColorBranchesCb() != null) {
                this._control_panel.getColorBranchesCb().setSelected(true);
            }
            if (this._control_panel.getColorAccSpeciesCb() != null) {
                this._control_panel.getColorAccSpeciesCb().setSelected(false);
            }
            this._options.setColorLabelsSameAsParentBranch(true);
            this._control_panel.repaint();
        }
        this.setArrowCursor();
        this.repaint();
        if (n > 0) {
            String string2 = "Taxonomy colorization via " + string + " completed:\n";
            string2 = n > 1 ? string2 + "colorized " + n + " subtrees" : string2 + "colorized one subtree";
            JOptionPane.showMessageDialog(this, string2, "Taxonomy Colorization Completed (" + string + ")", 1);
        } else {
            String string3 = "Could not taxonomy colorize any subtree via " + string + ".\n";
            string3 = string3 + "Possible solutions (given that suitable taxonomic information is present):\n";
            string3 = string3 + "select a different rank (e.g. phylum, genus, ...)\n";
            string3 = string3 + "  and/or\n";
            string3 = string3 + "execute:\n";
            string3 = string3 + "1. \"Obtain Detailed Taxonomic Information\" (Tools)\n";
            string3 = string3 + "2. \"Infer Ancestor Taxonomies\" (Analysis)";
            JOptionPane.showMessageDialog(this, string3, "Taxonomy Colorization Failed", 2);
        }
    }

    private final void copySubtree(PhylogenyNode phylogenyNode) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            this.errorMessageNoCutCopyPasteInUnrootedDisplay();
            return;
        }
        this._nodes_in_preorder = null;
        this.setCutOrCopiedTree(this._phylogeny.copy(phylogenyNode));
        List<PhylogenyNode> list = PhylogenyMethods.getAllDescendants(phylogenyNode);
        HashSet<Integer> hashSet = new HashSet<Integer>(list.size());
        for (PhylogenyNode phylogenyNode2 : list) {
            hashSet.add(phylogenyNode2.getId());
        }
        hashSet.add(phylogenyNode.getId());
        this.setCopiedAndPastedNodes(hashSet);
        this.repaint();
    }

    private final void cutSubtree(PhylogenyNode phylogenyNode) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            this.errorMessageNoCutCopyPasteInUnrootedDisplay();
            return;
        }
        if (phylogenyNode.isRoot()) {
            JOptionPane.showMessageDialog(this, "Cannot cut entire tree as subtree", "Attempt to cut entire tree", 0);
            return;
        }
        String string = this.getASimpleTextRepresentationOfANode(phylogenyNode);
        int n = JOptionPane.showConfirmDialog(null, "Cut subtree" + string + "?", "Confirm Cutting of Subtree", 0);
        if (n != 0) {
            return;
        }
        this._nodes_in_preorder = null;
        this.setCopiedAndPastedNodes(null);
        this.setCutOrCopiedTree(this._phylogeny.copy(phylogenyNode));
        this._phylogeny.deleteSubtree(phylogenyNode, true);
        this._phylogeny.hashIDs();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.setEdited(true);
        this.repaint();
    }

    private final void cycleColors() {
        this.getMainPanel().getTreeColorSet().cycleColorScheme();
        for (TreePanel treePanel : this.getMainPanel().getTreePanels()) {
            treePanel.setBackground(this.getMainPanel().getTreeColorSet().getBackgroundColor());
        }
    }

    final void decreaseDomainStructureEvalueThreshold() {
        if (this._domain_structure_e_value_thr_exp > -20) {
            --this._domain_structure_e_value_thr_exp;
        }
    }

    private final void decreaseOvSize() {
        if (this.getOvMaxWidth() > 20.0f && this.getOvMaxHeight() > 20.0f) {
            this.setOvMaxWidth(this.getOvMaxWidth() - 5.0f);
            this.setOvMaxHeight(this.getOvMaxHeight() - 5.0f);
            this.updateOvSettings();
            this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
        }
    }

    private final void deleteNodeOrSubtree(PhylogenyNode phylogenyNode) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            this.errorMessageNoCutCopyPasteInUnrootedDisplay();
            return;
        }
        if (phylogenyNode.isRoot()) {
            JOptionPane.showMessageDialog(this, "Cannot delete entire tree", "Attempt to delete entire tree", 0);
            return;
        }
        String string = this.getASimpleTextRepresentationOfANode(phylogenyNode);
        Object[] objectArray = new Object[]{"Node only", "Entire subtree", "Cancel"};
        int n = JOptionPane.showOptionDialog(this, "Delete" + string + "?", "Delete Node/Subtree", -1, 3, null, objectArray, objectArray[2]);
        this._nodes_in_preorder = null;
        boolean bl = true;
        if (n == 1) {
            bl = false;
        } else if (n != 0) {
            return;
        }
        if (bl) {
            PhylogenyMethods.removeNode(phylogenyNode, this._phylogeny);
        } else {
            this._phylogeny.deleteSubtree(phylogenyNode, true);
        }
        this._phylogeny.externalNodesHaveChanged();
        this._phylogeny.hashIDs();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.setEdited(true);
        this.repaint();
    }

    private final void displayNodePopupMenu(PhylogenyNode phylogenyNode, int n, int n2) {
        this.makePopupMenus(phylogenyNode);
        this._node_popup_menu.putClientProperty(NODE_POPMENU_NODE_CLIENT_PROPERTY, phylogenyNode);
        this._node_popup_menu.show(this, n, n2);
    }

    private final void drawArc(double d, double d2, double d3, double d4, double d5, double d6, Graphics2D graphics2D) {
        this._arc.setArc(d, d2, d3, d4, 57.29577951308232 * d5, 57.29577951308232 * d6, 0);
        graphics2D.draw(this._arc);
    }

    private final void drawLine(double d, double d2, double d3, double d4, Graphics2D graphics2D) {
        if (d == d3 && d2 == d4) {
            return;
        }
        this._line.setLine(d, d2, d3, d4);
        graphics2D.draw(this._line);
    }

    private final void drawOval(double d, double d2, double d3, double d4, Graphics2D graphics2D) {
        this._ellipse.setFrame(d, d2, d3, d4);
        graphics2D.draw(this._ellipse);
    }

    private final void drawOvalFilled(double d, double d2, double d3, double d4, Graphics2D graphics2D) {
        this._ellipse.setFrame(d, d2, d3, d4);
        graphics2D.fill(this._ellipse);
    }

    private final void drawRect(float f, float f2, float f3, float f4, Graphics2D graphics2D) {
        this._rectangle.setFrame(f, f2, f3, f4);
        graphics2D.draw(this._rectangle);
    }

    private final void drawRectFilled(double d, double d2, double d3, double d4, Graphics2D graphics2D) {
        this._rectangle.setFrame(d, d2, d3, d4);
        graphics2D.fill(this._rectangle);
    }

    private final void drawRectGradient(double d, double d2, double d3, double d4, Graphics2D graphics2D, Color color, Color color2, Color color3) {
        this._rectangle.setFrame(d, d2, d3, d4);
        graphics2D.setPaint(new GradientPaint((float)d, (float)d2, color, (float)(d + d3), (float)(d2 + d4), color2, false));
        graphics2D.fill(this._rectangle);
        if (color3 != null) {
            graphics2D.setPaint(color3);
            graphics2D.draw(this._rectangle);
        }
    }

    private final void drawOvalGradient(double d, double d2, double d3, double d4, Graphics2D graphics2D, Color color, Color color2, Color color3) {
        this._ellipse.setFrame(d, d2, d3, d4);
        graphics2D.setPaint(new GradientPaint((float)d, (float)d2, color, (float)(d + d3), (float)(d2 + d4), color2, false));
        graphics2D.fill(this._ellipse);
        if (color3 != null) {
            graphics2D.setPaint(color3);
            graphics2D.draw(this._ellipse);
        }
    }

    private final void errorMessageNoCutCopyPasteInUnrootedDisplay() {
        JOptionPane.showMessageDialog(this, "Cannot cut, copy, paste, add, or delete subtrees/nodes in unrooted display", "Attempt to cut/copy/paste/add/delete in unrooted display", 0);
    }

    final PhylogenyNode findNode(int n, int n2) {
        if (this._phylogeny == null || this._phylogeny.isEmpty()) {
            return null;
        }
        int n3 = this.getOptions().getDefaultNodeShapeSize() / 2 + 2;
        PhylogenyNodeIterator phylogenyNodeIterator = this._phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!this._phylogeny.isRooted() && phylogenyNode.isRoot() && phylogenyNode.getNumberOfDescendants() <= 2 || !(phylogenyNode.getXcoord() - (float)n3 <= (float)n) || !(phylogenyNode.getXcoord() + (float)n3 >= (float)n) || !(phylogenyNode.getYcoord() - (float)n3 <= (float)n2) || !(phylogenyNode.getYcoord() + (float)n3 >= (float)n2)) continue;
            return phylogenyNode;
        }
        return null;
    }

    private final String getASimpleTextRepresentationOfANode(PhylogenyNode phylogenyNode) {
        String string = PhylogenyMethods.getSpecies(phylogenyNode);
        String string2 = phylogenyNode.getName();
        string2 = !ForesterUtil.isEmpty(string2) && !ForesterUtil.isEmpty(string) ? string2 + " " + string : (!ForesterUtil.isEmpty(string) ? string : "");
        if (!ForesterUtil.isEmpty(string2)) {
            string2 = " [" + string2 + "]";
        }
        return string2;
    }

    final Configuration getConfiguration() {
        return this._configuration;
    }

    final ControlPanel getControlPanel() {
        return this._control_panel;
    }

    private final Set<Integer> getCopiedAndPastedNodes() {
        return this.getMainPanel().getCopiedAndPastedNodes();
    }

    private final Phylogeny getCutOrCopiedTree() {
        return this.getMainPanel().getCutOrCopiedTree();
    }

    final int getDomainStructureEvalueThreshold() {
        return this._domain_structure_e_value_thr_exp;
    }

    final Set<Integer> getFoundNodes() {
        return this._found_nodes;
    }

    private final float getLastDragPointX() {
        return this._last_drag_point_x;
    }

    private final float getLastDragPointY() {
        return this._last_drag_point_y;
    }

    final int getLongestExtNodeInfo() {
        return this._longest_ext_node_info;
    }

    public final MainPanel getMainPanel() {
        return this._main_panel;
    }

    private final short getMaxBranchesToLeaf(PhylogenyNode phylogenyNode) {
        if (!this._nodeid_dist_to_leaf.containsKey(phylogenyNode.getId())) {
            short s = PhylogenyMethods.calculateMaxBranchesToLeaf(phylogenyNode);
            this._nodeid_dist_to_leaf.put(phylogenyNode.getId(), s);
            return s;
        }
        return this._nodeid_dist_to_leaf.get(phylogenyNode.getId());
    }

    private final double getMaxDistanceToRoot() {
        if (this._max_distance_to_root < 0.0) {
            this.recalculateMaxDistanceToRoot();
        }
        return this._max_distance_to_root;
    }

    final Options getOptions() {
        if (this._options == null) {
            this._options = this.getControlPanel().getOptions();
        }
        return this._options;
    }

    private final float getOvMaxHeight() {
        return this._ov_max_height;
    }

    private final float getOvMaxWidth() {
        return this._ov_max_width;
    }

    final Rectangle2D getOvRectangle() {
        return this._ov_rectangle;
    }

    final Rectangle getOvVirtualRectangle() {
        return this._ov_virtual_rectangle;
    }

    private final float getOvXcorrectionFactor() {
        return this._ov_x_correction_factor;
    }

    private final float getOvXDistance() {
        return this._ov_x_distance;
    }

    private final int getOvXPosition() {
        return this._ov_x_position;
    }

    private final float getOvYDistance() {
        return this._ov_y_distance;
    }

    private final int getOvYPosition() {
        return this._ov_y_position;
    }

    private final int getOvYStart() {
        return this._ov_y_start;
    }

    public final Phylogeny getPhylogeny() {
        return this._phylogeny;
    }

    final Options.PHYLOGENY_GRAPHICS_TYPE getPhylogenyGraphicsType() {
        return this._graphics_type;
    }

    private final double getScaleDistance() {
        return this._scale_distance;
    }

    private final String getScaleLabel() {
        return this._scale_label;
    }

    final double getStartingAngle() {
        return this._urt_starting_angle;
    }

    final Color getTaxonomyBasedColor(PhylogenyNode phylogenyNode) {
        if (phylogenyNode.getNodeData().isHasTaxonomy()) {
            return this.calculateTaxonomyBasedColor(phylogenyNode.getNodeData().getTaxonomy());
        }
        return this.getTreeColorSet().getTaxonomyColor();
    }

    final TreeColorSet getTreeColorSet() {
        return this.getMainPanel().getTreeColorSet();
    }

    final File getTreeFile() {
        return this._treefile;
    }

    private final TreeFontSet getTreeFontSet() {
        return this.getMainPanel().getTreeFontSet();
    }

    private final float getUrtFactor() {
        return this._urt_factor;
    }

    private final float getUrtFactorOv() {
        return this._urt_factor_ov;
    }

    final float getXcorrectionFactor() {
        return this._x_correction_factor;
    }

    final float getXdistance() {
        return this._x_distance;
    }

    final float getYdistance() {
        return this._y_distance;
    }

    private final void handleClickToAction(ControlPanel.NodeClickAction nodeClickAction, PhylogenyNode phylogenyNode) {
        switch (nodeClickAction) {
            case SHOW_DATA: {
                this.showNodeFrame(phylogenyNode);
                break;
            }
            case COLLAPSE: {
                this.collapse(phylogenyNode);
                break;
            }
            case REROOT: {
                this.reRoot(phylogenyNode);
                break;
            }
            case SUBTREE: {
                this.subTree(phylogenyNode);
                break;
            }
            case SWAP: {
                this.swap(phylogenyNode);
                break;
            }
            case COLOR_SUBTREE: {
                this.colorSubtree(phylogenyNode);
                break;
            }
            case OPEN_SEQ_WEB: {
                this.openSeqWeb(phylogenyNode);
                break;
            }
            case BLAST: {
                this.blast(phylogenyNode);
                break;
            }
            case OPEN_TAX_WEB: {
                this.openTaxWeb(phylogenyNode);
                break;
            }
            case CUT_SUBTREE: {
                this.cutSubtree(phylogenyNode);
                break;
            }
            case COPY_SUBTREE: {
                this.copySubtree(phylogenyNode);
                break;
            }
            case PASTE_SUBTREE: {
                this.pasteSubtree(phylogenyNode);
                break;
            }
            case DELETE_NODE_OR_SUBTREE: {
                this.deleteNodeOrSubtree(phylogenyNode);
                break;
            }
            case ADD_NEW_NODE: {
                this.addEmptyNode(phylogenyNode);
                break;
            }
            case EDIT_NODE_DATA: {
                this.showNodeEditFrame(phylogenyNode);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown action: " + (Object)((Object)nodeClickAction));
            }
        }
    }

    final void increaseDomainStructureEvalueThreshold() {
        if (this._domain_structure_e_value_thr_exp < 3) {
            ++this._domain_structure_e_value_thr_exp;
        }
    }

    private final void increaseOvSize() {
        if ((double)this.getOvMaxWidth() < this.getMainPanel().getCurrentScrollPane().getViewport().getVisibleRect().getWidth() / 2.0 && (double)this.getOvMaxHeight() < this.getMainPanel().getCurrentScrollPane().getViewport().getVisibleRect().getHeight() / 2.0) {
            this.setOvMaxWidth(this.getOvMaxWidth() + 5.0f);
            this.setOvMaxHeight(this.getOvMaxHeight() + 5.0f);
            this.updateOvSettings();
            this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
        }
    }

    final void inferCommonPartOfScientificNames() {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        this.setWaitCursor();
        Util.inferCommonPartOfScientificNames(this._phylogeny);
        this.setArrowCursor();
        this.repaint();
    }

    private final void init() {
        this._color_chooser = new JColorChooser();
        this._rollover_popup = new JTextArea();
        this._rollover_popup.setFont(POPUP_FONT);
        this.resetNodeIdToDistToLeafMap();
        this.setTextAntialias();
        this.setTreeFile(null);
        this.setEdited(false);
        this.initializeOvSettings();
        this.setStartingAngle(4.71238898038469);
        ImageLoader imageLoader = new ImageLoader(this);
        new Thread(imageLoader).start();
    }

    private final void initializeOvSettings() {
        this.setOvMaxHeight(this.getConfiguration().getOvMaxHeight());
        this.setOvMaxWidth(this.getConfiguration().getOvMaxWidth());
    }

    final void initNodeData() {
        if (this._phylogeny == null || this._phylogeny.isEmpty()) {
            return;
        }
        double d = 0.0;
        for (PhylogenyNode phylogenyNode : this._phylogeny.getExternalNodes()) {
            double d2;
            if (!phylogenyNode.getNodeData().isHasSequence() || phylogenyNode.getNodeData().getSequence().getDomainArchitecture() == null) continue;
            Object object = null;
            if (!(phylogenyNode.getNodeData().getSequence().getDomainArchitecture() instanceof RenderableDomainArchitecture)) {
                object = new RenderableDomainArchitecture(phylogenyNode.getNodeData().getSequence().getDomainArchitecture(), this.getConfiguration());
                phylogenyNode.getNodeData().getSequence().setDomainArchitecture((DomainArchitecture)object);
            } else {
                object = (RenderableDomainArchitecture)phylogenyNode.getNodeData().getSequence().getDomainArchitecture();
            }
            if (!this.getControlPanel().isShowDomainArchitectures() || !((d2 = ((RenderableDomainArchitecture)object).getOriginalSize().getWidth()) > d)) continue;
            d = d2;
        }
        if (this.getControlPanel().isShowDomainArchitectures()) {
            double d3 = this._domain_structure_width / d;
            for (PhylogenyNode phylogenyNode : this._phylogeny.getExternalNodes()) {
                if (!phylogenyNode.getNodeData().isHasSequence() || phylogenyNode.getNodeData().getSequence().getDomainArchitecture() == null) continue;
                RenderableDomainArchitecture renderableDomainArchitecture = (RenderableDomainArchitecture)phylogenyNode.getNodeData().getSequence().getDomainArchitecture();
                renderableDomainArchitecture.setRenderingFactorWidth(d3);
                renderableDomainArchitecture.setParameter(this._domain_structure_e_value_thr_exp);
            }
        }
    }

    final boolean inOv(MouseEvent mouseEvent) {
        return mouseEvent.getX() > this.getVisibleRect().x + this.getOvXPosition() + 1 && (float)mouseEvent.getX() < (float)(this.getVisibleRect().x + this.getOvXPosition()) + this.getOvMaxWidth() - 1.0f && mouseEvent.getY() > this.getVisibleRect().y + this.getOvYPosition() + 1 && (float)mouseEvent.getY() < (float)(this.getVisibleRect().y + this.getOvYPosition()) + this.getOvMaxHeight() - 1.0f;
    }

    final boolean inOvRectangle(MouseEvent mouseEvent) {
        return (double)mouseEvent.getX() >= this.getOvRectangle().getX() - 1.0 && (double)mouseEvent.getX() <= this.getOvRectangle().getX() + this.getOvRectangle().getWidth() + 1.0 && (double)mouseEvent.getY() >= this.getOvRectangle().getY() - 1.0 && (double)mouseEvent.getY() <= this.getOvRectangle().getY() + this.getOvRectangle().getHeight() + 1.0;
    }

    private final boolean inOvVirtualRectangle(int n, int n2) {
        return n >= this.getOvVirtualRectangle().x - 1 && n <= this.getOvVirtualRectangle().x + this.getOvVirtualRectangle().width + 1 && n2 >= this.getOvVirtualRectangle().y - 1 && n2 <= this.getOvVirtualRectangle().y + this.getOvVirtualRectangle().height + 1;
    }

    private final boolean inOvVirtualRectangle(MouseEvent mouseEvent) {
        return this.inOvVirtualRectangle(mouseEvent.getX(), mouseEvent.getY());
    }

    final boolean isApplet() {
        return this.getMainPanel() instanceof MainPanelApplets;
    }

    private final boolean isCanBlast(PhylogenyNode phylogenyNode) {
        return phylogenyNode.getNodeData().isHasSequence() && (phylogenyNode.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getValue()) || !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getName()) || !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getSymbol()));
    }

    final boolean isCanCollapse() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED;
    }

    final boolean isCanColorSubtree() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED;
    }

    final boolean isCanCopy() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this.getOptions().isEditable();
    }

    final boolean isCanCut(PhylogenyNode phylogenyNode) {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this.getOptions().isEditable() && !phylogenyNode.isRoot();
    }

    final boolean isCanDelete() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this.getOptions().isEditable();
    }

    private final boolean isCanOpenSeqWeb(PhylogenyNode phylogenyNode) {
        return phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getSource()) && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getValue()) && this.getConfiguration().isHasWebLink(phylogenyNode.getNodeData().getSequence().getAccession().getSource().toLowerCase());
    }

    private final boolean isCanOpenTaxWeb(PhylogenyNode phylogenyNode) {
        return phylogenyNode.getNodeData().isHasTaxonomy() && (phylogenyNode.getNodeData().getTaxonomy().getIdentifier() != null && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getProvider()) && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getValue()) && this.getConfiguration().isHasWebLink(phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getProvider().toLowerCase()) || !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getScientificName()) || !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode()) || !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getCommonName()) || phylogenyNode.getNodeData().getTaxonomy().getIdentifier() != null && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getValue()) && phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getValue().startsWith("http://"));
    }

    final boolean isCanPaste() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this.getOptions().isEditable() && this.getCutOrCopiedTree() != null && !this.getCutOrCopiedTree().isEmpty();
    }

    final boolean isCanReroot() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this._subtree_index < 1;
    }

    final boolean isCanSubtree(PhylogenyNode phylogenyNode) {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && !phylogenyNode.isExternal() && (!phylogenyNode.isRoot() || this._subtree_index > 0);
    }

    final boolean isEdited() {
        return this._edited;
    }

    private final boolean isInFoundNodes(PhylogenyNode phylogenyNode) {
        return this.getFoundNodes() != null && this.getFoundNodes().contains(phylogenyNode.getId());
    }

    private final boolean isInOv() {
        return this._in_ov;
    }

    final boolean isInOvRect() {
        return this._in_ov_rect;
    }

    private final boolean isNodeDataInvisible(PhylogenyNode phylogenyNode) {
        int n = 40;
        if (this.getControlPanel().isShowTaxonomyImages()) {
            n = 40 + (int)this.getYdistance();
        }
        return (double)phylogenyNode.getYcoord() < this.getVisibleRect().getMinY() - (double)n || (double)phylogenyNode.getYcoord() > this.getVisibleRect().getMaxY() + (double)n || phylogenyNode.getParent() != null && (double)phylogenyNode.getParent().getXcoord() > this.getVisibleRect().getMaxX();
    }

    private final boolean isNodeDataInvisibleUnrootedCirc(PhylogenyNode phylogenyNode) {
        return (double)phylogenyNode.getYcoord() < this.getVisibleRect().getMinY() - 20.0 || (double)phylogenyNode.getYcoord() > this.getVisibleRect().getMaxY() + 20.0 || (double)phylogenyNode.getXcoord() < this.getVisibleRect().getMinX() - 20.0 || (double)phylogenyNode.getXcoord() > this.getVisibleRect().getMaxX() + 20.0;
    }

    private final boolean isNonLinedUpCladogram() {
        return this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP;
    }

    final boolean isOvOn() {
        return this._ov_on;
    }

    final boolean isPhyHasBranchLengths() {
        return this._phy_has_branch_lengths;
    }

    private final boolean isUniformBranchLengthsForCladogram() {
        return this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP;
    }

    private final void keyPressedCalls(KeyEvent keyEvent) {
        if (this.isOvOn() && this.getMousePosition() != null && this.getMousePosition().getLocation() != null) {
            if (this.inOvVirtualRectangle(this.getMousePosition().x, this.getMousePosition().y)) {
                if (!this.isInOvRect()) {
                    this.setInOvRect(true);
                }
            } else if (this.isInOvRect()) {
                this.setInOvRect(false);
            }
        }
        if (keyEvent.getModifiersEx() == 128) {
            if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 36 || keyEvent.getKeyCode() == 70) {
                this.getMainPanel().getTreeFontSet().mediumFonts();
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(true);
            } else if (keyEvent.getKeyCode() == 109 || keyEvent.getKeyCode() == 45) {
                this.getMainPanel().getTreeFontSet().decreaseFontSize();
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(true);
            } else if (TreePanel.plusPressed(keyEvent.getKeyCode())) {
                this.getMainPanel().getTreeFontSet().increaseFontSize();
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(true);
            }
        } else {
            if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 36 || keyEvent.getKeyCode() == 70) {
                this.getControlPanel().showWhole();
            } else if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 39) {
                if (keyEvent.getModifiersEx() == 64) {
                    if (keyEvent.getKeyCode() == 38) {
                        this.getMainPanel().getControlPanel().zoomInY(1.08f);
                        this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
                    } else if (keyEvent.getKeyCode() == 40) {
                        this.getMainPanel().getControlPanel().zoomOutY(0.9259259f);
                        this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
                    } else if (keyEvent.getKeyCode() == 37) {
                        this.getMainPanel().getControlPanel().zoomOutX(0.9259259f, 0.92165893f);
                        this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
                    } else if (keyEvent.getKeyCode() == 39) {
                        this.getMainPanel().getControlPanel().zoomInX(1.08f, 1.08f);
                        this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
                    }
                } else {
                    int n;
                    int n2 = 0;
                    int n3 = -80;
                    if (keyEvent.getKeyCode() == 40) {
                        n3 = 80;
                    } else if (keyEvent.getKeyCode() == 37) {
                        n2 = -80;
                        n3 = 0;
                    } else if (keyEvent.getKeyCode() == 39) {
                        n2 = 80;
                        n3 = 0;
                    }
                    Point point = this.getMainPanel().getCurrentScrollPane().getViewport().getViewPosition();
                    point.x += n2;
                    point.y += n3;
                    if (point.x <= 0) {
                        point.x = 0;
                    } else {
                        n = this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getVisibleAmount();
                        if (point.x >= n) {
                            point.x = n;
                        }
                    }
                    if (point.y <= 0) {
                        point.y = 0;
                    } else {
                        n = this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getVisibleAmount();
                        if (point.y >= n) {
                            point.y = n;
                        }
                    }
                    this.repaint();
                    this.getMainPanel().getCurrentScrollPane().getViewport().setViewPosition(point);
                }
            } else if (keyEvent.getKeyCode() == 109 || keyEvent.getKeyCode() == 45) {
                this.getMainPanel().getControlPanel().zoomOutY(0.9259259f);
                this.getMainPanel().getControlPanel().zoomOutX(0.9259259f, 0.92165893f);
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
            } else if (TreePanel.plusPressed(keyEvent.getKeyCode())) {
                this.getMainPanel().getControlPanel().zoomInX(1.08f, 1.08f);
                this.getMainPanel().getControlPanel().zoomInY(1.08f);
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
            } else if (keyEvent.getKeyCode() == 83) {
                if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                    this.setStartingAngle(this.getStartingAngle() % (Math.PI * 2) + 0.09817477315664291);
                    this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                }
            } else if (keyEvent.getKeyCode() == 65) {
                if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                    this.setStartingAngle(this.getStartingAngle() % (Math.PI * 2) - 0.09817477315664291);
                    if (this.getStartingAngle() < 0.0) {
                        this.setStartingAngle(Math.PI * 2 + this.getStartingAngle());
                    }
                    this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                }
            } else if (keyEvent.getKeyCode() == 68) {
                boolean bl = false;
                if (this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.HORIZONTAL) {
                    this.getOptions().setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.RADIAL);
                    bl = true;
                } else {
                    this.getOptions().setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.HORIZONTAL);
                }
                if (this.getMainPanel().getMainFrame() == null) {
                    ArchaeopteryxE archaeopteryxE = (ArchaeopteryxE)((MainPanelApplets)this.getMainPanel()).getApplet();
                    if (archaeopteryxE.getlabelDirectionCbmi() != null) {
                        archaeopteryxE.getlabelDirectionCbmi().setSelected(bl);
                    }
                } else {
                    this.getMainPanel().getMainFrame().getlabelDirectionCbmi().setSelected(bl);
                }
                this.repaint();
            } else if (keyEvent.getKeyCode() == 88) {
                this.switchDisplaygetPhylogenyGraphicsType();
                this.repaint();
            } else if (keyEvent.getKeyCode() == 67) {
                this.cycleColors();
                this.repaint();
            } else if (this.getOptions().isShowOverview() && this.isOvOn() && keyEvent.getKeyCode() == 79) {
                MainFrame.cycleOverview(this.getOptions(), this);
                this.repaint();
            } else if (this.getOptions().isShowOverview() && this.isOvOn() && keyEvent.getKeyCode() == 73) {
                this.increaseOvSize();
            } else if (this.getOptions().isShowOverview() && this.isOvOn() && keyEvent.getKeyCode() == 85) {
                this.decreaseOvSize();
            }
            keyEvent.consume();
        }
    }

    private final void makePopupMenus(PhylogenyNode phylogenyNode) {
        this._node_popup_menu = new JPopupMenu();
        List<String> list = this._main_panel.getControlPanel().getSingleClickToNames();
        this._node_popup_menu_items = new JMenuItem[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            this._node_popup_menu_items[i] = new JMenuItem(string);
            if (string.equals(Configuration.clickto_options[6][0])) {
                this._node_popup_menu_items[i].setEnabled(this.isCanOpenSeqWeb(phylogenyNode));
            } else if (string.equals(Configuration.clickto_options[7][0])) {
                this._node_popup_menu_items[i].setEnabled(this.isCanOpenTaxWeb(phylogenyNode));
            } else {
                if (string.equals(Configuration.clickto_options[14][0])) continue;
                if (string.equals(Configuration.clickto_options[11][0])) {
                    if (!this.getOptions().isEditable()) continue;
                    this._node_popup_menu_items[i].setEnabled(this.isCanDelete());
                } else if (string.equals(Configuration.clickto_options[8][0])) {
                    if (!this.getOptions().isEditable()) continue;
                    this._node_popup_menu_items[i].setEnabled(this.isCanCut(phylogenyNode));
                } else if (string.equals(Configuration.clickto_options[9][0])) {
                    if (!this.getOptions().isEditable()) continue;
                    this._node_popup_menu_items[i].setEnabled(this.isCanCopy());
                } else if (string.equals(Configuration.clickto_options[10][0])) {
                    if (!this.getOptions().isEditable()) continue;
                    this._node_popup_menu_items[i].setEnabled(this.isCanPaste());
                } else if (string.equals(Configuration.clickto_options[13][0])) {
                    if (!this.getOptions().isEditable()) {
                        continue;
                    }
                } else if (string.equals(Configuration.clickto_options[12][0])) {
                    if (!this.getOptions().isEditable()) {
                        continue;
                    }
                } else if (string.equals(Configuration.clickto_options[2][0])) {
                    this._node_popup_menu_items[i].setEnabled(this.isCanReroot());
                } else if (string.equals(Configuration.clickto_options[1][0])) {
                    this._node_popup_menu_items[i].setEnabled(this.isCanCollapse());
                } else if (string.equals(Configuration.clickto_options[5][0])) {
                    this._node_popup_menu_items[i].setEnabled(this.isCanColorSubtree());
                } else if (string.equals(Configuration.clickto_options[3][0])) {
                    this._node_popup_menu_items[i].setEnabled(this.isCanSubtree(phylogenyNode));
                }
            }
            this._node_popup_menu_items[i].addActionListener(this);
            this._node_popup_menu.add(this._node_popup_menu_items[i]);
        }
    }

    final void midpointRoot() {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        if (!this._phylogeny.isRerootable()) {
            JOptionPane.showMessageDialog(this, "This is not rerootable", "Not rerootable", 2);
            return;
        }
        this._nodes_in_preorder = null;
        this.setWaitCursor();
        PhylogenyMethods.midpointRoot(this._phylogeny);
        this.resetNodeIdToDistToLeafMap();
        this.setArrowCursor();
        this.repaint();
    }

    final void mouseClicked(MouseEvent mouseEvent) {
        if (this.getOptions().isShowOverview() && this.isOvOn() && this.isInOv()) {
            double d = (double)this.getVisibleRect().width / this.getOvRectangle().getWidth();
            double d2 = (double)this.getVisibleRect().height / this.getOvRectangle().getHeight();
            double d3 = ((double)(mouseEvent.getX() - this.getVisibleRect().x - this.getOvXPosition()) - this.getOvRectangle().getWidth() / 2.0) * d;
            double d4 = ((double)(mouseEvent.getY() - this.getVisibleRect().y - this.getOvYPosition()) - this.getOvRectangle().getHeight() / 2.0) * d2;
            if (d3 < 0.0) {
                d3 = 0.0;
            }
            if (d4 < 0.0) {
                d4 = 0.0;
            }
            double d5 = this.getWidth() - this.getVisibleRect().width;
            double d6 = this.getHeight() - this.getVisibleRect().height;
            if (d3 > d5) {
                d3 = d5;
            }
            if (d4 > d6) {
                d4 = d6;
            }
            this.getMainPanel().getCurrentScrollPane().getViewport().setViewPosition(new Point(ForesterUtil.roundToInt(d3), ForesterUtil.roundToInt(d4)));
            this.setInOvRect(true);
            this.repaint();
        } else {
            PhylogenyNode phylogenyNode = this.findNode(mouseEvent.getX(), mouseEvent.getY());
            if (phylogenyNode != null) {
                if (!phylogenyNode.isRoot() && phylogenyNode.getParent().isCollapse()) {
                    return;
                }
                this._highlight_node = phylogenyNode;
                if ((mouseEvent.getModifiers() & 1) != 0) {
                    if (this.getFoundNodes() == null) {
                        this.setFoundNodes(new HashSet<Integer>());
                    }
                    this.getFoundNodes().add(phylogenyNode.getId());
                } else if ((mouseEvent.getModifiers() & 2) != 0) {
                    this.displayNodePopupMenu(phylogenyNode, mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getModifiers() == 4) {
                    this.displayNodePopupMenu(phylogenyNode, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    this.handleClickToAction(this._control_panel.getActionWhenNodeClicked(), phylogenyNode);
                }
            } else {
                this._highlight_node = null;
            }
        }
        this.repaint();
    }

    final void mouseDragInBrowserPanel(MouseEvent mouseEvent) {
        int n;
        this.setCursor(MOVE_CURSOR);
        Point point = this.getMainPanel().getCurrentScrollPane().getViewport().getViewPosition();
        point.x = (int)((float)point.x - ((float)mouseEvent.getX() - this.getLastDragPointX()));
        point.y = (int)((float)point.y - ((float)mouseEvent.getY() - this.getLastDragPointY()));
        if (point.x < 0) {
            point.x = 0;
        } else {
            n = this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getVisibleAmount();
            if (point.x > n) {
                point.x = n;
            }
        }
        if (point.y < 0) {
            point.y = 0;
        } else {
            n = this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getVisibleAmount();
            if (point.y > n) {
                point.y = n;
            }
        }
        if (this.isOvOn() || this.getOptions().isShowScale()) {
            this.repaint();
        }
        this.getMainPanel().getCurrentScrollPane().getViewport().setViewPosition(point);
    }

    final void mouseDragInOvRectangle(MouseEvent mouseEvent) {
        int n;
        this.setCursor(HAND_CURSOR);
        double d = (double)this.getVisibleRect().width / this.getOvRectangle().getWidth();
        double d2 = (double)this.getVisibleRect().height / this.getOvRectangle().getHeight();
        Point point = this.getMainPanel().getCurrentScrollPane().getViewport().getViewPosition();
        double d3 = d * (double)mouseEvent.getX() - d * (double)this.getLastDragPointX();
        double d4 = d2 * (double)mouseEvent.getY() - d2 * (double)this.getLastDragPointY();
        point.x = ForesterUtil.roundToInt((double)point.x + d3);
        point.y = ForesterUtil.roundToInt((double)point.y + d4);
        if (point.x <= 0) {
            point.x = 0;
            d3 = 0.0;
        } else {
            n = this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getVisibleAmount();
            if (point.x >= n) {
                d3 = 0.0;
                point.x = n;
            }
        }
        if (point.y <= 0) {
            d4 = 0.0;
            point.y = 0;
        } else {
            n = this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getVisibleAmount();
            if (point.y >= n) {
                d4 = 0.0;
                point.y = n;
            }
        }
        this.repaint();
        this.getMainPanel().getCurrentScrollPane().getViewport().setViewPosition(point);
        this.setLastMouseDragPointX((float)((double)mouseEvent.getX() + d3));
        this.setLastMouseDragPointY((float)((double)mouseEvent.getY() + d4));
    }

    final void mouseMoved(MouseEvent mouseEvent) {
        this.requestFocusInWindow();
        if (this.getControlPanel().isNodeDescPopup() && this._node_desc_popup != null) {
            this._node_desc_popup.hide();
            this._node_desc_popup = null;
        }
        if (this.getOptions().isShowOverview() && this.isOvOn()) {
            if (this.inOvVirtualRectangle(mouseEvent)) {
                if (!this.isInOvRect()) {
                    this.setInOvRect(true);
                    this.repaint();
                }
            } else if (this.isInOvRect()) {
                this.setInOvRect(false);
                this.repaint();
            }
        }
        if (this.inOv(mouseEvent) && this.getOptions().isShowOverview() && this.isOvOn()) {
            if (!this.isInOv()) {
                this.setInOv(true);
            }
        } else {
            PhylogenyNode phylogenyNode;
            if (this.isInOv()) {
                this.setInOv(false);
            }
            if ((phylogenyNode = this.findNode(mouseEvent.getX(), mouseEvent.getY())) != null && (phylogenyNode.isRoot() || !phylogenyNode.getParent().isCollapse())) {
                if (this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.CUT_SUBTREE || this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.COPY_SUBTREE || this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.PASTE_SUBTREE || this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.DELETE_NODE_OR_SUBTREE || this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.REROOT || this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.ADD_NEW_NODE) {
                    this.setCursor(CUT_CURSOR);
                } else {
                    this.setCursor(HAND_CURSOR);
                    if (this.getControlPanel().isNodeDescPopup()) {
                        this.showNodeDataPopup(mouseEvent, phylogenyNode);
                    }
                }
            } else {
                this.setCursor(ARROW_CURSOR);
            }
        }
    }

    final void mouseReleasedInBrowserPanel(MouseEvent mouseEvent) {
        this.setCursor(ARROW_CURSOR);
    }

    @Override
    public final void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        if (this.inOvVirtualRectangle(mouseWheelEvent)) {
            if (!this.isInOvRect()) {
                this.setInOvRect(true);
                this.repaint();
            }
        } else if (this.isInOvRect()) {
            this.setInOvRect(false);
            this.repaint();
        }
        if (mouseWheelEvent.isControlDown()) {
            if (n < 0) {
                this.getTreeFontSet().increaseFontSize();
                this.getControlPanel().displayedPhylogenyMightHaveChanged(true);
            } else {
                this.getTreeFontSet().decreaseFontSize();
                this.getControlPanel().displayedPhylogenyMightHaveChanged(true);
            }
        } else if (mouseWheelEvent.isShiftDown()) {
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                if (n < 0) {
                    for (int i = 0; i < -n; ++i) {
                        this.setStartingAngle(this.getStartingAngle() % (Math.PI * 2) + 0.09817477315664291);
                        this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        this.setStartingAngle(this.getStartingAngle() % (Math.PI * 2) - 0.09817477315664291);
                        if (this.getStartingAngle() < 0.0) {
                            this.setStartingAngle(Math.PI * 2 + this.getStartingAngle());
                        }
                        this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                    }
                }
            } else if (n < 0) {
                for (int i = 0; i < -n; ++i) {
                    this.getControlPanel().zoomInY(1.08f);
                    this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    this.getControlPanel().zoomOutY(0.9259259f);
                    this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                }
            }
        } else if (n < 0) {
            for (int i = 0; i < -n; ++i) {
                this.getControlPanel().zoomInX(1.08f, 1.085f);
                this.getControlPanel().zoomInY(1.08f);
                this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.getControlPanel().zoomOutY(0.9259259f);
                this.getControlPanel().zoomOutX(0.9259259f, 0.92165893f);
                this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
            }
        }
        this.requestFocus();
        this.requestFocusInWindow();
        this.requestFocus();
    }

    final void multiplyUrtFactor(float f) {
        this._urt_factor *= f;
    }

    final JApplet obtainApplet() {
        return ((MainPanelApplets)this.getMainPanel()).getApplet();
    }

    private final void openSeqWeb(PhylogenyNode phylogenyNode) {
        Object object;
        String string;
        if (!this.isCanOpenSeqWeb(phylogenyNode)) {
            this.cannotOpenBrowserWarningMessage("sequence");
            return;
        }
        String string2 = null;
        Sequence sequence = phylogenyNode.getNodeData().getSequence();
        String string3 = sequence.getAccession().getSource().toLowerCase();
        if (string3.toLowerCase().equals("ncbi")) {
            string = "http://www.ncbi.nlm.nih.gov/gquery/?term=";
        } else {
            object = this.getConfiguration().getWebLink(string3);
            string = ((WebLink)object).getUrl().toString();
        }
        try {
            string2 = string + URLEncoder.encode(sequence.getAccession().getValue(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Util.showErrorMessage(this, unsupportedEncodingException.toString());
            unsupportedEncodingException.printStackTrace();
        }
        if (!ForesterUtil.isEmpty(string2)) {
            try {
                object = null;
                if (this.isApplet()) {
                    object = this.obtainApplet();
                }
                Util.launchWebBrowser(new URI(string2), this.isApplet(), (JApplet)object, "_aptx_seq");
            }
            catch (IOException iOException) {
                Util.showErrorMessage(this, iOException.toString());
                iOException.printStackTrace();
            }
            catch (URISyntaxException uRISyntaxException) {
                Util.showErrorMessage(this, uRISyntaxException.toString());
                uRISyntaxException.printStackTrace();
            }
        } else {
            this.cannotOpenBrowserWarningMessage("sequence");
        }
    }

    private final void openTaxWeb(PhylogenyNode phylogenyNode) {
        Object object;
        if (!this.isCanOpenTaxWeb(phylogenyNode)) {
            this.cannotOpenBrowserWarningMessage("taxonomic");
            return;
        }
        String string = null;
        Taxonomy taxonomy = phylogenyNode.getNodeData().getTaxonomy();
        if (taxonomy.getIdentifier() != null && !ForesterUtil.isEmpty(taxonomy.getIdentifier().getProvider()) && this.getConfiguration().isHasWebLink(taxonomy.getIdentifier().getProvider().toLowerCase())) {
            object = taxonomy.getIdentifier().getProvider().toLowerCase();
            WebLink webLink = this.getConfiguration().getWebLink((String)object);
            try {
                string = webLink.getUrl() + URLEncoder.encode(taxonomy.getIdentifier().getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Util.showErrorMessage(this, unsupportedEncodingException.toString());
                unsupportedEncodingException.printStackTrace();
            }
        } else if (taxonomy.getIdentifier() != null && !ForesterUtil.isEmpty(taxonomy.getIdentifier().getValue()) && taxonomy.getIdentifier().getValue().startsWith("http://")) {
            try {
                string = new URI(taxonomy.getIdentifier().getValue()).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                Util.showErrorMessage(this, uRISyntaxException.toString());
                string = null;
                uRISyntaxException.printStackTrace();
            }
        } else if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) {
            try {
                string = "http://www.eol.org/search?q=" + URLEncoder.encode(taxonomy.getScientificName(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Util.showErrorMessage(this, unsupportedEncodingException.toString());
                unsupportedEncodingException.printStackTrace();
            }
        } else if (!ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
            try {
                string = "http://www.uniprot.org/taxonomy/?query=" + URLEncoder.encode(taxonomy.getTaxonomyCode(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Util.showErrorMessage(this, unsupportedEncodingException.toString());
                unsupportedEncodingException.printStackTrace();
            }
        } else if (!ForesterUtil.isEmpty(taxonomy.getCommonName())) {
            try {
                string = "http://www.eol.org/search?q=" + URLEncoder.encode(taxonomy.getCommonName(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Util.showErrorMessage(this, unsupportedEncodingException.toString());
                unsupportedEncodingException.printStackTrace();
            }
        }
        if (!ForesterUtil.isEmpty(string)) {
            try {
                object = null;
                if (this.isApplet()) {
                    object = this.obtainApplet();
                }
                Util.launchWebBrowser(new URI(string), this.isApplet(), (JApplet)object, "_aptx_tax");
            }
            catch (IOException iOException) {
                Util.showErrorMessage(this, iOException.toString());
                iOException.printStackTrace();
            }
            catch (URISyntaxException uRISyntaxException) {
                Util.showErrorMessage(this, uRISyntaxException.toString());
                uRISyntaxException.printStackTrace();
            }
        } else {
            this.cannotOpenBrowserWarningMessage("taxonomic");
        }
    }

    final void paintBranchCircular(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2, Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        double d = this._urt_nodeid_angle_map.get(phylogenyNode2.getId());
        double d2 = this._root.getXcoord();
        double d3 = this._root.getYcoord();
        double d4 = d2 - (double)phylogenyNode.getXcoord();
        double d5 = d3 - (double)phylogenyNode.getYcoord();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = this._urt_nodeid_angle_map.get(phylogenyNode.getId()) - d;
        this.assignGraphicsForBranchWithColorForParentBranch(phylogenyNode2, false, graphics2D, bl2, bl3);
        if ((phylogenyNode2.isFirstChildNode() || phylogenyNode2.isLastChildNode()) && (Math.abs(d6 * d7) > 1.5 || bl2 || bl3)) {
            double d8 = 2.0 * d6;
            this.drawArc(d2 - d6, d3 - d6, d8, d8, -d - d7, d7, graphics2D);
        }
        this.drawLine(phylogenyNode2.getXcoord(), phylogenyNode2.getYcoord(), d2 + Math.cos(d) * d6, d3 + Math.sin(d) * d6, graphics2D);
        this.paintNodeBox(phylogenyNode2.getXcoord(), phylogenyNode2.getYcoord(), phylogenyNode2, graphics2D, bl2, bl3, this.isInFoundNodes(phylogenyNode2));
        if (phylogenyNode2.isExternal()) {
            boolean bl4 = this.isInFoundNodes(phylogenyNode2);
            if (this._dynamic_hiding_factor > 1 && !bl4 && this._urt_nodeid_index_map.get(phylogenyNode2.getId()) % this._dynamic_hiding_factor != 1) {
                return;
            }
            this.paintNodeDataUnrootedCirc(graphics2D, phylogenyNode2, bl2, bl3, bl, 0.0, bl4);
        }
    }

    final void paintBranchCircularLite(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2, Graphics2D graphics2D) {
        double d = this._urt_nodeid_angle_map.get(phylogenyNode2.getId());
        double d2 = this._root.getXSecondary();
        double d3 = this._root.getYSecondary();
        double d4 = d2 - (double)phylogenyNode.getXSecondary();
        double d5 = d3 - (double)phylogenyNode.getYSecondary();
        double d6 = this._urt_nodeid_angle_map.get(phylogenyNode.getId()) - d;
        double d7 = Math.sqrt(d4 * d4 + d5 * d5);
        graphics2D.setColor(this.getTreeColorSet().getOvColor());
        if ((phylogenyNode2.isFirstChildNode() || phylogenyNode2.isLastChildNode()) && Math.abs(d6) > 0.02) {
            double d8 = 2.0 * d7;
            this.drawArc(d2 - d7, d3 - d7, d8, d8, -d - d6, d6, graphics2D);
        }
        this.drawLine(phylogenyNode2.getXSecondary(), phylogenyNode2.getYSecondary(), d2 + Math.cos(d) * d7, d3 + Math.sin(d) * d7, graphics2D);
        if (this.isInFoundNodes(phylogenyNode2)) {
            graphics2D.setColor(this.getTreeColorSet().getFoundColor());
            this.drawRectFilled(phylogenyNode2.getXSecondary() - 1.0f, phylogenyNode2.getYSecondary() - 1.0f, 3.0, 3.0, graphics2D);
        }
    }

    private final void paintBranchLength(Graphics2D graphics2D, PhylogenyNode phylogenyNode, boolean bl, boolean bl2) {
        graphics2D.setFont(this.getTreeFontSet().getSmallFont());
        if ((bl || bl2) && this.getOptions().isPrintBlackAndWhite()) {
            graphics2D.setColor(Color.BLACK);
        } else {
            graphics2D.setColor(this.getTreeColorSet().getBranchLengthColor());
        }
        if (!phylogenyNode.isRoot()) {
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) {
                TreePanel.drawString(FORMATTER_BRANCH_LENGTH.format(phylogenyNode.getDistanceToParent()), (double)(phylogenyNode.getParent().getXcoord() + 10.0f), (double)(phylogenyNode.getYcoord() - (float)this.getTreeFontSet()._small_max_descent), graphics2D);
            } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                TreePanel.drawString(FORMATTER_BRANCH_LENGTH.format(phylogenyNode.getDistanceToParent()), (double)(phylogenyNode.getParent().getXcoord() + 8.0f), (double)(phylogenyNode.getYcoord() - (float)this.getTreeFontSet()._small_max_descent), graphics2D);
            } else {
                TreePanel.drawString(FORMATTER_BRANCH_LENGTH.format(phylogenyNode.getDistanceToParent()), (double)(phylogenyNode.getParent().getXcoord() + 3.0f), (double)(phylogenyNode.getYcoord() - (float)this.getTreeFontSet()._small_max_descent), graphics2D);
            }
        } else {
            TreePanel.drawString(FORMATTER_BRANCH_LENGTH.format(phylogenyNode.getDistanceToParent()), 3.0, (double)(phylogenyNode.getYcoord() - (float)this.getTreeFontSet()._small_max_descent), graphics2D);
        }
    }

    private final void paintBranchLite(Graphics2D graphics2D, float f, float f2, float f3, float f4, PhylogenyNode phylogenyNode) {
        graphics2D.setColor(this.getTreeColorSet().getOvColor());
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR) {
            this.drawLine(f, f3, f2, f4, graphics2D);
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX) {
            this._quad_curve.setCurve(f, f3, f, f4, f2, f4);
            graphics2D.draw(this._quad_curve);
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CURVED) {
            float f5 = f2 - f;
            float f6 = f4 - f3;
            this._cubic_curve.setCurve(f, f3, f + f5 * 0.4f, f3 + f6 * 0.2f, f + f5 * 0.6f, f3 + f6 * 0.8f, f2, f4);
            graphics2D.draw(this._cubic_curve);
        } else {
            float f7 = f2;
            float f8 = f;
            if (phylogenyNode.isFirstChildNode() || phylogenyNode.isLastChildNode()) {
                this.drawLine(f, f3, f, f4, graphics2D);
            }
            this.drawLine(f8, f4, f7, f4, graphics2D);
        }
    }

    private final void paintBranchRectangular(Graphics2D graphics2D, float f, float f2, float f3, float f4, PhylogenyNode phylogenyNode, boolean bl, boolean bl2) {
        this.assignGraphicsForBranchWithColorForParentBranch(phylogenyNode, false, graphics2D, bl, bl2);
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR) {
            this.drawLine(f, f3, f2, f4, graphics2D);
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX) {
            this._quad_curve.setCurve(f, f3, f, f4, f2, f4);
            graphics2D.draw(this._quad_curve);
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CURVED) {
            float f5 = f2 - f;
            float f6 = f4 - f3;
            this._cubic_curve.setCurve(f, f3, f + f5 * 0.4f, f3 + f6 * 0.2f, f + f5 * 0.6f, f3 + f6 * 0.8f, f2, f4);
            graphics2D.draw(this._cubic_curve);
        } else {
            float f7;
            float f8 = f2;
            float f9 = f;
            float f10 = 0.0f;
            if (!(!phylogenyNode.isFirstChildNode() && !phylogenyNode.isLastChildNode() && this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE && this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED || !bl2 && !bl && ((double)f4 < this.getVisibleRect().getMinY() - 20.0 && (double)f3 < this.getVisibleRect().getMinY() - 20.0 || (double)f4 > this.getVisibleRect().getMaxY() + 20.0 && (double)f3 > this.getVisibleRect().getMaxY() + 20.0))) {
                if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) {
                    f7 = f + 10.0f;
                    if (f7 > f8) {
                        f7 = f8;
                    }
                    this.drawLine(f, f3, f7, f4, graphics2D);
                } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                    if (f4 > f3) {
                        f10 = f4 - 8.0f;
                        if (f10 < f3) {
                            f10 = f3;
                        }
                        this.drawLine(f, f3, f, f10, graphics2D);
                    } else {
                        f10 = f4 + 8.0f;
                        if (f10 > f3) {
                            f10 = f3;
                        }
                        this.drawLine(f, f3, f, f10, graphics2D);
                    }
                } else {
                    this.drawLine(f, f3, f, f4, graphics2D);
                }
            }
            if (!bl2 && !bl && ((double)f4 < this.getVisibleRect().getMinY() - 20.0 || (double)f4 > this.getVisibleRect().getMaxY() + 20.0)) {
                return;
            }
            f7 = 0.0f;
            if (!this.getControlPanel().isWidthBranches() || PhylogenyMethods.getBranchWidthValue(phylogenyNode) == 1.0) {
                if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                    f7 = f9 + 8.0f;
                    if (f7 < f8) {
                        this.drawLine(f7, f4, f8, f4, graphics2D);
                    }
                } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) {
                    float f11 = f9 + 10.0f;
                    if (f11 < f8) {
                        this.drawLine(f11, f4, f8, f4, graphics2D);
                    }
                } else {
                    this.drawLine(f9, f4, f8, f4, graphics2D);
                }
            } else {
                double d = PhylogenyMethods.getBranchWidthValue(phylogenyNode);
                if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                    f7 = f9 + 8.0f;
                    if (f7 < f8) {
                        this.drawRectFilled(f7, (double)f4 - d / 2.0, f8 - f7, d, graphics2D);
                    }
                } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) {
                    float f12 = f9 + 10.0f;
                    if (f12 < f8) {
                        this.drawRectFilled(f12, (double)f4 - d / 2.0, f8 - f12, d, graphics2D);
                    }
                } else {
                    this.drawRectFilled(f9, (double)f4 - d / 2.0, f8 - f9, d, graphics2D);
                }
            }
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                if (f7 > f8) {
                    f7 = f8;
                }
                if (f4 > f10) {
                    double d = f4 - f10;
                    this._arc.setArc(f, (double)f10 - d, 2.0f * (f7 - f), 2.0 * d, 180.0, 90.0, 0);
                } else {
                    this._arc.setArc(f, f4, 2.0f * (f7 - f), 2.0f * (f10 - f4), 90.0, 90.0, 0);
                }
                graphics2D.draw(this._arc);
            }
        }
        if (phylogenyNode.isExternal()) {
            this.paintNodeBox(f2, f4, phylogenyNode, graphics2D, bl, bl2, this.isInFoundNodes(phylogenyNode));
        }
    }

    final void paintCircular(Phylogeny phylogeny, double d, int n, int n2, int n3, Graphics2D graphics2D, boolean bl, boolean bl2) {
        int n4 = phylogeny.getNumberOfExternalNodes() - this._collapsed_external_nodeid_set.size();
        System.out.println("# collapsed external = " + this._collapsed_external_nodeid_set.size());
        this._root = phylogeny.getRoot();
        this._root.setXcoord(n);
        this._root.setYcoord(n2);
        boolean bl3 = this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.RADIAL;
        double d2 = d;
        int n5 = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.isCollapse()) {
                phylogenyNode.setXcoord((float)((double)n + (double)n3 * Math.cos(d2)));
                phylogenyNode.setYcoord((float)((double)n2 + (double)n3 * Math.sin(d2)));
                this._urt_nodeid_angle_map.put(phylogenyNode.getId(), d2);
                this._urt_nodeid_index_map.put(phylogenyNode.getId(), n5++);
                d2 += Math.PI * 2 / (double)n4;
                continue;
            }
            System.out.println("is collapse" + phylogenyNode.getName());
        }
        this.paintCirculars(phylogeny.getRoot(), phylogeny, n, n2, n3, bl3, graphics2D, bl, bl2);
        this.paintNodeBox(this._root.getXcoord(), this._root.getYcoord(), this._root, graphics2D, bl, bl2, this.isInFoundNodes(this._root));
    }

    private void updateSetOfCollapsedExternalNodes(Phylogeny phylogeny) {
        this._collapsed_external_nodeid_set.clear();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        block0: while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode;
            PhylogenyNode phylogenyNode2 = phylogenyNode = phylogenyNodeIterator.next();
            while (!phylogenyNode2.isRoot()) {
                if (phylogenyNode2.isCollapse()) {
                    this._collapsed_external_nodeid_set.add(phylogenyNode.getId());
                    continue block0;
                }
                phylogenyNode2 = phylogenyNode2.getParent();
            }
        }
    }

    final void paintCircularLite(Phylogeny phylogeny, double d, int n, int n2, int n3, Graphics2D graphics2D) {
        int n4 = phylogeny.getNumberOfExternalNodes();
        this._root = phylogeny.getRoot();
        this._root.setXSecondary(n);
        this._root.setYSecondary(n2);
        double d2 = d;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            phylogenyNode.setXSecondary((float)((double)n + (double)n3 * Math.cos(d2)));
            phylogenyNode.setYSecondary((float)((double)n2 + (double)n3 * Math.sin(d2)));
            this._urt_nodeid_angle_map.put(phylogenyNode.getId(), d2);
            d2 += Math.PI * 2 / (double)n4;
        }
        this.paintCircularsLite(phylogeny.getRoot(), phylogeny, n, n2, n3, graphics2D);
    }

    private final double paintCirculars(PhylogenyNode phylogenyNode, Phylogeny phylogeny, float f, float f2, double d, boolean bl, Graphics2D graphics2D, boolean bl2, boolean bl3) {
        if (phylogenyNode.isExternal() || phylogenyNode.isCollapse()) {
            if (!this._urt_nodeid_angle_map.containsKey(phylogenyNode.getId())) {
                System.out.println("no " + phylogenyNode + " =====>>>>>>> ERROR!");
            }
            return this._urt_nodeid_angle_map.get(phylogenyNode.getId());
        }
        List<PhylogenyNode> list = phylogenyNode.getDescendants();
        double d2 = 0.0;
        for (PhylogenyNode phylogenyNode2 : list) {
            d2 += this.paintCirculars(phylogenyNode2, phylogeny, f, f2, d, bl, graphics2D, bl2, bl3);
        }
        double d3 = 0.0;
        if (!phylogenyNode.isRoot()) {
            d3 = 1.0 - ((double)this._circ_max_depth - (double)PhylogenyMethods.calculateDepth(phylogenyNode)) / (double)this._circ_max_depth;
        }
        double d4 = d2 / (double)list.size();
        phylogenyNode.setXcoord((float)((double)f + d3 * d * Math.cos(d4)));
        phylogenyNode.setYcoord((float)((double)f2 + d3 * d * Math.sin(d4)));
        this._urt_nodeid_angle_map.put(phylogenyNode.getId(), d4);
        for (PhylogenyNode phylogenyNode3 : list) {
            this.paintBranchCircular(phylogenyNode, phylogenyNode3, graphics2D, bl, bl2, bl3);
        }
        return d4;
    }

    private final void paintCircularsLite(PhylogenyNode phylogenyNode, Phylogeny phylogeny, int n, int n2, int n3, Graphics2D graphics2D) {
        if (phylogenyNode.isExternal()) {
            return;
        }
        List<PhylogenyNode> list = phylogenyNode.getDescendants();
        for (PhylogenyNode phylogenyNode2 : list) {
            this.paintCircularsLite(phylogenyNode2, phylogeny, n, n2, n3, graphics2D);
        }
        float f = 0.0f;
        if (!phylogenyNode.isRoot()) {
            f = 1.0f - ((float)this._circ_max_depth - (float)PhylogenyMethods.calculateDepth(phylogenyNode)) / (float)this._circ_max_depth;
        }
        double d = this._urt_nodeid_angle_map.get(phylogenyNode.getId());
        phylogenyNode.setXSecondary((float)((double)n + (double)((float)n3 * f) * Math.cos(d)));
        phylogenyNode.setYSecondary((float)((double)n2 + (double)((float)n3 * f) * Math.sin(d)));
        for (PhylogenyNode phylogenyNode3 : list) {
            this.paintBranchCircularLite(phylogenyNode, phylogenyNode3, graphics2D);
        }
    }

    private final void paintCollapsedNode(Graphics2D graphics2D, PhylogenyNode phylogenyNode, boolean bl, boolean bl2, boolean bl3) {
        short s;
        Color color = null;
        color = (bl2 || bl) && this.getOptions().isPrintBlackAndWhite() ? Color.BLACK : (bl3 ? this.getTreeColorSet().getFoundColor() : (this.getControlPanel().isColorAccordingToTaxonomy() ? this.getTaxonomyBasedColor(phylogenyNode) : (this.getOptions().isColorLabelsSameAsParentBranch() && this.getControlPanel().isColorBranches() && PhylogenyMethods.getBranchColorValue(phylogenyNode) != null ? PhylogenyMethods.getBranchColorValue(phylogenyNode) : this.getTreeColorSet().getCollapseFillColor())));
        double d = phylogenyNode.getAllExternalDescendants().size();
        if ((d = d > 1000.0 ? (double)(3.0f * this._y_distance / 3.0f) : Math.log10(d) * (double)this._y_distance / 2.5) < (double)(s = this.getOptions().getDefaultNodeShapeSize())) {
            d = s;
        }
        this._polygon.reset();
        this._polygon.addPoint(ForesterUtil.roundToInt(phylogenyNode.getXcoord() - (float)s), ForesterUtil.roundToInt(phylogenyNode.getYcoord()));
        this._polygon.addPoint(ForesterUtil.roundToInt(phylogenyNode.getXcoord() + (float)s), ForesterUtil.roundToInt((double)phylogenyNode.getYcoord() - d));
        this._polygon.addPoint(ForesterUtil.roundToInt(phylogenyNode.getXcoord() + (float)s), ForesterUtil.roundToInt((double)phylogenyNode.getYcoord() + d));
        if (this.getOptions().getDefaultNodeFill() == NodeVisualization.NodeFill.SOLID) {
            graphics2D.setColor(color);
            graphics2D.fillPolygon(this._polygon);
        } else if (this.getOptions().getDefaultNodeFill() == NodeVisualization.NodeFill.NONE) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillPolygon(this._polygon);
            graphics2D.setColor(color);
            graphics2D.drawPolygon(this._polygon);
        } else if (this.getOptions().getDefaultNodeFill() == NodeVisualization.NodeFill.GRADIENT) {
            graphics2D.setPaint(new GradientPaint(phylogenyNode.getXcoord() - (float)s, phylogenyNode.getYcoord(), this.getBackground(), phylogenyNode.getXcoord() + (float)s, (float)((double)phylogenyNode.getYcoord() - d), color, false));
            graphics2D.fill(this._polygon);
            graphics2D.setPaint(color);
            graphics2D.draw(this._polygon);
        }
        this.paintNodeData(graphics2D, phylogenyNode, bl, bl2, bl3);
    }

    @Override
    public final void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHints(this._rendering_hints);
        this.paintPhylogeny(graphics2D, false, false, 0, 0, 0, 0);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private final void paintConfidenceValues(Graphics2D graphics2D, PhylogenyNode phylogenyNode, boolean bl, boolean bl2) {
        double d;
        String string = "";
        List<Confidence> list = phylogenyNode.getBranchData().getConfidences();
        if (list.size() == 1) {
            d = phylogenyNode.getBranchData().getConfidence(0).getValue();
            if (d == -9999.0 || d < this.getOptions().getMinConfidenceValue()) {
                return;
            }
            string = FORMATTER_CONFIDENCE.format(d);
        } else if (list.size() > 1) {
            boolean bl3 = false;
            boolean bl4 = false;
            Collections.sort(list);
            StringBuilder stringBuilder = new StringBuilder();
            for (Confidence confidence : list) {
                double d2 = confidence.getValue();
                if (d2 == -9999.0) continue;
                if (d2 >= this.getOptions().getMinConfidenceValue()) {
                    bl3 = true;
                }
                if (bl4) {
                    stringBuilder.append("/");
                } else {
                    bl4 = true;
                }
                stringBuilder.append(FORMATTER_CONFIDENCE.format(ForesterUtil.round(d2, this.getOptions().getNumberOfDigitsAfterCommaForConfidenceValues())));
            }
            if (bl3) {
                string = stringBuilder.toString();
            }
        }
        if (string.length() > 0) {
            d = phylogenyNode.getParent().getXcoord();
            double d3 = phylogenyNode.getXcoord();
            graphics2D.setFont(this.getTreeFontSet().getSmallFont());
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) {
                d3 += 10.0;
            } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                d3 += 8.0;
            }
            if ((bl || bl2) && this.getOptions().isPrintBlackAndWhite()) {
                graphics2D.setColor(Color.BLACK);
            } else {
                graphics2D.setColor(this.getTreeColorSet().getConfidenceColor());
            }
            TreePanel.drawString(string, d + (d3 - d - (double)this.getTreeFontSet()._fm_small.stringWidth(string)) / 2.0, (double)(phylogenyNode.getYcoord() + (float)this.getTreeFontSet()._small_max_ascent - 1.0f), graphics2D);
        }
    }

    private final void paintFoundNode(int n, int n2, Graphics2D graphics2D) {
        short s = this.getOptions().getDefaultNodeShapeSize();
        int n3 = this.getOptions().getDefaultNodeShapeSize() / 2;
        graphics2D.setColor(this.getTreeColorSet().getFoundColor());
        graphics2D.fillRect(n - n3, n2 - n3, s, s);
    }

    private final void paintGainedAndLostCharacters(Graphics2D graphics2D, PhylogenyNode phylogenyNode, String string, String string2) {
        if (phylogenyNode.getParent() != null) {
            double d = phylogenyNode.getParent().getXcoord();
            double d2 = phylogenyNode.getXcoord();
            graphics2D.setFont(this.getTreeFontSet().getLargeFont());
            graphics2D.setColor(this.getTreeColorSet().getGainedCharactersColor());
            TreePanel.drawString(string, d + (d2 - d - (double)this.getTreeFontSet()._fm_large.stringWidth(string)) / 2.0, (double)(phylogenyNode.getYcoord() - (float)this.getTreeFontSet()._fm_large.getMaxDescent()), graphics2D);
            graphics2D.setColor(this.getTreeColorSet().getLostCharactersColor());
            TreePanel.drawString(string2, d + (d2 - d - (double)this.getTreeFontSet()._fm_large.stringWidth(string2)) / 2.0, (double)(phylogenyNode.getYcoord() + (float)this.getTreeFontSet()._fm_large.getMaxAscent()), graphics2D);
        }
    }

    private final void paintNodeBox(double d, double d2, PhylogenyNode phylogenyNode, Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        if (phylogenyNode.isCollapse()) {
            return;
        }
        if (this._highlight_node == phylogenyNode && !bl && !bl2) {
            graphics2D.setColor(this.getTreeColorSet().getFoundColor());
            this.drawOval(d - 8.0, d2 - 8.0, 16.0, 16.0, graphics2D);
            this.drawOval(d - 9.0, d2 - 8.0, 17.0, 17.0, graphics2D);
            this.drawOval(d - 9.0, d2 - 9.0, 18.0, 18.0, graphics2D);
        }
        if (bl3) {
            this.paintFoundNode(ForesterUtil.roundToInt(d), ForesterUtil.roundToInt(d2), graphics2D);
        } else {
            Color color = null;
            if ((bl || bl2) && this.getOptions().isPrintBlackAndWhite()) {
                color = Color.BLACK;
            } else if (this.getControlPanel().isEvents() && Util.isHasAssignedEvent(phylogenyNode)) {
                Event event = phylogenyNode.getNodeData().getEvent();
                if (event.isDuplication()) {
                    color = this.getTreeColorSet().getDuplicationBoxColor();
                } else if (event.isSpeciation()) {
                    color = this.getTreeColorSet().getSpecBoxColor();
                } else if (event.isSpeciationOrDuplication()) {
                    color = this.getTreeColorSet().getDuplicationOrSpeciationColor();
                }
            } else if (this.getOptions().isTaxonomyColorizeNodeShapes()) {
                color = this.getTaxonomyBasedColor(phylogenyNode);
            } else {
                color = this.getGraphicsForNodeBoxWithColorForParentBranch(phylogenyNode);
                if (bl && color == this.getTreeColorSet().getBranchColor()) {
                    color = this.getTreeColorSet().getBranchColorForPdf();
                }
            }
            short s = this.getOptions().getDefaultNodeShapeSize();
            int n = s / 2;
            if (this.getOptions().isShowDefaultNodeShapes() || this.getControlPanel().isEvents() && phylogenyNode.isHasAssignedEvent()) {
                if (this.getOptions().getDefaultNodeShape() == NodeVisualization.NodeShape.CIRCLE) {
                    if (this.getOptions().getDefaultNodeFill() == NodeVisualization.NodeFill.GRADIENT) {
                        this.drawOvalGradient(d - (double)n, d2 - (double)n, s, s, graphics2D, bl ? Color.WHITE : color, bl ? color : this.getBackground(), color);
                    } else if (this.getOptions().getDefaultNodeFill() == NodeVisualization.NodeFill.NONE) {
                        Color color2 = this.getBackground();
                        if (bl) {
                            color2 = Color.WHITE;
                        }
                        this.drawOvalGradient(d - (double)n, d2 - (double)n, s, s, graphics2D, color2, color2, color);
                    } else if (this.getOptions().getDefaultNodeFill() == NodeVisualization.NodeFill.SOLID) {
                        graphics2D.setColor(color);
                        this.drawOvalFilled(d - (double)n, d2 - (double)n, s, s, graphics2D);
                    }
                } else if (this.getOptions().getDefaultNodeShape() == NodeVisualization.NodeShape.RECTANGLE) {
                    if (this.getOptions().getDefaultNodeFill() == NodeVisualization.NodeFill.GRADIENT) {
                        this.drawRectGradient(d - (double)n, d2 - (double)n, s, s, graphics2D, bl ? Color.WHITE : color, bl ? color : this.getBackground(), color);
                    } else if (this.getOptions().getDefaultNodeFill() == NodeVisualization.NodeFill.NONE) {
                        Color color3 = this.getBackground();
                        if (bl) {
                            color3 = Color.WHITE;
                        }
                        this.drawRectGradient(d - (double)n, d2 - (double)n, s, s, graphics2D, color3, color3, color);
                    } else if (this.getOptions().getDefaultNodeFill() == NodeVisualization.NodeFill.SOLID) {
                        graphics2D.setColor(color);
                        this.drawRectFilled(d - (double)n, d2 - (double)n, s, s, graphics2D);
                    }
                }
            }
        }
    }

    private final void paintNodeData(Graphics2D graphics2D, PhylogenyNode phylogenyNode, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        String string;
        double d;
        double d2;
        double d3;
        int n;
        int n2;
        block49: {
            int n3;
            block50: {
                if (this.isNodeDataInvisible(phylogenyNode) && !bl && !bl2) {
                    return;
                }
                if (this.getOptions().isShowBranchLengthValues() && (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) && !phylogenyNode.isRoot() && phylogenyNode.getDistanceToParent() != -1024.0) {
                    this.paintBranchLength(graphics2D, phylogenyNode, bl2, bl);
                }
                if (!(this.getControlPanel().isShowInternalData() || phylogenyNode.isExternal() || phylogenyNode.isCollapse())) {
                    return;
                }
                n2 = 0;
                n = this.getOptions().getDefaultNodeShapeSize() / 2;
                if (this.getControlPanel().isShowTaxonomyImages() && this.getImageMap() != null && !this.getImageMap().isEmpty() && phylogenyNode.getNodeData().isHasTaxonomy() && phylogenyNode.getNodeData().getTaxonomy().getUris() != null && !phylogenyNode.getNodeData().getTaxonomy().getUris().isEmpty()) {
                    n2 = (int)((double)n2 + this.drawTaxonomyImage(phylogenyNode.getXcoord() + 2.0f + (float)n, phylogenyNode.getYcoord(), phylogenyNode, graphics2D));
                }
                if ((this.getControlPanel().isShowTaxonomyCode() || this.getControlPanel().isShowTaxonomyScientificNames() || this.getControlPanel().isShowTaxonomyCommonNames()) && phylogenyNode.getNodeData().isHasTaxonomy()) {
                    n2 += this.paintTaxonomy(graphics2D, phylogenyNode, bl3, bl2, bl, n2);
                }
                if ((bl2 || bl) && this.getOptions().isPrintBlackAndWhite()) {
                    graphics2D.setColor(Color.BLACK);
                } else if (bl3) {
                    graphics2D.setColor(this.getTreeColorSet().getFoundColor());
                } else if (this.getControlPanel().isColorAccordingToTaxonomy()) {
                    graphics2D.setColor(this.getTaxonomyBasedColor(phylogenyNode));
                } else if (this.getOptions().isColorLabelsSameAsParentBranch() && this.getControlPanel().isColorBranches() && PhylogenyMethods.getBranchColorValue(phylogenyNode) != null) {
                    graphics2D.setColor(PhylogenyMethods.getBranchColorValue(phylogenyNode));
                } else if (bl2) {
                    graphics2D.setColor(Color.BLACK);
                } else {
                    graphics2D.setColor(this.getTreeColorSet().getSequenceColor());
                }
                this._sb.setLength(0);
                if (phylogenyNode.isCollapse() && (!phylogenyNode.isRoot() && !phylogenyNode.getParent().isCollapse() || phylogenyNode.isRoot())) {
                    this._sb.append(" [");
                    this._sb.append(phylogenyNode.getAllExternalDescendants().size());
                    this._sb.append("]");
                }
                if (this.getControlPanel().isShowNodeNames() && phylogenyNode.getName().length() > 0) {
                    if (this._sb.length() > 0) {
                        this._sb.append(" ");
                    }
                    this._sb.append(phylogenyNode.getName());
                }
                if (phylogenyNode.getNodeData().isHasSequence()) {
                    if (this.getControlPanel().isShowGeneSymbols() && phylogenyNode.getNodeData().getSequence().getSymbol().length() > 0) {
                        if (this._sb.length() > 0) {
                            this._sb.append(" ");
                        }
                        this._sb.append(phylogenyNode.getNodeData().getSequence().getSymbol());
                    }
                    if (this.getControlPanel().isShowGeneNames() && phylogenyNode.getNodeData().getSequence().getName().length() > 0) {
                        if (this._sb.length() > 0) {
                            this._sb.append(" ");
                        }
                        this._sb.append(phylogenyNode.getNodeData().getSequence().getName());
                    }
                    if (this.getControlPanel().isShowSequenceAcc() && phylogenyNode.getNodeData().getSequence().getAccession() != null) {
                        if (this._sb.length() > 0) {
                            this._sb.append(" ");
                        }
                        if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getSource())) {
                            this._sb.append(phylogenyNode.getNodeData().getSequence().getAccession().getSource());
                            this._sb.append(":");
                        }
                        this._sb.append(phylogenyNode.getNodeData().getSequence().getAccession().getValue());
                    }
                }
                if (this.getControlPanel().isShowProperties() && phylogenyNode.getNodeData().isHasProperties()) {
                    if (this._sb.length() > 0) {
                        this._sb.append(" ");
                    }
                    this._sb.append(this.propertiesToString(phylogenyNode));
                }
                graphics2D.setFont(this.getTreeFontSet().getLargeFont());
                if (bl3) {
                    graphics2D.setFont(this.getTreeFontSet().getLargeFont().deriveFont(1));
                }
                d3 = 3.0;
                if (!phylogenyNode.isExternal() && phylogenyNode.getNumberOfDescendants() == 1) {
                    d3 = 1.0;
                }
                d2 = phylogenyNode.getXcoord() + (float)n2 + 2.0f + (float)n;
                d = (double)phylogenyNode.getYcoord() + (double)this.getTreeFontSet()._fm_large.getAscent() / d3;
                string = this._sb.toString();
                if (!this._control_panel.isShowSequenceRelations() || !phylogenyNode.getNodeData().isHasSequence() || this._query_sequence == null) break block49;
                n3 = 0;
                if (string.length() > 0) {
                    object = new TextLayout(string, graphics2D.getFont(), this._frc).getBounds();
                    n3 = (int)((RectangularShape)object).getWidth();
                }
                if (!phylogenyNode.getNodeData().getSequence().equals(this._query_sequence)) break block50;
                if (n3 <= 0) break block49;
                graphics2D.fillRect((int)d2 - 1, (int)d - 8, n3 + 5, 11);
                graphics2D.setColor(this.getTreeColorSet().getBackgroundColor());
                break block49;
            }
            object = phylogenyNode.getNodeData().getSequence().getSequenceRelations();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2;
                SequenceRelation sequenceRelation = (SequenceRelation)iterator.next();
                boolean bl4 = (sequenceRelation.getRef0().isEqual(this._query_sequence) || sequenceRelation.getRef1().isEqual(this._query_sequence)) && sequenceRelation.getType().equals(this.getControlPanel().getSequenceRelationTypeBox().getSelectedItem());
                if (!bl4) continue;
                double d4 = phylogenyNode.getXcoord() + 2.0f + (float)n;
                String string3 = string2 = !this.getControlPanel().isShowSequenceRelationConfidence() || sequenceRelation.getConfidence() == null ? null : " (" + sequenceRelation.getConfidence().getValue() + ")";
                if (string2 != null) {
                    double d5 = d2;
                    if (string.length() > 0) {
                        d5 += new TextLayout(string, graphics2D.getFont(), this._frc).getBounds().getWidth() + 4.0;
                    }
                    if (d5 > d4) {
                        int n4 = (int)new TextLayout(string2, graphics2D.getFont(), this._frc).getBounds().getWidth();
                        TreePanel.drawString(string2, d5, d, graphics2D);
                        n2 += 4 + n4;
                    }
                }
                if (n2 + n3 <= 0) continue;
                n3 = n3 == 0 ? (n3 -= 3) : (n3 += 2);
                graphics2D.drawLine((int)d4 + 1, 3 + (int)d, (int)d4 + n2 + n3, 3 + (int)d);
                break;
            }
        }
        if (string.length() > 0) {
            TreePanel.drawString(string, d2, d, graphics2D);
        }
        if (this.getControlPanel().isShowAnnotation() && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getAnnotations() != null && !phylogenyNode.getNodeData().getSequence().getAnnotations().isEmpty()) {
            if (this._sb.length() > 0) {
                n2 += this.getTreeFontSet()._fm_large.stringWidth(this._sb.toString()) + 5;
            }
            Annotation annotation = phylogenyNode.getNodeData().getSequence().getAnnotation(0);
            if ((bl2 || bl) && this.getOptions().isPrintBlackAndWhite()) {
                graphics2D.setColor(Color.BLACK);
            } else {
                graphics2D.setColor(this.calculateColorForAnnotation(annotation));
            }
            object = annotation.asSimpleText().toString();
            TreePanel.drawString((String)object, (double)(phylogenyNode.getXcoord() + (float)n2 + 3.0f + (float)n), (double)phylogenyNode.getYcoord() + (double)this.getTreeFontSet()._fm_large.getAscent() / d3, graphics2D);
            this._sb.setLength(0);
            this._sb.append((String)object);
        }
        if ((this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) && (this.getControlPanel().isShowBinaryCharacters() || this.getControlPanel().isShowBinaryCharacterCounts()) && phylogenyNode.getNodeData().isHasBinaryCharacters()) {
            if (this._sb.length() > 0) {
                n2 += this.getTreeFontSet()._fm_large.stringWidth(this._sb.toString()) + 5;
            }
            if ((bl2 || bl) && this.getOptions().isPrintBlackAndWhite()) {
                graphics2D.setColor(Color.BLACK);
            } else {
                graphics2D.setColor(this.getTreeColorSet().getBinaryDomainCombinationsColor());
            }
            if (this.getControlPanel().isShowBinaryCharacters()) {
                TreePanel.drawString(phylogenyNode.getNodeData().getBinaryCharacters().getPresentCharactersAsStringBuffer().toString(), (double)(phylogenyNode.getXcoord() + (float)n2 + 1.0f + (float)n), (double)phylogenyNode.getYcoord() + (double)this.getTreeFontSet()._fm_large.getAscent() / d3, graphics2D);
                this.paintGainedAndLostCharacters(graphics2D, phylogenyNode, phylogenyNode.getNodeData().getBinaryCharacters().getGainedCharactersAsStringBuffer().toString(), phylogenyNode.getNodeData().getBinaryCharacters().getLostCharactersAsStringBuffer().toString());
            } else {
                if (phylogenyNode.isInternal()) {
                    List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
                    double d6 = 0.0;
                    int n5 = 0;
                    for (PhylogenyNode phylogenyNode2 : list) {
                        ++n5;
                        if (phylogenyNode2.getNodeData().getBinaryCharacters() == null) continue;
                        d6 += (double)phylogenyNode2.getNodeData().getBinaryCharacters().getPresentCount();
                    }
                    double d7 = ForesterUtil.round(d6 / (double)n5, 1);
                    TreePanel.drawString(" " + phylogenyNode.getNodeData().getBinaryCharacters().getPresentCount() + " [" + d7 + "]", (double)(phylogenyNode.getXcoord() + (float)n2 + 4.0f + (float)n), (double)phylogenyNode.getYcoord() + (double)this.getTreeFontSet()._fm_large.getAscent() / d3, graphics2D);
                } else {
                    TreePanel.drawString(" " + phylogenyNode.getNodeData().getBinaryCharacters().getPresentCount(), (double)(phylogenyNode.getXcoord() + (float)n2 + 4.0f + (float)n), (double)phylogenyNode.getYcoord() + (double)this.getTreeFontSet()._fm_large.getAscent() / d3, graphics2D);
                }
                this.paintGainedAndLostCharacters(graphics2D, phylogenyNode, "+" + phylogenyNode.getNodeData().getBinaryCharacters().getGainedCount(), "-" + phylogenyNode.getNodeData().getBinaryCharacters().getLostCount());
            }
        }
    }

    private StringBuffer propertiesToString(PhylogenyNode phylogenyNode) {
        PropertiesMap propertiesMap = phylogenyNode.getNodeData().getProperties();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string : propertiesMap.getPropertyRefs()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append(propertiesMap.getProperty(string).asText());
        }
        return stringBuffer;
    }

    private double drawTaxonomyImage(double d, double d2, PhylogenyNode phylogenyNode, Graphics2D graphics2D) {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        for (Taxonomy taxonomy : phylogenyNode.getNodeData().getTaxonomies()) {
            for (Uri uri : taxonomy.getUris()) {
                arrayList.add(uri);
            }
        }
        double d3 = 0.0;
        for (Uri uri : arrayList) {
            BufferedImage bufferedImage;
            if (uri == null) continue;
            String string = uri.getValue().toString().toLowerCase();
            if (!this.getImageMap().containsKey(string) || (bufferedImage = this.getImageMap().get(string)) == null || bufferedImage.getHeight() <= 5 || bufferedImage.getWidth() <= 5) continue;
            double d4 = 1.0;
            if (this.getOptions().isAllowMagnificationOfTaxonomyImages() || (double)bufferedImage.getHeight() > 1.8 * (double)this.getYdistance()) {
                d4 = 1.8 * (double)this.getYdistance() / (double)bufferedImage.getHeight();
            }
            double d5 = (double)bufferedImage.getHeight() * d4;
            double d6 = (double)bufferedImage.getWidth() * d4 + d3;
            double d7 = d2 - 0.5 * d5;
            int n = (int)(d + d6 + 0.5);
            int n2 = (int)(d7 + d5 + 0.5);
            if ((double)n - d > 7.0 && (double)n2 - d7 > 7.0) {
                graphics2D.drawImage(bufferedImage, (int)(d + 0.5 + d3), (int)(d7 + 0.5), n, n2, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
                d6 += 8.0;
            } else {
                d6 = 0.0;
            }
            d3 = d6;
        }
        return d3;
    }

    private final void paintNodeDataUnrootedCirc(Graphics2D graphics2D, PhylogenyNode phylogenyNode, boolean bl, boolean bl2, boolean bl3, double d, boolean bl4) {
        Object object;
        if (this.isNodeDataInvisibleUnrootedCirc(phylogenyNode) && !bl2 && !bl) {
            return;
        }
        if ((bl || bl2) && this.getOptions().isPrintBlackAndWhite()) {
            graphics2D.setColor(Color.BLACK);
        } else if (bl4) {
            graphics2D.setColor(this.getTreeColorSet().getFoundColor());
        } else if (this.getControlPanel().isColorAccordingToTaxonomy()) {
            graphics2D.setColor(this.getTaxonomyBasedColor(phylogenyNode));
        } else {
            graphics2D.setColor(this.getTreeColorSet().getSequenceColor());
        }
        this._sb.setLength(0);
        this._sb.append(" ");
        if (phylogenyNode.getNodeData().isHasTaxonomy() && (this.getControlPanel().isShowTaxonomyCode() || this.getControlPanel().isShowTaxonomyScientificNames() || this.getControlPanel().isShowTaxonomyCommonNames())) {
            object = phylogenyNode.getNodeData().getTaxonomy();
            if (this._control_panel.isShowTaxonomyCode() && !ForesterUtil.isEmpty(((Taxonomy)object).getTaxonomyCode())) {
                this._sb.append(((Taxonomy)object).getTaxonomyCode());
                this._sb.append(" ");
            }
            if (this._control_panel.isShowTaxonomyScientificNames() && this._control_panel.isShowTaxonomyCommonNames()) {
                if (!ForesterUtil.isEmpty(((Taxonomy)object).getScientificName()) && !ForesterUtil.isEmpty(((Taxonomy)object).getCommonName())) {
                    this._sb.append(((Taxonomy)object).getScientificName());
                    this._sb.append(" (");
                    this._sb.append(((Taxonomy)object).getCommonName());
                    this._sb.append(") ");
                } else if (!ForesterUtil.isEmpty(((Taxonomy)object).getScientificName())) {
                    this._sb.append(((Taxonomy)object).getScientificName());
                    this._sb.append(" ");
                } else if (!ForesterUtil.isEmpty(((Taxonomy)object).getCommonName())) {
                    this._sb.append(((Taxonomy)object).getCommonName());
                    this._sb.append(" ");
                }
            } else if (this._control_panel.isShowTaxonomyScientificNames()) {
                if (!ForesterUtil.isEmpty(((Taxonomy)object).getScientificName())) {
                    this._sb.append(((Taxonomy)object).getScientificName());
                    this._sb.append(" ");
                }
            } else if (this._control_panel.isShowTaxonomyCommonNames() && !ForesterUtil.isEmpty(((Taxonomy)object).getCommonName())) {
                this._sb.append(((Taxonomy)object).getCommonName());
                this._sb.append(" ");
            }
        }
        if (phylogenyNode.isCollapse() && (!phylogenyNode.isRoot() && !phylogenyNode.getParent().isCollapse() || phylogenyNode.isRoot())) {
            this._sb.append(" [");
            this._sb.append(phylogenyNode.getAllExternalDescendants().size());
            this._sb.append("]");
        }
        if (this.getControlPanel().isShowNodeNames() && phylogenyNode.getName().length() > 0) {
            if (this._sb.length() > 0) {
                this._sb.append(" ");
            }
            this._sb.append(phylogenyNode.getName());
        }
        if (phylogenyNode.getNodeData().isHasSequence()) {
            if (this.getControlPanel().isShowSequenceAcc() && phylogenyNode.getNodeData().getSequence().getAccession() != null) {
                if (this._sb.length() > 0) {
                    this._sb.append(" ");
                }
                if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getSource())) {
                    this._sb.append(phylogenyNode.getNodeData().getSequence().getAccession().getSource());
                    this._sb.append(":");
                }
                this._sb.append(phylogenyNode.getNodeData().getSequence().getAccession().getValue());
            }
            if (this.getControlPanel().isShowGeneNames() && phylogenyNode.getNodeData().getSequence().getName().length() > 0) {
                if (this._sb.length() > 0) {
                    this._sb.append(" ");
                }
                this._sb.append(phylogenyNode.getNodeData().getSequence().getName());
            }
        }
        graphics2D.setFont(this.getTreeFontSet().getLargeFont());
        if (bl4) {
            graphics2D.setFont(this.getTreeFontSet().getLargeFont().deriveFont(1));
        }
        if (this._sb.length() > 1) {
            object = this._sb.toString();
            double d2 = 0.0;
            d2 = this._graphics_type == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR ? this._urt_nodeid_angle_map.get(phylogenyNode.getId()) % (Math.PI * 2) : (double)((float)(d % (Math.PI * 2)));
            this._at = graphics2D.getTransform();
            boolean bl5 = false;
            float f = phylogenyNode.getXcoord();
            float f2 = phylogenyNode.getYcoord() + (float)this.getTreeFontSet()._fm_large.getAscent() / 3.0f;
            if (bl3) {
                bl5 = true;
                boolean bl6 = false;
                if (d2 > 1.5707963705062866 && d2 < 4.71238899230957) {
                    d2 -= 3.1415927410125732;
                    bl6 = true;
                }
                graphics2D.rotate(d2, f, phylogenyNode.getYcoord());
                if (bl6) {
                    graphics2D.translate(-this.getTreeFontSet()._fm_large.getStringBounds((String)object, graphics2D).getWidth(), 0.0);
                }
            } else if (d2 > 1.5707963705062866 && d2 < 4.71238899230957) {
                bl5 = true;
                graphics2D.translate(-this.getTreeFontSet()._fm_large.getStringBounds((String)object, graphics2D).getWidth(), 0.0);
            }
            TreePanel.drawString((String)object, (double)f, (double)f2, graphics2D);
            if (bl5) {
                graphics2D.setTransform(this._at);
            }
        }
    }

    private final void paintNodeLite(Graphics2D graphics2D, PhylogenyNode phylogenyNode) {
        if (phylogenyNode.isCollapse()) {
            if (!phylogenyNode.isRoot() && !phylogenyNode.getParent().isCollapse() || phylogenyNode.isRoot()) {
                this.paintCollapsedNode(graphics2D, phylogenyNode, false, false, false);
            }
            return;
        }
        if (this.isInFoundNodes(phylogenyNode)) {
            graphics2D.setColor(this.getTreeColorSet().getFoundColor());
            this.drawRectFilled(phylogenyNode.getXSecondary() - 1.0f, phylogenyNode.getYSecondary() - 1.0f, 3.0, 3.0, graphics2D);
        }
        float f = 0.0f;
        if (!phylogenyNode.isExternal() && !phylogenyNode.isCollapse()) {
            boolean bl = true;
            float f2 = 0.0f;
            short s = this.getMaxBranchesToLeaf(phylogenyNode);
            for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
                PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode(i);
                int n = !this.isUniformBranchLengthsForCladogram() ? phylogenyNode.getNumberOfExternalNodes() - phylogenyNode2.getNumberOfExternalNodes() : s - this.getMaxBranchesToLeaf(phylogenyNode2);
                if (bl) {
                    bl = false;
                    f2 = phylogenyNode.getYSecondary() - this.getOvYDistance() * (float)(phylogenyNode.getNumberOfExternalNodes() - phylogenyNode2.getNumberOfExternalNodes());
                } else {
                    f2 += this.getOvYDistance() * (float)phylogenyNode2.getNumberOfExternalNodes();
                }
                float f3 = this.calculateOvBranchLengthToParent(phylogenyNode2, n);
                f = f3 + phylogenyNode.getXSecondary();
                float f4 = phylogenyNode.getYSecondary() - f2;
                float f5 = phylogenyNode.getXSecondary() - f;
                if (f4 > 2.0f || f4 < -2.0f || f5 > 2.0f || f5 < -2.0f) {
                    this.paintBranchLite(graphics2D, phylogenyNode.getXSecondary(), f, phylogenyNode.getYSecondary(), f2, phylogenyNode2);
                }
                phylogenyNode2.setXSecondary(f);
                phylogenyNode2.setYSecondary(f2);
                f2 += this.getOvYDistance() * (float)phylogenyNode2.getNumberOfExternalNodes();
            }
        }
    }

    private final void paintNodeRectangular(Graphics2D graphics2D, PhylogenyNode phylogenyNode, boolean bl, boolean bl2, int n, boolean bl3) {
        boolean bl4 = this.isInFoundNodes(phylogenyNode);
        if (phylogenyNode.isCollapse()) {
            if (!phylogenyNode.isRoot() && !phylogenyNode.getParent().isCollapse() || phylogenyNode.isRoot()) {
                this.paintCollapsedNode(graphics2D, phylogenyNode, bl3, bl, bl4);
            }
            return;
        }
        if (phylogenyNode.isExternal()) {
            ++this._external_node_index;
        }
        if (this.getControlPanel().isShowBootstrapValues() && !phylogenyNode.isExternal() && !phylogenyNode.isRoot() && (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) && phylogenyNode.getBranchData().isHasConfidences()) {
            this.paintConfidenceValues(graphics2D, phylogenyNode, bl, bl3);
        }
        if (phylogenyNode.isRoot() && this._phylogeny.isRooted()) {
            this.paintRootBranch(graphics2D, phylogenyNode.getXcoord(), phylogenyNode.getYcoord(), phylogenyNode, bl, bl3);
        }
        float f = 0.0f;
        float f2 = Float.MAX_VALUE;
        boolean bl5 = n < 40;
        float f3 = 1.5f;
        if (!bl5) {
            if (n > 4000) {
                f3 = 4.0f;
            } else if (n > 1000) {
                f3 = 3.0f;
            } else if (n > 100) {
                f3 = 2.0f;
            }
        }
        if (!phylogenyNode.isExternal() && !phylogenyNode.isCollapse()) {
            boolean bl6 = true;
            float f4 = 0.0f;
            short s = this.getMaxBranchesToLeaf(phylogenyNode);
            for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
                PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode(i);
                int n2 = !this.isUniformBranchLengthsForCladogram() ? phylogenyNode.getNumberOfExternalNodes() - phylogenyNode2.getNumberOfExternalNodes() : s - this.getMaxBranchesToLeaf(phylogenyNode2);
                if (bl6) {
                    bl6 = false;
                    f4 = phylogenyNode.getYcoord() - this._y_distance * (float)(phylogenyNode.getNumberOfExternalNodes() - phylogenyNode2.getNumberOfExternalNodes());
                } else {
                    f4 += this._y_distance * (float)phylogenyNode2.getNumberOfExternalNodes();
                }
                float f5 = this.calculateBranchLengthToParent(phylogenyNode2, n2);
                f = f5 + phylogenyNode.getXcoord();
                if (bl2 && f5 < f2) {
                    f2 = f5;
                }
                float f6 = phylogenyNode.getYcoord() - f4;
                float f7 = phylogenyNode.getXcoord() - f;
                if (bl5 || f6 > f3 || f6 < -f3 || f7 > f3 || f7 < -f3 || bl3 || bl) {
                    this.paintBranchRectangular(graphics2D, phylogenyNode.getXcoord(), f, phylogenyNode.getYcoord(), f4, phylogenyNode2, bl, bl3);
                }
                phylogenyNode2.setXcoord(f);
                phylogenyNode2.setYcoord(f4);
                f4 += this._y_distance * (float)phylogenyNode2.getNumberOfExternalNodes();
            }
            this.paintNodeBox(phylogenyNode.getXcoord(), phylogenyNode.getYcoord(), phylogenyNode, graphics2D, bl, bl3, this.isInFoundNodes(phylogenyNode));
        }
        if (bl2 && !bl4 && (phylogenyNode.isExternal() && this._external_node_index % n != 1 || !phylogenyNode.isExternal() && (f2 < 20.0f || this._y_distance * (float)phylogenyNode.getNumberOfExternalNodes() < (float)this.getTreeFontSet()._fm_large.getHeight()))) {
            return;
        }
        this.paintNodeData(graphics2D, phylogenyNode, bl3, bl, bl4);
        this.paintNodeWithRenderableData(graphics2D, phylogenyNode, bl3, bl);
    }

    private final void paintNodeWithRenderableData(Graphics2D graphics2D, PhylogenyNode phylogenyNode, boolean bl, boolean bl2) {
        int n;
        RenderablePhylogenyData renderablePhylogenyData;
        if (this.isNodeDataInvisible(phylogenyNode) && !bl) {
            return;
        }
        if (!this.getControlPanel().isShowInternalData() && !phylogenyNode.isExternal()) {
            return;
        }
        if (this.getControlPanel().isShowDomainArchitectures() && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getDomainArchitecture() != null) {
            renderablePhylogenyData = null;
            if (phylogenyNode.getNodeData().getSequence().getDomainArchitecture() instanceof RenderableDomainArchitecture) {
                try {
                    renderablePhylogenyData = (RenderableDomainArchitecture)phylogenyNode.getNodeData().getSequence().getDomainArchitecture();
                }
                catch (ClassCastException classCastException) {
                    classCastException.printStackTrace();
                    return;
                }
                ((RenderableDomainArchitecture)renderablePhylogenyData).setRenderingHeight(6.0);
                n = 0;
                if (this.getControlPanel().isShowTaxonomyCode() && PhylogenyMethods.getSpecies(phylogenyNode).length() > 0) {
                    n += this.getTreeFontSet()._fm_large_italic.stringWidth(PhylogenyMethods.getSpecies(phylogenyNode) + " ");
                }
                if (this.getControlPanel().isShowGeneNames()) {
                    n += this.getTreeFontSet()._fm_large.stringWidth(phylogenyNode.getNodeData().getSequence().getName() + " ");
                }
                if (this.getControlPanel().isShowGeneSymbols()) {
                    n += this.getTreeFontSet()._fm_large.stringWidth(phylogenyNode.getNodeData().getSequence().getSymbol() + " ");
                }
                if (this.getControlPanel().isShowSequenceAcc()) {
                    n += this.getTreeFontSet()._fm_large.stringWidth(phylogenyNode.getNodeData().getSequence().getAccession().toString() + " ");
                }
                if (this.getControlPanel().isShowNodeNames() && phylogenyNode.getName().length() > 0) {
                    n += this.getTreeFontSet()._fm_large.stringWidth(phylogenyNode.getName() + " ");
                }
                ((RenderableDomainArchitecture)renderablePhylogenyData).render(phylogenyNode.getXcoord() + (float)n, phylogenyNode.getYcoord() - 3.0f, graphics2D, this, bl2);
            }
        }
        if (this.getControlPanel().isShowVectorData() && phylogenyNode.getNodeData().getVector() != null && phylogenyNode.getNodeData().getVector().size() > 0 && this.getStatisticsForExpressionValues() != null) {
            renderablePhylogenyData = RenderableVector.createInstance(phylogenyNode.getNodeData().getVector(), this.getStatisticsForExpressionValues(), this.getConfiguration());
            n = 0;
            PhylogenyNode phylogenyNode2 = phylogenyNode;
            if (!this.getControlPanel().isDrawPhylogram()) {
                phylogenyNode2 = this.getPhylogeny().getFirstExternalNode();
            }
            if (this.getControlPanel().isShowTaxonomyCode() && PhylogenyMethods.getSpecies(phylogenyNode2).length() > 0) {
                n += this.getTreeFontSet()._fm_large_italic.stringWidth(PhylogenyMethods.getSpecies(phylogenyNode2) + " ");
            }
            if (this.getControlPanel().isShowNodeNames() && phylogenyNode2.getName().length() > 0) {
                n += this.getTreeFontSet()._fm_large.stringWidth(phylogenyNode2.getName() + " ");
            }
            ((RenderableVector)renderablePhylogenyData).render(phylogenyNode2.getXcoord() + (float)n, phylogenyNode.getYcoord() - 5.0f, graphics2D, this, bl2);
        }
    }

    private final void paintOvRectangle(Graphics2D graphics2D) {
        float f = (float)this.getWidth() / (float)this.getVisibleRect().width;
        float f2 = (float)this.getHeight() / (float)this.getVisibleRect().height;
        float f3 = (float)this.getWidth() / (float)this.getVisibleRect().x;
        float f4 = (float)this.getHeight() / (float)this.getVisibleRect().y;
        float f5 = this.getOvMaxWidth() / f;
        float f6 = this.getOvMaxHeight() / f2;
        float f7 = (float)(this.getVisibleRect().x + this.getOvXPosition()) + this.getOvMaxWidth() / f3;
        float f8 = (float)(this.getVisibleRect().y + this.getOvYPosition()) + this.getOvMaxHeight() / f4;
        graphics2D.setColor(this.getTreeColorSet().getFoundColor());
        this.getOvRectangle().setRect(f7, f8, f5, f6);
        if (f5 < 6.0f && f6 < 6.0f) {
            this.drawRectFilled(f7, f8, 6.0, 6.0, graphics2D);
            this.getOvVirtualRectangle().setRect(f7, f8, 6.0, 6.0);
        } else if (f5 < 6.0f) {
            this.drawRectFilled(f7, f8, 6.0, f6, graphics2D);
            this.getOvVirtualRectangle().setRect(f7, f8, 6.0, f6);
        } else if (f6 < 6.0f) {
            this.drawRectFilled(f7, f8, f5, 6.0, graphics2D);
            this.getOvVirtualRectangle().setRect(f7, f8, f5, 6.0);
        } else {
            this.drawRect(f7, f8, f5, f6, graphics2D);
            if (this.isInOvRect()) {
                this.drawRect(f7 + 1.0f, f8 + 1.0f, f5 - 2.0f, f6 - 2.0f, graphics2D);
            }
            this.getOvVirtualRectangle().setRect(f7, f8, f5, f6);
        }
    }

    final void paintPhylogeny(Graphics2D graphics2D, boolean bl, boolean bl2, int n, int n2, int n3, int n4) {
        if (this._control_panel.isShowSequenceRelations()) {
            this._query_sequence = this._control_panel.getSelectedQuerySequence();
        }
        if (!bl) {
            Rectangle rectangle = this.getVisibleRect();
            if (!this.getOptions().isBackgroundColorGradient() || this.getOptions().isPrintBlackAndWhite()) {
                graphics2D.setColor(this.getTreeColorSet().getBackgroundColor());
                if (!bl2) {
                    graphics2D.fill(rectangle);
                } else {
                    if (this.getOptions().isPrintBlackAndWhite()) {
                        graphics2D.setColor(Color.WHITE);
                    }
                    graphics2D.fillRect(n3, n4, n, n2);
                }
            } else if (!bl2) {
                graphics2D.setPaint(new GradientPaint(rectangle.x, rectangle.y, this.getTreeColorSet().getBackgroundColor(), rectangle.x, rectangle.y + rectangle.height, this.getTreeColorSet().getBackgroundColorGradientBottom()));
                graphics2D.fill(rectangle);
            } else {
                graphics2D.setPaint(new GradientPaint(n3, n4, this.getTreeColorSet().getBackgroundColor(), n3, n4 + n2, this.getTreeColorSet().getBackgroundColorGradientBottom()));
                graphics2D.fillRect(n3, n4, n, n2);
            }
            graphics2D.setStroke(new BasicStroke(1.0f));
        } else {
            graphics2D.setStroke(new BasicStroke(this.getOptions().getPrintLineWidth()));
        }
        if (this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
            int n5;
            this._external_node_index = 0;
            if (!this._phylogeny.isRooted()) {
                this._phylogeny.getRoot().setXcoord(20.0f);
            } else if (this._phylogeny.getRoot().getDistanceToParent() > 0.0 && this.getControlPanel().isDrawPhylogram()) {
                this._phylogeny.getRoot().setXcoord((float)(20.0 + this._phylogeny.getRoot().getDistanceToParent() * (double)this.getXcorrectionFactor()));
            } else {
                this._phylogeny.getRoot().setXcoord(20.0f + this.getXdistance());
            }
            this._phylogeny.getRoot().setYcoord(this.getYdistance() * (float)this._phylogeny.getRoot().getNumberOfExternalNodes() + 10.0f);
            int n6 = (int)((double)this.getTreeFontSet()._fm_large.getHeight() / (1.5 * (double)this.getYdistance()));
            if (this.getControlPanel().isDynamicallyHideData()) {
                if (n6 > 1) {
                    this.getControlPanel().setDynamicHidingIsOn(true);
                } else {
                    this.getControlPanel().setDynamicHidingIsOn(false);
                }
            }
            if (this._nodes_in_preorder == null) {
                this._nodes_in_preorder = new PhylogenyNode[this._phylogeny.getNodeCount()];
                n5 = 0;
                PhylogenyNodeIterator phylogenyNodeIterator = this._phylogeny.iteratorPreorder();
                while (phylogenyNodeIterator.hasNext()) {
                    this._nodes_in_preorder[n5++] = phylogenyNodeIterator.next();
                }
            }
            for (n5 = 0; n5 < this._nodes_in_preorder.length; ++n5) {
                this.paintNodeRectangular(graphics2D, this._nodes_in_preorder[n5], bl, this.getControlPanel().isDynamicallyHideData() && n6 > 1, n6, bl2);
            }
            if (this.getOptions().isShowScale() && this.getControlPanel().isDrawPhylogram() && this.getScaleDistance() > 0.0) {
                if (!bl2 && !bl) {
                    this.paintScale(graphics2D, this.getVisibleRect().x, this.getVisibleRect().y + this.getVisibleRect().height, bl, bl2);
                } else {
                    this.paintScale(graphics2D, n3, n4 + n2, bl, bl2);
                }
            }
            if (this.getOptions().isShowOverview() && this.isOvOn() && !bl2 && !bl) {
                this.paintPhylogenyLite(graphics2D);
            }
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            if (this.getControlPanel().getDynamicallyHideData() != null) {
                this.getControlPanel().setDynamicHidingIsOn(false);
            }
            double d = this.getStartingAngle();
            boolean bl3 = this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.RADIAL;
            this._dynamic_hiding_factor = 0;
            if (this.getControlPanel().isDynamicallyHideData()) {
                this._dynamic_hiding_factor = (int)((double)this.getTreeFontSet()._fm_large.getHeight() * 1.5 * (double)this.getPhylogeny().getNumberOfExternalNodes() / 62.83185307179586);
            }
            if (this.getControlPanel().getDynamicallyHideData() != null) {
                if (this._dynamic_hiding_factor > 1) {
                    this.getControlPanel().setDynamicHidingIsOn(true);
                } else {
                    this.getControlPanel().setDynamicHidingIsOn(false);
                }
            }
            this.paintUnrooted(this._phylogeny.getRoot(), d, (float)(d + Math.PI * 2), bl3, graphics2D, bl, bl2);
            if (this.getOptions().isShowScale()) {
                if (!bl2 && !bl) {
                    this.paintScale(graphics2D, this.getVisibleRect().x, this.getVisibleRect().y + this.getVisibleRect().height, bl, bl2);
                } else {
                    this.paintScale(graphics2D, n3, n4 + n2, bl, bl2);
                }
            }
            if (this.getOptions().isShowOverview() && this.isOvOn() && !bl2 && !bl) {
                graphics2D.setColor(this.getTreeColorSet().getOvColor());
                this.paintUnrootedLite(this._phylogeny.getRoot(), d, d + Math.PI * 2, graphics2D, this.getUrtFactorOv() / ((float)this.getVisibleRect().width / this.getOvMaxWidth()));
                this.paintOvRectangle(graphics2D);
            }
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
            int n7 = (int)(Math.min(this.getPreferredSize().getWidth(), this.getPreferredSize().getHeight()) / 2.0 - (double)(20 + this.getLongestExtNodeInfo()));
            int n8 = n7 + 20 + this.getLongestExtNodeInfo();
            this._dynamic_hiding_factor = 0;
            if (this.getControlPanel().isDynamicallyHideData() && n7 > 0) {
                this._dynamic_hiding_factor = (int)((double)this.getTreeFontSet()._fm_large.getHeight() * 1.5 * (double)this.getPhylogeny().getNumberOfExternalNodes() / (Math.PI * 2 * (double)n7));
            }
            if (this.getControlPanel().getDynamicallyHideData() != null) {
                if (this._dynamic_hiding_factor > 1) {
                    this.getControlPanel().setDynamicHidingIsOn(true);
                } else {
                    this.getControlPanel().setDynamicHidingIsOn(false);
                }
            }
            this.paintCircular(this._phylogeny, this.getStartingAngle(), n8, n8, n7 > 0 ? n7 : 0, graphics2D, bl, bl2);
            if (this.getOptions().isShowOverview() && this.isOvOn() && !bl2 && !bl) {
                int n9 = (int)(this.getOvMaxHeight() < this.getOvMaxWidth() ? this.getOvMaxHeight() / 2.0f : this.getOvMaxWidth() / 2.0f);
                double d = 1.0;
                double d2 = 1.0;
                int n10 = this.getVisibleRect().x + this.getOvXPosition();
                int n11 = this.getVisibleRect().y + this.getOvYPosition();
                if (this.getWidth() > this.getHeight()) {
                    d = (double)this.getHeight() / (double)this.getWidth();
                    n10 = ForesterUtil.roundToInt((double)n10 / d);
                } else {
                    d2 = (double)this.getWidth() / (double)this.getHeight();
                    n11 = ForesterUtil.roundToInt((double)n11 / d2);
                }
                this._at = graphics2D.getTransform();
                graphics2D.scale(d, d2);
                this.paintCircularLite(this._phylogeny, this.getStartingAngle(), n10 + n9, n11 + n9, (int)((double)n9 - (double)this.getLongestExtNodeInfo() / ((double)this.getVisibleRect().width / this.getOvRectangle().getWidth())), graphics2D);
                graphics2D.setTransform(this._at);
                this.paintOvRectangle(graphics2D);
            }
        }
    }

    private final void paintPhylogenyLite(Graphics2D graphics2D) {
        this._phylogeny.getRoot().setXSecondary((float)((double)(this.getVisibleRect().x + this.getOvXPosition()) + 20.0 / ((double)this.getVisibleRect().width / this.getOvRectangle().getWidth())));
        this._phylogeny.getRoot().setYSecondary(this.getVisibleRect().y + this.getOvYStart());
        for (int i = 0; i < this._nodes_in_preorder.length; ++i) {
            this.paintNodeLite(graphics2D, this._nodes_in_preorder[i]);
        }
        this.paintOvRectangle(graphics2D);
    }

    private final void paintRootBranch(Graphics2D graphics2D, float f, float f2, PhylogenyNode phylogenyNode, boolean bl, boolean bl2) {
        this.assignGraphicsForBranchWithColorForParentBranch(phylogenyNode, false, graphics2D, bl, bl2);
        float f3 = this.getXdistance();
        if (this.getControlPanel().isDrawPhylogram() && phylogenyNode.getDistanceToParent() > 0.0) {
            f3 = (float)((double)this.getXcorrectionFactor() * phylogenyNode.getDistanceToParent());
        }
        if (f3 < 3.0f) {
            f3 = 3.0f;
        }
        if (!this.getControlPanel().isWidthBranches() || PhylogenyMethods.getBranchWidthValue(phylogenyNode) == 1.0) {
            this.drawLine(f - f3, phylogenyNode.getYcoord(), f, phylogenyNode.getYcoord(), graphics2D);
        } else {
            double d = PhylogenyMethods.getBranchWidthValue(phylogenyNode);
            this.drawRectFilled(f - f3, (double)phylogenyNode.getYcoord() - d / 2.0, f3, d, graphics2D);
        }
        this.paintNodeBox(f, phylogenyNode.getYcoord(), phylogenyNode, graphics2D, bl, bl2, this.isInFoundNodes(phylogenyNode));
    }

    private final void paintScale(Graphics2D graphics2D, int n, int n2, boolean bl, boolean bl2) {
        double d = (double)(n += 20) + this.getScaleDistance() * (double)this.getXcorrectionFactor();
        int n3 = (n2 -= 12) - 8;
        int n4 = n2 - 4;
        graphics2D.setFont(this.getTreeFontSet().getSmallFont());
        if ((bl || bl2) && this.getOptions().isPrintBlackAndWhite()) {
            graphics2D.setColor(Color.BLACK);
        } else {
            graphics2D.setColor(this.getTreeColorSet().getBranchLengthColor());
        }
        this.drawLine(n, n2, n, n3, graphics2D);
        this.drawLine(d, n2, d, n3, graphics2D);
        this.drawLine(n, n4, d, n4, graphics2D);
        if (this.getScaleLabel() != null) {
            graphics2D.drawString(this.getScaleLabel(), n + 2, n4 - 2);
        }
    }

    private final int paintTaxonomy(Graphics2D graphics2D, PhylogenyNode phylogenyNode, boolean bl, boolean bl2, boolean bl3, double d) {
        Taxonomy taxonomy = phylogenyNode.getNodeData().getTaxonomy();
        graphics2D.setFont(this.getTreeFontSet().getLargeItalicFont());
        if ((bl2 || bl3) && this.getOptions().isPrintBlackAndWhite()) {
            graphics2D.setColor(Color.BLACK);
        } else if (bl) {
            graphics2D.setFont(this.getTreeFontSet().getLargeItalicFont().deriveFont(3));
            graphics2D.setColor(this.getTreeColorSet().getFoundColor());
        } else if (this.getControlPanel().isColorAccordingToTaxonomy()) {
            graphics2D.setColor(this.getTaxonomyBasedColor(phylogenyNode));
        } else if (this.getOptions().isColorLabelsSameAsParentBranch() && this.getControlPanel().isColorBranches() && PhylogenyMethods.getBranchColorValue(phylogenyNode) != null) {
            graphics2D.setColor(PhylogenyMethods.getBranchColorValue(phylogenyNode));
        } else if (bl2) {
            graphics2D.setColor(Color.BLACK);
        } else {
            graphics2D.setColor(this.getTreeColorSet().getTaxonomyColor());
        }
        double d2 = (double)(phylogenyNode.getXcoord() + 3.0f + (float)(this.getOptions().getDefaultNodeShapeSize() / 2)) + d;
        double d3 = (double)phylogenyNode.getYcoord() + (double)this.getTreeFontSet()._fm_large.getAscent() / (phylogenyNode.getNumberOfDescendants() == 1 ? 1.0 : 3.0);
        this._sb.setLength(0);
        if (this._control_panel.isShowTaxonomyCode() && !ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
            this._sb.append(taxonomy.getTaxonomyCode());
            this._sb.append(" ");
        }
        if (this._control_panel.isShowTaxonomyScientificNames() && this._control_panel.isShowTaxonomyCommonNames()) {
            if (!ForesterUtil.isEmpty(taxonomy.getScientificName()) && !ForesterUtil.isEmpty(taxonomy.getCommonName())) {
                if (this.getOptions().isAbbreviateScientificTaxonNames() && taxonomy.getScientificName().indexOf(32) > 0) {
                    this.abbreviateScientificName(taxonomy.getScientificName());
                } else {
                    this._sb.append(taxonomy.getScientificName());
                }
                this._sb.append(" (");
                this._sb.append(taxonomy.getCommonName());
                this._sb.append(") ");
            } else if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) {
                if (this.getOptions().isAbbreviateScientificTaxonNames() && taxonomy.getScientificName().indexOf(32) > 0) {
                    this.abbreviateScientificName(taxonomy.getScientificName());
                } else {
                    this._sb.append(taxonomy.getScientificName());
                }
                this._sb.append(" ");
            } else if (!ForesterUtil.isEmpty(taxonomy.getCommonName())) {
                this._sb.append(taxonomy.getCommonName());
                this._sb.append(" ");
            }
        } else if (this._control_panel.isShowTaxonomyScientificNames()) {
            if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) {
                if (this.getOptions().isAbbreviateScientificTaxonNames() && taxonomy.getScientificName().indexOf(32) > 0) {
                    this.abbreviateScientificName(taxonomy.getScientificName());
                } else {
                    this._sb.append(taxonomy.getScientificName());
                }
                this._sb.append(" ");
            }
        } else if (this._control_panel.isShowTaxonomyCommonNames() && !ForesterUtil.isEmpty(taxonomy.getCommonName())) {
            this._sb.append(taxonomy.getCommonName());
            this._sb.append(" ");
        }
        String string = this._sb.toString();
        if (this._control_panel.isShowSequenceRelations() && string.length() > 0 && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().equals(this._query_sequence)) {
            Rectangle2D rectangle2D = new TextLayout(string, graphics2D.getFont(), new FontRenderContext(null, false, false)).getBounds();
            graphics2D.fillRect((int)d2 - 1, (int)d3 - 8, (int)rectangle2D.getWidth() + 4, 11);
            graphics2D.setColor(this.getTreeColorSet().getBackgroundColor());
        }
        TreePanel.drawString(string, d2, d3, graphics2D);
        if (bl) {
            return this.getTreeFontSet()._fm_large_italic_bold.stringWidth(string);
        }
        return this.getTreeFontSet()._fm_large_italic.stringWidth(string);
    }

    private void abbreviateScientificName(String string) {
        String[] stringArray = string.split("\\s+");
        this._sb.append(stringArray[0].substring(0, 1));
        this._sb.append(stringArray[1].substring(0, 2));
        if (stringArray.length > 2) {
            for (int i = 2; i < stringArray.length; ++i) {
                this._sb.append(" ");
                this._sb.append(stringArray[i]);
            }
        }
    }

    private final void paintUnrooted(PhylogenyNode phylogenyNode, double d, double d2, boolean bl, Graphics2D graphics2D, boolean bl2, boolean bl3) {
        if (phylogenyNode.isRoot()) {
            phylogenyNode.setXcoord(this.getWidth() / 2);
            phylogenyNode.setYcoord(this.getHeight() / 2);
        }
        if (phylogenyNode.isExternal()) {
            this.paintNodeDataUnrootedCirc(graphics2D, phylogenyNode, bl2, bl3, bl, (d2 + d) / 2.0, this.isInFoundNodes(phylogenyNode));
            return;
        }
        float f = phylogenyNode.getNumberOfExternalNodes();
        float f2 = phylogenyNode.getXcoord();
        float f3 = phylogenyNode.getYcoord();
        double d3 = d;
        for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
            PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode(i);
            int n = phylogenyNode2.getNumberOfExternalNodes();
            double d4 = (double)((float)n / f) * (d2 - d);
            float f4 = this.isPhyHasBranchLengths() && this.getControlPanel().isDrawPhylogram() ? (phylogenyNode2.getDistanceToParent() < 0.0 ? 0.0f : (float)(phylogenyNode2.getDistanceToParent() * (double)this.getUrtFactor())) : this.getUrtFactor();
            double d5 = d3 + d4 / 2.0;
            float f5 = (float)((double)f2 + Math.cos(d5) * (double)f4);
            float f6 = (float)((double)f3 + Math.sin(d5) * (double)f4);
            phylogenyNode2.setXcoord(f5);
            phylogenyNode2.setYcoord(f6);
            this.paintUnrooted(phylogenyNode2, d3, d3 + d4, bl, graphics2D, bl2, bl3);
            d3 += d4;
            this.assignGraphicsForBranchWithColorForParentBranch(phylogenyNode2, false, graphics2D, bl2, bl3);
            this.drawLine(f2, f3, f5, f6, graphics2D);
            this.paintNodeBox(f5, f6, phylogenyNode2, graphics2D, bl2, bl3, this.isInFoundNodes(phylogenyNode2));
        }
        if (phylogenyNode.isRoot()) {
            this.paintNodeBox(phylogenyNode.getXcoord(), phylogenyNode.getYcoord(), phylogenyNode, graphics2D, bl2, bl3, this.isInFoundNodes(phylogenyNode));
        }
    }

    private final void paintUnrootedLite(PhylogenyNode phylogenyNode, double d, double d2, Graphics2D graphics2D, float f) {
        if (phylogenyNode.isRoot()) {
            int n = (int)((float)(this.getVisibleRect().x + this.getOvXPosition()) + this.getOvMaxWidth() / 2.0f);
            int n2 = (int)((float)(this.getVisibleRect().y + this.getOvYPosition()) + this.getOvMaxHeight() / 2.0f);
            phylogenyNode.setXSecondary(n);
            phylogenyNode.setYSecondary(n2);
        }
        if (phylogenyNode.isExternal()) {
            return;
        }
        float f2 = phylogenyNode.getNumberOfExternalNodes();
        float f3 = phylogenyNode.getXSecondary();
        float f4 = phylogenyNode.getYSecondary();
        double d3 = d;
        for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
            PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode(i);
            int n = phylogenyNode2.getNumberOfExternalNodes();
            double d4 = (double)((float)n / f2) * (d2 - d);
            float f5 = this.isPhyHasBranchLengths() && this.getControlPanel().isDrawPhylogram() ? (phylogenyNode2.getDistanceToParent() < 0.0 ? 0.0f : (float)(phylogenyNode2.getDistanceToParent() * (double)f)) : f;
            double d5 = d3 + d4 / 2.0;
            float f6 = (float)((double)f3 + Math.cos(d5) * (double)f5);
            float f7 = (float)((double)f4 + Math.sin(d5) * (double)f5);
            phylogenyNode2.setXSecondary(f6);
            phylogenyNode2.setYSecondary(f7);
            if (this.isInFoundNodes(phylogenyNode2)) {
                graphics2D.setColor(this.getTreeColorSet().getFoundColor());
                this.drawRectFilled(phylogenyNode2.getXSecondary() - 1.0f, phylogenyNode2.getYSecondary() - 1.0f, 3.0, 3.0, graphics2D);
                graphics2D.setColor(this.getTreeColorSet().getOvColor());
            }
            this.paintUnrootedLite(phylogenyNode2, d3, d3 + d4, graphics2D, f);
            d3 += d4;
            this.drawLine(f3, f4, f6, f7, graphics2D);
        }
    }

    private final void pasteSubtree(PhylogenyNode phylogenyNode) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            this.errorMessageNoCutCopyPasteInUnrootedDisplay();
            return;
        }
        if (this.getCutOrCopiedTree() == null || this.getCutOrCopiedTree().isEmpty()) {
            JOptionPane.showMessageDialog(this, "No tree in buffer (need to copy or cut a subtree first)", "Attempt to paste with empty buffer", 0);
            return;
        }
        String string = this.getASimpleTextRepresentationOfANode(this.getCutOrCopiedTree().getRoot());
        Object[] objectArray = new Object[]{"As sibling", "As descendant", "Cancel"};
        int n = JOptionPane.showOptionDialog(this, "How to paste subtree" + string + "?", "Paste Subtree", -1, 3, null, objectArray, objectArray[2]);
        boolean bl = true;
        if (n == 1) {
            bl = false;
        } else if (n != 0) {
            return;
        }
        Phylogeny phylogeny = this.getCutOrCopiedTree().copy();
        phylogeny.setAllNodesToNotCollapse();
        phylogeny.preOrderReId();
        phylogeny.setRooted(true);
        boolean bl2 = false;
        if (bl) {
            if (phylogenyNode.isRoot()) {
                JOptionPane.showMessageDialog(this, "Cannot paste sibling to root", "Attempt to paste sibling to root", 0);
                return;
            }
            phylogeny.addAsSibling(phylogenyNode);
        } else if (phylogenyNode.getNumberOfExternalNodes() == 1 && phylogenyNode.isRoot()) {
            bl2 = true;
            this._phylogeny = phylogeny;
        } else {
            phylogeny.addAsChild(phylogenyNode);
        }
        if (this.getCopiedAndPastedNodes() == null) {
            this.setCopiedAndPastedNodes(new HashSet<Integer>());
        }
        List<PhylogenyNode> list = PhylogenyMethods.obtainAllNodesAsList(phylogeny);
        HashSet<Integer> hashSet = new HashSet<Integer>(list.size());
        for (PhylogenyNode phylogenyNode2 : list) {
            hashSet.add(phylogenyNode2.getId());
        }
        hashSet.add(phylogenyNode.getId());
        this.getCopiedAndPastedNodes().addAll(hashSet);
        this._nodes_in_preorder = null;
        this._phylogeny.externalNodesHaveChanged();
        this._phylogeny.hashIDs();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.setEdited(true);
        if (bl2) {
            this.getControlPanel().showWhole();
        }
        this.repaint();
    }

    @Override
    public final int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.paintPhylogeny(graphics2D, true, false, 0, 0, 0, 0);
        return 0;
    }

    final void recalculateMaxDistanceToRoot() {
        this._max_distance_to_root = PhylogenyMethods.calculateMaxDistanceToRoot(this.getPhylogeny());
    }

    final void removeAllEditNodeJFrames() {
        for (int i = 0; i <= 9; ++i) {
            if (this._node_frames[i] == null) continue;
            this._node_frames[i].dispose();
            this._node_frames[i] = null;
        }
        this._node_frame_index = 0;
    }

    final void removeEditNodeFrame(int n) {
        --this._node_frame_index;
        this._node_frames[n] = null;
        if (n < this._node_frame_index) {
            for (int i = 0; i < this._node_frame_index - 1; ++i) {
                this._node_frames[i] = this._node_frames[i + 1];
            }
            this._node_frames[this._node_frame_index] = null;
        }
    }

    final void reRoot(PhylogenyNode phylogenyNode) {
        if (!this.getPhylogeny().isRerootable()) {
            JOptionPane.showMessageDialog(this, "This is not rerootable", "Not rerootable", 2);
            return;
        }
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            JOptionPane.showMessageDialog(this, "Cannot reroot in unrooted display type", "Attempt to reroot tree in unrooted display", 2);
            return;
        }
        this.getPhylogeny().reRoot(phylogenyNode);
        this.getPhylogeny().recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this._nodes_in_preorder = null;
        this.resetPreferredSize();
        this.getMainPanel().adjustJScrollPane();
        this.repaint();
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
            this.getControlPanel().showWhole();
        }
    }

    final void resetNodeIdToDistToLeafMap() {
        this._nodeid_dist_to_leaf = new HashMap();
    }

    final void resetPreferredSize() {
        if (this.getPhylogeny() == null || this.getPhylogeny().isEmpty()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        n2 = 20 + ForesterUtil.roundToInt(this.getYdistance() * (float)this.getPhylogeny().getRoot().getNumberOfExternalNodes() * 2.0f);
        n = this.getControlPanel().isDrawPhylogram() ? 20 + this.getLongestExtNodeInfo() + ForesterUtil.roundToInt((double)this.getXcorrectionFactor() * this.getPhylogeny().getHeight() + (double)this.getXdistance()) : (!this.isNonLinedUpCladogram() && !this.isUniformBranchLengthsForCladogram() ? 20 + this.getLongestExtNodeInfo() + ForesterUtil.roundToInt(this.getXdistance() * (float)(this.getPhylogeny().getRoot().getNumberOfExternalNodes() + 2)) : 20 + this.getLongestExtNodeInfo() + ForesterUtil.roundToInt(this.getXdistance() * (float)(PhylogenyMethods.calculateMaxDepth(this.getPhylogeny()) + 1)));
        this.setPreferredSize(new Dimension(n, n2));
    }

    public final void setArrowCursor() {
        this.setCursor(ARROW_CURSOR);
        this.repaint();
    }

    final void setControlPanel(ControlPanel controlPanel) {
        this._control_panel = controlPanel;
    }

    private final void setCopiedAndPastedNodes(Set<Integer> set) {
        this.getMainPanel().setCopiedAndPastedNodes(set);
    }

    private final void setCutOrCopiedTree(Phylogeny phylogeny) {
        this.getMainPanel().setCutOrCopiedTree(phylogeny);
    }

    public final void setEdited(boolean bl) {
        this._edited = bl;
    }

    final void setFoundNodes(Set<Integer> set) {
        this._found_nodes = set;
    }

    private final void setInOv(boolean bl) {
        this._in_ov = bl;
    }

    final void setInOvRect(boolean bl) {
        this._in_ov_rect = bl;
    }

    final void setLargeFonts() {
        this.getTreeFontSet().largeFonts();
    }

    final void setLastMouseDragPointX(float f) {
        this._last_drag_point_x = f;
    }

    final void setLastMouseDragPointY(float f) {
        this._last_drag_point_y = f;
    }

    final void setLongestExtNodeInfo(int n) {
        this._longest_ext_node_info = n;
    }

    final void setMediumFonts() {
        this.getTreeFontSet().mediumFonts();
    }

    private final void setOvMaxHeight(float f) {
        this._ov_max_height = f;
    }

    private final void setOvMaxWidth(float f) {
        this._ov_max_width = f;
    }

    final void setOvOn(boolean bl) {
        this._ov_on = bl;
    }

    private final void setOvXcorrectionFactor(float f) {
        this._ov_x_correction_factor = f;
    }

    private final void setOvXDistance(float f) {
        this._ov_x_distance = f;
    }

    private final void setOvXPosition(int n) {
        this._ov_x_position = n;
    }

    private final void setOvYDistance(float f) {
        this._ov_y_distance = f;
    }

    private final void setOvYPosition(int n) {
        this._ov_y_position = n;
    }

    private final void setOvYStart(int n) {
        this._ov_y_start = n;
    }

    final void setParametersForPainting(int n, int n2, boolean bl) {
        if (this._phylogeny != null && !this._phylogeny.isEmpty()) {
            this.initNodeData();
            if (bl) {
                this.calculateLongestExtNodeInfo();
            }
            int n3 = this._phylogeny.getRoot().getNumberOfExternalNodes();
            int n4 = PhylogenyMethods.calculateMaxDepth(this._phylogeny);
            if (n3 == 1 && (n3 = n4) < 1) {
                n3 = 1;
            }
            this.updateOvSizes();
            float f = 0.0f;
            float f2 = 0.0f;
            if (!this.isNonLinedUpCladogram() && !this.isUniformBranchLengthsForCladogram()) {
                f = (float)((double)(n - this.getLongestExtNodeInfo() - 20) / ((double)n3 + 3.0));
                f2 = (float)((double)this.getOvMaxWidth() / ((double)n3 + 3.0));
            } else {
                f = (n - this.getLongestExtNodeInfo() - 20) / (n4 + 1);
                f2 = this.getOvMaxWidth() / (float)(n4 + 1);
            }
            float f3 = (float)((double)(n2 - 20) / ((double)n3 * 2.0));
            if ((double)f < 0.0) {
                f = 0.0f;
            }
            if ((double)f2 < 0.0) {
                f2 = 0.0f;
            }
            if ((double)f3 < 0.0) {
                f3 = 0.0f;
            }
            this.setXdistance(f);
            this.setYdistance(f3);
            this.setOvXDistance(f2);
            double d = this._phylogeny.getHeight();
            if (d > 0.0) {
                float f4 = (float)((double)((float)(n - 20 - this.getLongestExtNodeInfo()) - this.getXdistance()) / d);
                this.setXcorrectionFactor(f4 > 0.0f ? f4 : 0.0f);
                float f5 = (float)((double)(this.getOvMaxWidth() - this.getOvXDistance()) / d);
                this.setOvXcorrectionFactor(f5 > 0.0f ? f5 : 0.0f);
            } else {
                this.setXcorrectionFactor(0.0f);
                this.setOvXcorrectionFactor(0.0f);
            }
            this._circ_max_depth = n4;
            this.setUpUrtFactor();
        }
    }

    final void setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE pHYLOGENY_GRAPHICS_TYPE) {
        this._graphics_type = pHYLOGENY_GRAPHICS_TYPE;
        this.setTextAntialias();
    }

    private final void setScaleDistance(double d) {
        this._scale_distance = d;
    }

    private final void setScaleLabel(String string) {
        this._scale_label = string;
    }

    final void setSmallFonts() {
        this.getTreeFontSet().smallFonts();
    }

    final void setStartingAngle(double d) {
        this._urt_starting_angle = d;
    }

    final void setSuperTinyFonts() {
        this.getTreeFontSet().superTinyFonts();
    }

    final void setTextAntialias() {
        if (this._phylogeny != null && !this._phylogeny.isEmpty()) {
            if (this._phylogeny.getNumberOfExternalNodes() <= 1000) {
                this._rendering_hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            } else {
                this._rendering_hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            }
        }
        if (this.getMainPanel().getOptions().isAntialiasScreen()) {
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR) {
                this._rendering_hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            } else {
                this._rendering_hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            try {
                this._rendering_hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            }
            catch (Throwable throwable) {
                this._rendering_hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        } else {
            this._rendering_hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this._rendering_hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    final void setTinyFonts() {
        this.getTreeFontSet().tinyFonts();
    }

    public final void setTree(Phylogeny phylogeny) {
        this._nodes_in_preorder = null;
        this._phylogeny = phylogeny;
    }

    final void setTreeFile(File file) {
        this._treefile = file;
    }

    private final void setUpUrtFactor() {
        int n;
        int n2 = n = this.getVisibleRect().width < this.getVisibleRect().height ? this.getVisibleRect().width : this.getVisibleRect().height;
        if (this.isPhyHasBranchLengths() && this.getControlPanel().isDrawPhylogram()) {
            this.setUrtFactor((float)((double)n / (2.0 * this.getMaxDistanceToRoot())));
        } else {
            int n3 = this._circ_max_depth;
            if (n3 > 0) {
                this.setUrtFactor(n / (2 * n3));
            } else {
                this.setUrtFactor(n / 2);
            }
        }
        this.setUrtFactorOv(this.getUrtFactor());
    }

    private final void setUrtFactor(float f) {
        this._urt_factor = f;
    }

    private final void setUrtFactorOv(float f) {
        this._urt_factor_ov = f;
    }

    public final void setWaitCursor() {
        this.setCursor(WAIT_CURSOR);
        this.repaint();
    }

    final void setXcorrectionFactor(float f) {
        this._x_correction_factor = f;
    }

    final void setXdistance(float f) {
        this._x_distance = f;
    }

    final void setYdistance(float f) {
        this._y_distance = f;
    }

    private final void showNodeDataPopup(MouseEvent mouseEvent, PhylogenyNode phylogenyNode) {
        try {
            if (phylogenyNode.getName().length() > 0 || phylogenyNode.getNodeData().isHasTaxonomy() && !TreePanel.isTaxonomyEmpty(phylogenyNode.getNodeData().getTaxonomy()) || phylogenyNode.getNodeData().isHasSequence() && !TreePanel.isSequenceEmpty(phylogenyNode.getNodeData().getSequence()) || phylogenyNode.getNodeData().isHasDate() || phylogenyNode.getNodeData().isHasDistribution() || phylogenyNode.getBranchData().isHasConfidences()) {
                Object object;
                boolean bl;
                this._popup_buffer.setLength(0);
                int n = 0;
                if (phylogenyNode.getName().length() > 0) {
                    n = (short)(n + 1);
                    this._popup_buffer.append(phylogenyNode.getName());
                }
                if (phylogenyNode.getNodeData().isHasTaxonomy() && !TreePanel.isTaxonomyEmpty(phylogenyNode.getNodeData().getTaxonomy())) {
                    n = (short)(n + 1);
                    bl = false;
                    object = phylogenyNode.getNodeData().getTaxonomy();
                    if (this._popup_buffer.length() > 0) {
                        this._popup_buffer.append("\n");
                    }
                    if (!ForesterUtil.isEmpty(((Taxonomy)object).getTaxonomyCode())) {
                        this._popup_buffer.append("[");
                        this._popup_buffer.append(((Taxonomy)object).getTaxonomyCode());
                        this._popup_buffer.append("]");
                        bl = true;
                    }
                    if (!ForesterUtil.isEmpty(((Taxonomy)object).getScientificName())) {
                        if (bl) {
                            this._popup_buffer.append(" ");
                        }
                        this._popup_buffer.append(((Taxonomy)object).getScientificName());
                        bl = true;
                    }
                    if (!ForesterUtil.isEmpty(((Taxonomy)object).getCommonName())) {
                        if (bl) {
                            this._popup_buffer.append(" (");
                        } else {
                            this._popup_buffer.append("(");
                        }
                        this._popup_buffer.append(((Taxonomy)object).getCommonName());
                        this._popup_buffer.append(")");
                        bl = true;
                    }
                    if (!ForesterUtil.isEmpty(((Taxonomy)object).getAuthority())) {
                        if (bl) {
                            this._popup_buffer.append(" (");
                        } else {
                            this._popup_buffer.append("(");
                        }
                        this._popup_buffer.append(((Taxonomy)object).getAuthority());
                        this._popup_buffer.append(")");
                        bl = true;
                    }
                    if (!ForesterUtil.isEmpty(((Taxonomy)object).getRank())) {
                        if (bl) {
                            this._popup_buffer.append(" [");
                        } else {
                            this._popup_buffer.append("[");
                        }
                        this._popup_buffer.append(((Taxonomy)object).getRank());
                        this._popup_buffer.append("]");
                        bl = true;
                    }
                    if (((Taxonomy)object).getSynonyms().size() > 0) {
                        if (bl) {
                            this._popup_buffer.append(" ");
                        }
                        this._popup_buffer.append("[");
                        int n2 = 1;
                        for (String string : ((Taxonomy)object).getSynonyms()) {
                            if (!ForesterUtil.isEmpty(string)) {
                                bl = true;
                                this._popup_buffer.append(string);
                                if (n2 < ((Taxonomy)object).getSynonyms().size()) {
                                    this._popup_buffer.append(", ");
                                }
                            }
                            ++n2;
                        }
                        this._popup_buffer.append("]");
                    }
                    if (!bl && ((Taxonomy)object).getIdentifier() != null && !ForesterUtil.isEmpty(((Taxonomy)object).getIdentifier().getValue())) {
                        if (!ForesterUtil.isEmpty(((Taxonomy)object).getIdentifier().getProvider())) {
                            this._popup_buffer.append("[");
                            this._popup_buffer.append(((Taxonomy)object).getIdentifier().getProvider());
                            this._popup_buffer.append("] ");
                        }
                        this._popup_buffer.append(((Taxonomy)object).getIdentifier().getValue());
                    }
                }
                if (phylogenyNode.getNodeData().isHasSequence() && !TreePanel.isSequenceEmpty(phylogenyNode.getNodeData().getSequence())) {
                    n = (short)(n + 1);
                    bl = false;
                    if (this._popup_buffer.length() > 0) {
                        this._popup_buffer.append("\n");
                    }
                    if (((Sequence)(object = phylogenyNode.getNodeData().getSequence())).getAccession() != null) {
                        this._popup_buffer.append("[");
                        if (!ForesterUtil.isEmpty(((Sequence)object).getAccession().getSource())) {
                            this._popup_buffer.append(((Sequence)object).getAccession().getSource());
                            this._popup_buffer.append(":");
                        }
                        this._popup_buffer.append(((Sequence)object).getAccession().getValue());
                        this._popup_buffer.append("]");
                        bl = true;
                    }
                    if (!ForesterUtil.isEmpty(((Sequence)object).getSymbol())) {
                        if (bl) {
                            this._popup_buffer.append(" [");
                        } else {
                            this._popup_buffer.append("[");
                        }
                        this._popup_buffer.append(((Sequence)object).getSymbol());
                        this._popup_buffer.append("]");
                        bl = true;
                    }
                    if (!ForesterUtil.isEmpty(((Sequence)object).getName())) {
                        if (bl) {
                            this._popup_buffer.append(" ");
                        }
                        this._popup_buffer.append(((Sequence)object).getName());
                    }
                }
                if (phylogenyNode.getNodeData().isHasDate()) {
                    n = (short)(n + 1);
                    if (this._popup_buffer.length() > 0) {
                        this._popup_buffer.append("\n");
                    }
                    this._popup_buffer.append(phylogenyNode.getNodeData().getDate().asSimpleText());
                }
                if (phylogenyNode.getNodeData().isHasDistribution()) {
                    n = (short)(n + 1);
                    if (this._popup_buffer.length() > 0) {
                        this._popup_buffer.append("\n");
                    }
                    this._popup_buffer.append(phylogenyNode.getNodeData().getDistribution().asSimpleText());
                }
                if (phylogenyNode.getBranchData().isHasConfidences()) {
                    List<Confidence> list = phylogenyNode.getBranchData().getConfidences();
                    for (Confidence confidence : list) {
                        n = (short)(n + 1);
                        if (this._popup_buffer.length() > 0) {
                            this._popup_buffer.append("\n");
                        }
                        if (!ForesterUtil.isEmpty(confidence.getType())) {
                            this._popup_buffer.append("[");
                            this._popup_buffer.append(confidence.getType());
                            this._popup_buffer.append("] ");
                        }
                        this._popup_buffer.append(FORMATTER_CONFIDENCE.format(ForesterUtil.round(confidence.getValue(), this.getOptions().getNumberOfDigitsAfterCommaForConfidenceValues())));
                    }
                }
                if (this._popup_buffer.length() > 0) {
                    if (!this.getConfiguration().isUseNativeUI()) {
                        this._rollover_popup.setBorder(BorderFactory.createLineBorder(this.getTreeColorSet().getBranchColor()));
                        this._rollover_popup.setBackground(this.getTreeColorSet().getBackgroundColor());
                        if (this.isInFoundNodes(phylogenyNode)) {
                            this._rollover_popup.setForeground(this.getTreeColorSet().getFoundColor());
                        } else if (this.getControlPanel().isColorAccordingToTaxonomy()) {
                            this._rollover_popup.setForeground(this.getTaxonomyBasedColor(phylogenyNode));
                        } else {
                            this._rollover_popup.setForeground(this.getTreeColorSet().getSequenceColor());
                        }
                    } else {
                        this._rollover_popup.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                    }
                    this._rollover_popup.setText(this._popup_buffer.toString());
                    this._node_desc_popup = PopupFactory.getSharedInstance().getPopup(null, this._rollover_popup, mouseEvent.getLocationOnScreen().x + 10, mouseEvent.getLocationOnScreen().y - n * 20);
                    this._node_desc_popup.show();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void showNodeEditFrame(PhylogenyNode phylogenyNode) {
        if (this._node_frame_index < 10) {
            this._node_frames[this._node_frame_index] = new NodeFrame(phylogenyNode, this._phylogeny, this, this._node_frame_index, "");
            ++this._node_frame_index;
        } else {
            JOptionPane.showMessageDialog(this, "too many node windows are open");
        }
    }

    private final void showNodeFrame(PhylogenyNode phylogenyNode) {
        if (this._node_frame_index < 10) {
            this._node_frames[this._node_frame_index] = new NodeFrame(phylogenyNode, this._phylogeny, this, this._node_frame_index);
            ++this._node_frame_index;
        } else {
            JOptionPane.showMessageDialog(this, "too many node windows are open");
        }
    }

    final void subTree(PhylogenyNode phylogenyNode) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            JOptionPane.showMessageDialog(this, "Cannot get a sub/super tree in unrooted display", "Attempt to get sub/super tree in unrooted display", 2);
            return;
        }
        if (phylogenyNode.isExternal()) {
            JOptionPane.showMessageDialog(this, "Cannot get a subtree of a external node", "Attempt to get subtree of external node", 2);
            return;
        }
        if (phylogenyNode.isRoot() && !this.isCurrentTreeIsSubtree()) {
            JOptionPane.showMessageDialog(this, "Cannot get a subtree of the root node", "Attempt to get subtree of root node", 2);
            return;
        }
        this._nodes_in_preorder = null;
        if (!phylogenyNode.isExternal() && !phylogenyNode.isRoot() && this._subtree_index <= 99) {
            this._sub_phylogenies[this._subtree_index] = this._phylogeny;
            this._sub_phylogenies_temp_roots[this._subtree_index] = phylogenyNode;
            ++this._subtree_index;
            this._phylogeny = TreePanel.subTree(phylogenyNode, this._phylogeny);
            this.updateSubSuperTreeButton();
        } else if (phylogenyNode.isRoot() && this.isCurrentTreeIsSubtree()) {
            this.superTree();
        }
        this._main_panel.getControlPanel().showWhole();
        this.repaint();
    }

    final boolean isCurrentTreeIsSubtree() {
        return this._subtree_index > 0;
    }

    private static final Phylogeny subTree(PhylogenyNode phylogenyNode, Phylogeny phylogeny) {
        Phylogeny phylogeny2 = new Phylogeny();
        phylogeny2.setRooted(true);
        phylogeny2.setName(phylogeny.getName());
        phylogeny2.setDescription(phylogeny.getDescription());
        phylogeny2.setType(phylogeny.getType());
        phylogeny2.setDistanceUnit(phylogeny.getDistanceUnit());
        phylogeny2.setConfidence(phylogeny.getConfidence());
        phylogeny2.setIdentifier(phylogeny.getIdentifier());
        phylogeny2.setRoot(phylogenyNode.copyNodeDataShallow());
        int n = 0;
        for (PhylogenyNode phylogenyNode2 : phylogenyNode.getDescendants()) {
            phylogeny2.getRoot().setChildNode(n++, phylogenyNode2);
        }
        return phylogeny2;
    }

    final void superTree() {
        this._nodes_in_preorder = null;
        PhylogenyNode phylogenyNode = this._sub_phylogenies_temp_roots[this._subtree_index - 1];
        for (PhylogenyNode phylogenyNode2 : phylogenyNode.getDescendants()) {
            phylogenyNode2.setParent(phylogenyNode);
        }
        this._sub_phylogenies[this._subtree_index] = null;
        this._sub_phylogenies_temp_roots[this._subtree_index] = null;
        this._phylogeny = this._sub_phylogenies[--this._subtree_index];
        this.updateSubSuperTreeButton();
    }

    final void swap(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.isExternal()) {
            this._phylogeny.swapChildren(phylogenyNode);
            this._nodes_in_preorder = null;
        }
        this.repaint();
    }

    private final void switchDisplaygetPhylogenyGraphicsType() {
        switch (this.getPhylogenyGraphicsType()) {
            case RECTANGULAR: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE);
                break;
            }
            case EURO_STYLE: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED);
                break;
            }
            case ROUNDED: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED);
                break;
            }
            case CURVED: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR);
                break;
            }
            case TRIANGULAR: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX);
                break;
            }
            case CONVEX: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED);
                break;
            }
            case UNROOTED: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR);
                break;
            }
            case CIRCULAR: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
                break;
            }
            default: {
                throw new RuntimeException("unkwnown display type: " + (Object)((Object)this.getPhylogenyGraphicsType()));
            }
        }
        if (this.getControlPanel().getDynamicallyHideData() != null) {
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
                this.getControlPanel().getDynamicallyHideData().setEnabled(false);
            } else {
                this.getControlPanel().getDynamicallyHideData().setEnabled(true);
            }
        }
        if (this.isPhyHasBranchLengths() && this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
            this.getControlPanel().setDrawPhylogramEnabled(true);
        } else {
            this.getControlPanel().setDrawPhylogramEnabled(false);
        }
        if (this.getMainPanel().getMainFrame() == null) {
            ((ArchaeopteryxE)((MainPanelApplets)this.getMainPanel()).getApplet()).setSelectedTypeInTypeMenu(this.getPhylogenyGraphicsType());
        } else {
            this.getMainPanel().getMainFrame().setSelectedTypeInTypeMenu(this.getPhylogenyGraphicsType());
        }
    }

    final void taxColor() {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        this.setWaitCursor();
        Util.colorPhylogenyAccordingToExternalTaxonomy(this._phylogeny, this);
        this._control_panel.setColorBranches(true);
        if (this._control_panel.getColorBranchesCb() != null) {
            this._control_panel.getColorBranchesCb().setSelected(true);
        }
        this.setArrowCursor();
        this.repaint();
    }

    final void updateOvSettings() {
        switch (this.getOptions().getOvPlacement()) {
            case LOWER_LEFT: {
                this.setOvXPosition(10);
                this.setOvYPosition(ForesterUtil.roundToInt((float)(this.getVisibleRect().height - 10) - this.getOvMaxHeight()));
                this.setOvYStart(ForesterUtil.roundToInt((float)this.getOvYPosition() + this.getOvMaxHeight() / 2.0f));
                break;
            }
            case LOWER_RIGHT: {
                this.setOvXPosition(ForesterUtil.roundToInt((float)(this.getVisibleRect().width - 10) - this.getOvMaxWidth()));
                this.setOvYPosition(ForesterUtil.roundToInt((float)(this.getVisibleRect().height - 10) - this.getOvMaxHeight()));
                this.setOvYStart(ForesterUtil.roundToInt((float)this.getOvYPosition() + this.getOvMaxHeight() / 2.0f));
                break;
            }
            case UPPER_RIGHT: {
                this.setOvXPosition(ForesterUtil.roundToInt((float)(this.getVisibleRect().width - 10) - this.getOvMaxWidth()));
                this.setOvYPosition(10);
                this.setOvYStart(ForesterUtil.roundToInt(10.0f + this.getOvMaxHeight() / 2.0f));
                break;
            }
            default: {
                this.setOvXPosition(10);
                this.setOvYPosition(10);
                this.setOvYStart(ForesterUtil.roundToInt(10.0f + this.getOvMaxHeight() / 2.0f));
            }
        }
    }

    final void updateOvSizes() {
        if ((double)this.getWidth() > 1.05 * (double)this.getVisibleRect().width || (double)this.getHeight() > 1.05 * (double)this.getVisibleRect().height) {
            this.setOvOn(true);
            float f = this.getLongestExtNodeInfo();
            float f2 = this.getOvMaxWidth() / (float)this.getWidth();
            int n = this._phylogeny.getRoot().getNumberOfExternalNodes();
            this.setOvYDistance(this.getOvMaxHeight() / (float)(2 * n));
            float f3 = 0.0f;
            f3 = !this.isNonLinedUpCladogram() && !this.isUniformBranchLengthsForCladogram() ? (this.getOvMaxWidth() - f) / (float)n : (this.getOvMaxWidth() - (f *= f2)) / (float)PhylogenyMethods.calculateMaxDepth(this._phylogeny);
            float f4 = (float)((double)this.getOvMaxWidth() / ((double)n * 2.0));
            if ((double)f3 < 0.0) {
                f3 = 0.0f;
            }
            if ((double)f4 < 0.0) {
                f4 = 0.0f;
            }
            this.setOvXDistance(f3);
            double d = this._phylogeny.getHeight();
            if (d > 0.0) {
                float f5 = (float)((double)(this.getOvMaxWidth() - f - this.getOvXDistance()) / d);
                this.setOvXcorrectionFactor(f5 > 0.0f ? f5 : 0.0f);
            } else {
                this.setOvXcorrectionFactor(0.0f);
            }
        } else {
            this.setOvOn(false);
        }
    }

    final void updateSubSuperTreeButton() {
        if (this._subtree_index < 1) {
            this.getControlPanel().deactivateButtonToReturnToSuperTree();
        } else {
            this.getControlPanel().activateButtonToReturnToSuperTree(this._subtree_index);
        }
    }

    final void zoomInDomainStructure() {
        if (this._domain_structure_width < 2000.0) {
            this._domain_structure_width *= 1.2;
        }
    }

    final void zoomOutDomainStructure() {
        if (this._domain_structure_width > 20.0) {
            this._domain_structure_width *= 0.8;
        }
    }

    private static final void drawString(int n, double d, double d2, Graphics2D graphics2D) {
        graphics2D.drawString(String.valueOf(n), (int)(d + 0.5), (int)(d2 + 0.5));
    }

    private static final void drawString(String string, double d, double d2, Graphics2D graphics2D) {
        graphics2D.drawString(string, (int)(d + 0.5), (int)(d2 + 0.5));
    }

    private static final boolean isSequenceEmpty(Sequence sequence) {
        return sequence.getAccession() == null && ForesterUtil.isEmpty(sequence.getName()) && ForesterUtil.isEmpty(sequence.getSymbol());
    }

    private static final boolean isTaxonomyEmpty(Taxonomy taxonomy) {
        return taxonomy.getIdentifier() == null && ForesterUtil.isEmpty(taxonomy.getTaxonomyCode()) && ForesterUtil.isEmpty(taxonomy.getCommonName()) && ForesterUtil.isEmpty(taxonomy.getScientificName()) && taxonomy.getSynonyms().isEmpty();
    }

    private static final boolean plusPressed(int n) {
        return n == 107 || n == 521 || n == 61 || n == 59 || n == 49;
    }

    void setStatisticsForExpressionValues(DescriptiveStatistics descriptiveStatistics) {
        this._statistics_for_vector_data = descriptiveStatistics;
    }

    DescriptiveStatistics getStatisticsForExpressionValues() {
        return this._statistics_for_vector_data;
    }

    public synchronized void setImageMap(Hashtable<String, BufferedImage> hashtable) {
        this.getMainPanel().setImageMap(hashtable);
    }

    public synchronized Hashtable<String, BufferedImage> getImageMap() {
        return this.getMainPanel().getImageMap();
    }

    static {
        POPUP_FONT = new Font(Configuration.getDefaultFontFamilyName(), 0, 12);
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        FORMATTER_CONFIDENCE = new DecimalFormat("#.###", decimalFormatSymbols);
        FORMATTER_BRANCH_LENGTH = new DecimalFormat("#.###", decimalFormatSymbols);
    }

    private final class SubtreeColorizationActionListener
    implements ActionListener {
        JColorChooser _chooser;
        PhylogenyNode _node;

        SubtreeColorizationActionListener(JColorChooser jColorChooser, PhylogenyNode phylogenyNode) {
            this._chooser = jColorChooser;
            this._node = phylogenyNode;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Color color = this._chooser.getColor();
            if (color != null) {
                TreePanel.this.colorizeSubtree(color, this._node);
            }
        }
    }
}

