/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.forester.archaeopteryx.Constants;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.tools.ImageLoader;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.BranchWidth;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Date;
import org.forester.phylogeny.data.Distribution;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.MultipleUris;
import org.forester.phylogeny.data.Point;
import org.forester.phylogeny.data.Reference;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.data.Uri;
import org.forester.util.FailedConditionCheckException;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NodeEditPanel
extends JPanel {
    private static final long serialVersionUID = 5120159904388100771L;
    private final JTree _tree;
    private final JEditorPane _pane;
    private final PhylogenyNode _my_node;
    private final TreePanel _tree_panel;
    private final Map<DefaultMutableTreeNode, TagNumber> _map = new HashMap<DefaultMutableTreeNode, TagNumber>();

    public NodeEditPanel(PhylogenyNode phylogenyNode, TreePanel treePanel) {
        this._my_node = phylogenyNode;
        this._tree_panel = treePanel;
        String string = "";
        if (!ForesterUtil.isEmpty(phylogenyNode.getName())) {
            string = phylogenyNode.getName() + " ";
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Node " + string);
        this.createNodes(defaultMutableTreeNode, phylogenyNode);
        this._tree = new JTree(defaultMutableTreeNode);
        this.getJTree().setEditable(true);
        this.getJTree().setFocusable(true);
        this.getJTree().setToggleClickCount(1);
        this.getJTree().setInvokesStopCellEditing(true);
        JScrollPane jScrollPane = new JScrollPane(this.getJTree());
        this._pane = new JEditorPane();
        this._pane.setEditable(true);
        JScrollPane jScrollPane2 = new JScrollPane(this._pane);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setTopComponent(jScrollPane);
        jScrollPane2.setMinimumSize(Constants.NODE_PANEL_SPLIT_MINIMUM_SIZE);
        jScrollPane.setMinimumSize(Constants.NODE_PANEL_SPLIT_MINIMUM_SIZE);
        jSplitPane.setPreferredSize(Constants.NODE_PANEL_SIZE);
        this.add(jSplitPane);
        this.getJTree().getSelectionModel().setSelectionMode(1);
        this.getJTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                NodeEditPanel.this.keyEvent(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                NodeEditPanel.this.keyEvent(keyEvent);
            }

            public void keyTyped(KeyEvent keyEvent) {
                NodeEditPanel.this.keyEvent(keyEvent);
            }
        });
        for (int i = 0; i < this.getJTree().getRowCount(); ++i) {
            this.getJTree().expandRow(i);
        }
        this.collapsePath("Basic");
        this.collapsePath("Taxonomy");
        this.collapsePath("Sequence");
        this.collapsePath("Events");
        this.collapsePath("Date");
        this.collapsePath("Distribution");
        this.collapsePath("Reference");
        this.getJTree().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                TreePath treePath2 = treeSelectionEvent.getOldLeadSelectionPath();
                if (treePath != null) {
                    NodeEditPanel.this.writeBack((DefaultMutableTreeNode)treePath.getLastPathComponent());
                }
                if (treePath2 != null) {
                    NodeEditPanel.this.writeBack((DefaultMutableTreeNode)treePath2.getLastPathComponent());
                }
            }
        });
    }

    private void addBasics(DefaultMutableTreeNode defaultMutableTreeNode, PhylogenyNode phylogenyNode, String string) {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.addSubelementEditable(defaultMutableTreeNode2, "Name", phylogenyNode.getName(), PHYLOXML_TAG.NODE_NAME);
        String string2 = "";
        if (phylogenyNode.getDistanceToParent() != -1024.0) {
            string2 = ForesterUtil.FORMATTER_6.format(phylogenyNode.getDistanceToParent());
        }
        this.addSubelementEditable(defaultMutableTreeNode2, "Branch length", string2, PHYLOXML_TAG.NODE_BRANCH_LENGTH);
        int n = 0;
        if (phylogenyNode.getBranchData().isHasConfidences()) {
            for (int i = phylogenyNode.getBranchData().getConfidences().size() - 1; i >= 0; --i) {
                if (phylogenyNode.getBranchData().getConfidences().get(i).getValue() != -9999.0) continue;
                phylogenyNode.getBranchData().getConfidences().remove(i);
            }
            object = phylogenyNode.getBranchData().getConfidences().iterator();
            while (object.hasNext()) {
                Confidence confidence;
                Confidence confidence2 = confidence = object.next();
                this.addSubelementEditable(defaultMutableTreeNode2, "Confidence [" + n + "]", ForesterUtil.FORMATTER_6.format(confidence2.getValue()), PHYLOXML_TAG.CONFIDENCE_VALUE, "type", confidence2.getType(), PHYLOXML_TAG.CONFIDENCE_TYPE, n++);
            }
        }
        this.addSubelementEditable(defaultMutableTreeNode2, "Confidence [" + n + "]", "", PHYLOXML_TAG.CONFIDENCE_VALUE, "type", "", PHYLOXML_TAG.CONFIDENCE_TYPE, n);
        object = "1";
        if (phylogenyNode.getBranchData().getBranchWidth() != null && phylogenyNode.getBranchData().getBranchWidth().getValue() != 1.0) {
            object = ForesterUtil.FORMATTER_3.format(phylogenyNode.getBranchData().getBranchWidth().getValue());
        }
        this.addSubelementEditable(defaultMutableTreeNode2, "Branch width", (String)object, PHYLOXML_TAG.NODE_BRANCH_WIDTH);
    }

    private void addDate(DefaultMutableTreeNode defaultMutableTreeNode, Date date, String string) {
        if (date == null) {
            date = new Date();
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.addSubelementEditable(defaultMutableTreeNode2, "Description", date.getDesc(), PHYLOXML_TAG.DATE_DESCRIPTION);
        this.addSubelementEditable(defaultMutableTreeNode2, "Value", String.valueOf(date.getValue() != null ? date.getValue() : ""), PHYLOXML_TAG.DATE_VALUE);
        this.addSubelementEditable(defaultMutableTreeNode2, "Min", String.valueOf(date.getMin() != null ? date.getMin() : ""), PHYLOXML_TAG.DATE_MIN);
        this.addSubelementEditable(defaultMutableTreeNode2, "Max", String.valueOf(date.getMax() != null ? date.getMax() : ""), PHYLOXML_TAG.DATE_MAX);
        this.addSubelementEditable(defaultMutableTreeNode2, "Unit", date.getUnit(), PHYLOXML_TAG.DATE_UNIT);
    }

    private void addDistribution(DefaultMutableTreeNode defaultMutableTreeNode, Distribution distribution, String string) {
        if (distribution == null) {
            distribution = new Distribution("");
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        Point point = null;
        point = distribution.getPoints() != null && distribution.getPoints().size() > 0 ? distribution.getPoints().get(0) : new Point();
        this.addSubelementEditable(defaultMutableTreeNode2, "Description", distribution.getDesc(), PHYLOXML_TAG.DIST_DESC);
        this.addSubelementEditable(defaultMutableTreeNode2, "Geodetic datum", point.getGeodeticDatum(), PHYLOXML_TAG.DIST_GEODETIC);
        this.addSubelementEditable(defaultMutableTreeNode2, "Latitude", String.valueOf(point.getLatitude() != null ? point.getLatitude() : ""), PHYLOXML_TAG.DIST_LAT);
        this.addSubelementEditable(defaultMutableTreeNode2, "Longitude", String.valueOf(point.getLongitude() != null ? point.getLongitude() : ""), PHYLOXML_TAG.DIST_LONG);
        this.addSubelementEditable(defaultMutableTreeNode2, "Altitude", String.valueOf(point.getAltitude() != null ? point.getAltitude() : ""), PHYLOXML_TAG.DIST_ALT);
        this.addSubelementEditable(defaultMutableTreeNode2, "Altitude unit", String.valueOf(point.getAltiudeUnit() != null ? point.getAltiudeUnit() : ""), PHYLOXML_TAG.DIST_ALT_UNIT);
    }

    private void addEvents(DefaultMutableTreeNode defaultMutableTreeNode, Event event, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        if (event == null) {
            event = new Event();
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.addSubelementEditable(defaultMutableTreeNode2, "Duplications", String.valueOf(event.getNumberOfDuplications() >= 0 ? event.getNumberOfDuplications() : 0), PHYLOXML_TAG.EVENTS_DUPLICATIONS);
        this.addSubelementEditable(defaultMutableTreeNode2, "Speciations", String.valueOf(event.getNumberOfSpeciations() >= 0 ? event.getNumberOfSpeciations() : 0), PHYLOXML_TAG.EVENTS_SPECIATIONS);
        this.addSubelementEditable(defaultMutableTreeNode2, "Gene losses", String.valueOf(event.getNumberOfGeneLosses() >= 0 ? event.getNumberOfGeneLosses() : 0), PHYLOXML_TAG.EVENTS_GENE_LOSSES);
    }

    private void addMapping(DefaultMutableTreeNode defaultMutableTreeNode, TagNumber tagNumber) {
        if (this.getMap().containsKey(defaultMutableTreeNode)) {
            throw new IllegalArgumentException("key " + defaultMutableTreeNode + " already present");
        }
        if (this.getMap().containsValue(tagNumber)) {
            throw new IllegalArgumentException("value " + tagNumber + " already present");
        }
        this.getMap().put(defaultMutableTreeNode, tagNumber);
    }

    private void addReference(DefaultMutableTreeNode defaultMutableTreeNode, Reference reference, String string) {
        if (reference == null) {
            reference = new Reference("");
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.addSubelementEditable(defaultMutableTreeNode2, "Description", reference.getDescription(), PHYLOXML_TAG.LIT_REFERENCE_DESC);
        this.addSubelementEditable(defaultMutableTreeNode2, "DOI", reference.getDoi(), PHYLOXML_TAG.LIT_REFERENCE_DOI);
    }

    private void addSequence(DefaultMutableTreeNode defaultMutableTreeNode, Sequence sequence, String string) {
        if (sequence == null) {
            sequence = new Sequence();
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        Accession accession = sequence.getAccession();
        if (accession == null) {
            accession = new Accession("", "");
        }
        this.addSubelementEditable(defaultMutableTreeNode2, "Name", sequence.getName(), PHYLOXML_TAG.SEQ_NAME);
        this.addSubelementEditable(defaultMutableTreeNode2, "Symbol", sequence.getSymbol(), PHYLOXML_TAG.SEQ_SYMBOL);
        this.addSubelementEditable(defaultMutableTreeNode2, "Accession", accession.getValue(), PHYLOXML_TAG.SEQ_ACC_VALUE, "Source", accession.getSource(), PHYLOXML_TAG.SEQ_ACC_SOURCE);
        this.addSubelementEditable(defaultMutableTreeNode2, "Location", sequence.getLocation(), PHYLOXML_TAG.SEQ_LOCATION);
        this.addSubelementEditable(defaultMutableTreeNode2, "Type", sequence.getType(), PHYLOXML_TAG.SEQ_TYPE);
        this.addSubelementEditable(defaultMutableTreeNode2, "Mol seq", sequence.getMolecularSequence(), PHYLOXML_TAG.SEQ_MOL_SEQ);
        int n = 0;
        if (sequence.getUris() != null) {
            for (Uri uri : sequence.getUris()) {
                if (uri == null) continue;
                this.addSubelementEditable(defaultMutableTreeNode2, "URI [" + n + "]", uri.getValue().toString(), PHYLOXML_TAG.SEQ_URI, n++);
            }
        }
        this.addSubelementEditable(defaultMutableTreeNode2, "URI [" + n + "]", "", PHYLOXML_TAG.SEQ_URI, n);
    }

    private void addSubelementEditable(DefaultMutableTreeNode defaultMutableTreeNode, String string, String string2, PHYLOXML_TAG pHYLOXML_TAG) {
        this.addSubelementEditable(defaultMutableTreeNode, string, string2, pHYLOXML_TAG, 0);
    }

    private void addSubelementEditable(DefaultMutableTreeNode defaultMutableTreeNode, String string, String string2, PHYLOXML_TAG pHYLOXML_TAG, int n) {
        String string3 = string2;
        if (ForesterUtil.isEmpty(string3)) {
            string3 = "";
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(string3);
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.addMapping(defaultMutableTreeNode2, new TagNumber(pHYLOXML_TAG, n));
    }

    private void addSubelementEditable(DefaultMutableTreeNode defaultMutableTreeNode, String string, String string2, PHYLOXML_TAG pHYLOXML_TAG, String string3, String string4, PHYLOXML_TAG pHYLOXML_TAG2) {
        this.addSubelementEditable(defaultMutableTreeNode, string, string2, pHYLOXML_TAG, string3, string4, pHYLOXML_TAG2, 0);
    }

    private void addSubelementEditable(DefaultMutableTreeNode defaultMutableTreeNode, String string, String string2, PHYLOXML_TAG pHYLOXML_TAG, String string3, String string4, PHYLOXML_TAG pHYLOXML_TAG2, int n) {
        String string5;
        String string6 = string2;
        if (ForesterUtil.isEmpty(string6)) {
            string6 = "";
        }
        if (ForesterUtil.isEmpty(string5 = string4)) {
            string5 = "";
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(string3);
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(string5);
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(string6);
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        defaultMutableTreeNode2.add(defaultMutableTreeNode5);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.addMapping(defaultMutableTreeNode2, new TagNumber(pHYLOXML_TAG, n));
        this.addMapping(defaultMutableTreeNode3, new TagNumber(pHYLOXML_TAG2, n));
    }

    private void addTaxonomy(DefaultMutableTreeNode defaultMutableTreeNode, Taxonomy taxonomy, String string) {
        int n;
        if (taxonomy == null) {
            taxonomy = new Taxonomy();
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        Identifier identifier = taxonomy.getIdentifier();
        if (identifier == null) {
            identifier = new Identifier();
        }
        this.addSubelementEditable(defaultMutableTreeNode2, "Identifier", identifier.getValue(), PHYLOXML_TAG.TAXONOMY_ID_VALUE, "Provider", identifier.getProvider(), PHYLOXML_TAG.TAXONOMY_ID_PROVIDER);
        this.addSubelementEditable(defaultMutableTreeNode2, "Code", taxonomy.getTaxonomyCode(), PHYLOXML_TAG.TAXONOMY_CODE);
        this.addSubelementEditable(defaultMutableTreeNode2, "Scientific name", taxonomy.getScientificName(), PHYLOXML_TAG.TAXONOMY_SCIENTIFIC_NAME);
        this.addSubelementEditable(defaultMutableTreeNode2, "Authority", taxonomy.getAuthority(), PHYLOXML_TAG.TAXONOMY_AUTHORITY);
        this.addSubelementEditable(defaultMutableTreeNode2, "Common name", taxonomy.getCommonName(), PHYLOXML_TAG.TAXONOMY_COMMON_NAME);
        for (n = taxonomy.getSynonyms().size() - 1; n >= 0; --n) {
            if (!ForesterUtil.isEmpty(taxonomy.getSynonyms().get(n))) continue;
            taxonomy.getSynonyms().remove(n);
        }
        n = 0;
        for (String object : taxonomy.getSynonyms()) {
            this.addSubelementEditable(defaultMutableTreeNode2, "Synonym [" + n + "]", object, PHYLOXML_TAG.TAXONOMY_SYNONYM, n++);
        }
        this.addSubelementEditable(defaultMutableTreeNode2, "Synonym [" + n + "]", "", PHYLOXML_TAG.TAXONOMY_SYNONYM, n);
        this.addSubelementEditable(defaultMutableTreeNode2, "Rank", taxonomy.getRank(), PHYLOXML_TAG.TAXONOMY_RANK);
        int n2 = 0;
        if (taxonomy.getUris() != null) {
            for (Uri uri : taxonomy.getUris()) {
                if (uri == null) continue;
                this.addSubelementEditable(defaultMutableTreeNode2, "URI [" + n2 + "]", uri.getValue().toString(), PHYLOXML_TAG.TAXONOMY_URI, n2++);
            }
        }
        this.addSubelementEditable(defaultMutableTreeNode2, "URI [" + n2 + "]", "", PHYLOXML_TAG.TAXONOMY_URI, n2);
    }

    private void collapsePath(String string) {
        TreePath treePath = this.getJTree().getNextMatch(string, 0, Position.Bias.Forward);
        if (treePath != null) {
            this.getJTree().collapsePath(treePath);
        }
    }

    private void createNodes(DefaultMutableTreeNode defaultMutableTreeNode, PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
            phylogenyNode.getNodeData().addTaxonomy(new Taxonomy());
        }
        if (!phylogenyNode.getNodeData().isHasSequence()) {
            phylogenyNode.getNodeData().addSequence(new Sequence());
        }
        if (!phylogenyNode.getNodeData().isHasDistribution()) {
            phylogenyNode.getNodeData().addDistribution(new Distribution(""));
        }
        if (!phylogenyNode.getNodeData().isHasReference()) {
            phylogenyNode.getNodeData().addReference(new Reference(""));
        }
        this.addBasics(defaultMutableTreeNode, phylogenyNode, "Basic");
        this.addTaxonomy(defaultMutableTreeNode, phylogenyNode.getNodeData().getTaxonomy(), "Taxonomy");
        this.addSequence(defaultMutableTreeNode, phylogenyNode.getNodeData().getSequence(), "Sequence");
        if (!phylogenyNode.isExternal()) {
            this.addEvents(defaultMutableTreeNode, phylogenyNode.getNodeData().getEvent(), "Events");
        }
        this.addDate(defaultMutableTreeNode, phylogenyNode.getNodeData().getDate(), "Date");
        this.addDistribution(defaultMutableTreeNode, phylogenyNode.getNodeData().getDistribution(), "Distribution");
        this.addReference(defaultMutableTreeNode, phylogenyNode.getNodeData().getReference(), "Reference");
    }

    private void formatError(DefaultMutableTreeNode defaultMutableTreeNode, PhyloXmlDataFormatException phyloXmlDataFormatException) {
        JOptionPane.showMessageDialog(this, phyloXmlDataFormatException.getMessage(), "Format error", 0);
        defaultMutableTreeNode.setUserObject("");
        this.getJTree().repaint();
    }

    private JTree getJTree() {
        return this._tree;
    }

    private Map<DefaultMutableTreeNode, TagNumber> getMap() {
        return this._map;
    }

    private TagNumber getMapping(DefaultMutableTreeNode defaultMutableTreeNode) {
        return this.getMap().get(defaultMutableTreeNode);
    }

    PhylogenyNode getMyNode() {
        return this._my_node;
    }

    private DefaultMutableTreeNode getSelectedTreeNode() {
        Object[] objectArray;
        TreePath treePath = this.getJTree().getSelectionPath();
        if (treePath != null && (objectArray = treePath.getPath()).length > 0) {
            return (DefaultMutableTreeNode)objectArray[objectArray.length - 1];
        }
        return null;
    }

    private TreePanel getTreePanel() {
        return this._tree_panel;
    }

    private void keyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.writeBack(this.getSelectedTreeNode());
        }
    }

    private List<Point> obtainPoints() {
        List<Point> list;
        ForesterUtil.ensurePresenceOfDistribution(this.getMyNode());
        Distribution distribution = this.getMyNode().getNodeData().getDistribution();
        if (distribution.getPoints() == null) {
            distribution = new Distribution(distribution.getDesc(), new ArrayList<Point>(), distribution.getPolygons());
            this.getMyNode().getNodeData().setDistribution(distribution);
        }
        if ((list = distribution.getPoints()).isEmpty()) {
            list.add(new Point());
        } else if (list.get(0) == null) {
            list.set(0, new Point());
        }
        return list;
    }

    private BigDecimal parseBigDecimal(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        if (ForesterUtil.isEmpty(string)) {
            return new BigDecimal(0);
        }
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "illegal value: " + string, "Error", 0);
            defaultMutableTreeNode.setUserObject("");
        }
        return bigDecimal;
    }

    private int parsePositiveInt(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        if (ForesterUtil.isEmpty(string)) {
            return 0;
        }
        int n = -1;
        try {
            n = ForesterUtil.parseInt(string);
        }
        catch (ParseException parseException) {
            JOptionPane.showMessageDialog(this, "illegal value: " + string, "Error", 0);
            defaultMutableTreeNode.setUserObject("");
        }
        if (n < 0) {
            JOptionPane.showMessageDialog(this, "illegal value: " + string, "Error", 0);
            defaultMutableTreeNode.setUserObject("");
        }
        return n;
    }

    void writeAll() {
        for (int i = 0; i < this.getJTree().getRowCount(); ++i) {
            TreePath treePath = this.getJTree().getPathForRow(i);
            this.writeBack((DefaultMutableTreeNode)treePath.getLastPathComponent());
        }
    }

    private void writeBack(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (!this.getMap().containsKey(defaultMutableTreeNode)) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            if (this.getMap().containsKey(defaultMutableTreeNode2)) {
                this.writeBack(defaultMutableTreeNode, this.getMapping(defaultMutableTreeNode2));
            }
        }
    }

    private void writeBack(DefaultMutableTreeNode defaultMutableTreeNode, TagNumber tagNumber) {
        if (tagNumber == null) {
            return;
        }
        String string = defaultMutableTreeNode.toString();
        if (string == null) {
            string = "";
        }
        string = string.replaceAll("\\s+", " ");
        string = string.trim();
        defaultMutableTreeNode.setUserObject(string);
        this.getJTree().repaint();
        PHYLOXML_TAG pHYLOXML_TAG = tagNumber.getTag();
        int n = tagNumber.getNumber();
        switch (pHYLOXML_TAG) {
            case NODE_NAME: {
                this.getMyNode().setName(string);
                break;
            }
            case NODE_BRANCH_LENGTH: {
                if (ForesterUtil.isEmpty(string)) {
                    this.getMyNode().setDistanceToParent(-1024.0);
                    break;
                }
                try {
                    this.getMyNode().setDistanceToParent(ForesterUtil.parseDouble(string));
                }
                catch (ParseException parseException) {
                    JOptionPane.showMessageDialog(this, "failed to parse branch length from: " + string, "Error", 0);
                    defaultMutableTreeNode.setUserObject("");
                }
                break;
            }
            case NODE_BRANCH_WIDTH: {
                if (ForesterUtil.isEmpty(string) || string.equals("1")) {
                    if (this.getMyNode().getBranchData().getBranchWidth() == null) break;
                    this.getMyNode().getBranchData().setBranchWidth(new BranchWidth());
                    break;
                }
                try {
                    double d = ForesterUtil.parseDouble(string);
                    if (!(d >= 0.0)) break;
                    this.getMyNode().getBranchData().setBranchWidth(new BranchWidth(d));
                }
                catch (ParseException parseException) {
                    JOptionPane.showMessageDialog(this, "failed to parse branch width from: " + string, "Error", 0);
                    defaultMutableTreeNode.setUserObject("");
                }
                break;
            }
            case CONFIDENCE_VALUE: {
                double d = -9999.0;
                if (!ForesterUtil.isEmpty(string)) {
                    try {
                        d = ForesterUtil.parseDouble(string);
                    }
                    catch (ParseException parseException) {
                        JOptionPane.showMessageDialog(this, "failed to parse confidence value from: " + string, "Error", 0);
                        defaultMutableTreeNode.setUserObject("");
                        break;
                    }
                }
                if (this.getMyNode().getBranchData().getConfidences().size() < n) {
                    throw new FailedConditionCheckException();
                }
                if (this.getMyNode().getBranchData().getConfidences().size() == n) {
                    if (!(d >= 0.0)) break;
                    this.getMyNode().getBranchData().getConfidences().add(new Confidence(d, "unknown"));
                    break;
                }
                String string2 = this.getMyNode().getBranchData().getConfidences().get(n).getType();
                this.getMyNode().getBranchData().getConfidences().set(n, new Confidence(d, string2));
                break;
            }
            case CONFIDENCE_TYPE: {
                if (this.getMyNode().getBranchData().getConfidences().size() < n) {
                    throw new FailedConditionCheckException();
                }
                if (this.getMyNode().getBranchData().getConfidences().size() == n) {
                    if (ForesterUtil.isEmpty(string)) break;
                    this.getMyNode().getBranchData().getConfidences().add(new Confidence(0.0, string));
                    break;
                }
                double d = this.getMyNode().getBranchData().getConfidences().get(n).getValue();
                this.getMyNode().getBranchData().getConfidences().set(n, new Confidence(d, string));
                break;
            }
            case TAXONOMY_CODE: {
                ForesterUtil.ensurePresenceOfTaxonomy(this.getMyNode());
                try {
                    this.getMyNode().getNodeData().getTaxonomy().setTaxonomyCode(string);
                }
                catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                    this.formatError(defaultMutableTreeNode, phyloXmlDataFormatException);
                }
                break;
            }
            case TAXONOMY_SCIENTIFIC_NAME: {
                ForesterUtil.ensurePresenceOfTaxonomy(this.getMyNode());
                this.getMyNode().getNodeData().getTaxonomy().setScientificName(string);
                break;
            }
            case TAXONOMY_COMMON_NAME: {
                ForesterUtil.ensurePresenceOfTaxonomy(this.getMyNode());
                this.getMyNode().getNodeData().getTaxonomy().setCommonName(string);
                break;
            }
            case TAXONOMY_RANK: {
                ForesterUtil.ensurePresenceOfTaxonomy(this.getMyNode());
                try {
                    this.getMyNode().getNodeData().getTaxonomy().setRank(string.toLowerCase());
                }
                catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                    this.formatError(defaultMutableTreeNode, phyloXmlDataFormatException);
                }
                break;
            }
            case TAXONOMY_AUTHORITY: {
                ForesterUtil.ensurePresenceOfTaxonomy(this.getMyNode());
                this.getMyNode().getNodeData().getTaxonomy().setAuthority(string);
                break;
            }
            case TAXONOMY_URI: {
                Uri uri = null;
                if (!ForesterUtil.isEmpty(string)) {
                    try {
                        uri = new Uri(new URL(string).toURI());
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(this, "failed to parse URL from: " + string, "Error", 0);
                        defaultMutableTreeNode.setUserObject("");
                    }
                }
                if (uri != null) {
                    ForesterUtil.ensurePresenceOfTaxonomy(this.getMyNode());
                }
                this.addUri(defaultMutableTreeNode, uri, n, this.getMyNode().getNodeData().getTaxonomy());
                break;
            }
            case TAXONOMY_SYNONYM: {
                if (this.getMyNode().getNodeData().getTaxonomy().getSynonyms().size() < n) {
                    throw new FailedConditionCheckException();
                }
                if (this.getMyNode().getNodeData().getTaxonomy().getSynonyms().size() == n) {
                    if (ForesterUtil.isEmpty(string)) break;
                    ForesterUtil.ensurePresenceOfTaxonomy(this.getMyNode());
                    this.getMyNode().getNodeData().getTaxonomy().getSynonyms().add(string);
                    break;
                }
                this.getMyNode().getNodeData().getTaxonomy().getSynonyms().set(n, string);
                break;
            }
            case TAXONOMY_ID_VALUE: {
                ForesterUtil.ensurePresenceOfTaxonomy(this.getMyNode());
                if (this.getMyNode().getNodeData().getTaxonomy().getIdentifier() == null) {
                    this.getMyNode().getNodeData().getTaxonomy().setIdentifier(new Identifier(string));
                    break;
                }
                String string3 = this.getMyNode().getNodeData().getTaxonomy().getIdentifier().getProvider();
                this.getMyNode().getNodeData().getTaxonomy().setIdentifier(new Identifier(string, string3));
                break;
            }
            case TAXONOMY_ID_PROVIDER: {
                ForesterUtil.ensurePresenceOfTaxonomy(this.getMyNode());
                if (this.getMyNode().getNodeData().getTaxonomy().getIdentifier() == null) {
                    this.getMyNode().getNodeData().getTaxonomy().setIdentifier(new Identifier("", string));
                    break;
                }
                String string4 = this.getMyNode().getNodeData().getTaxonomy().getIdentifier().getValue();
                this.getMyNode().getNodeData().getTaxonomy().setIdentifier(new Identifier(string4, string));
                break;
            }
            case SEQ_LOCATION: {
                ForesterUtil.ensurePresenceOfSequence(this.getMyNode());
                this.getMyNode().getNodeData().getSequence().setLocation(string);
                break;
            }
            case SEQ_MOL_SEQ: {
                ForesterUtil.ensurePresenceOfSequence(this.getMyNode());
                this.getMyNode().getNodeData().getSequence().setMolecularSequence(string);
                break;
            }
            case SEQ_NAME: {
                ForesterUtil.ensurePresenceOfSequence(this.getMyNode());
                this.getMyNode().getNodeData().getSequence().setName(string);
                break;
            }
            case SEQ_SYMBOL: {
                ForesterUtil.ensurePresenceOfSequence(this.getMyNode());
                try {
                    this.getMyNode().getNodeData().getSequence().setSymbol(string);
                }
                catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                    this.formatError(defaultMutableTreeNode, phyloXmlDataFormatException);
                }
                break;
            }
            case SEQ_TYPE: {
                ForesterUtil.ensurePresenceOfSequence(this.getMyNode());
                try {
                    this.getMyNode().getNodeData().getSequence().setType(string.toLowerCase());
                }
                catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                    this.formatError(defaultMutableTreeNode, phyloXmlDataFormatException);
                }
                break;
            }
            case SEQ_ACC_SOURCE: {
                ForesterUtil.ensurePresenceOfSequence(this.getMyNode());
                if (this.getMyNode().getNodeData().getSequence().getAccession() == null) {
                    this.getMyNode().getNodeData().getSequence().setAccession(new Accession("", string));
                    break;
                }
                String string5 = this.getMyNode().getNodeData().getSequence().getAccession().getValue();
                this.getMyNode().getNodeData().getSequence().setAccession(new Accession(string5, string));
                break;
            }
            case SEQ_ACC_VALUE: {
                ForesterUtil.ensurePresenceOfSequence(this.getMyNode());
                if (this.getMyNode().getNodeData().getSequence().getAccession() == null) {
                    this.getMyNode().getNodeData().getSequence().setAccession(new Accession(string, ""));
                    break;
                }
                String string6 = this.getMyNode().getNodeData().getSequence().getAccession().getSource();
                this.getMyNode().getNodeData().getSequence().setAccession(new Accession(string, string6));
                break;
            }
            case SEQ_URI: {
                Uri uri = null;
                if (!ForesterUtil.isEmpty(string)) {
                    try {
                        uri = new Uri(new URL(string).toURI());
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(this, "failed to parse URL from: " + string, "Error", 0);
                        defaultMutableTreeNode.setUserObject("");
                    }
                }
                if (uri != null) {
                    ForesterUtil.ensurePresenceOfSequence(this.getMyNode());
                }
                this.addUri(defaultMutableTreeNode, uri, n, this.getMyNode().getNodeData().getSequence());
                break;
            }
            case LIT_REFERENCE_DESC: {
                if (!this.getMyNode().getNodeData().isHasReference()) {
                    this.getMyNode().getNodeData().setReference(new Reference(""));
                }
                this.getMyNode().getNodeData().getReference().setValue(string);
                break;
            }
            case LIT_REFERENCE_DOI: {
                if (!this.getMyNode().getNodeData().isHasReference()) {
                    this.getMyNode().getNodeData().setReference(new Reference(""));
                }
                try {
                    this.getMyNode().getNodeData().getReference().setDoi(string);
                }
                catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                    this.formatError(defaultMutableTreeNode, phyloXmlDataFormatException);
                }
                break;
            }
            case EVENTS_DUPLICATIONS: {
                if (!this.getMyNode().getNodeData().isHasEvent()) {
                    this.getMyNode().getNodeData().setEvent(new Event());
                }
                this.getMyNode().getNodeData().getEvent().setDuplications(this.parsePositiveInt(defaultMutableTreeNode, string));
                break;
            }
            case EVENTS_SPECIATIONS: {
                if (!this.getMyNode().getNodeData().isHasEvent()) {
                    this.getMyNode().getNodeData().setEvent(new Event());
                }
                this.getMyNode().getNodeData().getEvent().setSpeciations(this.parsePositiveInt(defaultMutableTreeNode, string));
                break;
            }
            case EVENTS_GENE_LOSSES: {
                if (!this.getMyNode().getNodeData().isHasEvent()) {
                    this.getMyNode().getNodeData().setEvent(new Event());
                }
                this.getMyNode().getNodeData().getEvent().setGeneLosses(this.parsePositiveInt(defaultMutableTreeNode, string));
                break;
            }
            case DATE_DESCRIPTION: {
                ForesterUtil.ensurePresenceOfDate(this.getMyNode());
                this.getMyNode().getNodeData().getDate().setDesc(string);
                break;
            }
            case DATE_MAX: {
                ForesterUtil.ensurePresenceOfDate(this.getMyNode());
                this.getMyNode().getNodeData().getDate().setMax(this.parseBigDecimal(defaultMutableTreeNode, string));
                break;
            }
            case DATE_MIN: {
                ForesterUtil.ensurePresenceOfDate(this.getMyNode());
                this.getMyNode().getNodeData().getDate().setMin(this.parseBigDecimal(defaultMutableTreeNode, string));
                break;
            }
            case DATE_UNIT: {
                ForesterUtil.ensurePresenceOfDate(this.getMyNode());
                this.getMyNode().getNodeData().getDate().setUnit(string);
                break;
            }
            case DATE_VALUE: {
                ForesterUtil.ensurePresenceOfDate(this.getMyNode());
                this.getMyNode().getNodeData().getDate().setValue(this.parseBigDecimal(defaultMutableTreeNode, string));
                break;
            }
            case DIST_ALT: {
                BigDecimal bigDecimal = this.parseBigDecimal(defaultMutableTreeNode, string);
                if (bigDecimal == null) break;
                List<Point> list = this.obtainPoints();
                Point point = list.get(0);
                Point point2 = new Point(point.getGeodeticDatum(), point.getLatitude(), point.getLongitude(), bigDecimal, ForesterUtil.isEmpty(point.getAltiudeUnit()) ? "?" : point.getAltiudeUnit());
                list.set(0, point2);
                break;
            }
            case DIST_DESC: {
                ForesterUtil.ensurePresenceOfDistribution(this.getMyNode());
                Distribution distribution = this.getMyNode().getNodeData().getDistribution();
                this.getMyNode().getNodeData().setDistribution(new Distribution(string, distribution.getPoints(), distribution.getPolygons()));
                break;
            }
            case DIST_GEODETIC: {
                if (ForesterUtil.isEmpty(string)) break;
                List<Point> list = this.obtainPoints();
                Point point = list.get(0);
                Point point3 = new Point(string, point.getLatitude(), point.getLongitude(), point.getAltitude(), point.getAltiudeUnit());
                list.set(0, point3);
                break;
            }
            case DIST_ALT_UNIT: {
                if (ForesterUtil.isEmpty(string)) break;
                List<Point> list = this.obtainPoints();
                Point point = list.get(0);
                Point point4 = new Point(point.getGeodeticDatum(), point.getLatitude(), point.getLongitude(), point.getAltitude(), string);
                list.set(0, point4);
                break;
            }
            case DIST_LAT: {
                BigDecimal bigDecimal = this.parseBigDecimal(defaultMutableTreeNode, string);
                if (bigDecimal == null) break;
                List<Point> list = this.obtainPoints();
                Point point = list.get(0);
                Point point5 = new Point(point.getGeodeticDatum(), bigDecimal, point.getLongitude(), point.getAltitude(), point.getAltiudeUnit());
                list.set(0, point5);
                break;
            }
            case DIST_LONG: {
                BigDecimal bigDecimal = this.parseBigDecimal(defaultMutableTreeNode, string);
                if (bigDecimal == null) break;
                List<Point> list = this.obtainPoints();
                Point point = list.get(0);
                Point point6 = new Point(point.getGeodeticDatum(), point.getLatitude(), bigDecimal, point.getAltitude(), point.getAltiudeUnit());
                list.set(0, point6);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown: " + (Object)((Object)pHYLOXML_TAG));
            }
        }
        this.getJTree().repaint();
        this.getTreePanel().setEdited(true);
        this.getTreePanel().repaint();
    }

    private void addUri(DefaultMutableTreeNode defaultMutableTreeNode, Uri uri, int n, MultipleUris multipleUris) {
        if (uri != null && multipleUris.getUris() == null) {
            multipleUris.setUris(new ArrayList<Uri>());
        }
        if (uri != null && multipleUris.getUris() == null) {
            multipleUris.setUris(new ArrayList<Uri>());
        }
        if (uri != null && multipleUris.getUris().size() == n) {
            multipleUris.getUris().add(uri);
        }
        if (multipleUris.getUris() != null && multipleUris.getUris().size() != n) {
            multipleUris.getUris().set(n, uri);
        }
        ImageLoader imageLoader = new ImageLoader(this.getTreePanel());
        new Thread(imageLoader).start();
    }

    private class TagNumber {
        private final PHYLOXML_TAG _tag;
        private final int _number;

        TagNumber(PHYLOXML_TAG pHYLOXML_TAG, int n) {
            this._tag = pHYLOXML_TAG;
            this._number = n;
        }

        int getNumber() {
            return this._number;
        }

        PHYLOXML_TAG getTag() {
            return this._tag;
        }

        public String toString() {
            return (Object)((Object)this.getTag()) + "_" + this.getNumber();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PHYLOXML_TAG {
        NODE_NAME,
        NODE_BRANCH_LENGTH,
        NODE_BRANCH_WIDTH,
        TAXONOMY_CODE,
        TAXONOMY_SCIENTIFIC_NAME,
        TAXONOMY_AUTHORITY,
        TAXONOMY_COMMON_NAME,
        TAXONOMY_SYNONYM,
        TAXONOMY_RANK,
        TAXONOMY_URI,
        SEQ_SYMBOL,
        SEQ_NAME,
        SEQ_LOCATION,
        SEQ_TYPE,
        SEQ_MOL_SEQ,
        SEQ_URI,
        DATE_DESCRIPTION,
        DATE_VALUE,
        DATE_MIN,
        DATE_MAX,
        DATE_UNIT,
        TAXONOMY_ID_VALUE,
        TAXONOMY_ID_PROVIDER,
        SEQ_ACC_VALUE,
        SEQ_ACC_SOURCE,
        CONFIDENCE_VALUE,
        CONFIDENCE_TYPE,
        LIT_REFERENCE_DESC,
        LIT_REFERENCE_DOI,
        EVENTS_DUPLICATIONS,
        EVENTS_SPECIATIONS,
        EVENTS_GENE_LOSSES,
        DIST_DESC,
        DIST_GEODETIC,
        DIST_LAT,
        DIST_LONG,
        DIST_ALT,
        DIST_ALT_UNIT;

    }
}

