/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import org.forester.archaeopteryx.TreePanel;

final class MouseListener
extends MouseAdapter
implements MouseMotionListener {
    private final TreePanel _treepanel;
    private boolean _being_dragged = false;
    private final Point _click_point = new Point();

    MouseListener(TreePanel treePanel) {
        this._treepanel = treePanel;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this._click_point.setLocation(mouseEvent.getX(), mouseEvent.getY());
        this._treepanel.mouseClicked(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiersEx() == 1024 || mouseEvent.getModifiersEx() == 4096) {
            if (!this._treepanel.inOvRectangle(mouseEvent)) {
                if (!this._being_dragged) {
                    this._being_dragged = true;
                    this._treepanel.setLastMouseDragPointX(mouseEvent.getX());
                    this._treepanel.setLastMouseDragPointY(mouseEvent.getY());
                }
                this._treepanel.mouseDragInBrowserPanel(mouseEvent);
            } else {
                if (!this._being_dragged) {
                    this._being_dragged = true;
                    this._treepanel.setLastMouseDragPointX(mouseEvent.getX());
                    this._treepanel.setLastMouseDragPointY(mouseEvent.getY());
                }
                this._treepanel.mouseDragInOvRectangle(mouseEvent);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this._treepanel.mouseMoved(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiersEx() == 1024) {
            if (!this._being_dragged) {
                this._being_dragged = true;
                this._treepanel.setLastMouseDragPointX(mouseEvent.getX());
                this._treepanel.setLastMouseDragPointY(mouseEvent.getY());
            }
            if (!this._treepanel.inOvRectangle(mouseEvent)) {
                this._treepanel.mouseDragInBrowserPanel(mouseEvent);
            } else {
                this._treepanel.mouseDragInOvRectangle(mouseEvent);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._being_dragged) {
            this._being_dragged = false;
        }
        this._treepanel.mouseReleasedInBrowserPanel(mouseEvent);
    }
}

