/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JApplet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import org.forester.archaeopteryx.ColorSchemeChooser;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.ControlPanel;
import org.forester.archaeopteryx.FontChooser;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TextFrame;
import org.forester.archaeopteryx.TreeColorSet;
import org.forester.archaeopteryx.TreeFontSet;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.UrlTreeReader;
import org.forester.archaeopteryx.Util;
import org.forester.archaeopteryx.WebLink;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.data.NodeVisualization;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MainFrame
extends JFrame
implements ActionListener {
    static final String USE_MOUSEWHEEL_SHIFT_TO_ROTATE = "In this display type, use mousewheel + Shift to rotate [or A and S]";
    static final String PHYLOXML_REF_TOOL_TIP = "Han MV and Zmasek CM (2009): \"phyloXML: XML for evolutionary biology and comparative genomics\", BMC Bioinformatics 10:356";
    static final String APTX_REF_TOOL_TIP = "Zmasek...";
    private static final long serialVersionUID = 3655000897845508358L;
    static final Font menu_font = new Font(Configuration.getDefaultFontFamilyName(), 0, 10);
    static final String TYPE_MENU_HEADER = "Type";
    static final String RECTANGULAR_TYPE_CBMI_LABEL = "Rectangular";
    static final String EURO_TYPE_CBMI_LABEL = "Euro Type";
    static final String CURVED_TYPE_CBMI_LABEL = "Curved";
    static final String TRIANGULAR_TYPE_CBMI_LABEL = "Triangular";
    static final String CONVEX_TYPE_CBMI_LABEL = "Convex";
    static final String ROUNDED_TYPE_CBMI_LABEL = "Rounded";
    static final String UNROOTED_TYPE_CBMI_LABEL = "Unrooted (alpha)";
    static final String CIRCULAR_TYPE_CBMI_LABEL = "Circular (alpha)";
    static final String OPTIONS_HEADER = "Options";
    static final String SEARCH_SUBHEADER = "Search:";
    static final String DISPLAY_SUBHEADER = "Display:";
    static final String SEARCH_TERMS_ONLY_LABEL = "Match Complete Terms Only";
    static final String SEARCH_CASE_SENSITIVE_LABEL = "Case Sensitive";
    static final String INVERSE_SEARCH_RESULT_LABEL = "Negate Result";
    static final String DISPLAY_BRANCH_LENGTH_VALUES_LABEL = "Display Branch Length Values";
    static final String DISPLAY_SCALE_LABEL = "Display Scale";
    static final String NON_LINED_UP_CLADOGRAMS_LABEL = "Non-Lined Up Cladograms";
    static final String UNIFORM_CLADOGRAMS_LABEL = "Total Node Sum Dependent Cladograms";
    static final String LABEL_DIRECTION_LABEL = "Radial Labels";
    static final String LABEL_DIRECTION_TIP = "To use radial node labels in radial and unrooted display types";
    static final String SCREEN_ANTIALIAS_LABEL = "Antialias";
    static final String COLOR_LABELS_LABEL = "Colorize Labels Same as Parent Branch";
    static final String BG_GRAD_LABEL = "Background Color Gradient";
    static final String DISPLAY_NODE_BOXES_LABEL = "Display Node Shapes";
    static final String SHOW_OVERVIEW_LABEL = "Show Overview";
    static final String FONT_SIZE_MENU_LABEL = "Font Size";
    static final String NONUNIFORM_CLADOGRAMS_LABEL = "External Node Sum Dependent Cladograms";
    static final String SHOW_DOMAIN_LABELS_LABEL = "Show Domain Labels";
    static final String COLOR_LABELS_TIP = "To use parent branch colors for node labels as well, need to turn off taxonomy dependent colorization and turn on branch colorization for this to become apparent";
    static final String ABBREV_SN_LABEL = "Abbreviate Scientific Taxonomic Names";
    static final String TAXONOMY_COLORIZE_NODE_SHAPES_LABEL = "Colorize Node Shapes According to Taxonomy";
    static final String CYCLE_NODE_SHAPE_LABEL = "Cycle Node Shapes";
    static final String CYCLE_NODE_FILL_LABEL = "Cycle Node Fill Type";
    static final String CHOOSE_NODE_SIZE_LABEL = "Choose Node Shape Size";
    JMenuBar _jmenubar;
    JMenu _file_jmenu;
    JMenu _tools_menu;
    JMenu _view_jmenu;
    JMenu _options_jmenu;
    JMenu _font_size_menu;
    JMenu _help_jmenu;
    JMenuItem[] _load_phylogeny_from_webservice_menu_items;
    JMenuItem _open_item;
    JMenuItem _open_url_item;
    JMenuItem _save_item;
    JMenuItem _save_all_item;
    JMenuItem _close_item;
    JMenuItem _exit_item;
    JMenuItem _new_item;
    JMenuItem _midpoint_root_item;
    JMenuItem _taxcolor_item;
    JMenuItem _confcolor_item;
    JMenuItem _color_rank_jmi;
    JMenuItem _infer_common_sn_names_item;
    JMenuItem _collapse_species_specific_subtrees;
    JMenuItem _collapse_below_threshold;
    JMenuItem _obtain_detailed_taxonomic_information_jmi;
    JMenuItem _obtain_detailed_taxonomic_information_deleting_jmi;
    JMenuItem _obtain_uniprot_seq_information_jmi;
    JMenuItem _move_node_names_to_tax_sn_jmi;
    JMenuItem _move_node_names_to_seq_names_jmi;
    JMenuItem _extract_tax_code_from_node_names_jmi;
    JMenuItem _super_tiny_fonts_item;
    JMenuItem _tiny_fonts_item;
    JMenuItem _small_fonts_item;
    JMenuItem _medium_fonts_item;
    JMenuItem _large_fonts_item;
    JMenuItem _choose_font_mi;
    JMenuItem _switch_colors_mi;
    JCheckBoxMenuItem _label_direction_cbmi;
    JCheckBoxMenuItem _screen_antialias_cbmi;
    JCheckBoxMenuItem _background_gradient_cbmi;
    JRadioButtonMenuItem _non_lined_up_cladograms_rbmi;
    JRadioButtonMenuItem _uniform_cladograms_rbmi;
    JRadioButtonMenuItem _ext_node_dependent_cladogram_rbmi;
    JCheckBoxMenuItem _show_branch_length_values_cbmi;
    JCheckBoxMenuItem _show_scale_cbmi;
    JCheckBoxMenuItem _show_overview_cbmi;
    JCheckBoxMenuItem _show_domain_labels;
    JCheckBoxMenuItem _abbreviate_scientific_names;
    JCheckBoxMenuItem _color_labels_same_as_parent_branch;
    JMenuItem _overview_placment_mi;
    JMenuItem _choose_minimal_confidence_mi;
    JCheckBoxMenuItem _show_default_node_shapes_cbmi;
    JMenuItem _cycle_node_shape_mi;
    JMenuItem _cycle_node_fill_mi;
    JMenuItem _choose_node_size_mi;
    JCheckBoxMenuItem _taxonomy_colorize_node_shapes_cbmi;
    JCheckBoxMenuItem _graphics_export_visible_only_cbmi;
    JCheckBoxMenuItem _antialias_print_cbmi;
    JCheckBoxMenuItem _print_black_and_white_cbmi;
    JCheckBoxMenuItem _print_using_actual_size_cbmi;
    JCheckBoxMenuItem _graphics_export_using_actual_size_cbmi;
    JMenuItem _print_size_mi;
    JMenuItem _choose_pdf_width_mi;
    JCheckBoxMenuItem _internal_number_are_confidence_for_nh_parsing_cbmi;
    JCheckBoxMenuItem _extract_pfam_style_tax_codes_cbmi;
    JCheckBoxMenuItem _replace_underscores_cbmi;
    JCheckBoxMenuItem _search_case_senstive_cbmi;
    JCheckBoxMenuItem _search_whole_words_only_cbmi;
    JCheckBoxMenuItem _inverse_search_result_cbmi;
    JMenu _type_menu;
    JCheckBoxMenuItem _rectangular_type_cbmi;
    JCheckBoxMenuItem _triangular_type_cbmi;
    JCheckBoxMenuItem _curved_type_cbmi;
    JCheckBoxMenuItem _convex_type_cbmi;
    JCheckBoxMenuItem _euro_type_cbmi;
    JCheckBoxMenuItem _rounded_type_cbmi;
    JCheckBoxMenuItem _unrooted_type_cbmi;
    JCheckBoxMenuItem _circular_type_cbmi;
    JMenuItem _view_as_NH_item;
    JMenuItem _view_as_NHX_item;
    JMenuItem _view_as_XML_item;
    JMenuItem _view_as_nexus_item;
    JMenuItem _display_basic_information_item;
    JMenuItem _about_item;
    JMenuItem _help_item;
    JMenuItem _website_item;
    JMenuItem _phyloxml_website_item;
    JMenuItem _phyloxml_ref_item;
    JMenuItem _aptx_ref_item;
    MainPanel _mainpanel;
    Container _contentpane;
    TextFrame _textframe;
    Configuration _configuration;
    JMenuItem _remove_branch_color_item;
    Options _options;

    MainFrame() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        boolean bl = false;
        JApplet jApplet = null;
        if (this.getCurrentTreePanel() != null && (bl = this.getCurrentTreePanel().isApplet())) {
            jApplet = this.getCurrentTreePanel().obtainApplet();
        }
        if (object == this._open_url_item) {
            this.readPhylogeniesFromURL();
        } else if (object == this._exit_item) {
            this.close();
        } else if (object == this._taxcolor_item) {
            this.taxColor();
        } else if (object == this._confcolor_item) {
            this.confColor();
        } else if (object == this._color_rank_jmi) {
            this.colorRank();
        } else if (object == this._infer_common_sn_names_item) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().inferCommonPartOfScientificNames();
            }
        } else if (object == this._collapse_species_specific_subtrees) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().collapseSpeciesSpecificSubtrees();
            }
        } else if (object == this._remove_branch_color_item) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            this.removeBranchColors();
        } else if (object == this._midpoint_root_item) {
            if (this.isSubtreeDisplayed()) {
                return;
            }
            this.midpointRoot();
        } else if (object == this._switch_colors_mi) {
            this.switchColors();
        } else if (object == this._display_basic_information_item) {
            this.displayBasicInformation();
        } else if (object == this._view_as_NH_item) {
            this.viewAsNH();
        } else if (object == this._view_as_NHX_item) {
            this.viewAsNHX();
        } else if (object == this._view_as_XML_item) {
            this.viewAsXML();
        } else if (object == this._view_as_nexus_item) {
            this.viewAsNexus();
        } else if (object == this._super_tiny_fonts_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setSuperTinyFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (object == this._tiny_fonts_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setTinyFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (object == this._small_fonts_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setSmallFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (object == this._medium_fonts_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setMediumFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (object == this._large_fonts_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setLargeFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (object == this._choose_font_mi) {
            this.chooseFont();
        } else if (object == this._choose_minimal_confidence_mi) {
            this.chooseMinimalConfidence();
        } else if (object == this._choose_node_size_mi) {
            MainFrame.chooseNodeSize(this.getOptions(), this);
        } else if (object == this._overview_placment_mi) {
            MainFrame.cycleOverview(this.getOptions(), this.getCurrentTreePanel());
        } else if (object == this._cycle_node_fill_mi) {
            MainFrame.cycleNodeFill(this.getOptions(), this.getCurrentTreePanel());
        } else if (object == this._cycle_node_shape_mi) {
            MainFrame.cycleNodeShape(this.getOptions(), this.getCurrentTreePanel());
        } else if (object == this._screen_antialias_cbmi) {
            this.updateOptions(this.getOptions());
            MainFrame.updateScreenTextAntialias(this.getMainPanel().getTreePanels());
        } else if (object == this._background_gradient_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._show_domain_labels) {
            this.updateOptions(this.getOptions());
        } else if (object == this._abbreviate_scientific_names) {
            this.updateOptions(this.getOptions());
        } else if (object == this._color_labels_same_as_parent_branch) {
            this.updateOptions(this.getOptions());
        } else if (object == this._show_default_node_shapes_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._taxonomy_colorize_node_shapes_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._non_lined_up_cladograms_rbmi) {
            this.updateOptions(this.getOptions());
            this.showWhole();
        } else if (object == this._uniform_cladograms_rbmi) {
            this.updateOptions(this.getOptions());
            this.showWhole();
        } else if (object == this._ext_node_dependent_cladogram_rbmi) {
            this.updateOptions(this.getOptions());
            this.showWhole();
        } else if (object == this._search_case_senstive_cbmi) {
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search();
        } else if (object == this._search_whole_words_only_cbmi) {
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search();
        } else if (object == this._inverse_search_result_cbmi) {
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search();
        } else if (object == this._show_scale_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._show_branch_length_values_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._label_direction_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (object == this._show_overview_cbmi) {
            this.updateOptions(this.getOptions());
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().updateOvSizes();
            }
        } else if (object == this._rectangular_type_cbmi || object == this._triangular_type_cbmi || object == this._curved_type_cbmi || object == this._convex_type_cbmi || object == this._euro_type_cbmi || object == this._rounded_type_cbmi || object == this._unrooted_type_cbmi || object == this._circular_type_cbmi) {
            this.typeChanged(object);
        } else if (object == this._about_item) {
            MainFrame.about();
        } else if (object == this._help_item) {
            MainFrame.help(this.getConfiguration().getWebLinks());
        } else if (object == this._website_item) {
            try {
                Util.openWebsite("http://www.phylosoft.org/archaeopteryx/", bl, jApplet);
            }
            catch (IOException iOException) {
                ForesterUtil.printErrorMessage("Archaeopteryx", iOException.toString());
            }
        } else if (object == this._phyloxml_website_item) {
            try {
                Util.openWebsite("http://www.phyloxml.org", bl, jApplet);
            }
            catch (IOException iOException) {
                ForesterUtil.printErrorMessage("Archaeopteryx", iOException.toString());
            }
        } else if (object == this._aptx_ref_item) {
            try {
                Util.openWebsite("http://www.biomedcentral.com/bmcbioinformatics/", bl, jApplet);
            }
            catch (IOException iOException) {
                ForesterUtil.printErrorMessage("Archaeopteryx", iOException.toString());
            }
        } else if (object == this._phyloxml_ref_item) {
            try {
                Util.openWebsite("http://www.biomedcentral.com/1471-2105/10/356/", bl, jApplet);
            }
            catch (IOException iOException) {
                ForesterUtil.printErrorMessage("Archaeopteryx", iOException.toString());
            }
        } else if (this._load_phylogeny_from_webservice_menu_items != null) {
            for (int i = 0; i < this._load_phylogeny_from_webservice_menu_items.length; ++i) {
                if (object != this._load_phylogeny_from_webservice_menu_items[i]) continue;
                this.readPhylogeniesFromWebservice(i);
            }
        }
        this._contentpane.repaint();
    }

    boolean isSubtreeDisplayed() {
        if (this.getCurrentTreePanel() != null && this.getCurrentTreePanel().isCurrentTreeIsSubtree()) {
            JOptionPane.showMessageDialog(this, "This operation can only be performed on a complete tree, not on the currently displayed sub-tree only.", "Operation can not be exectuted on a sub-tree", 2);
            return true;
        }
        return false;
    }

    void activateSaveAllIfNeeded() {
        if (this.getMainPanel().getTabbedPane() != null && this.getMainPanel().getTabbedPane().getTabCount() > 1) {
            this._save_all_item.setEnabled(true);
        } else {
            this._save_all_item.setEnabled(false);
        }
    }

    void buildFileMenu() {
        this._file_jmenu = MainFrame.createMenu("File", this.getConfiguration());
        this._open_url_item = new JMenuItem("Read tree from URL/webservice...");
        this._file_jmenu.add(this._open_url_item);
        this._file_jmenu.addSeparator();
        this._exit_item = new JMenuItem("Exit");
        this._file_jmenu.add(this._exit_item);
        this.customizeJMenuItem(this._open_url_item);
        this.customizeJMenuItem(this._exit_item);
        this._jmenubar.add(this._file_jmenu);
    }

    void buildFontSizeMenu() {
        this._font_size_menu = MainFrame.createMenu(FONT_SIZE_MENU_LABEL, this.getConfiguration());
        this._super_tiny_fonts_item = new JMenuItem("Super Tiny Fonts");
        this._font_size_menu.add(this._super_tiny_fonts_item);
        this._tiny_fonts_item = new JMenuItem("Tiny Fonts");
        this._font_size_menu.add(this._tiny_fonts_item);
        this._small_fonts_item = new JMenuItem("Small Fonts");
        this._font_size_menu.add(this._small_fonts_item);
        this._medium_fonts_item = new JMenuItem("Medium Fonts");
        this._font_size_menu.add(this._medium_fonts_item);
        this._large_fonts_item = new JMenuItem("Large Fonts");
        this._font_size_menu.add(this._large_fonts_item);
        this.customizeJMenuItem(this._super_tiny_fonts_item);
        this.customizeJMenuItem(this._tiny_fonts_item);
        this.customizeJMenuItem(this._small_fonts_item);
        this.customizeJMenuItem(this._medium_fonts_item);
        this.customizeJMenuItem(this._large_fonts_item);
        this._jmenubar.add(this._font_size_menu);
    }

    void buildHelpMenu() {
        this._help_jmenu = MainFrame.createMenu("Help", this.getConfiguration());
        this._help_item = new JMenuItem("Help");
        this._help_jmenu.add(this._help_item);
        this._website_item = new JMenuItem("Archaeopteryx Home");
        this._help_jmenu.add(this._website_item);
        this._aptx_ref_item = new JMenuItem("Archaeopteryx Reference");
        this._phyloxml_website_item = new JMenuItem("phyloXML Home");
        this._help_jmenu.add(this._phyloxml_website_item);
        this._phyloxml_ref_item = new JMenuItem("phyloXML Reference");
        this._help_jmenu.add(this._phyloxml_ref_item);
        this._help_jmenu.addSeparator();
        this._about_item = new JMenuItem("About");
        this._help_jmenu.add(this._about_item);
        this.customizeJMenuItem(this._help_item);
        this.customizeJMenuItem(this._website_item);
        this.customizeJMenuItem(this._phyloxml_website_item);
        this.customizeJMenuItem(this._aptx_ref_item);
        this.customizeJMenuItem(this._phyloxml_ref_item);
        this.customizeJMenuItem(this._about_item);
        this._phyloxml_ref_item.setToolTipText(PHYLOXML_REF_TOOL_TIP);
        this._aptx_ref_item.setToolTipText(APTX_REF_TOOL_TIP);
        this._jmenubar.add(this._help_jmenu);
    }

    void buildTypeMenu() {
        this._type_menu = MainFrame.createMenu(TYPE_MENU_HEADER, this.getConfiguration());
        this._rectangular_type_cbmi = new JCheckBoxMenuItem(RECTANGULAR_TYPE_CBMI_LABEL);
        this._type_menu.add(this._rectangular_type_cbmi);
        this._euro_type_cbmi = new JCheckBoxMenuItem(EURO_TYPE_CBMI_LABEL);
        this._type_menu.add(this._euro_type_cbmi);
        this._rounded_type_cbmi = new JCheckBoxMenuItem(ROUNDED_TYPE_CBMI_LABEL);
        this._type_menu.add(this._rounded_type_cbmi);
        this._curved_type_cbmi = new JCheckBoxMenuItem(CURVED_TYPE_CBMI_LABEL);
        this._type_menu.add(this._curved_type_cbmi);
        this._triangular_type_cbmi = new JCheckBoxMenuItem(TRIANGULAR_TYPE_CBMI_LABEL);
        this._type_menu.add(this._triangular_type_cbmi);
        this._convex_type_cbmi = new JCheckBoxMenuItem(CONVEX_TYPE_CBMI_LABEL);
        this._type_menu.add(this._convex_type_cbmi);
        this._unrooted_type_cbmi = new JCheckBoxMenuItem(UNROOTED_TYPE_CBMI_LABEL);
        this._type_menu.add(this._unrooted_type_cbmi);
        this._circular_type_cbmi = new JCheckBoxMenuItem(CIRCULAR_TYPE_CBMI_LABEL);
        this._type_menu.add(this._circular_type_cbmi);
        this.customizeCheckBoxMenuItem(this._rectangular_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._triangular_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._euro_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._rounded_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._curved_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._convex_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._unrooted_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._circular_type_cbmi, false);
        this._unrooted_type_cbmi.setToolTipText(USE_MOUSEWHEEL_SHIFT_TO_ROTATE);
        this._circular_type_cbmi.setToolTipText(USE_MOUSEWHEEL_SHIFT_TO_ROTATE);
        this.initializeTypeMenu(this.getOptions());
        this._jmenubar.add(this._type_menu);
    }

    void buildViewMenu() {
        this._view_jmenu = MainFrame.createMenu("View", this.getConfiguration());
        this._display_basic_information_item = new JMenuItem("Display Basic Information");
        this._view_jmenu.add(this._display_basic_information_item);
        this._view_jmenu.addSeparator();
        this._view_as_XML_item = new JMenuItem("View as phyloXML");
        this._view_jmenu.add(this._view_as_XML_item);
        this._view_as_NH_item = new JMenuItem("View as Newick");
        this._view_jmenu.add(this._view_as_NH_item);
        this._view_as_NHX_item = new JMenuItem("View as NHX");
        this._view_jmenu.add(this._view_as_NHX_item);
        this._view_as_nexus_item = new JMenuItem("View as Nexus");
        this._view_jmenu.add(this._view_as_nexus_item);
        this.customizeJMenuItem(this._display_basic_information_item);
        this.customizeJMenuItem(this._view_as_NH_item);
        this.customizeJMenuItem(this._view_as_NHX_item);
        this.customizeJMenuItem(this._view_as_XML_item);
        this.customizeJMenuItem(this._view_as_nexus_item);
        this._jmenubar.add(this._view_jmenu);
    }

    private void chooseFont() {
        FontChooser fontChooser = new FontChooser();
        fontChooser.setFont(this.getMainPanel().getTreeFontSet().getLargeFont());
        fontChooser.showDialog(this, "Select the Base Font");
        this.getMainPanel().getTreeFontSet().setBaseFont(fontChooser.getFont());
    }

    private void chooseMinimalConfidence() {
        String string = (String)JOptionPane.showInputDialog(this, "Please enter the minimum for confidence values to be displayed.\n[current value: " + this.getOptions().getMinConfidenceValue() + "]\n", "Minimal Confidence Value", 3, null, null, this.getOptions().getMinConfidenceValue());
        if (!ForesterUtil.isEmpty(string)) {
            boolean bl = true;
            double d = 0.0;
            String string2 = string.trim();
            if (!ForesterUtil.isEmpty(string2)) {
                try {
                    d = Double.parseDouble(string2);
                }
                catch (Exception exception) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl && d >= 0.0) {
                this.getOptions().setMinConfidenceValue(d);
            }
        }
    }

    static void chooseNodeSize(Options options, Component component) {
        String string = (String)JOptionPane.showInputDialog(component, "Please enter the default size for node shapes.\n[current value: " + options.getDefaultNodeShapeSize() + "]\n", "Node Shape Size", 3, null, null, options.getDefaultNodeShapeSize());
        if (!ForesterUtil.isEmpty(string)) {
            short s;
            boolean bl = true;
            double d = 0.0;
            String string2 = string.trim();
            if (!ForesterUtil.isEmpty(string2)) {
                try {
                    d = Double.parseDouble(string2);
                }
                catch (Exception exception) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl && d >= 0.0 && (double)(s = ForesterUtil.roundToShort(d)) >= 0.0) {
                options.setDefaultNodeShapeSize(s);
            }
        }
    }

    void close() {
        this.removeTextFrame();
        if (this._mainpanel != null) {
            this._mainpanel.terminate();
        }
        if (this._contentpane != null) {
            this._contentpane.removeAll();
        }
        this.setVisible(false);
        this.dispose();
    }

    void confColor() {
        if (this._mainpanel.getCurrentTreePanel() != null) {
            this._mainpanel.getCurrentTreePanel().confColor();
        }
    }

    void colorRank() {
        Object[] objectArray;
        String string;
        if (this._mainpanel.getCurrentTreePanel() != null && !ForesterUtil.isEmpty(string = (String)JOptionPane.showInputDialog(this, "What rank should the colorization be based on", "Rank Selection", 3, null, objectArray = Util.getAllPossibleRanks(), null))) {
            this._mainpanel.getCurrentTreePanel().colorRank(string);
        }
    }

    void customizeCheckBoxMenuItem(JCheckBoxMenuItem jCheckBoxMenuItem, boolean bl) {
        if (jCheckBoxMenuItem != null) {
            jCheckBoxMenuItem.setFont(menu_font);
            if (!this.getConfiguration().isUseNativeUI()) {
                jCheckBoxMenuItem.setBackground(this.getConfiguration().getGuiMenuBackgroundColor());
                jCheckBoxMenuItem.setForeground(this.getConfiguration().getGuiMenuTextColor());
            }
            jCheckBoxMenuItem.setSelected(bl);
            jCheckBoxMenuItem.addActionListener(this);
        }
    }

    void customizeJMenuItem(JMenuItem jMenuItem) {
        if (jMenuItem != null) {
            jMenuItem.setFont(menu_font);
            if (!this.getConfiguration().isUseNativeUI()) {
                jMenuItem.setBackground(this.getConfiguration().getGuiMenuBackgroundColor());
                jMenuItem.setForeground(this.getConfiguration().getGuiMenuTextColor());
            }
            jMenuItem.addActionListener(this);
        }
    }

    void customizeRadioButtonMenuItem(JRadioButtonMenuItem jRadioButtonMenuItem, boolean bl) {
        if (jRadioButtonMenuItem != null) {
            jRadioButtonMenuItem.setFont(menu_font);
            if (!this.getConfiguration().isUseNativeUI()) {
                jRadioButtonMenuItem.setBackground(this.getConfiguration().getGuiMenuBackgroundColor());
                jRadioButtonMenuItem.setForeground(this.getConfiguration().getGuiMenuTextColor());
            }
            jRadioButtonMenuItem.setSelected(bl);
            jRadioButtonMenuItem.addActionListener(this);
        }
    }

    void exceptionOccuredDuringOpenFile(Exception exception) {
        try {
            this._mainpanel.getCurrentTreePanel().setArrowCursor();
        }
        catch (Exception exception2) {
            // empty catch block
        }
        JOptionPane.showMessageDialog(this, ForesterUtil.wordWrap(exception.getLocalizedMessage(), 80), "Error during File|Open", 0);
    }

    void exceptionOccuredDuringSaveAs(Exception exception) {
        try {
            this._mainpanel.getCurrentTreePanel().setArrowCursor();
        }
        catch (Exception exception2) {
            // empty catch block
        }
        JOptionPane.showMessageDialog(this, "Exception" + exception, "Error during File|SaveAs", 0);
    }

    boolean GAndSDoHaveMoreThanOneSpeciesInComman(Phylogeny phylogeny) {
        if (phylogeny == null || phylogeny.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Gene tree and species tree have no species in common.", "Error during SDI", 0);
            return false;
        }
        if (phylogeny.getNumberOfExternalNodes() < 2) {
            JOptionPane.showMessageDialog(this, "Gene tree and species tree have only one species in common.", "Error during SDI", 0);
            return false;
        }
        return true;
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    TreePanel getCurrentTreePanel() {
        return this.getMainPanel().getCurrentTreePanel();
    }

    JMenu getHelpMenu() {
        return this._help_jmenu;
    }

    JCheckBoxMenuItem getlabelDirectionCbmi() {
        return this._label_direction_cbmi;
    }

    MainPanel getMainPanel() {
        return this._mainpanel;
    }

    JMenuBar getMenuBarOfMainFrame() {
        return this._jmenubar;
    }

    Options getOptions() {
        return this._options;
    }

    void initializeTypeMenu(Options options) {
        this.setTypeMenuToAllUnselected();
        switch (options.getPhylogenyGraphicsType()) {
            case CONVEX: {
                this._convex_type_cbmi.setSelected(true);
                break;
            }
            case CURVED: {
                this._curved_type_cbmi.setSelected(true);
                break;
            }
            case EURO_STYLE: {
                this._euro_type_cbmi.setSelected(true);
                break;
            }
            case ROUNDED: {
                this._rounded_type_cbmi.setSelected(true);
                break;
            }
            case TRIANGULAR: {
                this._triangular_type_cbmi.setSelected(true);
                break;
            }
            case UNROOTED: {
                this._unrooted_type_cbmi.setSelected(true);
                break;
            }
            case CIRCULAR: {
                this._circular_type_cbmi.setSelected(true);
                break;
            }
            default: {
                this._rectangular_type_cbmi.setSelected(true);
            }
        }
    }

    void midpointRoot() {
        if (this._mainpanel.getCurrentTreePanel() != null) {
            this._mainpanel.getCurrentTreePanel().midpointRoot();
        }
    }

    abstract void readPhylogeniesFromURL();

    void readPhylogeniesFromWebservice(int n) {
        UrlTreeReader urlTreeReader = new UrlTreeReader(this, n);
        new Thread(urlTreeReader).start();
    }

    private void removeBranchColors() {
        if (this.getMainPanel().getCurrentPhylogeny() != null) {
            Util.removeBranchColors(this.getMainPanel().getCurrentPhylogeny());
        }
    }

    void removeTextFrame() {
        if (this._textframe != null) {
            this._textframe.close();
            this._textframe = null;
        }
    }

    void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
    }

    void setOptions(Options options) {
        this._options = options;
    }

    void setSelectedTypeInTypeMenu(Options.PHYLOGENY_GRAPHICS_TYPE pHYLOGENY_GRAPHICS_TYPE) {
        this.setTypeMenuToAllUnselected();
        switch (pHYLOGENY_GRAPHICS_TYPE) {
            case CIRCULAR: {
                this._circular_type_cbmi.setSelected(true);
                break;
            }
            case CONVEX: {
                this._convex_type_cbmi.setSelected(true);
                break;
            }
            case CURVED: {
                this._curved_type_cbmi.setSelected(true);
                break;
            }
            case EURO_STYLE: {
                this._euro_type_cbmi.setSelected(true);
                break;
            }
            case ROUNDED: {
                this._rounded_type_cbmi.setSelected(true);
                break;
            }
            case RECTANGULAR: {
                this._rectangular_type_cbmi.setSelected(true);
                break;
            }
            case TRIANGULAR: {
                this._triangular_type_cbmi.setSelected(true);
                break;
            }
            case UNROOTED: {
                this._unrooted_type_cbmi.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type: " + (Object)((Object)pHYLOGENY_GRAPHICS_TYPE));
            }
        }
    }

    void setTypeMenuToAllUnselected() {
        this._convex_type_cbmi.setSelected(false);
        this._curved_type_cbmi.setSelected(false);
        this._euro_type_cbmi.setSelected(false);
        this._rounded_type_cbmi.setSelected(false);
        this._triangular_type_cbmi.setSelected(false);
        this._rectangular_type_cbmi.setSelected(false);
        this._unrooted_type_cbmi.setSelected(false);
        this._circular_type_cbmi.setSelected(false);
    }

    public void showWhole() {
        this._mainpanel.getControlPanel().showWhole();
    }

    void switchColors() {
        TreeColorSet treeColorSet = this._mainpanel.getTreeColorSet();
        ColorSchemeChooser colorSchemeChooser = new ColorSchemeChooser(this.getMainPanel(), treeColorSet);
        colorSchemeChooser.setVisible(true);
    }

    void taxColor() {
        if (this._mainpanel.getCurrentTreePanel() != null) {
            this._mainpanel.getCurrentTreePanel().taxColor();
        }
    }

    void typeChanged(Object object) {
        this.updateTypeCheckboxes(this.getOptions(), object);
        this.updateOptions(this.getOptions());
        if (this.getCurrentTreePanel() != null) {
            Options.PHYLOGENY_GRAPHICS_TYPE pHYLOGENY_GRAPHICS_TYPE = this.getCurrentTreePanel().getPhylogenyGraphicsType();
            Options.PHYLOGENY_GRAPHICS_TYPE pHYLOGENY_GRAPHICS_TYPE2 = this.getOptions().getPhylogenyGraphicsType();
            if (pHYLOGENY_GRAPHICS_TYPE == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && pHYLOGENY_GRAPHICS_TYPE2 != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || pHYLOGENY_GRAPHICS_TYPE == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR && pHYLOGENY_GRAPHICS_TYPE2 != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || pHYLOGENY_GRAPHICS_TYPE != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && pHYLOGENY_GRAPHICS_TYPE2 == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || pHYLOGENY_GRAPHICS_TYPE != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR && pHYLOGENY_GRAPHICS_TYPE2 == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                this.getCurrentTreePanel().getControlPanel().showWhole();
            }
            if (this.getCurrentTreePanel().isPhyHasBranchLengths() && pHYLOGENY_GRAPHICS_TYPE2 != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                this.getCurrentTreePanel().getControlPanel().setDrawPhylogramEnabled(true);
            } else {
                this.getCurrentTreePanel().getControlPanel().setDrawPhylogramEnabled(false);
            }
            this.getCurrentTreePanel().setPhylogenyGraphicsType(this.getOptions().getPhylogenyGraphicsType());
            MainFrame.updateScreenTextAntialias(this.getMainPanel().getTreePanels());
            if (this.getCurrentTreePanel().getControlPanel().getDynamicallyHideData() != null) {
                if (pHYLOGENY_GRAPHICS_TYPE2 == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
                    this.getCurrentTreePanel().getControlPanel().getDynamicallyHideData().setEnabled(false);
                } else {
                    this.getCurrentTreePanel().getControlPanel().getDynamicallyHideData().setEnabled(true);
                }
            }
        }
    }

    void updateOptions(Options options) {
        options.setAntialiasScreen(this._screen_antialias_cbmi != null && this._screen_antialias_cbmi.isSelected());
        options.setBackgroundColorGradient(this._background_gradient_cbmi != null && this._background_gradient_cbmi.isSelected());
        options.setShowDomainLabels(this._show_domain_labels != null && this._show_domain_labels.isSelected());
        options.setAbbreviateScientificTaxonNames(this._abbreviate_scientific_names != null && this._abbreviate_scientific_names.isSelected());
        options.setColorLabelsSameAsParentBranch(this._color_labels_same_as_parent_branch != null && this._color_labels_same_as_parent_branch.isSelected());
        options.setShowDefaultNodeShapes(this._show_default_node_shapes_cbmi != null && this._show_default_node_shapes_cbmi.isSelected());
        options.setTaxonomyColorizeNodeShapes(this._taxonomy_colorize_node_shapes_cbmi != null && this._taxonomy_colorize_node_shapes_cbmi.isSelected());
        if (this._non_lined_up_cladograms_rbmi != null && this._non_lined_up_cladograms_rbmi.isSelected()) {
            options.setCladogramType(Options.CLADOGRAM_TYPE.NON_LINED_UP);
        } else if (this._uniform_cladograms_rbmi != null && this._uniform_cladograms_rbmi.isSelected()) {
            options.setCladogramType(Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP);
        } else if (this._ext_node_dependent_cladogram_rbmi != null && this._ext_node_dependent_cladogram_rbmi.isSelected()) {
            options.setCladogramType(Options.CLADOGRAM_TYPE.EXT_NODE_SUM_DEP);
        }
        options.setSearchCaseSensitive(this._search_case_senstive_cbmi != null && this._search_case_senstive_cbmi.isSelected());
        if (this._show_scale_cbmi != null && this._show_scale_cbmi.isEnabled()) {
            options.setShowScale(this._show_scale_cbmi.isSelected());
        }
        if (this._label_direction_cbmi != null) {
            if (this._label_direction_cbmi.isSelected()) {
                options.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.RADIAL);
            } else {
                options.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.HORIZONTAL);
            }
        }
        options.setShowOverview(this._show_overview_cbmi != null && this._show_overview_cbmi.isSelected());
        if (this._show_branch_length_values_cbmi != null && this._show_branch_length_values_cbmi.isEnabled()) {
            options.setShowBranchLengthValues(this._show_branch_length_values_cbmi.isSelected());
        }
        options.setPrintUsingActualSize(this._print_using_actual_size_cbmi != null && this._print_using_actual_size_cbmi.isSelected());
        options.setGraphicsExportUsingActualSize(this._graphics_export_using_actual_size_cbmi != null && this._graphics_export_using_actual_size_cbmi.isSelected());
        options.setAntialiasPrint(this._antialias_print_cbmi != null && this._antialias_print_cbmi.isSelected());
        options.setPrintBlackAndWhite(this._print_black_and_white_cbmi != null && this._print_black_and_white_cbmi.isSelected());
        options.setInternalNumberAreConfidenceForNhParsing(this._internal_number_are_confidence_for_nh_parsing_cbmi != null && this._internal_number_are_confidence_for_nh_parsing_cbmi.isSelected());
        options.setExtractPfamTaxonomyCodesInNhParsing(this._extract_pfam_style_tax_codes_cbmi != null && this._extract_pfam_style_tax_codes_cbmi.isSelected());
        options.setReplaceUnderscoresInNhParsing(this._replace_underscores_cbmi != null && this._replace_underscores_cbmi.isSelected());
        options.setMatchWholeTermsOnly(this._search_whole_words_only_cbmi != null && this._search_whole_words_only_cbmi.isSelected());
        options.setInverseSearchResult(this._inverse_search_result_cbmi != null && this._inverse_search_result_cbmi.isSelected());
        if (this._graphics_export_visible_only_cbmi != null) {
            options.setGraphicsExportVisibleOnly(this._graphics_export_visible_only_cbmi.isSelected());
            if (this._graphics_export_visible_only_cbmi.isSelected() && this._graphics_export_using_actual_size_cbmi != null) {
                this._graphics_export_using_actual_size_cbmi.setSelected(true);
                this._graphics_export_using_actual_size_cbmi.setEnabled(false);
            } else {
                this._graphics_export_using_actual_size_cbmi.setEnabled(true);
            }
        }
        if (this._rectangular_type_cbmi != null && this._rectangular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        } else if (this._triangular_type_cbmi != null && this._triangular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR);
        } else if (this._curved_type_cbmi != null && this._curved_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED);
        } else if (this._convex_type_cbmi != null && this._convex_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX);
        } else if (this._euro_type_cbmi != null && this._euro_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE);
        } else if (this._rounded_type_cbmi != null && this._rounded_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED);
        } else if (this._unrooted_type_cbmi != null && this._unrooted_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED);
        } else if (this._circular_type_cbmi != null && this._circular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR);
        }
    }

    void updateTypeCheckboxes(Options options, Object object) {
        this.setTypeMenuToAllUnselected();
        ((JCheckBoxMenuItem)object).setSelected(true);
    }

    void displayBasicInformation() {
        if (this._mainpanel.getCurrentPhylogeny() == null || this._mainpanel.getCurrentPhylogeny().isEmpty()) {
            return;
        }
        this._textframe = TextFrame.instantiate(Util.crateBasicInformation(this._mainpanel.getCurrentPhylogeny()));
    }

    void viewAsNexus() {
        this.removeTextFrame();
        if (this._mainpanel.getCurrentPhylogeny() == null || this._mainpanel.getCurrentPhylogeny().isEmpty() || this._mainpanel.getCurrentPhylogeny().getNumberOfExternalNodes() > 10000) {
            return;
        }
        this._textframe = TextFrame.instantiate(this._mainpanel.getCurrentPhylogeny().toNexus());
    }

    void viewAsNH() {
        this.removeTextFrame();
        if (this._mainpanel.getCurrentPhylogeny() == null || this._mainpanel.getCurrentPhylogeny().isEmpty() || this._mainpanel.getCurrentPhylogeny().getNumberOfExternalNodes() > 10000) {
            return;
        }
        this._textframe = TextFrame.instantiate(this._mainpanel.getCurrentPhylogeny().toNewHampshire(false));
    }

    void viewAsNHX() {
        this.removeTextFrame();
        if (this._mainpanel.getCurrentPhylogeny() == null || this._mainpanel.getCurrentPhylogeny().isEmpty() || this._mainpanel.getCurrentPhylogeny().getNumberOfExternalNodes() > 10000) {
            return;
        }
        this._textframe = TextFrame.instantiate(this._mainpanel.getCurrentPhylogeny().toNewHampshireX());
    }

    void viewAsXML() {
        this.removeTextFrame();
        if (this._mainpanel.getCurrentPhylogeny() != null && !this._mainpanel.getCurrentPhylogeny().isEmpty() && this._mainpanel.getCurrentPhylogeny().getNumberOfExternalNodes() <= 10000) {
            this._textframe = TextFrame.instantiate(this._mainpanel.getCurrentPhylogeny().toPhyloXML(0));
        }
    }

    static void about() {
        StringBuffer stringBuffer = new StringBuffer("Archaeopteryx\nVersion 0.962 beta 2N\n");
        stringBuffer.append("Copyright (C) 2007-2011 Christian Zmasek\n");
        stringBuffer.append("All Rights Reserved\n");
        stringBuffer.append("License: GNU Lesser General Public License (LGPL)\n");
        stringBuffer.append("Last modified: 2011.09.17\n");
        stringBuffer.append("phyloXML version : 1.10\n");
        stringBuffer.append("phyloXML location: http://www.phyloxml.org\n");
        if (!ForesterUtil.isEmpty(ForesterUtil.JAVA_VERSION) && !ForesterUtil.isEmpty(ForesterUtil.JAVA_VENDOR)) {
            stringBuffer.append("[your Java version: " + ForesterUtil.JAVA_VERSION + " " + ForesterUtil.JAVA_VENDOR + "]\n");
        }
        if (!(ForesterUtil.isEmpty(ForesterUtil.OS_NAME) || ForesterUtil.isEmpty(ForesterUtil.OS_ARCH) || ForesterUtil.isEmpty(ForesterUtil.OS_VERSION))) {
            stringBuffer.append("[your OS: " + ForesterUtil.OS_NAME + " " + ForesterUtil.OS_ARCH + " " + ForesterUtil.OS_VERSION + "]\n");
        }
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory() / 1000000L;
        long l2 = runtime.totalMemory() / 1000000L;
        stringBuffer.append("[free memory: " + l + "MB, total memory: " + l2 + "MB]\n");
        stringBuffer.append("[locale: " + Locale.getDefault() + "]\n");
        stringBuffer.append("References:\n");
        stringBuffer.append("Han MV and Zmasek CM (2009), BMC Bioinformatics, 10:356\n");
        stringBuffer.append("For more information & download:\n");
        stringBuffer.append("http://www.phylosoft.org/archaeopteryx/\n");
        stringBuffer.append("Comments: phylosoft@gmail.com");
        JOptionPane.showMessageDialog(null, stringBuffer, "Archaeopteryx", -1);
    }

    static String createCurrentFontDesc(TreeFontSet treeFontSet) {
        return treeFontSet.getLargeFont().getFamily() + " " + treeFontSet.getLargeFont().getSize();
    }

    static JMenu createMenu(String string, Configuration configuration) {
        JMenu jMenu = new JMenu(string);
        if (!configuration.isUseNativeUI()) {
            jMenu.setFont(menu_font);
            jMenu.setBackground(configuration.getGuiMenuBackgroundColor());
            jMenu.setForeground(configuration.getGuiMenuTextColor());
        }
        return jMenu;
    }

    static JMenuItem customizeMenuItemAsLabel(JMenuItem jMenuItem, Configuration configuration) {
        jMenuItem.setFont(menu_font.deriveFont(1));
        if (!configuration.isUseNativeUI()) {
            jMenuItem.setBackground(configuration.getGuiMenuBackgroundColor());
            jMenuItem.setForeground(configuration.getGuiMenuTextColor());
            jMenuItem.setOpaque(true);
        }
        jMenuItem.setSelected(false);
        jMenuItem.setEnabled(false);
        return jMenuItem;
    }

    static void cycleOverview(Options options, TreePanel treePanel) {
        switch (options.getOvPlacement()) {
            case LOWER_LEFT: {
                options.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT);
                break;
            }
            case LOWER_RIGHT: {
                options.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_LEFT);
                break;
            }
            case UPPER_LEFT: {
                options.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.UPPER_RIGHT);
                break;
            }
            case UPPER_RIGHT: {
                options.setOvPlacement(Options.OVERVIEW_PLACEMENT_TYPE.LOWER_RIGHT);
                break;
            }
            default: {
                throw new RuntimeException("unknown placement: " + (Object)((Object)options.getOvPlacement()));
            }
        }
        if (treePanel != null) {
            treePanel.updateOvSettings();
        }
    }

    static void cycleNodeFill(Options options, TreePanel treePanel) {
        switch (options.getDefaultNodeFill()) {
            case GRADIENT: {
                options.setDefaultNodeFill(NodeVisualization.NodeFill.SOLID);
                break;
            }
            case NONE: {
                options.setDefaultNodeFill(NodeVisualization.NodeFill.GRADIENT);
                break;
            }
            case SOLID: {
                options.setDefaultNodeFill(NodeVisualization.NodeFill.NONE);
                break;
            }
            default: {
                throw new RuntimeException("unknown fill: " + (Object)((Object)options.getDefaultNodeFill()));
            }
        }
    }

    static void cycleNodeShape(Options options, TreePanel treePanel) {
        switch (options.getDefaultNodeShape()) {
            case CIRCLE: {
                options.setDefaultNodeShape(NodeVisualization.NodeShape.RECTANGLE);
                break;
            }
            case RECTANGLE: {
                options.setDefaultNodeShape(NodeVisualization.NodeShape.CIRCLE);
                break;
            }
            default: {
                throw new RuntimeException("unknown shape: " + (Object)((Object)options.getDefaultNodeShape()));
            }
        }
    }

    static void help(Map<String, WebLink> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Display options\n");
        stringBuilder.append("-------------------\n");
        stringBuilder.append("Use the checkboxes to select types of information to display on the tree.\n\n");
        stringBuilder.append("Clickable tree nodes\n");
        stringBuilder.append("--------------------\n");
        stringBuilder.append("Tree nodes can be clicked, the action is determined by the 'click on node to' menu\n");
        stringBuilder.append("or by right clicking:\n");
        stringBuilder.append("o  Display Node Data -- display information for a node\n");
        stringBuilder.append("o  Collapse/Uncollapse -- collapse and uncollapse subtree from clicked node\n");
        stringBuilder.append("o  Root/Reroot -- change tree root to clicked node\n");
        stringBuilder.append("o  Sub/Super Tree -- toggle between subtree from clicked node and whole tree\n");
        stringBuilder.append("o  Swap Descendants -- switch descendant on either side of clicked node\n");
        stringBuilder.append("o  Colorize Subtree -- color a subtree\n");
        stringBuilder.append("o  Open Sequence Web -- launch a web browser to display sequence information\n");
        stringBuilder.append("o  Open Taxonomy Web -- launch a web browser to display taxonomy information\n");
        stringBuilder.append("-  there may be additional choices depending on this particular setup\n\n");
        stringBuilder.append("Right clicking on a node always displays the information of a node.\n\n");
        stringBuilder.append("Zooming\n");
        stringBuilder.append("---------\n");
        stringBuilder.append("The mouse wheel and the plus and minus keys control zooming.\n");
        stringBuilder.append("Mouse wheel+Ctrl changes the text size.\n");
        stringBuilder.append("Mouse wheel+Shift controls zooming in vertical direction only.\n");
        stringBuilder.append("Use the buttons on the control panel to zoom the tree in and out, horizontally or vertically.\n");
        stringBuilder.append("The entire tree can be fitted into the window by clicking the \"F\" button, or by pressing F, Delete, or Home.\n");
        stringBuilder.append("The up, down, left, and right keys can be used to move the visible part (if zoomed in).\n");
        stringBuilder.append("Up, down, left, and right+Shift can be used to control zooming horizontally and vertically.\n");
        stringBuilder.append("Plus and minus keys+Ctrl change the text size; F+Ctrl, Delete+Ctrl, or Home+Ctrl resets it.\n\n");
        stringBuilder.append("Quick tree manipulation:\n");
        stringBuilder.append("------------------------\n");
        stringBuilder.append("Order Subtrees -- order the tree by branch length\n");
        stringBuilder.append("Uncollapse All -- uncollapse any and all collapsed branches\n\n");
        stringBuilder.append("Memory problems (Java heap space error)\n");
        stringBuilder.append("---------------------------------------\n");
        stringBuilder.append("Since the Java default memory allocation is quite small, it might by necessary (for trees\n");
        stringBuilder.append("with more than approximately 5000 external nodes) to increase the memory which Java can use, with\n");
        stringBuilder.append("the '-Xmx' Java command line option. For example:\n");
        stringBuilder.append("java -Xms32m -Xmx256m -cp path\\to\\forester.jar org.forester.archaeopteryx.Archaeopteryx\n\n");
        if (map != null && map.size() > 0) {
            stringBuilder.append("Active web links\n");
            stringBuilder.append("--------------------\n");
            for (String string : map.keySet()) {
                stringBuilder.append(" " + map.get(string).toString() + "\n");
            }
        }
        stringBuilder.append("\n");
        stringBuilder.append("phyloXML\n");
        stringBuilder.append("-------------------\n");
        stringBuilder.append("Reference: Han MV and Zmasek CM (2009): \"phyloXML: XML for evolutionary biology and comparative genomics\", BMC Bioinformatics 10:356\n");
        stringBuilder.append("Website: http://www.phyloxml.org\n");
        stringBuilder.append("Version: 1.10\n");
        stringBuilder.append("\n");
        stringBuilder.append("For more information: http://www.phylosoft.org/archaeopteryx/\n");
        stringBuilder.append("Email: phylosoft@gmail.com\n\n");
        TextFrame.instantiate(stringBuilder.toString());
    }

    static void setOvPlacementColorChooseMenuItem(JMenuItem jMenuItem, Options options) {
        if (options != null && options.getOvPlacement() != null) {
            jMenuItem.setText("Cycle Overview Placement... (current: " + (Object)((Object)options.getOvPlacement()) + ")");
        } else {
            jMenuItem.setText("Cycle Overview Placement...");
        }
    }

    static void setCycleNodeFillMenuItem(JMenuItem jMenuItem, Options options) {
        if (options != null && options.getDefaultNodeFill() != null) {
            jMenuItem.setText("Cycle Node Shape Fill Type... (current: " + options.getDefaultNodeFill().toString().toLowerCase() + ")");
        } else {
            jMenuItem.setText("Cycle Node Shape Fill Type...");
        }
    }

    static void setCycleNodeShapeMenuItem(JMenuItem jMenuItem, Options options) {
        if (options != null && options.getDefaultNodeShape() != null) {
            jMenuItem.setText("Cycle Node Shape Fill Type... (current: " + options.getDefaultNodeShape().toString().toLowerCase() + ")");
        } else {
            jMenuItem.setText("Cycle Node Shape Fill Type...");
        }
    }

    static void setTextColorChooseMenuItem(JMenuItem jMenuItem, TreePanel treePanel) {
        if (treePanel != null && treePanel.getTreeColorSet() != null) {
            jMenuItem.setText("Select Colors... (current: " + treePanel.getTreeColorSet().getCurrentColorSchemeName() + ")");
        } else {
            jMenuItem.setText("Select Colors...");
        }
    }

    static void setTextForFontChooserMenuItem(JMenuItem jMenuItem, String string) {
        jMenuItem.setText("Select Font... (current: " + string + ")");
    }

    static void setTextMinSupportMenuItem(JMenuItem jMenuItem, Options options, TreePanel treePanel) {
        if (treePanel == null || treePanel.getPhylogeny() == null) {
            jMenuItem.setEnabled(true);
        } else if (ForesterUtil.isHasAtLeastOneBranchWithSupportValues(treePanel.getPhylogeny())) {
            jMenuItem.setEnabled(true);
        } else {
            jMenuItem.setEnabled(false);
        }
        jMenuItem.setText("Enter Min Confidence Value... (current: " + options.getMinConfidenceValue() + ")");
    }

    static void setTextNodeSizeMenuItem(JMenuItem jMenuItem, Options options) {
        jMenuItem.setText("Enter Default Node Shape Size... (current: " + options.getDefaultNodeShapeSize() + ")");
    }

    static void updateOptionsMenuDependingOnPhylogenyType(MainPanel mainPanel, JCheckBoxMenuItem jCheckBoxMenuItem, JCheckBoxMenuItem jCheckBoxMenuItem2, JRadioButtonMenuItem jRadioButtonMenuItem, JRadioButtonMenuItem jRadioButtonMenuItem2, JRadioButtonMenuItem jRadioButtonMenuItem3, JCheckBoxMenuItem jCheckBoxMenuItem3) {
        TreePanel treePanel = mainPanel.getCurrentTreePanel();
        ControlPanel controlPanel = mainPanel.getControlPanel();
        Options options = mainPanel.getOptions();
        jCheckBoxMenuItem.setSelected(options.isShowScale());
        jCheckBoxMenuItem2.setSelected(options.isShowBranchLengthValues());
        if (treePanel != null && !treePanel.isPhyHasBranchLengths()) {
            jCheckBoxMenuItem.setSelected(false);
            jCheckBoxMenuItem.setEnabled(false);
            jCheckBoxMenuItem2.setSelected(false);
            jCheckBoxMenuItem2.setEnabled(false);
        } else if (treePanel != null && !controlPanel.isDrawPhylogram()) {
            jCheckBoxMenuItem.setSelected(false);
            jCheckBoxMenuItem.setEnabled(false);
            jCheckBoxMenuItem2.setEnabled(true);
        } else {
            jCheckBoxMenuItem.setEnabled(true);
            jCheckBoxMenuItem2.setEnabled(true);
        }
        if (treePanel != null && treePanel.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED && treePanel.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE && treePanel.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR) {
            jCheckBoxMenuItem2.setSelected(false);
            jCheckBoxMenuItem2.setEnabled(false);
        }
        if (treePanel != null) {
            if (treePanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || treePanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
                jRadioButtonMenuItem.setEnabled(false);
                jRadioButtonMenuItem2.setEnabled(false);
                jRadioButtonMenuItem3.setEnabled(false);
            } else {
                jRadioButtonMenuItem.setEnabled(true);
                jRadioButtonMenuItem2.setEnabled(true);
                jRadioButtonMenuItem3.setEnabled(true);
            }
        } else {
            if (treePanel != null && treePanel.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE && treePanel.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR) {
                jCheckBoxMenuItem2.setSelected(false);
                jCheckBoxMenuItem2.setEnabled(false);
            }
            if (treePanel != null && (treePanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || treePanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED)) {
                jRadioButtonMenuItem.setEnabled(false);
            } else {
                jRadioButtonMenuItem.setEnabled(true);
            }
        }
        jCheckBoxMenuItem3.setEnabled(true);
        if (treePanel != null) {
            if (treePanel.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && treePanel.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                jCheckBoxMenuItem3.setEnabled(false);
            }
            if (treePanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                jCheckBoxMenuItem.setSelected(false);
                jCheckBoxMenuItem.setEnabled(false);
            }
        }
    }

    static void updateScreenTextAntialias(List<TreePanel> list) {
        for (TreePanel treePanel : list) {
            treePanel.setTextAntialias();
        }
    }
}

