/*
 * Decompiled with CFR 0.152.
 */
package org.forester.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.analysis.AncestralTaxonomyInferenceException;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;
import org.forester.ws.uniprot.UniProtTaxonomy;
import org.forester.ws.uniprot.UniProtWsTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AncestralTaxonomyInference {
    private static final int MAX_CACHE_SIZE = 100000;
    private static final int MAX_TAXONOMIES_TO_RETURN = 10;
    private static final HashMap<String, UniProtTaxonomy> _sn_up_cache_map = new HashMap();
    private static final HashMap<String, UniProtTaxonomy> _lineage_up_cache_map = new HashMap();
    private static final HashMap<String, UniProtTaxonomy> _code_up_cache_map = new HashMap();
    private static final HashMap<String, UniProtTaxonomy> _cn_up_cache_map = new HashMap();
    private static final HashMap<String, UniProtTaxonomy> _id_up_cache_map = new HashMap();

    private static synchronized void clearCachesIfTooLarge() {
        if (AncestralTaxonomyInference.getSnTaxCacheMap().size() > 100000) {
            AncestralTaxonomyInference.getSnTaxCacheMap().clear();
        }
        if (AncestralTaxonomyInference.getLineageTaxCacheMap().size() > 100000) {
            AncestralTaxonomyInference.getLineageTaxCacheMap().clear();
        }
        if (AncestralTaxonomyInference.getCnTaxCacheMap().size() > 100000) {
            AncestralTaxonomyInference.getCnTaxCacheMap().clear();
        }
        if (AncestralTaxonomyInference.getCodeTaxCacheMap().size() > 100000) {
            AncestralTaxonomyInference.getCodeTaxCacheMap().clear();
        }
        if (AncestralTaxonomyInference.getIdTaxCacheMap().size() > 100000) {
            AncestralTaxonomyInference.getIdTaxCacheMap().clear();
        }
    }

    private static synchronized HashMap<String, UniProtTaxonomy> getCnTaxCacheMap() {
        return _cn_up_cache_map;
    }

    private static synchronized HashMap<String, UniProtTaxonomy> getCodeTaxCacheMap() {
        return _code_up_cache_map;
    }

    private static synchronized HashMap<String, UniProtTaxonomy> getIdTaxCacheMap() {
        return _id_up_cache_map;
    }

    private static synchronized HashMap<String, UniProtTaxonomy> getSnTaxCacheMap() {
        return _sn_up_cache_map;
    }

    private static synchronized HashMap<String, UniProtTaxonomy> getLineageTaxCacheMap() {
        return _lineage_up_cache_map;
    }

    private static synchronized UniProtTaxonomy getTaxonomies(HashMap<String, UniProtTaxonomy> hashMap, Object object, QUERY_TYPE qUERY_TYPE) throws IOException, AncestralTaxonomyInferenceException {
        if (hashMap.containsKey(object)) {
            return hashMap.get(object).copy();
        }
        List<UniProtTaxonomy> list = null;
        switch (qUERY_TYPE) {
            case ID: {
                list = AncestralTaxonomyInference.getTaxonomiesFromId((String)object);
                break;
            }
            case CODE: {
                list = AncestralTaxonomyInference.getTaxonomiesFromTaxonomyCode((String)object);
                break;
            }
            case SN: {
                list = AncestralTaxonomyInference.getTaxonomiesFromScientificName((String)object);
                break;
            }
            case CN: {
                list = AncestralTaxonomyInference.getTaxonomiesFromCommonName((String)object);
                break;
            }
            case LIN: {
                return AncestralTaxonomyInference.obtainUniProtTaxonomyFromLineage((List)object);
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (list != null && list.size() == 1) {
            UniProtTaxonomy uniProtTaxonomy = list.get(0);
            if (!ForesterUtil.isEmpty(uniProtTaxonomy.getScientificName())) {
                AncestralTaxonomyInference.getSnTaxCacheMap().put(uniProtTaxonomy.getScientificName(), uniProtTaxonomy);
            }
            if (!ForesterUtil.isEmpty(uniProtTaxonomy.getCode())) {
                AncestralTaxonomyInference.getCodeTaxCacheMap().put(uniProtTaxonomy.getCode(), uniProtTaxonomy);
            }
            if (!ForesterUtil.isEmpty(uniProtTaxonomy.getCommonName())) {
                AncestralTaxonomyInference.getCnTaxCacheMap().put(uniProtTaxonomy.getCommonName(), uniProtTaxonomy);
            }
            if (!ForesterUtil.isEmpty(uniProtTaxonomy.getId())) {
                AncestralTaxonomyInference.getIdTaxCacheMap().put(uniProtTaxonomy.getId(), uniProtTaxonomy);
            }
            return uniProtTaxonomy;
        }
        return null;
    }

    private static synchronized List<UniProtTaxonomy> getTaxonomiesFromCommonName(String string) throws IOException {
        return UniProtWsTools.getTaxonomiesFromCommonNameStrict(string, 10);
    }

    private static synchronized List<UniProtTaxonomy> getTaxonomiesFromId(String string) throws IOException {
        return UniProtWsTools.getTaxonomiesFromId(string, 10);
    }

    private static synchronized List<UniProtTaxonomy> getTaxonomiesFromScientificName(String string) throws IOException {
        return UniProtWsTools.getTaxonomiesFromScientificNameStrict(string, 10);
    }

    private static synchronized List<UniProtTaxonomy> getTaxonomiesFromTaxonomyCode(String string) throws IOException {
        return UniProtWsTools.getTaxonomiesFromTaxonomyCode(string, 10);
    }

    public static synchronized void inferTaxonomyFromDescendents(Phylogeny phylogeny) throws IOException, AncestralTaxonomyInferenceException {
        AncestralTaxonomyInference.clearCachesIfTooLarge();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal()) continue;
            AncestralTaxonomyInference.inferTaxonomyFromDescendents(phylogenyNode);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static synchronized void inferTaxonomyFromDescendents(PhylogenyNode phylogenyNode) throws IOException, AncestralTaxonomyInferenceException {
        void var5_10;
        Object object;
        if (phylogenyNode.isExternal()) {
            throw new IllegalArgumentException("attempt to infer taxonomy from descendants of external node");
        }
        phylogenyNode.getNodeData().setTaxonomy(null);
        List<PhylogenyNode> list = phylogenyNode.getDescendants();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n = Integer.MAX_VALUE;
        for (PhylogenyNode object22 : list) {
            Object object2;
            if (!(!object22.getNodeData().isHasTaxonomy() || !AncestralTaxonomyInference.isHasAppropriateId(object22.getNodeData().getTaxonomy()) && ForesterUtil.isEmpty(object22.getNodeData().getTaxonomy().getScientificName()) && ForesterUtil.isEmpty(object22.getNodeData().getTaxonomy().getLineage()) && ForesterUtil.isEmpty(object22.getNodeData().getTaxonomy().getTaxonomyCode()) && ForesterUtil.isEmpty(object22.getNodeData().getTaxonomy().getCommonName()))) {
                object2 = AncestralTaxonomyInference.obtainUniProtTaxonomy(object22.getNodeData().getTaxonomy(), null, null);
                if (object2 == null && ForesterUtil.isEmpty(object22.getNodeData().getTaxonomy().getLineage())) {
                    object = "";
                    object = !ForesterUtil.isEmpty(object22.getName()) ? "\"" + object22.getName() + "\"" : "[" + object22.getId() + "]";
                    System.out.println(object22.getNodeData().getTaxonomy().toString());
                    System.out.println(ForesterUtil.stringListToString(object22.getNodeData().getTaxonomy().getLineage(), "  >  "));
                    throw new AncestralTaxonomyInferenceException("a taxonomy for node " + (String)object + " could not be established from the database");
                }
                object = ForesterUtil.stringListToArray(object22.getNodeData().getTaxonomy().getLineage());
                if (object == null || ((String[])object).length < 1) {
                    object = ForesterUtil.stringListToArray(((UniProtTaxonomy)object2).getLineage());
                }
                if (object == null || ((String[])object).length < 1) {
                    throw new AncestralTaxonomyInferenceException("a taxonomic lineage for node \"" + object22.getNodeData().getTaxonomy().toString() + "\" could not be established");
                }
                if (((String[])object).length < n) {
                    n = ((String[])object).length;
                }
                arrayList.add((String[])object);
                continue;
            }
            object2 = "";
            object2 = !ForesterUtil.isEmpty(object22.getName()) ? "\"" + object22.getName() + "\"" : "[" + object22.getId() + "]";
            throw new AncestralTaxonomyInferenceException("node " + (String)object2 + " has no or inappropriate taxonomic information");
        }
        ArrayList arrayList2 = new ArrayList();
        Object var5_6 = null;
        if (n > 0) {
            block3: for (int i = 0; i < n; ++i) {
                object = ((String[])arrayList.get(0))[i];
                for (int iterator = 1; iterator < arrayList.size(); ++iterator) {
                    if (!object.equals(((String[])arrayList.get(iterator))[i])) break block3;
                }
                arrayList2.add(object);
                Object object3 = object;
            }
        }
        if (arrayList2.isEmpty()) {
            boolean bl = false;
            boolean bl2 = false;
            for (String[] stringArray : arrayList) {
                if (stringArray.length <= 0) continue;
                if (stringArray[0].equalsIgnoreCase("Viruses")) {
                    bl = true;
                } else if (stringArray[0].equalsIgnoreCase("cellular organisms")) {
                    bl2 = true;
                }
                if (!bl2 || !bl) continue;
                break;
            }
            if (bl2 && bl) {
                arrayList2.add("cellular organisms");
                String string = "cellular organisms";
            } else {
                Object object4 = "no common lineage for:\n";
                boolean bl3 = false;
                for (String[] stringArray : arrayList) {
                    void var9_28;
                    object4 = (String)object4 + (int)var9_28 + ": ";
                    ++var9_28;
                    for (String string : stringArray) {
                        object4 = (String)object4 + string + " ";
                    }
                    object4 = (String)object4 + "\n";
                }
                throw new AncestralTaxonomyInferenceException((String)object4);
            }
        }
        Taxonomy taxonomy = new Taxonomy();
        phylogenyNode.getNodeData().setTaxonomy(taxonomy);
        taxonomy.setScientificName((String)var5_10);
        UniProtTaxonomy uniProtTaxonomy = AncestralTaxonomyInference.obtainUniProtTaxonomyFromLineage(arrayList2);
        if (uniProtTaxonomy != null) {
            if (!ForesterUtil.isEmpty(uniProtTaxonomy.getRank())) {
                try {
                    taxonomy.setRank(uniProtTaxonomy.getRank().toLowerCase());
                }
                catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                    taxonomy.setRank("");
                }
            }
            if (!ForesterUtil.isEmpty(uniProtTaxonomy.getId())) {
                taxonomy.setIdentifier(new Identifier(uniProtTaxonomy.getId(), "uniprot"));
            }
            if (!ForesterUtil.isEmpty(uniProtTaxonomy.getCommonName())) {
                taxonomy.setCommonName(uniProtTaxonomy.getCommonName());
            }
            if (!ForesterUtil.isEmpty(uniProtTaxonomy.getSynonym()) && !taxonomy.getSynonyms().contains(uniProtTaxonomy.getSynonym())) {
                taxonomy.getSynonyms().add(uniProtTaxonomy.getSynonym());
            }
            if (uniProtTaxonomy.getLineage() != null) {
                taxonomy.setLineage(new ArrayList<String>());
                for (String string : uniProtTaxonomy.getLineage()) {
                    if (ForesterUtil.isEmpty(string)) continue;
                    taxonomy.getLineage().add(string);
                }
            }
        }
        if (ForesterUtil.isEmpty(taxonomy.getLineage())) {
            taxonomy.setLineage(new ArrayList<String>());
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (ForesterUtil.isEmpty(string)) continue;
                taxonomy.getLineage().add(string);
            }
        }
        for (PhylogenyNode phylogenyNode2 : list) {
            if (phylogenyNode2.isExternal() || !phylogenyNode2.getNodeData().isHasTaxonomy() || !phylogenyNode2.getNodeData().getTaxonomy().isEqual(taxonomy)) continue;
            phylogenyNode2.getNodeData().setTaxonomy(null);
        }
    }

    private static synchronized boolean isHasAppropriateId(Taxonomy taxonomy) {
        return taxonomy.getIdentifier() != null && !ForesterUtil.isEmpty(taxonomy.getIdentifier().getValue()) && (taxonomy.getIdentifier().getProvider().equalsIgnoreCase("ncbi") || taxonomy.getIdentifier().getProvider().equalsIgnoreCase("uniprot") || taxonomy.getIdentifier().getProvider().equalsIgnoreCase("uniprotkb"));
    }

    public static synchronized SortedSet<String> obtainDetailedTaxonomicInformation(Phylogeny phylogeny, boolean bl) throws IOException, AncestralTaxonomyInferenceException {
        AncestralTaxonomyInference.clearCachesIfTooLarge();
        TreeSet<String> treeSet = new TreeSet<String>();
        ArrayList<PhylogenyNode> arrayList = null;
        if (bl) {
            arrayList = new ArrayList<PhylogenyNode>();
        }
        Iterator<PhylogenyNode> iterator = phylogeny.iteratorPostorder();
        while (iterator.hasNext()) {
            PhylogenyNode phylogenyNode = iterator.next();
            QUERY_TYPE qUERY_TYPE = null;
            Taxonomy taxonomy = null;
            if (phylogenyNode.getNodeData().isHasTaxonomy()) {
                taxonomy = phylogenyNode.getNodeData().getTaxonomy();
            } else if (phylogenyNode.isExternal()) {
                if (!ForesterUtil.isEmpty(phylogenyNode.getName())) {
                    treeSet.add(phylogenyNode.getName());
                } else {
                    treeSet.add(phylogenyNode.toString());
                }
                if (bl) {
                    arrayList.add(phylogenyNode);
                }
            }
            UniProtTaxonomy uniProtTaxonomy = null;
            if (taxonomy == null || !AncestralTaxonomyInference.isHasAppropriateId(taxonomy) && ForesterUtil.isEmpty(taxonomy.getScientificName()) && ForesterUtil.isEmpty(taxonomy.getTaxonomyCode()) && ForesterUtil.isEmpty(taxonomy.getCommonName())) continue;
            uniProtTaxonomy = AncestralTaxonomyInference.obtainUniProtTaxonomy(taxonomy, null, qUERY_TYPE);
            if (uniProtTaxonomy != null) {
                AncestralTaxonomyInference.updateTaxonomy(qUERY_TYPE, phylogenyNode, taxonomy, uniProtTaxonomy);
                continue;
            }
            treeSet.add(taxonomy.toString());
            if (!bl || !phylogenyNode.isExternal()) continue;
            arrayList.add(phylogenyNode);
        }
        if (bl) {
            for (PhylogenyNode phylogenyNode : arrayList) {
                phylogeny.deleteSubtree(phylogenyNode, true);
            }
            phylogeny.externalNodesHaveChanged();
            phylogeny.hashIDs();
            phylogeny.recalculateNumberOfExternalDescendants(true);
        }
        return treeSet;
    }

    public static synchronized UniProtTaxonomy obtainUniProtTaxonomy(Taxonomy taxonomy, Object object, QUERY_TYPE qUERY_TYPE) throws IOException, AncestralTaxonomyInferenceException {
        if (AncestralTaxonomyInference.isHasAppropriateId(taxonomy)) {
            object = taxonomy.getIdentifier().getValue();
            qUERY_TYPE = QUERY_TYPE.ID;
            return AncestralTaxonomyInference.getTaxonomies(AncestralTaxonomyInference.getIdTaxCacheMap(), object, qUERY_TYPE);
        }
        if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) {
            if (!ForesterUtil.isEmpty(taxonomy.getLineage())) {
                object = taxonomy.getLineage();
                qUERY_TYPE = QUERY_TYPE.LIN;
                return AncestralTaxonomyInference.getTaxonomies(AncestralTaxonomyInference.getLineageTaxCacheMap(), object, qUERY_TYPE);
            }
            object = taxonomy.getScientificName();
            qUERY_TYPE = QUERY_TYPE.SN;
            return AncestralTaxonomyInference.getTaxonomies(AncestralTaxonomyInference.getSnTaxCacheMap(), object, qUERY_TYPE);
        }
        if (!ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
            object = taxonomy.getTaxonomyCode();
            qUERY_TYPE = QUERY_TYPE.CODE;
            return AncestralTaxonomyInference.getTaxonomies(AncestralTaxonomyInference.getCodeTaxCacheMap(), object, qUERY_TYPE);
        }
        object = taxonomy.getCommonName();
        qUERY_TYPE = QUERY_TYPE.CN;
        return AncestralTaxonomyInference.getTaxonomies(AncestralTaxonomyInference.getCnTaxCacheMap(), object, qUERY_TYPE);
    }

    private static synchronized UniProtTaxonomy obtainUniProtTaxonomyFromLineage(List<String> list) throws AncestralTaxonomyInferenceException, IOException {
        String string = ForesterUtil.stringListToString(list, ">");
        UniProtTaxonomy uniProtTaxonomy = null;
        if (AncestralTaxonomyInference.getLineageTaxCacheMap().containsKey(string)) {
            uniProtTaxonomy = AncestralTaxonomyInference.getLineageTaxCacheMap().get(string).copy();
        } else {
            List<UniProtTaxonomy> list2 = AncestralTaxonomyInference.getTaxonomiesFromScientificName(list.get(list.size() - 1));
            if (list2 != null && list2.size() > 0) {
                for (UniProtTaxonomy uniProtTaxonomy2 : list2) {
                    boolean bl = true;
                    for (int i = 0; i < list.size(); ++i) {
                        if (list.get(i).equalsIgnoreCase(uniProtTaxonomy2.getLineage().get(i))) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    if (uniProtTaxonomy != null) {
                        throw new AncestralTaxonomyInferenceException("lineage \"" + ForesterUtil.stringListToString(list, " > ") + "\" is not unique");
                    }
                    uniProtTaxonomy = uniProtTaxonomy2;
                }
                if (uniProtTaxonomy == null) {
                    throw new AncestralTaxonomyInferenceException("lineage \"" + ForesterUtil.stringListToString(list, " > ") + "\" not found");
                }
                AncestralTaxonomyInference.getLineageTaxCacheMap().put(string, uniProtTaxonomy);
                if (!ForesterUtil.isEmpty(uniProtTaxonomy.getScientificName())) {
                    AncestralTaxonomyInference.getSnTaxCacheMap().put(uniProtTaxonomy.getScientificName(), uniProtTaxonomy);
                }
                if (!ForesterUtil.isEmpty(uniProtTaxonomy.getCode())) {
                    AncestralTaxonomyInference.getCodeTaxCacheMap().put(uniProtTaxonomy.getCode(), uniProtTaxonomy);
                }
                if (!ForesterUtil.isEmpty(uniProtTaxonomy.getCommonName())) {
                    AncestralTaxonomyInference.getCnTaxCacheMap().put(uniProtTaxonomy.getCommonName(), uniProtTaxonomy);
                }
                if (!ForesterUtil.isEmpty(uniProtTaxonomy.getId())) {
                    AncestralTaxonomyInference.getIdTaxCacheMap().put(uniProtTaxonomy.getId(), uniProtTaxonomy);
                }
            }
        }
        return uniProtTaxonomy;
    }

    private static synchronized void updateTaxonomy(QUERY_TYPE qUERY_TYPE, PhylogenyNode phylogenyNode, Taxonomy taxonomy, UniProtTaxonomy uniProtTaxonomy) {
        if (qUERY_TYPE != QUERY_TYPE.SN && !ForesterUtil.isEmpty(uniProtTaxonomy.getScientificName()) && ForesterUtil.isEmpty(taxonomy.getScientificName())) {
            taxonomy.setScientificName(uniProtTaxonomy.getScientificName());
        }
        if (phylogenyNode.isExternal() && qUERY_TYPE != QUERY_TYPE.CODE && !ForesterUtil.isEmpty(uniProtTaxonomy.getCode()) && ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
            taxonomy.setTaxonomyCode(uniProtTaxonomy.getCode());
        }
        if (qUERY_TYPE != QUERY_TYPE.CN && !ForesterUtil.isEmpty(uniProtTaxonomy.getCommonName()) && ForesterUtil.isEmpty(taxonomy.getCommonName())) {
            taxonomy.setCommonName(uniProtTaxonomy.getCommonName());
        }
        if (!ForesterUtil.isEmpty(uniProtTaxonomy.getSynonym()) && !taxonomy.getSynonyms().contains(uniProtTaxonomy.getSynonym())) {
            taxonomy.getSynonyms().add(uniProtTaxonomy.getSynonym());
        }
        if (!ForesterUtil.isEmpty(uniProtTaxonomy.getRank()) && ForesterUtil.isEmpty(taxonomy.getRank())) {
            try {
                taxonomy.setRank(uniProtTaxonomy.getRank().toLowerCase());
            }
            catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                taxonomy.setRank("");
            }
        }
        if (qUERY_TYPE != QUERY_TYPE.ID && !ForesterUtil.isEmpty(uniProtTaxonomy.getId()) && (taxonomy.getIdentifier() == null || ForesterUtil.isEmpty(taxonomy.getIdentifier().getValue()))) {
            taxonomy.setIdentifier(new Identifier(uniProtTaxonomy.getId(), "uniprot"));
        }
        if (uniProtTaxonomy.getLineage() != null) {
            taxonomy.setLineage(new ArrayList<String>());
            for (String string : uniProtTaxonomy.getLineage()) {
                if (ForesterUtil.isEmpty(string)) continue;
                taxonomy.getLineage().add(string);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum QUERY_TYPE {
        CODE,
        SN,
        CN,
        ID,
        LIN;

    }
}

